<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Iam
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Iam\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;


class OAuthAppList extends ListResource
    {
    /**
     * Construct the OAuthAppList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Account/OAuthApps';
    }

    /**
     * Create the OAuthAppInstance
     *
     * @param IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest
     * @return OAuthAppInstance Created OAuthAppInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest): OAuthAppInstance
    {

        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $iamV1AccountVendorOauthAppCreateRequest->toArray();
        $payload = $this->version->create('POST', $this->uri, [], $data, $headers);

        return new OAuthAppInstance(
            $this->version,
            $payload
        );
    }


    /**
     * Constructs a OAuthAppContext
     *
     * @param string $sid Unique ID (sid) of the OAuth app
     */
    public function getContext(
        string $sid
        
    ): OAuthAppContext
    {
        return new OAuthAppContext(
            $this->version,
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Iam.V1.OAuthAppList]';
    }
}
