<?php
// This file was auto-generated from sdk-root/src/data/route53globalresolver/2022-09-27/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2022-09-27', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'route53globalresolver', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Amazon Route 53 Global Resolver', 'serviceId' => 'Route53GlobalResolver', 'signatureVersion' => 'v4', 'signingName' => 'route53globalresolver', 'uid' => 'route53globalresolver-2022-09-27', ], 'operations' => [ 'AssociateHostedZone' => [ 'name' => 'AssociateHostedZone', 'http' => [ 'method' => 'POST', 'requestUri' => '/hosted-zone-associations/{hostedZoneId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateHostedZoneInput', ], 'output' => [ 'shape' => 'AssociateHostedZoneOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'BatchCreateFirewallRule' => [ 'name' => 'BatchCreateFirewallRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/firewall-rules/batch-create', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchCreateFirewallRuleInput', ], 'output' => [ 'shape' => 'BatchCreateFirewallRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'BatchDeleteFirewallRule' => [ 'name' => 'BatchDeleteFirewallRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/firewall-rules/batch-delete', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchDeleteFirewallRuleInput', ], 'output' => [ 'shape' => 'BatchDeleteFirewallRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'BatchUpdateFirewallRule' => [ 'name' => 'BatchUpdateFirewallRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/firewall-rules/batch-update', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchUpdateFirewallRuleInput', ], 'output' => [ 'shape' => 'BatchUpdateFirewallRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'CreateAccessSource' => [ 'name' => 'CreateAccessSource', 'http' => [ 'method' => 'POST', 'requestUri' => '/access-sources', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateAccessSourceInput', ], 'output' => [ 'shape' => 'CreateAccessSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateAccessToken' => [ 'name' => 'CreateAccessToken', 'http' => [ 'method' => 'POST', 'requestUri' => '/tokens/{dnsViewId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateAccessTokenInput', ], 'output' => [ 'shape' => 'CreateAccessTokenOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateDNSView' => [ 'name' => 'CreateDNSView', 'http' => [ 'method' => 'POST', 'requestUri' => '/dns-views/{globalResolverId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDNSViewInput', ], 'output' => [ 'shape' => 'CreateDNSViewOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateFirewallDomainList' => [ 'name' => 'CreateFirewallDomainList', 'http' => [ 'method' => 'POST', 'requestUri' => '/firewall-domain-lists/{globalResolverId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateFirewallDomainListInput', ], 'output' => [ 'shape' => 'CreateFirewallDomainListOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateFirewallRule' => [ 'name' => 'CreateFirewallRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/firewall-rules', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateFirewallRuleInput', ], 'output' => [ 'shape' => 'CreateFirewallRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateGlobalResolver' => [ 'name' => 'CreateGlobalResolver', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-resolver', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateGlobalResolverInput', ], 'output' => [ 'shape' => 'CreateGlobalResolverOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteAccessSource' => [ 'name' => 'DeleteAccessSource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/access-sources/{accessSourceId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteAccessSourceInput', ], 'output' => [ 'shape' => 'DeleteAccessSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteAccessToken' => [ 'name' => 'DeleteAccessToken', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tokens/{accessTokenId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteAccessTokenInput', ], 'output' => [ 'shape' => 'DeleteAccessTokenOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteDNSView' => [ 'name' => 'DeleteDNSView', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/dns-views/{dnsViewId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDNSViewInput', ], 'output' => [ 'shape' => 'DeleteDNSViewOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteFirewallDomainList' => [ 'name' => 'DeleteFirewallDomainList', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/firewall-domain-lists/{firewallDomainListId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFirewallDomainListInput', ], 'output' => [ 'shape' => 'DeleteFirewallDomainListOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteFirewallRule' => [ 'name' => 'DeleteFirewallRule', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/firewall-rules/{firewallRuleId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFirewallRuleInput', ], 'output' => [ 'shape' => 'DeleteFirewallRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteGlobalResolver' => [ 'name' => 'DeleteGlobalResolver', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-resolver/{globalResolverId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteGlobalResolverInput', ], 'output' => [ 'shape' => 'DeleteGlobalResolverOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DisableDNSView' => [ 'name' => 'DisableDNSView', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/dns-views/{dnsViewId}/disable', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisableDNSViewInput', ], 'output' => [ 'shape' => 'DisableDNSViewOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DisassociateHostedZone' => [ 'name' => 'DisassociateHostedZone', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/hosted-zone-associations/hosted-zone/{hostedZoneId}/resource-arn/{resourceArn+}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateHostedZoneInput', ], 'output' => [ 'shape' => 'DisassociateHostedZoneOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'EnableDNSView' => [ 'name' => 'EnableDNSView', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/dns-views/{dnsViewId}/enable', 'responseCode' => 200, ], 'input' => [ 'shape' => 'EnableDNSViewInput', ], 'output' => [ 'shape' => 'EnableDNSViewOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'GetAccessSource' => [ 'name' => 'GetAccessSource', 'http' => [ 'method' => 'GET', 'requestUri' => '/access-sources/{accessSourceId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAccessSourceInput', ], 'output' => [ 'shape' => 'GetAccessSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetAccessToken' => [ 'name' => 'GetAccessToken', 'http' => [ 'method' => 'GET', 'requestUri' => '/tokens/{accessTokenId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAccessTokenInput', ], 'output' => [ 'shape' => 'GetAccessTokenOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetDNSView' => [ 'name' => 'GetDNSView', 'http' => [ 'method' => 'GET', 'requestUri' => '/dns-views/{dnsViewId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDNSViewInput', ], 'output' => [ 'shape' => 'GetDNSViewOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetFirewallDomainList' => [ 'name' => 'GetFirewallDomainList', 'http' => [ 'method' => 'GET', 'requestUri' => '/firewall-domain-lists/{firewallDomainListId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFirewallDomainListInput', ], 'output' => [ 'shape' => 'GetFirewallDomainListOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetFirewallRule' => [ 'name' => 'GetFirewallRule', 'http' => [ 'method' => 'GET', 'requestUri' => '/firewall-rules/{firewallRuleId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFirewallRuleInput', ], 'output' => [ 'shape' => 'GetFirewallRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetGlobalResolver' => [ 'name' => 'GetGlobalResolver', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-resolver/{globalResolverId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGlobalResolverInput', ], 'output' => [ 'shape' => 'GetGlobalResolverOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetHostedZoneAssociation' => [ 'name' => 'GetHostedZoneAssociation', 'http' => [ 'method' => 'GET', 'requestUri' => '/hosted-zone-associations/{hostedZoneAssociationId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetHostedZoneAssociationInput', ], 'output' => [ 'shape' => 'GetHostedZoneAssociationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetManagedFirewallDomainList' => [ 'name' => 'GetManagedFirewallDomainList', 'http' => [ 'method' => 'GET', 'requestUri' => '/managed-firewall-domain-lists/{managedFirewallDomainListId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetManagedFirewallDomainListInput', ], 'output' => [ 'shape' => 'GetManagedFirewallDomainListOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ImportFirewallDomains' => [ 'name' => 'ImportFirewallDomains', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/firewall-domain-lists/{firewallDomainListId}/domains/s3_file_url', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ImportFirewallDomainsInput', ], 'output' => [ 'shape' => 'ImportFirewallDomainsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAccessSources' => [ 'name' => 'ListAccessSources', 'http' => [ 'method' => 'GET', 'requestUri' => '/access-sources', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAccessSourcesInput', ], 'output' => [ 'shape' => 'ListAccessSourcesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], 'readonly' => true, ], 'ListAccessTokens' => [ 'name' => 'ListAccessTokens', 'http' => [ 'method' => 'GET', 'requestUri' => '/tokens/dns-view/{dnsViewId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAccessTokensInput', ], 'output' => [ 'shape' => 'ListAccessTokensOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListDNSViews' => [ 'name' => 'ListDNSViews', 'http' => [ 'method' => 'GET', 'requestUri' => '/dns-views/resolver/{globalResolverId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDNSViewsInput', ], 'output' => [ 'shape' => 'ListDNSViewsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListFirewallDomainLists' => [ 'name' => 'ListFirewallDomainLists', 'http' => [ 'method' => 'GET', 'requestUri' => '/firewall-domain-lists', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFirewallDomainListsInput', ], 'output' => [ 'shape' => 'ListFirewallDomainListsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListFirewallDomains' => [ 'name' => 'ListFirewallDomains', 'http' => [ 'method' => 'GET', 'requestUri' => '/firewall-domain-lists/{firewallDomainListId}/domains', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFirewallDomainsInput', ], 'output' => [ 'shape' => 'ListFirewallDomainsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListFirewallRules' => [ 'name' => 'ListFirewallRules', 'http' => [ 'method' => 'GET', 'requestUri' => '/firewall-rules', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFirewallRulesInput', ], 'output' => [ 'shape' => 'ListFirewallRulesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListGlobalResolvers' => [ 'name' => 'ListGlobalResolvers', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-resolver', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGlobalResolversInput', ], 'output' => [ 'shape' => 'ListGlobalResolversOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], 'readonly' => true, ], 'ListHostedZoneAssociations' => [ 'name' => 'ListHostedZoneAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/hosted-zone-associations/resource-arn/{resourceArn+}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListHostedZoneAssociationsInput', ], 'output' => [ 'shape' => 'ListHostedZoneAssociationsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListManagedFirewallDomainLists' => [ 'name' => 'ListManagedFirewallDomainLists', 'http' => [ 'method' => 'GET', 'requestUri' => '/list-managed-firewall-domain-lists/{managedFirewallDomainListType}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListManagedFirewallDomainListsInput', ], 'output' => [ 'shape' => 'ListManagedFirewallDomainListsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/get-all-tags', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tag-resource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/untag-resource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateAccessSource' => [ 'name' => 'UpdateAccessSource', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/access-sources/{accessSourceId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAccessSourceInput', ], 'output' => [ 'shape' => 'UpdateAccessSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateAccessToken' => [ 'name' => 'UpdateAccessToken', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/tokens/{accessTokenId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAccessTokenInput', ], 'output' => [ 'shape' => 'UpdateAccessTokenOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateDNSView' => [ 'name' => 'UpdateDNSView', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/dns-views/{dnsViewId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDNSViewInput', ], 'output' => [ 'shape' => 'UpdateDNSViewOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateFirewallDomains' => [ 'name' => 'UpdateFirewallDomains', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/firewall-domain-lists/{firewallDomainListId}/domains', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFirewallDomainsInput', ], 'output' => [ 'shape' => 'UpdateFirewallDomainsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateFirewallRule' => [ 'name' => 'UpdateFirewallRule', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/firewall-rules/{firewallRuleId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFirewallRuleInput', ], 'output' => [ 'shape' => 'UpdateFirewallRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateGlobalResolver' => [ 'name' => 'UpdateGlobalResolver', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-resolver/{globalResolverId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateGlobalResolverInput', ], 'output' => [ 'shape' => 'UpdateGlobalResolverOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateHostedZoneAssociation' => [ 'name' => 'UpdateHostedZoneAssociation', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/hosted-zone-associations/{hostedZoneAssociationId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateHostedZoneAssociationInput', ], 'output' => [ 'shape' => 'UpdateHostedZoneAssociationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccessSources' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccessSourcesItem', ], ], 'AccessSourcesItem' => [ 'type' => 'structure', 'required' => [ 'arn', 'cidr', 'createdAt', 'id', 'ipAddressType', 'dnsViewId', 'protocol', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'cidr' => [ 'shape' => 'Cidr', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'id' => [ 'shape' => 'ResourceId', ], 'ipAddressType' => [ 'shape' => 'IpAddressType', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'protocol' => [ 'shape' => 'DnsProtocol', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'AccessTokenItem' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'createdAt', 'dnsViewId', 'expiresAt', 'globalResolverId', 'status', 'updatedAt', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'expiresAt' => [ 'shape' => 'ISO8601TimeString', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'status' => [ 'shape' => 'TokenStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'AccessTokenValue' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'sensitive' => true, ], 'AccessTokens' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccessTokenItem', ], ], 'AssociateHostedZoneInput' => [ 'type' => 'structure', 'required' => [ 'hostedZoneId', 'resourceArn', 'name', ], 'members' => [ 'hostedZoneId' => [ 'shape' => 'HostedZoneId', 'location' => 'uri', 'locationName' => 'hostedZoneId', ], 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'name' => [ 'shape' => 'ResourceName', ], ], ], 'AssociateHostedZoneOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'resourceArn', 'hostedZoneId', 'hostedZoneName', 'name', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'hostedZoneId' => [ 'shape' => 'HostedZoneId', ], 'hostedZoneName' => [ 'shape' => 'HostedZoneName', ], 'name' => [ 'shape' => 'ResourceName', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'HostedZoneAssociationStatus', ], ], ], 'BatchCreateFirewallRuleInput' => [ 'type' => 'structure', 'required' => [ 'firewallRules', ], 'members' => [ 'firewallRules' => [ 'shape' => 'BatchCreateFirewallRuleInputItems', ], ], ], 'BatchCreateFirewallRuleInputItem' => [ 'type' => 'structure', 'required' => [ 'action', 'clientToken', 'name', 'dnsViewId', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'qType' => [ 'shape' => 'DnsQueryType', ], ], ], 'BatchCreateFirewallRuleInputItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchCreateFirewallRuleInputItem', ], ], 'BatchCreateFirewallRuleOutput' => [ 'type' => 'structure', 'required' => [ 'failures', 'successes', ], 'members' => [ 'failures' => [ 'shape' => 'BatchCreateFirewallRuleOutputItems', ], 'successes' => [ 'shape' => 'BatchCreateFirewallRuleOutputItems', ], ], ], 'BatchCreateFirewallRuleOutputItem' => [ 'type' => 'structure', 'required' => [ 'firewallRule', 'code', ], 'members' => [ 'firewallRule' => [ 'shape' => 'BatchCreateFirewallRuleResult', ], 'code' => [ 'shape' => 'Integer', ], 'message' => [ 'shape' => 'String', ], ], ], 'BatchCreateFirewallRuleOutputItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchCreateFirewallRuleOutputItem', ], ], 'BatchCreateFirewallRuleResult' => [ 'type' => 'structure', 'required' => [ 'action', 'clientToken', 'name', 'dnsViewId', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'id' => [ 'shape' => 'ResourceId', ], 'managedDomainListName' => [ 'shape' => 'ResourceName', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'queryType' => [ 'shape' => 'DnsQueryType', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'BatchDeleteFirewallRuleInput' => [ 'type' => 'structure', 'required' => [ 'firewallRules', ], 'members' => [ 'firewallRules' => [ 'shape' => 'BatchDeleteFirewallRuleInputItems', ], ], ], 'BatchDeleteFirewallRuleInputItem' => [ 'type' => 'structure', 'required' => [ 'firewallRuleId', ], 'members' => [ 'firewallRuleId' => [ 'shape' => 'ResourceId', ], ], ], 'BatchDeleteFirewallRuleInputItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchDeleteFirewallRuleInputItem', ], ], 'BatchDeleteFirewallRuleOutput' => [ 'type' => 'structure', 'required' => [ 'failures', 'successes', ], 'members' => [ 'failures' => [ 'shape' => 'BatchDeleteFirewallRuleOutputItems', ], 'successes' => [ 'shape' => 'BatchDeleteFirewallRuleOutputItems', ], ], ], 'BatchDeleteFirewallRuleOutputItem' => [ 'type' => 'structure', 'required' => [ 'firewallRule', 'code', ], 'members' => [ 'firewallRule' => [ 'shape' => 'BatchDeleteFirewallRuleResult', ], 'code' => [ 'shape' => 'Integer', ], 'message' => [ 'shape' => 'String', ], ], ], 'BatchDeleteFirewallRuleOutputItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchDeleteFirewallRuleOutputItem', ], ], 'BatchDeleteFirewallRuleResult' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'clientToken' => [ 'shape' => 'ClientToken', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'status' => [ 'shape' => 'CRResourceStatus', ], ], ], 'BatchUpdateFirewallRuleInput' => [ 'type' => 'structure', 'required' => [ 'firewallRules', ], 'members' => [ 'firewallRules' => [ 'shape' => 'BatchUpdateFirewallRuleInputItems', ], ], ], 'BatchUpdateFirewallRuleInputItem' => [ 'type' => 'structure', 'required' => [ 'firewallRuleId', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallRuleId' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], ], ], 'BatchUpdateFirewallRuleInputItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchUpdateFirewallRuleInputItem', ], ], 'BatchUpdateFirewallRuleOutput' => [ 'type' => 'structure', 'required' => [ 'failures', 'successes', ], 'members' => [ 'failures' => [ 'shape' => 'BatchUpdateFirewallRuleOutputItems', ], 'successes' => [ 'shape' => 'BatchUpdateFirewallRuleOutputItems', ], ], ], 'BatchUpdateFirewallRuleOutputItem' => [ 'type' => 'structure', 'required' => [ 'firewallRule', 'code', ], 'members' => [ 'firewallRule' => [ 'shape' => 'BatchUpdateFirewallRuleResult', ], 'code' => [ 'shape' => 'Integer', ], 'message' => [ 'shape' => 'String', ], ], ], 'BatchUpdateFirewallRuleOutputItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchUpdateFirewallRuleOutputItem', ], ], 'BatchUpdateFirewallRuleResult' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'queryType' => [ 'shape' => 'DnsQueryType', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'BlockOverrideDnsQueryType' => [ 'type' => 'string', 'enum' => [ 'CNAME', ], ], 'BlockOverrideTtl' => [ 'type' => 'integer', 'box' => true, 'max' => 604800, 'min' => 0, ], 'CRResourceStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'OPERATIONAL', 'UPDATING', 'DELETING', ], ], 'Cidr' => [ 'type' => 'string', 'max' => 42, 'min' => 1, ], 'ClientToken' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'ConfidenceThreshold' => [ 'type' => 'string', 'enum' => [ 'LOW', 'MEDIUM', 'HIGH', ], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CreateAccessSourceInput' => [ 'type' => 'structure', 'required' => [ 'cidr', 'dnsViewId', 'protocol', ], 'members' => [ 'cidr' => [ 'shape' => 'Cidr', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'ipAddressType' => [ 'shape' => 'IpAddressType', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'protocol' => [ 'shape' => 'DnsProtocol', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateAccessSourceOutput' => [ 'type' => 'structure', 'required' => [ 'arn', 'cidr', 'createdAt', 'id', 'ipAddressType', 'dnsViewId', 'protocol', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'cidr' => [ 'shape' => 'Cidr', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'id' => [ 'shape' => 'ResourceId', ], 'ipAddressType' => [ 'shape' => 'IpAddressType', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'protocol' => [ 'shape' => 'DnsProtocol', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'CreateAccessTokenInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'dnsViewId', ], 'expiresAt' => [ 'shape' => 'ISO8601TimeString', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateAccessTokenOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'createdAt', 'dnsViewId', 'expiresAt', 'status', 'value', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'expiresAt' => [ 'shape' => 'ISO8601TimeString', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'status' => [ 'shape' => 'TokenStatus', ], 'value' => [ 'shape' => 'AccessTokenValue', ], ], ], 'CreateDNSViewInput' => [ 'type' => 'structure', 'required' => [ 'globalResolverId', 'name', ], 'members' => [ 'globalResolverId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'globalResolverId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'name' => [ 'shape' => 'ResourceName', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateDNSViewOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'dnssecValidation', 'ednsClientSubnet', 'firewallRulesFailOpen', 'name', 'globalResolverId', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'ProfileResourceStatus', ], ], ], 'CreateFirewallDomainListInput' => [ 'type' => 'structure', 'required' => [ 'globalResolverId', 'name', ], 'members' => [ 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'globalResolverId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'globalResolverId', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'name' => [ 'shape' => 'ResourceName', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateFirewallDomainListOutput' => [ 'type' => 'structure', 'required' => [ 'arn', 'globalResolverId', 'createdAt', 'domainCount', 'id', 'name', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'domainCount' => [ 'shape' => 'Integer', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'CreateFirewallRuleInput' => [ 'type' => 'structure', 'required' => [ 'action', 'name', 'dnsViewId', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'qType' => [ 'shape' => 'DnsQueryType', ], ], ], 'CreateFirewallRuleOutput' => [ 'type' => 'structure', 'required' => [ 'action', 'createdAt', 'id', 'name', 'priority', 'dnsViewId', 'status', 'updatedAt', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'queryType' => [ 'shape' => 'DnsQueryType', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'CreateGlobalResolverInput' => [ 'type' => 'structure', 'required' => [ 'name', 'regions', ], 'members' => [ 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'ResourceDescription', ], 'name' => [ 'shape' => 'ResourceName', ], 'observabilityRegion' => [ 'shape' => 'Region', ], 'regions' => [ 'shape' => 'Regions', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateGlobalResolverOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'clientToken', 'createdAt', 'dnsName', 'ipv4Addresses', 'name', 'regions', 'status', 'updatedAt', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsName' => [ 'shape' => 'Sni', ], 'ipv4Addresses' => [ 'shape' => 'IPv4Addresses', ], 'name' => [ 'shape' => 'ResourceName', ], 'observabilityRegion' => [ 'shape' => 'Region', ], 'regions' => [ 'shape' => 'Regions', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'DNSViewSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'clientToken', 'dnssecValidation', 'ednsClientSubnet', 'firewallRulesFailOpen', 'name', 'globalResolverId', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'ProfileResourceStatus', ], ], ], 'DNSViews' => [ 'type' => 'list', 'member' => [ 'shape' => 'DNSViewSummary', ], ], 'DeleteAccessSourceInput' => [ 'type' => 'structure', 'required' => [ 'accessSourceId', ], 'members' => [ 'accessSourceId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'accessSourceId', ], ], ], 'DeleteAccessSourceOutput' => [ 'type' => 'structure', 'required' => [ 'arn', 'cidr', 'createdAt', 'id', 'ipAddressType', 'dnsViewId', 'protocol', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'cidr' => [ 'shape' => 'Cidr', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'id' => [ 'shape' => 'ResourceId', ], 'ipAddressType' => [ 'shape' => 'IpAddressType', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'protocol' => [ 'shape' => 'DnsProtocol', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'DeleteAccessTokenInput' => [ 'type' => 'structure', 'required' => [ 'accessTokenId', ], 'members' => [ 'accessTokenId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'accessTokenId', ], ], ], 'DeleteAccessTokenOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'status', 'deletedAt', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'status' => [ 'shape' => 'TokenStatus', ], 'deletedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'DeleteDNSViewInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'dnsViewId', ], ], ], 'DeleteDNSViewOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'dnssecValidation', 'ednsClientSubnet', 'firewallRulesFailOpen', 'name', 'globalResolverId', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'ProfileResourceStatus', ], ], ], 'DeleteFirewallDomainListInput' => [ 'type' => 'structure', 'required' => [ 'firewallDomainListId', ], 'members' => [ 'firewallDomainListId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallDomainListId', ], ], ], 'DeleteFirewallDomainListOutput' => [ 'type' => 'structure', 'required' => [ 'arn', 'id', 'name', 'status', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'status' => [ 'shape' => 'CRResourceStatus', ], ], ], 'DeleteFirewallRuleInput' => [ 'type' => 'structure', 'required' => [ 'firewallRuleId', ], 'members' => [ 'firewallRuleId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallRuleId', ], ], ], 'DeleteFirewallRuleOutput' => [ 'type' => 'structure', 'required' => [ 'action', 'createdAt', 'id', 'name', 'priority', 'dnsViewId', 'status', 'updatedAt', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'queryType' => [ 'shape' => 'DnsQueryType', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'DeleteGlobalResolverInput' => [ 'type' => 'structure', 'required' => [ 'globalResolverId', ], 'members' => [ 'globalResolverId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'globalResolverId', ], ], ], 'DeleteGlobalResolverOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'clientToken', 'dnsName', 'name', 'regions', 'createdAt', 'updatedAt', 'status', 'ipv4Addresses', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnsName' => [ 'shape' => 'Sni', ], 'observabilityRegion' => [ 'shape' => 'Region', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'regions' => [ 'shape' => 'Regions', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'ipv4Addresses' => [ 'shape' => 'IPv4Addresses', ], ], ], 'DisableDNSViewInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'dnsViewId', ], ], ], 'DisableDNSViewOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'dnssecValidation', 'ednsClientSubnet', 'firewallRulesFailOpen', 'name', 'globalResolverId', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'ProfileResourceStatus', ], ], ], 'DisassociateHostedZoneInput' => [ 'type' => 'structure', 'required' => [ 'hostedZoneId', 'resourceArn', ], 'members' => [ 'hostedZoneId' => [ 'shape' => 'HostedZoneId', 'location' => 'uri', 'locationName' => 'hostedZoneId', ], 'resourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'DisassociateHostedZoneOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'resourceArn', 'hostedZoneId', 'hostedZoneName', 'name', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'hostedZoneId' => [ 'shape' => 'HostedZoneId', ], 'hostedZoneName' => [ 'shape' => 'HostedZoneName', ], 'name' => [ 'shape' => 'ResourceName', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'HostedZoneAssociationStatus', ], ], ], 'DnsAdvancedProtection' => [ 'type' => 'string', 'enum' => [ 'DGA', 'DNS_TUNNELING', ], ], 'DnsProtocol' => [ 'type' => 'string', 'enum' => [ 'DO53', 'DOH', 'DOT', ], ], 'DnsQueryType' => [ 'type' => 'string', 'max' => 16, 'min' => 0, ], 'DnsSecValidationType' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'Domain' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '\\*?[-a-zA-Z0-9.]+', ], 'Domains' => [ 'type' => 'list', 'member' => [ 'shape' => 'Domain', ], ], 'EdnsClientSubnetType' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'EnableDNSViewInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'dnsViewId', ], ], ], 'EnableDNSViewOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'dnssecValidation', 'ednsClientSubnet', 'firewallRulesFailOpen', 'name', 'globalResolverId', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'ProfileResourceStatus', ], ], ], 'Filters' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'Strings', ], ], 'FirewallBlockResponse' => [ 'type' => 'string', 'enum' => [ 'NODATA', 'NXDOMAIN', 'OVERRIDE', ], ], 'FirewallDomainLists' => [ 'type' => 'list', 'member' => [ 'shape' => 'FirewallDomainListsItem', ], ], 'FirewallDomainListsItem' => [ 'type' => 'structure', 'required' => [ 'arn', 'globalResolverId', 'createdAt', 'id', 'name', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'FirewallRuleAction' => [ 'type' => 'string', 'enum' => [ 'ALLOW', 'ALERT', 'BLOCK', ], ], 'FirewallRulePriority' => [ 'type' => 'long', 'box' => true, 'max' => 10000, 'min' => 1, ], 'FirewallRules' => [ 'type' => 'list', 'member' => [ 'shape' => 'FirewallRulesItem', ], ], 'FirewallRulesFailOpenType' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'FirewallRulesItem' => [ 'type' => 'structure', 'required' => [ 'action', 'createdAt', 'id', 'name', 'priority', 'dnsViewId', 'status', 'updatedAt', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'queryType' => [ 'shape' => 'DnsQueryType', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'GetAccessSourceInput' => [ 'type' => 'structure', 'required' => [ 'accessSourceId', ], 'members' => [ 'accessSourceId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'accessSourceId', ], ], ], 'GetAccessSourceOutput' => [ 'type' => 'structure', 'required' => [ 'arn', 'cidr', 'createdAt', 'id', 'ipAddressType', 'dnsViewId', 'protocol', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'cidr' => [ 'shape' => 'Cidr', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'id' => [ 'shape' => 'ResourceId', ], 'ipAddressType' => [ 'shape' => 'IpAddressType', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'protocol' => [ 'shape' => 'DnsProtocol', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'GetAccessTokenInput' => [ 'type' => 'structure', 'required' => [ 'accessTokenId', ], 'members' => [ 'accessTokenId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'accessTokenId', ], ], ], 'GetAccessTokenOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'createdAt', 'dnsViewId', 'expiresAt', 'globalResolverId', 'status', 'updatedAt', 'value', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'expiresAt' => [ 'shape' => 'ISO8601TimeString', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'status' => [ 'shape' => 'TokenStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'value' => [ 'shape' => 'AccessTokenValue', ], ], ], 'GetDNSViewInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'dnsViewId', ], ], ], 'GetDNSViewOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'dnssecValidation', 'ednsClientSubnet', 'firewallRulesFailOpen', 'name', 'globalResolverId', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'ProfileResourceStatus', ], ], ], 'GetFirewallDomainListInput' => [ 'type' => 'structure', 'required' => [ 'firewallDomainListId', ], 'members' => [ 'firewallDomainListId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallDomainListId', ], ], ], 'GetFirewallDomainListOutput' => [ 'type' => 'structure', 'required' => [ 'arn', 'globalResolverId', 'createdAt', 'domainCount', 'id', 'name', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'domainCount' => [ 'shape' => 'Integer', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'statusMessage' => [ 'shape' => 'String', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'GetFirewallRuleInput' => [ 'type' => 'structure', 'required' => [ 'firewallRuleId', ], 'members' => [ 'firewallRuleId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallRuleId', ], ], ], 'GetFirewallRuleOutput' => [ 'type' => 'structure', 'required' => [ 'action', 'createdAt', 'id', 'name', 'priority', 'dnsViewId', 'status', 'updatedAt', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'queryType' => [ 'shape' => 'DnsQueryType', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'GetGlobalResolverInput' => [ 'type' => 'structure', 'required' => [ 'globalResolverId', ], 'members' => [ 'globalResolverId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'globalResolverId', ], ], ], 'GetGlobalResolverOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'clientToken', 'dnsName', 'name', 'regions', 'createdAt', 'updatedAt', 'status', 'ipv4Addresses', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnsName' => [ 'shape' => 'Sni', ], 'observabilityRegion' => [ 'shape' => 'Region', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'regions' => [ 'shape' => 'Regions', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'ipv4Addresses' => [ 'shape' => 'IPv4Addresses', ], ], ], 'GetHostedZoneAssociationInput' => [ 'type' => 'structure', 'required' => [ 'hostedZoneAssociationId', ], 'members' => [ 'hostedZoneAssociationId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'hostedZoneAssociationId', ], ], ], 'GetHostedZoneAssociationOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'resourceArn', 'hostedZoneId', 'hostedZoneName', 'name', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'hostedZoneId' => [ 'shape' => 'HostedZoneId', ], 'hostedZoneName' => [ 'shape' => 'HostedZoneName', ], 'name' => [ 'shape' => 'ResourceName', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'HostedZoneAssociationStatus', ], ], ], 'GetManagedFirewallDomainListInput' => [ 'type' => 'structure', 'required' => [ 'managedFirewallDomainListId', ], 'members' => [ 'managedFirewallDomainListId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'managedFirewallDomainListId', ], ], ], 'GetManagedFirewallDomainListOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'managedListType', ], 'members' => [ 'description' => [ 'shape' => 'ResourceDescription', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'managedListType' => [ 'shape' => 'String', ], ], ], 'GlobalResolvers' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlobalResolversItem', ], ], 'GlobalResolversItem' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'clientToken', 'dnsName', 'name', 'regions', 'createdAt', 'updatedAt', 'status', 'ipv4Addresses', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnsName' => [ 'shape' => 'Sni', ], 'observabilityRegion' => [ 'shape' => 'Region', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'regions' => [ 'shape' => 'Regions', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'ipv4Addresses' => [ 'shape' => 'IPv4Addresses', ], ], ], 'HostedZoneAssociationStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'OPERATIONAL', 'DELETING', ], ], 'HostedZoneAssociationSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'resourceArn', 'hostedZoneId', 'hostedZoneName', 'name', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'hostedZoneId' => [ 'shape' => 'HostedZoneId', ], 'hostedZoneName' => [ 'shape' => 'HostedZoneName', ], 'name' => [ 'shape' => 'ResourceName', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'HostedZoneAssociationStatus', ], ], ], 'HostedZoneAssociations' => [ 'type' => 'list', 'member' => [ 'shape' => 'HostedZoneAssociationSummary', ], ], 'HostedZoneId' => [ 'type' => 'string', 'max' => 32, 'min' => 1, ], 'HostedZoneName' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'IPv4Address' => [ 'type' => 'string', 'max' => 15, 'min' => 1, 'pattern' => '((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}', ], 'IPv4Addresses' => [ 'type' => 'list', 'member' => [ 'shape' => 'IPv4Address', ], ], 'ISO8601TimeString' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'ImportFirewallDomainsInput' => [ 'type' => 'structure', 'required' => [ 'domainFileUrl', 'firewallDomainListId', 'operation', ], 'members' => [ 'domainFileUrl' => [ 'shape' => 'String', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallDomainListId', ], 'operation' => [ 'shape' => 'String', ], ], ], 'ImportFirewallDomainsOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'status' => [ 'shape' => 'CRResourceStatus', ], ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'IpAddressType' => [ 'type' => 'string', 'enum' => [ 'IPV4', 'IPV6', ], ], 'ListAccessSourcesInput' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'filters' => [ 'shape' => 'Filters', 'location' => 'querystring', ], ], ], 'ListAccessSourcesOutput' => [ 'type' => 'structure', 'required' => [ 'accessSources', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'accessSources' => [ 'shape' => 'AccessSources', ], ], ], 'ListAccessTokensInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'dnsViewId', ], 'filters' => [ 'shape' => 'Filters', 'location' => 'querystring', ], ], ], 'ListAccessTokensOutput' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'accessTokens' => [ 'shape' => 'AccessTokens', ], ], ], 'ListDNSViewsInput' => [ 'type' => 'structure', 'required' => [ 'globalResolverId', ], 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'globalResolverId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'globalResolverId', ], ], ], 'ListDNSViewsOutput' => [ 'type' => 'structure', 'required' => [ 'dnsViews', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'dnsViews' => [ 'shape' => 'DNSViews', ], ], ], 'ListFirewallDomainListsInput' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'globalResolverId' => [ 'shape' => 'ResourceId', 'location' => 'querystring', 'locationName' => 'global_resolver_id', ], ], ], 'ListFirewallDomainListsOutput' => [ 'type' => 'structure', 'required' => [ 'firewallDomainLists', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'firewallDomainLists' => [ 'shape' => 'FirewallDomainLists', ], ], ], 'ListFirewallDomainsInput' => [ 'type' => 'structure', 'required' => [ 'firewallDomainListId', ], 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallDomainListId', ], ], ], 'ListFirewallDomainsOutput' => [ 'type' => 'structure', 'required' => [ 'domains', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'domains' => [ 'shape' => 'Domains', ], ], ], 'ListFirewallRulesInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'querystring', 'locationName' => 'dnsview_id', ], 'filters' => [ 'shape' => 'Filters', 'location' => 'querystring', ], ], ], 'ListFirewallRulesOutput' => [ 'type' => 'structure', 'required' => [ 'firewallRules', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'firewallRules' => [ 'shape' => 'FirewallRules', ], ], ], 'ListGlobalResolversInput' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], ], ], 'ListGlobalResolversOutput' => [ 'type' => 'structure', 'required' => [ 'globalResolvers', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'globalResolvers' => [ 'shape' => 'GlobalResolvers', ], ], ], 'ListHostedZoneAssociationsInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'resourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListHostedZoneAssociationsOutput' => [ 'type' => 'structure', 'required' => [ 'hostedZoneAssociations', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'hostedZoneAssociations' => [ 'shape' => 'HostedZoneAssociations', ], ], ], 'ListManagedFirewallDomainListsInput' => [ 'type' => 'structure', 'required' => [ 'managedFirewallDomainListType', ], 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'max_results', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'next_token', ], 'managedFirewallDomainListType' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'managedFirewallDomainListType', ], ], ], 'ListManagedFirewallDomainListsOutput' => [ 'type' => 'structure', 'required' => [ 'managedFirewallDomainLists', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'managedFirewallDomainLists' => [ 'shape' => 'ManagedFirewallDomainLists', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ResourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'Tags', ], ], ], 'ManagedFirewallDomainLists' => [ 'type' => 'list', 'member' => [ 'shape' => 'ManagedFirewallDomainListsItem', ], ], 'ManagedFirewallDomainListsItem' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'managedListType', ], 'members' => [ 'description' => [ 'shape' => 'ResourceDescription', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'managedListType' => [ 'shape' => 'String', ], ], ], 'ProfileResourceStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'OPERATIONAL', 'UPDATING', 'ENABLING', 'DISABLING', 'DISABLED', 'DELETING', ], ], 'Region' => [ 'type' => 'string', 'max' => 32, 'min' => 0, ], 'Regions' => [ 'type' => 'list', 'member' => [ 'shape' => 'Region', ], ], 'ResourceArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 'arn:[-.a-z0-9]{1,63}:[-.a-z0-9]{1,63}:[-.a-z0-9]{0,63}:[-.a-z0-9]{0,63}:[^/].{0,1023}', ], 'ResourceDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'ResourceId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[-.a-zA-Z0-9]+', ], 'ResourceName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '(?!^[0-9]+$)([a-zA-Z0-9-_/\' \']+)', ], 'ResourceNameShort' => [ 'type' => 'string', 'max' => 32, 'min' => 1, 'pattern' => '(?!^[0-9]+$)([a-zA-Z0-9-_/\' \']+)', ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], 'serviceCode' => [ 'shape' => 'String', ], 'quotaCode' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'Sni' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'String' => [ 'type' => 'string', ], 'Strings' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)', ], 'TagKeys' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)', ], 'Tags' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 0, ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'serviceCode' => [ 'shape' => 'String', ], 'quotaCode' => [ 'shape' => 'String', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => true, ], ], 'TokenStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'OPERATIONAL', 'DELETING', ], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAccessSourceInput' => [ 'type' => 'structure', 'required' => [ 'accessSourceId', ], 'members' => [ 'accessSourceId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'accessSourceId', ], 'cidr' => [ 'shape' => 'Cidr', ], 'ipAddressType' => [ 'shape' => 'IpAddressType', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'protocol' => [ 'shape' => 'DnsProtocol', ], ], ], 'UpdateAccessSourceOutput' => [ 'type' => 'structure', 'required' => [ 'arn', 'cidr', 'createdAt', 'id', 'ipAddressType', 'dnsViewId', 'protocol', 'status', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'ResourceArn', ], 'cidr' => [ 'shape' => 'Cidr', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'id' => [ 'shape' => 'ResourceId', ], 'ipAddressType' => [ 'shape' => 'IpAddressType', ], 'name' => [ 'shape' => 'ResourceNameShort', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'protocol' => [ 'shape' => 'DnsProtocol', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'UpdateAccessTokenInput' => [ 'type' => 'structure', 'required' => [ 'accessTokenId', 'name', ], 'members' => [ 'accessTokenId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'accessTokenId', ], 'name' => [ 'shape' => 'ResourceNameShort', ], ], ], 'UpdateAccessTokenOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceNameShort', ], ], ], 'UpdateDNSViewInput' => [ 'type' => 'structure', 'required' => [ 'dnsViewId', ], 'members' => [ 'dnsViewId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'dnsViewId', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], ], ], 'UpdateDNSViewOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'dnssecValidation', 'ednsClientSubnet', 'firewallRulesFailOpen', 'name', 'globalResolverId', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnssecValidation' => [ 'shape' => 'DnsSecValidationType', ], 'ednsClientSubnet' => [ 'shape' => 'EdnsClientSubnetType', ], 'firewallRulesFailOpen' => [ 'shape' => 'FirewallRulesFailOpenType', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'globalResolverId' => [ 'shape' => 'ResourceId', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'ProfileResourceStatus', ], ], ], 'UpdateFirewallDomainsInput' => [ 'type' => 'structure', 'required' => [ 'domains', 'firewallDomainListId', 'operation', ], 'members' => [ 'domains' => [ 'shape' => 'Domains', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallDomainListId', ], 'operation' => [ 'shape' => 'String', ], ], ], 'UpdateFirewallDomainsOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'status' => [ 'shape' => 'CRResourceStatus', ], ], ], 'UpdateFirewallRuleInput' => [ 'type' => 'structure', 'required' => [ 'clientToken', 'firewallRuleId', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallRuleId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'firewallRuleId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], ], ], 'UpdateFirewallRuleOutput' => [ 'type' => 'structure', 'required' => [ 'action', 'createdAt', 'id', 'name', 'priority', 'dnsViewId', 'status', 'updatedAt', ], 'members' => [ 'action' => [ 'shape' => 'FirewallRuleAction', ], 'blockOverrideDnsType' => [ 'shape' => 'BlockOverrideDnsQueryType', ], 'blockOverrideDomain' => [ 'shape' => 'Domain', ], 'blockOverrideTtl' => [ 'shape' => 'BlockOverrideTtl', ], 'blockResponse' => [ 'shape' => 'FirewallBlockResponse', ], 'confidenceThreshold' => [ 'shape' => 'ConfidenceThreshold', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'dnsAdvancedProtection' => [ 'shape' => 'DnsAdvancedProtection', ], 'firewallDomainListId' => [ 'shape' => 'ResourceId', ], 'id' => [ 'shape' => 'ResourceId', ], 'name' => [ 'shape' => 'ResourceName', ], 'priority' => [ 'shape' => 'FirewallRulePriority', ], 'dnsViewId' => [ 'shape' => 'ResourceId', ], 'queryType' => [ 'shape' => 'DnsQueryType', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], ], ], 'UpdateGlobalResolverInput' => [ 'type' => 'structure', 'required' => [ 'globalResolverId', ], 'members' => [ 'globalResolverId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'globalResolverId', ], 'name' => [ 'shape' => 'ResourceName', ], 'observabilityRegion' => [ 'shape' => 'Region', ], 'description' => [ 'shape' => 'ResourceDescription', ], ], ], 'UpdateGlobalResolverOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'clientToken', 'dnsName', 'name', 'regions', 'createdAt', 'updatedAt', 'status', 'ipv4Addresses', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'arn' => [ 'shape' => 'ResourceArn', ], 'clientToken' => [ 'shape' => 'ClientToken', ], 'dnsName' => [ 'shape' => 'Sni', ], 'observabilityRegion' => [ 'shape' => 'Region', ], 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'regions' => [ 'shape' => 'Regions', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'CRResourceStatus', ], 'ipv4Addresses' => [ 'shape' => 'IPv4Addresses', ], ], ], 'UpdateHostedZoneAssociationInput' => [ 'type' => 'structure', 'required' => [ 'hostedZoneAssociationId', ], 'members' => [ 'hostedZoneAssociationId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'hostedZoneAssociationId', ], 'name' => [ 'shape' => 'ResourceName', ], ], ], 'UpdateHostedZoneAssociationOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'resourceArn', 'hostedZoneId', 'hostedZoneName', 'name', 'createdAt', 'updatedAt', 'status', ], 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'resourceArn' => [ 'shape' => 'ResourceArn', ], 'hostedZoneId' => [ 'shape' => 'HostedZoneId', ], 'hostedZoneName' => [ 'shape' => 'HostedZoneName', ], 'name' => [ 'shape' => 'ResourceName', ], 'createdAt' => [ 'shape' => 'ISO8601TimeString', ], 'updatedAt' => [ 'shape' => 'ISO8601TimeString', ], 'status' => [ 'shape' => 'HostedZoneAssociationStatus', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', 'reason', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'UNKNOWN_OPERATION', 'CANNOT_PARSE', 'FIELD_VALIDATION_FAILED', 'OTHER', ], ], ],];
