{{-- SPDX-License-Identifier: MIT --}}
<div class="bg-gray-800 pt-16 pb-48 lg:px-32 px-4">
	<div class="container mx-auto">
	<div class="flex flex-col lg:flex-row md:flex-row items-center justify-between">
		<div class="w-full lg:w-1/2">
		<h2 class="text-2xl lg:text-4xl font-plex text-gray-100 mb-2">A robust platform for School Management and School Communication Management</h2>
		<p class="font-exo font-medium text-gray-100 tracking-wide leading-relaxed">We worked hard to develop the secure, scalable cloud solution for schools. It is easy for you to get started with our modern day school ERP solution. </p>
		<div class="flex lg:flex-row md:flex-row flex-col mt-8">
			<div class="w-full lg:w-1/2 mb-8 lg:mb-0">
				<div class="bg-white text-gray-900 w-16 h-16 rounded-full flex justify-center items-center">
                    <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="57" height="56" viewBox="0 0 57 56">
  <g transform="translate(1 3)">
    <path d="M34.524131,36.8524845 L34.524131,33.1024845 L45.7719893,33.1024845 C49.0868806,33.1024845 51.774131,30.4152341 51.774131,27.1003427 C51.774131,24.3015031 49.8409938,21.890444 47.1573791,21.2580066 L43.9834738,20.5100242 L44.2834668,17.2630014 C44.3167576,16.9026725 44.3335279,16.5391274 44.3335279,16.1729948 C44.3335279,9.7375897 39.1166013,4.52066307 32.6811961,4.52066307 C28.6869556,4.52066307 25.0428468,6.54208569 22.9037463,9.83103522 L21.3792775,12.1749647 L18.6977601,11.3828318 C18.2430482,11.2485078 17.7676239,11.1793923 17.2788644,11.1793923 C14.5209738,11.1793923 12.2852618,13.4151043 12.2852618,16.1729948 C12.2852618,16.224154 12.2860189,16.2751635 12.2875287,16.326017 L12.3787986,19.4002123 L9.38191809,20.0913808 C6.4204754,20.7743764 4.28252942,23.4284284 4.28252942,26.5127397 C4.28252942,30.1521552 7.23285867,33.1024845 10.8722742,33.1024845 L21.5241311,33.1024845 L21.524131,36.8524845 L10.8722742,36.8524845 C5.16179086,36.8524845 0.532529419,32.223223 0.532529419,26.5127397 C0.532529419,21.6045779 3.95235292,17.4951588 8.5391803,16.4373019 C8.53657409,16.3495183 8.53526178,16.2614098 8.53526178,16.1729948 C8.53526178,11.3440365 12.449906,7.42939227 17.2788644,7.42939227 C18.1407721,7.42939227 18.9735519,7.5541039 19.7601433,7.7864667 C22.5068558,3.56329032 27.2678994,0.770663069 32.6811961,0.770663069 C41.1876691,0.770663069 48.0835279,7.66652189 48.0835279,16.1729948 C48.0835279,16.6568639 48.0612156,17.1355216 48.0175636,17.6079953 C52.3210371,18.6221788 55.524131,22.4871994 55.524131,27.1003427 C55.524131,32.4863019 51.1579484,36.8524845 45.7719893,36.8524845 L34.524131,36.8524845 L34.524131,36.8524845 Z"/>
    <path d="M27.944431,17.0584061 C28.436631,17.0584061 28.835031,17.2224061 29.303831,17.6912061 L37.225631,25.3318061 C37.577231,25.6834061 37.788231,26.0584061 37.788231,26.5740061 C37.788231,27.5349061 37.085031,28.2146061 36.100631,28.2146061 C35.631931,28.2146061 35.139731,28.0271061 34.811631,27.6521061 L31.249131,23.8787061 L29.655331,22.2146061 L29.819431,25.7068061 L29.819431,43.7692817 C29.819431,44.7535817 28.952231,45.5739817 27.944431,45.5739817 C26.936631,45.5739817 26.092831,44.7535817 26.092831,43.7692817 L26.092831,25.7068061 L26.233531,22.2146061 L24.639731,23.8787061 L21.100631,27.6521061 C20.772531,28.0271061 20.280331,28.2146061 19.835031,28.2146061 C18.850631,28.2146061 18.124131,27.5349061 18.124131,26.5740061 C18.124131,26.0584061 18.311631,25.6834061 18.663131,25.3318061 L26.585031,17.6912061 C27.053831,17.2224061 27.475631,17.0584061 27.944431,17.0584061 Z"/>
  </g>
</svg>
                </div>
				<h2 class="text-xl text-gray-100 my-2 font-plex">Cloud Storage</h2>
				<p class="font-primary font-normal text-gray-100 tracking-wide leading-relaxed">All your data files are stored in AWS cloud. </p>
			</div>
			<div class="w-full lg:w-1/2">
				<div class="bg-white text-gray-900 w-16 h-16 rounded-full flex justify-center items-center">
                    <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56">
  <path fill-rule="evenodd" d="M13,22 L13,32 C16.5185185,31.6836983 18,29.7128954 18,27.1094891 C18,24.6034063 16.8477366,23.1192214 13,22 Z M10,17 L10,8 C6.72727273,8.41538462 5,10.3307692 5,12.4307692 C5,14.5307692 6.36363636,16.0769231 10,17 Z M12.8398058,17.7367206 L13.9116505,18.0138568 C19.784466,19.4226328 23,21.9168591 23,26.8360277 C23,32.4942263 18.5339806,35.704388 12.8398058,36.1200924 L12.8398058,40 L10.3165049,40 L10.3165049,36.1200924 C4.64466019,35.6812933 0.15631068,32.3787529 0,26.8360277 L4.6223301,26.8360277 C5.02427184,29.5381062 6.72135922,31.5242494 10.3165049,31.9168591 L10.3165049,21.8475751 L9.40097087,21.6166282 C3.72912621,20.2540416 0.669902913,17.6212471 0.669902913,12.9330254 C0.669902913,7.75981524 4.68932039,4.34180139 10.3165049,3.90300231 L10.3165049,0 L12.8398058,0 L12.8398058,3.90300231 C18.4223301,4.36489607 22.4640777,7.82909931 22.6427184,13.0715935 L17.9980583,13.0715935 C17.707767,10.1616628 15.6980583,8.47575058 12.8398058,8.10623557 L12.8398058,17.7367206 Z" transform="translate(16 8)"/>
</svg>
                </div>
				<h2 class="text-xl text-gray-100 my-2 font-plex">Simple Pricing</h2>
				<p class="font-primary font-normal text-gray-100 tracking-wide leading-relaxed">All your data files are stored in AWS cloud. </p>
			</div>
		</div>
	</div>
	<div class="w-full lg:w-1/2 md:w-1/2" data-aos="fade-up"
     data-aos-duration="3000">
		<!-- <lottie-player src="https://assets8.lottiefiles.com/packages/lf20_sSF6EG.json"  background="transparent"  speed="1"  style="width: 500px; height: 500px;margin:auto;"  loop  autoplay></lottie-player> -->
		<!-- <lottie-player src="https://assets7.lottiefiles.com/packages/lf20_GsFUFN.json"  background="transparent"  speed="1"  style="width: 600px; height: 600px; margin:auto;"  loop  autoplay></lottie-player> -->
		<lottie-player src="https://assets5.lottiefiles.com/packages/lf20_qDHlG2.json"  background="transparent"  speed="1"  style="margin: auto;"  loop  autoplay></lottie-player> <!-- width: 600px; height: 600px; -->
	</div>
	</div>
</div>
</div>
<div class="container mx-auto -mt-32 px-8 lg:px-24">
	<div class="w-full">
		<img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/gegok12_dashboard.jpg" class="hero-image border-8 object-scale-down w-full">
	</div>
</div>
<div class="container mx-auto my-24 flex flex-wrap">
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
            <svg class="h-8 fill-current"xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g>
            <g>
                <path d="M466,242.581c0-168.832,0.472-158.076-1.102-161.96c3.369-8.323-1.27-17.612-9.777-20.043l-210-60    c-2.693-0.77-5.548-0.77-8.241,0l-210,60C20.439,62.417,16,68.303,16,75.001s4.439,12.583,10.879,14.423L106,112.029    c0,0.679,0,1.306,0,1.891c0,5.083,0,6.755,0,6.727c0,8.27,0,25.579,0,59.353c0,58.278,30.068,108.896,73.87,133.718l-8.275,16.55    c-40.483,2.316-78.308,19.564-107.364,49.156C33.129,411.1,16,452.855,16,497.001c0,8.284,6.716,15,15,15h420    c8.284,0,15-6.716,15-15c0-44.145-17.129-85.9-48.231-117.575c-29.054-29.59-66.879-46.827-107.359-49.146l-8.281-16.561    C345.932,288.897,376,238.279,376,180.001c0-3.699,0-66.967,0-67.971l60-17.143v147.694c-17.459,6.192-30,22.865-30,42.42v30    c0,8.284,6.716,15,15,15h60c8.284,0,15-6.716,15-15v-30C496,265.446,483.459,248.772,466,242.581z M226,482.001H46.804    c7.103-65.907,60.46-117.899,126.328-121.761L226,439.543V482.001z M198.309,343.923l9.286-18.573    c10.687,3.034,21.879,4.651,33.405,4.651s22.717-1.617,33.404-4.65l9.286,18.572L241,407.959L198.309,343.923z M308.868,360.241    c65.868,3.86,119.225,55.853,126.328,121.76H256v-42.458L308.868,360.241z M241,300.001c-50.888,0-93.431-41.589-102.988-96.587    c31.678,14.133,67.086,21.587,102.988,21.587c35.9,0,71.308-7.453,102.987-21.584C334.43,258.413,291.887,300.001,241,300.001z     M345.672,163.069c-0.872,4.334-3.441,7.986-7.037,9.752c-29.533,14.51-63.294,22.179-97.635,22.179    c-34.344,0-68.106-7.671-97.637-22.183c-4.892-2.403-7.363-7.967-7.363-13.031V120.6c108.861,31.103,101.999,29.4,105,29.4    c3,0-3.883,1.71,105-29.4C346,163.657,346.119,160.868,345.672,163.069z M241,119.401l-155.399-44.4L241,30.6l155.399,44.4    L241,119.401z M466,300.001h-30v-15c0-8.271,6.729-15,15-15s15,6.729,15,15V300.001z" data-original="#000000" class="active-path" data-old_color="#000000" />
            </g>
        </g><g>
            <g>
                <path d="M361,420.001h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S369.284,420.001,361,420.001z" data-original="#000000" class="active-path" data-old_color="#000000" />
            </g>
        </g></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Searchable Student Records</h5>
			<p class="text-sm font-medium">Search or Brwose the students by Class, by Name or by Locality</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center" >
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56"><path d="M 13.7851 49.5742 L 42.2382 49.5742 C 47.1366 49.5742 49.5743 47.1367 49.5743 42.3086 L 49.5743 13.6914 C 49.5743 8.8633 47.1366 6.4258 42.2382 6.4258 L 13.7851 6.4258 C 8.9101 6.4258 6.4257 8.8398 6.4257 13.6914 L 6.4257 42.3086 C 6.4257 47.1602 8.9101 49.5742 13.7851 49.5742 Z M 13.8554 45.8008 C 11.5117 45.8008 10.1992 44.5586 10.1992 42.1211 L 10.1992 13.8789 C 10.1992 11.4414 11.5117 10.1992 13.8554 10.1992 L 42.1679 10.1992 C 44.4882 10.1992 45.8007 11.4414 45.8007 13.8789 L 45.8007 42.1211 C 45.8007 44.5586 44.4882 45.8008 42.1679 45.8008 Z M 20.8398 38.7696 C 21.7539 38.7696 22.4101 38.1133 22.4101 37.1758 L 22.4101 25.0352 L 22.2695 21.4258 L 24.4726 24.0508 L 26.2304 26.0898 C 26.4648 26.3945 26.8866 26.5586 27.3554 26.5586 C 28.2226 26.5586 28.9023 25.8789 28.9023 25.0118 C 28.9023 24.5664 28.7382 24.1914 28.4570 23.9102 L 22.1992 17.3242 C 21.8007 16.9023 21.3085 16.6914 20.8398 16.6914 C 20.3710 16.6914 19.9257 16.8789 19.5039 17.3242 L 13.1992 23.9102 C 12.9179 24.1914 12.7773 24.5664 12.7773 25.0118 C 12.7773 25.8789 13.4570 26.5586 14.3241 26.5586 C 14.7695 26.5586 15.1679 26.3945 15.4492 26.0898 L 17.2304 24.0508 L 19.3866 21.4727 L 19.2460 25.0352 L 19.2460 37.1758 C 19.2460 38.1133 19.9023 38.7696 20.8398 38.7696 Z M 35.1835 38.7696 C 35.6757 38.7696 36.1679 38.5820 36.5663 38.1367 L 42.8241 31.5742 C 43.1054 31.2930 43.2695 30.8945 43.2695 30.4727 C 43.2695 29.5820 42.5663 28.9258 41.6992 28.9258 C 41.2539 28.9258 40.8320 29.0664 40.5742 29.3945 L 38.8398 31.4102 L 36.6132 34.0352 L 36.7773 30.4258 L 36.7773 18.2852 C 36.7773 17.3711 36.1210 16.6914 35.1835 16.6914 C 34.2695 16.6914 33.5898 17.3711 33.5898 18.2852 L 33.5898 30.4258 L 33.7539 34.0118 L 31.5976 31.4102 L 29.7929 29.3945 C 29.5351 29.0664 29.1366 28.9258 28.6679 28.9258 C 27.8007 28.9258 27.1444 29.5820 27.1444 30.4727 C 27.1444 30.8945 27.2851 31.2930 27.5663 31.5742 L 33.8476 38.1367 C 34.2695 38.6055 34.7382 38.7696 35.1835 38.7696 Z"/></svg>
            </div>
			<h5 class="font-bold mt-2">Export / Import Student Data</h5>
			<p class="text-sm font-medium">Simply Import or Export Student Data to CSV format</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 -32 512 512" width="512px"><g><path d="m464.867188 0h-224.933594c-25.988282 0-47.132813 21.144531-47.132813 47.132812v144.292969l-41.765625-20.769531c-1.410156-.703125-2.84375-1.367188-4.289062-1.996094 12.261718-12.800781 19.820312-30.144531 19.820312-49.226562 0-39.277344-31.953125-71.234375-71.230468-71.234375-39.28125 0-71.234376 31.957031-71.234376 71.234375 0 21.34375 9.449219 40.515625 24.371094 53.582031-27.480468 15.460937-48.472656 45.621094-48.472656 82.984375v48.199219c0 20.75 13.472656 38.410156 32.132812 44.6875v83.847656c0 8.28125 6.714844 15 15 15h96.398438c8.285156 0 15-6.71875 15-15v-168.535156l48.023438 24.007812c18.378906 9.1875 43.308593 3.710938 54.582031-17.207031h53.78125l-56.949219 156.605469c-2.832031 7.785156 1.1875 16.394531 8.972656 19.222656 8.898438 3.238281 16.8125-2.34375 19.222656-8.96875l60.675782-166.859375h10.515625l61.296875 166.90625c2.328125 6.332031 10.183594 12.238281 19.253906 8.90625 7.773438-2.855469 11.765625-11.472656 8.90625-19.25l-57.5-156.5625h75.554688c25.484374 0 47.132812-20.558594 47.132812-47.132812v-176.734376c0-26.578124-21.648438-47.132812-47.132812-47.132812zm-410.765626 119.433594c0-22.738282 18.496094-41.234375 41.230469-41.234375 22.738281 0 41.234375 18.496093 41.234375 41.234375 0 22.734375-18.496094 41.230468-41.234375 41.230468-22.734375 0-41.230469-18.496093-41.230469-41.230468zm181.398438 135.527344c-.039062.109374-.078125.222656-.113281.335937-1.023438 2.855469-3.335938 5.261719-6.167969 6.425781-2.996094 1.21875-6.367188 1.089844-9.246094-.347656-28.523437-14.269531-69.738281-34.859375-69.738281-34.859375-9.953125-4.976563-21.703125 2.273437-21.703125 13.417969v177.800781h-66.398438v-81.402344c0-8.28125-6.71875-15-15-15-9.449218 0-17.132812-7.683593-17.132812-17.132812v-48.199219c0-36.652344 29.84375-65.332031 65.332031-65.332031h13.253907c10.054687 0 20.097656 2.359375 29.070312 6.839843 0 0 74.402344 37 93.351562 46.4375 4.058594 2.015626 5.988282 6.75 4.492188 11.015626zm246.5-31.09375c0 4.582031-1.777344 8.882812-5.011719 12.117187-3.183593 3.1875-7.601562 5.015625-12.121093 5.015625h-200.46875c-.027344-.082031-.046876-.164062-.074219-.242188l37.226562-74.449218c3.703125-7.410156.703125-16.417969-6.707031-20.125-7.40625-3.703125-16.417969-.703125-20.125 6.707031l-31.75 63.496094c-5.917969-2.949219-12.796875-6.375-20.167969-10.039063v-159.214844c0-9.445312 7.683594-17.132812 17.132813-17.132812h224.933594c4.519531 0 8.9375 1.828125 12.125 5.023438 3.230468 3.226562 5.007812 7.527343 5.007812 12.109374zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m432.734375 64.265625h-160.667969c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h160.667969c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m432.734375 120.5h-80.335937c-8.28125 0-15 6.714844-15 15s6.71875 15 15 15h80.335937c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m432.734375 176.734375h-80.335937c-8.28125 0-15 6.714844-15 15 0 8.28125 6.71875 15 15 15h80.335937c8.28125 0 15-6.71875 15-15 0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Teacher / Staff Records</h5>
			<p class="text-sm font-medium">Organize the Teacher and Staff Records as easly searchable database.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center" >
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-1 0 512 512" width="512px"><g><path d="m360 242.839844v-207.839844c0-19.300781-15.699219-35-35-35h-290c-19.300781 0-35 15.699219-35 35v381c0 19.300781 15.699219 35 35 35h227.148438c24.152343 36.710938 65.714843 61 112.851562 61 74.4375 0 135-60.5625 135-135 0-79.980469-69.660156-143.085938-150-134.160156zm-325 178.160156c-2.757812 0-5-2.242188-5-5v-381c0-2.757812 2.242188-5 5-5h290c2.757812 0 5 2.242188 5 5v214.722656c-14.539062 5.15625-27.941406 12.734375-39.71875 22.253906-3.734375-1.410156 6.6875-.976562-155.28125-.976562-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h128.484375c-6.320313 9.242188-11.523437 19.308594-15.410156 30h-113.074219c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h105.953125c-2.425781 20.433594-.191406 40.886719 6.414063 60zm340 61c-57.898438 0-105-47.101562-105-105s47.101562-105 105-105 105 47.101562 105 105-47.101562 105-105 105zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m135 121h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m135 181h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m135 241h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m90 106c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m90 166c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m90 226c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m90 286c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m90 346c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m375 301c-8.285156 0-15 6.714844-15 15v45h-30c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h45c8.285156 0 15-6.714844 15-15v-60c0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Activity Logs</h5>
			<p class="text-sm font-medium">All app related activities and data updates are logged.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 511.998 511.998" style="enable-background:new 0 0 511.998 511.998;" xml:space="preserve" width="512px" height="512px"><g><g>
	<g>
		<path d="M386.872,397.626c-2.031-5.158-7.859-7.698-13.02-5.663l-70.492,27.755c-5.159,2.031-7.695,7.86-5.663,13.02    c1.556,3.951,5.339,6.364,9.344,6.364c1.223,0,2.468-0.226,3.675-0.701l70.492-27.755    C386.368,408.615,388.904,402.786,386.872,397.626z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M402.433,381.438c-12.919,0-12.94,20.078,0,20.078C415.352,401.516,415.374,381.438,402.433,381.438z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M478.201,247.628c-0.138-0.66-0.34-1.295-0.6-1.9c0,0-0.001-0.002-0.001-0.003c-0.006-0.013-0.013-0.025-0.019-0.039    c-0.125-0.289-0.263-0.57-0.415-0.844c-0.064-0.117-0.139-0.228-0.208-0.341c-0.097-0.162-0.192-0.324-0.298-0.48    c-0.109-0.161-0.23-0.312-0.347-0.465c-0.077-0.099-0.151-0.203-0.232-0.3c-0.138-0.165-0.284-0.319-0.431-0.474    c-0.075-0.079-0.147-0.161-0.225-0.238c-0.149-0.147-0.304-0.282-0.46-0.419c-0.089-0.078-0.177-0.159-0.269-0.234    c-0.146-0.117-0.296-0.226-0.448-0.334c-0.115-0.083-0.229-0.17-0.347-0.248c-0.133-0.088-0.272-0.168-0.409-0.249    c-0.146-0.086-0.29-0.175-0.44-0.254c-0.12-0.063-0.246-0.118-0.368-0.178c-0.171-0.081-0.341-0.164-0.518-0.236    c-0.12-0.049-0.244-0.089-0.365-0.134c-0.181-0.065-0.36-0.133-0.546-0.189c-0.147-0.044-0.296-0.077-0.445-0.114    c-0.162-0.04-0.321-0.084-0.486-0.117c-0.221-0.044-0.444-0.073-0.668-0.102c-0.095-0.012-0.19-0.031-0.286-0.04    c-1.046-0.105-2.117-0.043-3.177,0.195c-0.616,0.137-1.213,0.326-1.781,0.571l-54.72,23.5    c-23.478-40.073-61.031-68.797-104.573-81.214c29.199-16.986,48.872-48.62,48.872-84.765C353.991,43.955,310.031,0,255.999,0    c-54.028,0-97.982,43.954-97.982,97.982c0,36.145,19.672,67.778,48.868,84.765c-43.537,12.416-81.091,41.139-104.576,81.212    l-54.722-23.498c-0.618-0.266-1.268-0.475-1.943-0.612c-0.673-0.139-1.35-0.204-2.021-0.204c-0.002,0-0.004,0-0.005,0    c-0.329,0-0.656,0.017-0.981,0.049c-0.122,0.012-0.241,0.035-0.362,0.051c-0.199,0.027-0.397,0.052-0.592,0.09    c-0.182,0.035-0.357,0.083-0.535,0.128c-0.133,0.034-0.266,0.063-0.397,0.102c-0.197,0.058-0.388,0.13-0.579,0.2    c-0.111,0.041-0.224,0.077-0.334,0.122c-0.184,0.075-0.361,0.161-0.54,0.246c-0.116,0.055-0.234,0.107-0.348,0.168    c-0.156,0.082-0.305,0.173-0.455,0.262c-0.133,0.079-0.266,0.156-0.396,0.24c-0.122,0.08-0.238,0.168-0.356,0.254    c-0.149,0.107-0.297,0.214-0.441,0.329c-0.093,0.076-0.182,0.158-0.272,0.237c-0.156,0.135-0.31,0.27-0.458,0.416    c-0.078,0.077-0.151,0.16-0.226,0.24c-0.147,0.155-0.292,0.308-0.43,0.472c-0.081,0.097-0.155,0.2-0.232,0.3    c-0.118,0.154-0.238,0.304-0.348,0.465c-0.106,0.155-0.201,0.318-0.298,0.479c-0.069,0.115-0.143,0.224-0.208,0.342    c-0.152,0.274-0.288,0.555-0.415,0.844c-0.006,0.013-0.013,0.025-0.019,0.039c0,0.001-0.001,0.002-0.001,0.002    c-0.26,0.606-0.463,1.242-0.6,1.901c-0.144,0.685-0.213,1.373-0.213,2.057V410.75c0,4.014,2.39,7.641,6.078,9.224l212.378,91.206    c0.348,0.15,0.702,0.274,1.056,0.383c0.059,0.018,0.12,0.029,0.179,0.046c0.377,0.107,0.756,0.189,1.136,0.25    c0.09,0.014,0.181,0.029,0.271,0.041c0.439,0.058,0.877,0.098,1.315,0.098c0.039,0,0.077-0.008,0.117-0.009    c0.385-0.004,0.77-0.035,1.153-0.084c0.128-0.016,0.254-0.036,0.38-0.058c0.344-0.057,0.686-0.132,1.024-0.226    c0.078-0.022,0.158-0.037,0.236-0.061c0.356-0.107,0.709-0.232,1.055-0.38l212.378-91.206c3.687-1.583,6.078-5.21,6.078-9.224    V249.685C478.415,249.001,478.346,248.313,478.201,247.628z M178.093,97.983c0-42.956,34.947-77.904,77.904-77.904    c42.962,0,77.914,34.948,77.914,77.904c0,42.963-34.951,77.914-77.914,77.914C213.04,175.897,178.093,140.946,178.093,97.983z     M245.957,486.722l-192.3-82.583V264.92h0.001l48.648,20.89c0.134,0.064,0.27,0.126,0.407,0.186l143.245,61.51V486.722z     M255.996,329.964l-135.104-58.013c28.622-47.125,79.447-75.975,135.105-75.975c55.666,0,106.49,28.848,135.103,75.969    L255.996,329.964z M458.336,404.138l-192.3,82.583V347.504l192.3-82.583V404.138z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Classroom Management</h5>
			<p class="text-sm font-medium">Student Data orgainized by Classes for effective record keeping and day to day management.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 w-auto fill-current" xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px"><g><g><path d="m74.791 114.523c26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.441.561-16.425-6.881-20.067-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.115 8.283 6.507 15.091 14.79 15.207z" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m202.593 176.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m202.593 236.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m309.407 116.126c-7.441 3.641-10.521 12.625-6.881 20.067 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 37.64-18.419 75.865-28.024 113.616-28.55 8.283-.115 14.905-6.924 14.789-15.208-.115-8.283-6.876-14.901-15.207-14.79-42.213.589-84.735 11.221-126.383 31.601z" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m500.638 7.584c-18.59-4.713-37.148-7.584-60.591-7.584-.016 0-.035 0-.05 0-43.627.009-110.281 11.25-183.997 63.569-73.272-52-139.55-63.382-182.937-63.566-24.136-.104-43.055 2.852-61.7 7.581-6.678 1.67-11.363 7.669-11.363 14.552v294.5c0 4.619 2.128 8.98 5.769 11.823 6.635 5.182 13.606 2.463 13.981 2.448 41.952-10.63 127.258-17.266 227.25 57.729 2.667 2 5.833 3 9 3s6.333-1 9-3c31.188-23.391 63.401-40.556 96-51.235v159.599c0 8.284 6.716 15 15 15h60c8.284 0 15-6.716 15-15v-172.236c21.132 1.097 36.088 4.848 41.675 6.252.277.008 7.061 2.515 13.557-2.557 3.641-2.843 5.769-7.204 5.769-11.823v-294.5c-.001-6.883-4.685-12.882-11.363-14.552zm-470.638 290.414v-263.956c9.661-1.955 24.286-4.124 42.937-4.04 39.466.168 100.214 10.809 168.063 59.726v258.166c-45.801-29.614-93.332-47.095-141.641-52.035-29.797-3.047-53.622-.62-69.359 2.139zm385.485-56.998h-18.969l9.484-29.8zm5.515 241h-30v-211h30zm61-183.931c-8.266-1.429-18.763-2.783-31-3.342v-38.667c.009-1.64-.255-3.321-.813-4.942l-29.894-93.926c-2.22-6.938-9.127-11.275-16.273-10.32-31.752 4.227-63.585 14.069-94.613 29.253-7.441 3.641-10.521 12.625-6.881 20.066 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 20.297-9.932 40.912-17.319 61.544-22.097l-22.324 70.143c-.521 1.513-.806 3.135-.813 4.823v50.053c-30.537 8.934-60.681 22.965-90 41.91v-258.175c68.249-49.206 129.329-59.72 169.004-59.728h.043c18.182 0 32.464 2.124 41.954 4.043z" data-original="#000000" class="active-path" data-old_color="#000000" /></g></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Homework / Assignment</h5>
			<p class="text-sm font-medium">In a simple click give homework to students and update it to Parent & Student Apps.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 0 480 480" width="512px"><g><path d="m399.832031 54.398438c-.0625-.277344-.230469-.496094-.3125-.757813-.136719-.449219-.316406-.882813-.535156-1.296875-.25-.476562-.550781-.921875-.894531-1.335938-.277344-.34375-.582032-.664062-.914063-.960937-.402343-.339844-.84375-.632813-1.3125-.878906-.394531-.238281-.8125-.441407-1.246093-.609375-.519532-.164063-1.058594-.273438-1.601563-.328125-.332031-.097657-.671875-.175781-1.015625-.230469h-40.335938c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-40.335938c-4.417969 0-8 3.582031-8 8v416c0 4.417969 3.582031 8 8 8h384c4.417969 0 8-3.582031 8-8v-24h72c2.402344 0 4.675781-1.082031 6.191406-2.941406 1.519532-1.863282 2.121094-4.304688 1.640625-6.660156zm-79.832031-38.398438c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-64 48h32.335938c2.0625 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h79.617188v80h-368zm368 400h-368v-304h368zm16-32v-298.398438l62.167969 298.398438zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m176 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m256 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m96 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m176 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m256 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m96 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m176 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m256 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m336 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m336 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m336 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /><path d="m96 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" /></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Timetable Management</h5>
			<p class="text-sm font-medium">Publish the time table for the Class Room for easy access to parents & students.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56"><path d="M 26.6875 12.6602 C 26.9687 12.6602 27.1094 12.4961 27.1797 12.2383 C 27.9062 8.3242 27.8594 8.2305 31.9375 7.4570 C 32.2187 7.4102 32.3828 7.2461 32.3828 6.9648 C 32.3828 6.6836 32.2187 6.5195 31.9375 6.4726 C 27.8828 5.6524 28.0000 5.5586 27.1797 1.6914 C 27.1094 1.4336 26.9687 1.2695 26.6875 1.2695 C 26.4062 1.2695 26.2656 1.4336 26.1953 1.6914 C 25.3750 5.5586 25.5156 5.6524 21.4375 6.4726 C 21.1797 6.5195 20.9922 6.6836 20.9922 6.9648 C 20.9922 7.2461 21.1797 7.4102 21.4375 7.4570 C 25.5156 8.2774 25.4687 8.3242 26.1953 12.2383 C 26.2656 12.4961 26.4062 12.6602 26.6875 12.6602 Z M 15.3438 28.7852 C 15.7891 28.7852 16.0938 28.5039 16.1406 28.0821 C 16.9844 21.8242 17.1953 21.8242 23.6641 20.5821 C 24.0860 20.5117 24.3906 20.2305 24.3906 19.7852 C 24.3906 19.3633 24.0860 19.0586 23.6641 18.9883 C 17.1953 18.0977 16.9609 17.8867 16.1406 11.5117 C 16.0938 11.0899 15.7891 10.7852 15.3438 10.7852 C 14.9219 10.7852 14.6172 11.0899 14.5703 11.5352 C 13.7969 17.8164 13.4687 17.7930 7.0469 18.9883 C 6.6250 19.0821 6.3203 19.3633 6.3203 19.7852 C 6.3203 20.2539 6.6250 20.5117 7.1406 20.5821 C 13.5156 21.6133 13.7969 21.7774 14.5703 28.0352 C 14.6172 28.5039 14.9219 28.7852 15.3438 28.7852 Z M 31.2344 54.7305 C 31.8438 54.7305 32.2891 54.2852 32.4062 53.6524 C 34.0703 40.8086 35.8750 38.8633 48.5781 37.4570 C 49.2344 37.3867 49.6797 36.8945 49.6797 36.2852 C 49.6797 35.6758 49.2344 35.2070 48.5781 35.1133 C 35.8750 33.7070 34.0703 31.7617 32.4062 18.9180 C 32.2891 18.2852 31.8438 17.8633 31.2344 17.8633 C 30.6250 17.8633 30.1797 18.2852 30.0860 18.9180 C 28.4219 31.7617 26.5938 33.7070 13.9140 35.1133 C 13.2344 35.2070 12.7891 35.6758 12.7891 36.2852 C 12.7891 36.8945 13.2344 37.3867 13.9140 37.4570 C 26.5703 39.1211 28.3281 40.8321 30.0860 53.6524 C 30.1797 54.2852 30.6250 54.7305 31.2344 54.7305 Z"/></svg>
            </div>
			<h5 class="font-bold mt-2">Exam Scheduler</h5>
			<p class="text-sm font-medium">Schedule Exams ( Term Exam or Class exam) per class or all classes and update it on Calender.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56"><path d="M 11.9923 49.5742 L 44.0079 49.5742 C 48.9066 49.5742 51.3671 47.1367 51.3671 42.3086 L 51.3671 13.6914 C 51.3671 8.8633 48.9066 6.4258 44.0079 6.4258 L 11.9923 6.4258 C 7.1173 6.4258 4.6329 8.8398 4.6329 13.6914 L 4.6329 42.3086 C 4.6329 47.1602 7.1173 49.5742 11.9923 49.5742 Z M 11.6642 45.8008 C 9.5782 45.8008 8.4064 44.6992 8.4064 42.5195 L 8.4064 20.4180 C 8.4064 18.2617 9.5782 17.1367 11.6642 17.1367 L 44.3126 17.1367 C 46.3985 17.1367 47.5938 18.2617 47.5938 20.4180 L 47.5938 42.5195 C 47.5938 44.6992 46.3985 45.8008 44.3126 45.8008 Z M 23.4064 25.5508 L 24.7892 25.5508 C 25.6095 25.5508 25.8907 25.3164 25.8907 24.4961 L 25.8907 23.1133 C 25.8907 22.2930 25.6095 22.0352 24.7892 22.0352 L 23.4064 22.0352 C 22.5860 22.0352 22.3282 22.2930 22.3282 23.1133 L 22.3282 24.4961 C 22.3282 25.3164 22.5860 25.5508 23.4064 25.5508 Z M 31.2111 25.5508 L 32.5704 25.5508 C 33.4142 25.5508 33.6720 25.3164 33.6720 24.4961 L 33.6720 23.1133 C 33.6720 22.2930 33.4142 22.0352 32.5704 22.0352 L 31.2111 22.0352 C 30.3907 22.0352 30.1095 22.2930 30.1095 23.1133 L 30.1095 24.4961 C 30.1095 25.3164 30.3907 25.5508 31.2111 25.5508 Z M 38.9923 25.5508 L 40.3751 25.5508 C 41.1954 25.5508 41.4767 25.3164 41.4767 24.4961 L 41.4767 23.1133 C 41.4767 22.2930 41.1954 22.0352 40.3751 22.0352 L 38.9923 22.0352 C 38.1720 22.0352 37.8907 22.2930 37.8907 23.1133 L 37.8907 24.4961 C 37.8907 25.3164 38.1720 25.5508 38.9923 25.5508 Z M 15.6251 33.2149 L 17.0079 33.2149 C 17.8282 33.2149 18.1095 32.9805 18.1095 32.1602 L 18.1095 30.7774 C 18.1095 29.9571 17.8282 29.7227 17.0079 29.7227 L 15.6251 29.7227 C 14.8048 29.7227 14.5235 29.9571 14.5235 30.7774 L 14.5235 32.1602 C 14.5235 32.9805 14.8048 33.2149 15.6251 33.2149 Z M 23.4064 33.2149 L 24.7892 33.2149 C 25.6095 33.2149 25.8907 32.9805 25.8907 32.1602 L 25.8907 30.7774 C 25.8907 29.9571 25.6095 29.7227 24.7892 29.7227 L 23.4064 29.7227 C 22.5860 29.7227 22.3282 29.9571 22.3282 30.7774 L 22.3282 32.1602 C 22.3282 32.9805 22.5860 33.2149 23.4064 33.2149 Z M 31.2111 33.2149 L 32.5704 33.2149 C 33.4142 33.2149 33.6720 32.9805 33.6720 32.1602 L 33.6720 30.7774 C 33.6720 29.9571 33.4142 29.7227 32.5704 29.7227 L 31.2111 29.7227 C 30.3907 29.7227 30.1095 29.9571 30.1095 30.7774 L 30.1095 32.1602 C 30.1095 32.9805 30.3907 33.2149 31.2111 33.2149 Z M 38.9923 33.2149 L 40.3751 33.2149 C 41.1954 33.2149 41.4767 32.9805 41.4767 32.1602 L 41.4767 30.7774 C 41.4767 29.9571 41.1954 29.7227 40.3751 29.7227 L 38.9923 29.7227 C 38.1720 29.7227 37.8907 29.9571 37.8907 30.7774 L 37.8907 32.1602 C 37.8907 32.9805 38.1720 33.2149 38.9923 33.2149 Z M 15.6251 40.9024 L 17.0079 40.9024 C 17.8282 40.9024 18.1095 40.6445 18.1095 39.8242 L 18.1095 38.4414 C 18.1095 37.6211 17.8282 37.3867 17.0079 37.3867 L 15.6251 37.3867 C 14.8048 37.3867 14.5235 37.6211 14.5235 38.4414 L 14.5235 39.8242 C 14.5235 40.6445 14.8048 40.9024 15.6251 40.9024 Z M 23.4064 40.9024 L 24.7892 40.9024 C 25.6095 40.9024 25.8907 40.6445 25.8907 39.8242 L 25.8907 38.4414 C 25.8907 37.6211 25.6095 37.3867 24.7892 37.3867 L 23.4064 37.3867 C 22.5860 37.3867 22.3282 37.6211 22.3282 38.4414 L 22.3282 39.8242 C 22.3282 40.6445 22.5860 40.9024 23.4064 40.9024 Z M 31.2111 40.9024 L 32.5704 40.9024 C 33.4142 40.9024 33.6720 40.6445 33.6720 39.8242 L 33.6720 38.4414 C 33.6720 37.6211 33.4142 37.3867 32.5704 37.3867 L 31.2111 37.3867 C 30.3907 37.3867 30.1095 37.6211 30.1095 38.4414 L 30.1095 39.8242 C 30.1095 40.6445 30.3907 40.9024 31.2111 40.9024 Z"/></svg>
            </div>
			<h5 class="font-bold mt-2">Integrated Calendar</h5>
			<p class="text-sm font-medium">All events (including exams) are auto created in Calender for effective presentation and reminder settings</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56"><path d="M 15.3203 53.0078 L 40.7031 53.0078 C 45.3438 53.0078 47.7344 50.6172 47.7344 45.8828 L 47.7344 10.1406 C 47.7344 5.4297 45.3438 2.9922 40.7031 2.9922 L 15.3203 2.9922 C 10.6562 2.9922 8.2656 5.4297 8.2656 10.1406 L 8.2656 45.8828 C 8.2656 50.6172 10.6562 53.0078 15.3203 53.0078 Z M 15.4844 49.2578 C 13.2344 49.2578 12.0391 48.0156 12.0391 45.8359 L 12.0391 10.1875 C 12.0391 7.9843 13.2344 6.7656 15.5078 6.7656 L 40.4922 6.7656 C 42.7656 6.7656 43.9609 7.9843 43.9609 10.1875 L 43.9609 45.8359 C 43.9609 48.0156 42.7656 49.2578 40.5156 49.2578 Z M 33.8125 26.8047 C 36.6719 26.8047 38.6406 24.8594 38.6406 22.0234 C 38.6406 19.2812 36.9531 17.4765 34.4687 17.4765 C 33.2266 17.4765 32.1953 17.8750 31.4687 18.7656 L 31.0000 18.7656 C 31.1875 17.9453 31.7031 17.1250 32.4766 16.4687 C 33.2031 15.7890 34.1406 15.3672 35.1953 15.1328 C 36.0625 14.9453 36.3203 14.6641 36.3203 14.1484 C 36.3203 13.6797 35.9687 13.3047 35.3125 13.3047 C 33.7891 13.3047 31.8438 14.2656 30.5781 15.6250 C 29.2656 17.0547 28.6094 18.9063 28.6094 20.8750 C 28.6094 24.6250 30.9297 26.8047 33.8125 26.8047 Z M 21.9297 26.8281 C 24.7891 26.8281 26.7578 24.8828 26.7578 22.0468 C 26.7578 19.3047 25.0703 17.5 22.5860 17.5 C 21.3438 17.5 20.3125 17.8984 19.6094 18.7890 L 19.1172 18.7890 C 19.3047 17.9453 19.8438 17.1016 20.6640 16.4453 C 21.4141 15.8125 22.2813 15.3672 23.3125 15.1563 C 24.1797 14.9687 24.4609 14.6875 24.4609 14.1719 C 24.4609 13.7031 24.1094 13.3281 23.4297 13.3281 C 21.9062 13.3281 20.0078 14.2422 18.6953 15.6484 C 17.3828 17.0781 16.7266 18.9297 16.7266 20.8984 C 16.7266 24.6484 19.0469 26.8281 21.9297 26.8281 Z M 18.8125 34.7265 L 36.6016 34.7265 C 37.4219 34.7265 38.0547 34.0937 38.0547 33.2734 C 38.0547 32.4765 37.4219 31.8437 36.6016 31.8437 L 18.8125 31.8437 C 17.9687 31.8437 17.3594 32.4765 17.3594 33.2734 C 17.3594 34.0937 17.9687 34.7265 18.8125 34.7265 Z M 18.8125 42.9062 L 27.2500 42.9062 C 28.0703 42.9062 28.6797 42.2969 28.6797 41.4765 C 28.6797 40.6562 28.0703 40.0234 27.2500 40.0234 L 18.8125 40.0234 C 17.9687 40.0234 17.3594 40.6562 17.3594 41.4765 C 17.3594 42.2969 17.9687 42.9062 18.8125 42.9062 Z"/></svg>
            </div>
			<h5 class="font-bold mt-2">Notice Board</h5>
			<p class="text-sm font-medium">Admin can publish notice boards, with publish & expre dates, for Teachers Group, Classes or Full School.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg  class="h-8 w-auto fill-current" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g>
	<g>
		<path d="M347,61h-46V45c0-8.284-6.716-15-15-15h-47.57C232.239,12.539,215.556,0,196,0c-19.556,0-36.239,12.539-42.43,30H105    c-8.284,0-15,6.716-15,15v16H45C20.187,61,0,81.187,0,106v361c0,24.813,20.187,45,45,45h302c24.813,0,45-20.187,45-45V106    C392,81.187,371.813,61,347,61z M120,60h46c8.284,0,15-6.716,15-15c0-8.271,6.729-15,15-15s15,6.729,15,15c0,8.284,6.716,15,15,15    h45v16c0,8.271-6.729,15-15,15H135c-8.271,0-15-6.729-15-15V60z M362,467c0,8.271-6.729,15-15,15H45c-8.271,0-15-6.729-15-15V106    c0-8.271,6.729-15,15-15h47.58c6.192,17.459,22.865,30,42.42,30h121c19.555,0,36.228-12.541,42.42-30H347c8.271,0,15,6.729,15,15    V467z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M176.693,260.482c-5.808-5.906-15.306-5.985-21.212-0.175l-50.394,49.568l-19.481-19.481    c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213l30.001,30C97.321,344.534,101.16,346,105,346    c3.798,0,7.599-1.434,10.518-4.306l61-60C182.424,275.885,182.502,266.388,176.693,260.482z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M176.693,365.482c-5.808-5.906-15.306-5.985-21.212-0.175l-50.394,49.568l-19.481-19.481    c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213l30.001,30C97.321,449.534,101.16,451,105,451    c3.798,0,7.599-1.434,10.518-4.306l61-60C182.424,380.885,182.502,371.388,176.693,365.482z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M145.607,215.394L126.213,196l19.393-19.393c5.858-5.858,5.858-15.355,0-21.213c-5.857-5.858-15.355-5.858-21.213,0    L105,174.787l-19.394-19.393c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213L83.787,196l-19.393,19.393    c-5.858,5.858-5.858,15.356,0,21.214c5.857,5.857,15.355,5.858,21.213,0L105,217.213l19.394,19.394    c5.857,5.857,15.355,5.858,21.213,0C151.465,230.749,151.465,221.252,145.607,215.394z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M317,181h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,181,317,181z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M317,286h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,286,317,286z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M317,391h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,391,317,391z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g><g>
	<g>
		<path d="M467,91c-24.813,0-45,20.187-45,45c0,9.542,0,230.112,0,240c0,1.614,0.289,3.286,0.754,4.697l30,91    C454.781,477.845,460.525,482,467,482c6.475,0,12.219-4.155,14.246-10.303l30-91C511.75,379.165,512,377.465,512,376    c0-9.872,0-230.419,0-240C512,111.187,491.813,91,467,91z M467,419.091l-12.388-37.576c3.792-1.924,8.012-2.942,12.388-2.942    c4.376,0,8.596,1.018,12.388,2.942L467,419.091z M482,350.558c-4.832-1.299-9.862-1.985-15-1.985s-10.168,0.685-15,1.984V211h30    V350.558z M482,181h-30v-45c0-8.271,6.729-15,15-15s15,6.729,15,15V181z" data-original="#000000" class="active-path" data-old_color="#000000" />
	</g>
</g></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Mark Entry</h5>
			<p class="text-sm font-medium">Teachers simply import the Marks through excel sheets. Marks auto published and auto graded.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56">
                    <g fill-rule="evenodd" transform="translate(6 6)">
                        <path fill-rule="nonzero" d="M7.7851,43.5742 L36.2382,43.5742 C41.1366,43.5742 43.5743,41.1367 43.5743,36.3086 L43.5743,7.6914 C43.5743,2.8633 41.1366,0.4258 36.2382,0.4258 L7.7851,0.4258 C2.9101,0.4258 0.4257,2.8398 0.4257,7.6914 L0.4257,36.3086 C0.4257,41.1602 2.9101,43.5742 7.7851,43.5742 Z M7.8554,39.8008 C5.5117,39.8008 4.1992,38.5586 4.1992,36.1211 L4.1992,7.8789 C4.1992,5.4414 5.5117,4.1992 7.8554,4.1992 L36.1679,4.1992 C38.4882,4.1992 39.8007,5.4414 39.8007,7.8789 L39.8007,36.1211 C39.8007,38.5586 38.4882,39.8008 36.1679,39.8008 L7.8554,39.8008 Z"/>
                        <path d="M12 16L14 16C15.1045695 16 16 16.8954305 16 18L16 32C16 33.1045695 15.1045695 34 14 34L12 34C10.8954305 34 10 33.1045695 10 32L10 18C10 16.8954305 10.8954305 16 12 16zM21 10L23 10C24.1045695 10 25 10.8954305 25 12L25 32C25 33.1045695 24.1045695 34 23 34L21 34C19.8954305 34 19 33.1045695 19 32L19 12C19 10.8954305 19.8954305 10 21 10zM30 22L32 22C33.1045695 22 34 22.8954305 34 24L34 32C34 33.1045695 33.1045695 34 32 34L30 34C28.8954305 34 28 33.1045695 28 32L28 24C28 22.8954305 28.8954305 22 30 22z"/>
                    </g>
                    </svg>
            </div>
			<h5 class="font-bold mt-2">Grading System</h5>
			<p class="text-sm font-medium">The system supports Scholostic and non-scholostic grading system. Custom grading systems also can be added.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
                <svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56"><path d="M 23.6641 52.3985 C 26.6407 55.375 29.3594 55.3516 32.3126 52.3985 L 35.9219 48.8125 C 36.2969 48.4610 36.6250 48.3203 37.1172 48.3203 L 42.1797 48.3203 C 46.3749 48.3203 48.3204 46.3985 48.3204 42.1797 L 48.3204 37.1172 C 48.3204 36.625 48.4610 36.2969 48.8124 35.9219 L 52.3749 32.3125 C 55.3749 29.3594 55.3514 26.6407 52.3749 23.6641 L 48.8124 20.0547 C 48.4610 19.7031 48.3204 19.3516 48.3204 18.8829 L 48.3204 13.7969 C 48.3204 9.625 46.3985 7.6563 42.1797 7.6563 L 37.1172 7.6563 C 36.6250 7.6563 36.2969 7.5391 35.9219 7.1875 L 32.3126 3.6016 C 29.3594 .6250 26.6407 .6485 23.6641 3.6016 L 20.0547 7.1875 C 19.7032 7.5391 19.3516 7.6563 18.8828 7.6563 L 13.7969 7.6563 C 9.6016 7.6563 7.6563 9.5782 7.6563 13.7969 L 7.6563 18.8829 C 7.6563 19.3516 7.5391 19.7031 7.1876 20.0547 L 3.6016 23.6641 C .6251 26.6407 .6485 29.3594 3.6016 32.3125 L 7.1876 35.9219 C 7.5391 36.2969 7.6563 36.625 7.6563 37.1172 L 7.6563 42.1797 C 7.6563 46.3750 9.6016 48.3203 13.7969 48.3203 L 18.8828 48.3203 C 19.3516 48.3203 19.7032 48.4610 20.0547 48.8125 Z M 26.2891 49.7734 L 21.8828 45.3438 C 21.3672 44.8047 20.8282 44.5938 20.1016 44.5938 L 13.7969 44.5938 C 11.7110 44.5938 11.3828 44.2656 11.3828 42.1797 L 11.3828 35.875 C 11.3828 35.1719 11.1719 34.6329 10.6563 34.1172 L 6.2266 29.7109 C 4.7501 28.2109 4.7501 27.7891 6.2266 26.2891 L 10.6563 21.8829 C 11.1719 21.3672 11.3828 20.8282 11.3828 20.1016 L 11.3828 13.7969 C 11.3828 11.6875 11.6876 11.3829 13.7969 11.3829 L 20.1016 11.3829 C 20.8282 11.3829 21.3672 11.1953 21.8828 10.6563 L 26.2891 6.2266 C 27.7891 4.7500 28.2110 4.7500 29.7110 6.2266 L 34.1172 10.6563 C 34.6328 11.1953 35.1719 11.3829 35.8750 11.3829 L 42.1797 11.3829 C 44.2657 11.3829 44.5938 11.7109 44.5938 13.7969 L 44.5938 20.1016 C 44.5938 20.8282 44.8282 21.3672 45.3439 21.8829 L 49.7733 26.2891 C 51.2498 27.7891 51.2498 28.2109 49.7733 29.7109 L 45.3439 34.1172 C 44.8282 34.6329 44.5938 35.1719 44.5938 35.875 L 44.5938 42.1797 C 44.5938 44.2656 44.2657 44.5938 42.1797 44.5938 L 35.8750 44.5938 C 35.1719 44.5938 34.6328 44.8047 34.1172 45.3438 L 29.7110 49.7734 C 28.2110 51.2500 27.7891 51.2500 26.2891 49.7734 Z M 24.3438 39.2266 C 25.0235 39.2266 25.5391 38.9453 25.8907 38.5234 L 38.8985 20.3360 C 39.1563 19.9609 39.2969 19.5391 39.2969 19.1407 C 39.2969 18.1094 38.5001 17.2891 37.4219 17.2891 C 36.6485 17.2891 36.2266 17.5469 35.7579 18.2266 L 24.2735 34.3985 L 18.3438 27.8594 C 17.9454 27.4141 17.5001 27.2266 16.9141 27.2266 C 15.7657 27.2266 14.9454 28.0000 14.9454 29.0782 C 14.9454 29.5469 15.1094 29.9922 15.4376 30.3203 L 22.8907 38.6172 C 23.2423 38.9922 23.6876 39.2266 24.3438 39.2266 Z"/></svg>
            </div>
			<h5 class="font-bold mt-2">Report Cards</h5>
			<p class="text-sm font-medium">With a simple click publish Standard Report Cards as Printer Friendly PDF and auto publish to Apps.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center"><svg class=" w-auto h-8 fill-current"xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-4 0 361 361.81333" ><g><path d="m353.964844 143.359375c0-36.851563-29.984375-66.835937-66.839844-66.835937-8.195312 0-16.019531 1.554687-23.28125 4.269531-18.796875-22.527344-44.214844-37.734375-72.289062-43.746094v-6.328125c0-16.9375-13.78125-30.71875-30.722657-30.71875-16.9375 0-30.71875 13.78125-30.71875 30.71875v8.125c-54.988281 15.039062-95.574219 65.304688-95.574219 124.996094v102.398437h-3.414062c-16.9375 0-30.71875 13.78125-30.71875 30.722657 0 16.9375 13.78125 30.71875 30.71875 30.71875h93.390625c4.621094 19.832031 22.15625 34.132812 43.144531 34.132812 20.988282 0 38.527344-14.300781 43.144532-34.132812h86.5625c16.941406 0 30.71875-13.78125 30.71875-30.71875 0-16.941407-13.777344-30.722657-30.71875-30.722657h-3.414063v-56.386719c33.660156-3.433593 60.011719-31.941406 60.011719-66.492187zm-13.652344 0c0 29.328125-23.859375 53.183594-53.1875 53.183594-29.324219 0-53.183594-23.855469-53.183594-53.183594s23.859375-53.183594 53.183594-53.183594c29.328125 0 53.1875 23.855469 53.1875 53.183594zm-196.546875-112.640625c0-9.410156 7.652344-17.066406 17.066406-17.066406 9.414063 0 17.066407 7.65625 17.066407 17.066406v4.148438c-4.507813-.472657-9.0625-.734376-13.652344-.734376-6.984375 0-13.789063.710938-20.480469 1.777344zm23.894531 317.441406c-13.378906 0-24.65625-8.4375-28.875-20.480468h57.75c-4.21875 12.042968-15.496094 20.480468-28.875 20.480468zm129.707032-68.265625c9.414062 0 17.066406 7.65625 17.066406 17.066407 0 9.410156-7.652344 17.066406-17.066406 17.066406h-266.242188c-9.414062 0-17.066406-7.65625-17.066406-17.066406 0-9.410157 7.652344-17.066407 17.066406-17.066407h10.242188c3.773437 0 6.824218-3.058593 6.824218-6.828125v-109.226562c0-63.992188 52.0625-116.054688 116.054688-116.054688 33.46875 0 64.816406 14.363282 86.882812 39.351563-18.519531 11.894531-30.84375 32.628906-30.84375 56.222656 0 34.550781 26.355469 63.058594 60.011719 66.492187v63.214844c0 3.769532 3.054687 6.828125 6.828125 6.828125zm0 0" data-original="#000000" class="active-path" /><path d="m268.859375 168.449219c1.746094 0 3.496094-.667969 4.828125-2l18.265625-18.261719c1.28125-1.28125 2-3.019531 2-4.828125v-26.09375c0-3.769531-3.054687-6.824219-6.828125-6.824219s-6.824219 3.054688-6.824219 6.824219v23.269531l-16.265625 16.261719c-2.667968 2.664063-2.667968 6.988281 0 9.652344 1.332032 1.335937 3.078125 2 4.824219 2zm0 0" data-original="#000000" class="active-path" /><path d="m184.726562 266.238281h-13.652343c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h13.652343c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path" /><path d="m146.039062 266.238281h-70.539062c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h70.539062c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path" /></g> </svg></div>
			<h5 class="font-bold mt-2">Disciplinary Records</h5>
			<p class="text-sm font-medium">Record the incident and actions taken towards the Disciplinary of a particular student.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
			<div class="bg-red-300 text-red-600 w-16 h-16 p-4 rounded-full flex justify-center items-center">
                <svg  class="h-8 w-auto fill-current"xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512"  xml:space="preserve" width="512px" height="512px"><g><g>
	    <g>
		<path d="M511.03,349.749c0-19.506-12.509-36.136-29.924-42.313V152.629l30.896-12.349L255.669,37.825L0,140.28l121.018,48.496    v71.201c0,21.949,15.388,41.731,43.329,55.702c24.645,12.323,57.079,19.109,91.329,19.109s66.685-6.786,91.329-19.109    c27.941-13.971,43.329-33.752,43.329-55.702V188.91l60.846-24.32v142.847c-17.415,6.176-29.924,22.807-29.924,42.313    c0,17.844,10.467,33.287,25.584,40.516l-24.816,74.448l28.389,9.463l15.73-47.189l15.73,47.189l28.389-9.463l-24.816-74.448    C500.561,383.035,511.03,367.593,511.03,349.749z M360.411,259.976c0,21.188-44.79,44.886-104.734,44.886    c-59.944,0-104.734-23.698-104.734-44.886v-59.209l104.727,41.968l104.742-41.866V259.976z M255.684,210.504L80.445,140.28    l175.239-70.224l175.691,70.224L255.684,210.504z M466.143,364.711c-8.25,0-14.962-6.712-14.962-14.962    c0-8.25,6.712-14.962,14.962-14.962c8.25,0,14.962,6.712,14.962,14.962C481.105,357.999,474.393,364.711,466.143,364.711z" data-original="#000000" class="active-path" data-old_color="#000000" />
	        </g>
            </g></g>
        </svg>
            </div>
			<h5 class="font-bold mt-2">Academic Year</h5>
			<p class="text-sm font-medium">All academic data are grouped under Academic Year for effective data management and record keeping.</p>
		</div>
	</div>
	<div class="w-full lg:w-1/4 md:w-1/2 p-2">
		<div class="p-4">
            <div class="bg-red-300 text-red-600 w-16 h-16 p-4 rounded-full flex justify-center items-center">
                <svg class="h-8 fill-current w-auto"xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px"><g><path d="m497 161h-60c-8.284 0-15 6.716-15 15s6.716 15 15 15h23.787l-73.093 73.093c-6.583-30.894-26.794-56.8-54.017-71.104 16.093-13.767 26.323-34.2 26.323-56.989 0-41.355-33.645-75-75-75s-75 33.645-75 75c0 22.789 10.23 43.222 26.323 56.988-25.113 13.196-44.261 36.262-52.247 64.012-1.878-2.151-3.844-4.24-5.91-6.252-7.355-7.167-15.59-13.13-24.454-17.789 16.073-13.767 26.288-34.187 26.288-56.959 0-41.355-33.645-75-75-75s-75 33.645-75 75c0 22.789 10.23 43.222 26.323 56.988-33.452 17.578-56.323 52.672-56.323 93.012v110c0 8.284 6.716 15 15 15h122c3.979 0 7.794-1.58 10.606-4.394l109.394-109.393 39.394 39.394c5.857 5.857 15.355 5.857 21.213 0l164.393-164.394v23.787c0 8.284 6.716 15 15 15s15-6.716 15-15v-60c0-8.284-6.716-15-15-15zm-257-25c0-24.813 20.187-45 45-45s45 20.187 45 45-20.187 45-45 45-45-20.187-45-45zm-180 40c0-24.813 20.187-45 45-45s45 20.187 45 45-20.187 45-45 45-45-20.187-45-45zm70.787 245h-100.787v-95c0-41.355 33.645-75 75-75 19.629 0 38.177 7.541 52.229 21.233 14.024 13.666 22.066 31.967 22.644 51.531.016.528.06 1.048.128 1.56v46.462zm176.213-76.213-39.394-39.394c-5.857-5.857-15.355-5.857-21.213 0l-36.393 36.394v-55.787c0-41.355 33.645-75 75-75s75 33.645 75 75v5.787z" data-original="#000000" class="active-path" data-old_color="#000000" /></g> </svg>
            </div>
			<h5 class="font-bold mt-2">Promotions</h5>
			<p class="text-sm font-medium">Promotion module let you populate the acdemic & student data for the upcoming academic year.</p>
		</div>
	</div>

</div>

@push('scripts')
<script src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>
@endpush