{{-- SPDX-License-Identifier: MIT --}}
<div class="container lg:mx-auto lg:my-32 my-2 p-4">
  <h2 class="font-plex font-extrabold text-black text-2xl lg:text-4xl md:text-4xl  text-center my-4">Better Communication makes a Best School</h2>
  <div class="w-full lg:w-2/3 md:w-2/3 mx-auto text-center font-primary leading-relaxed mb-4">
    A proper channelized communication between Parent & School Administration, Parent & Teacher makes a school life better for a student. With GegoK12 we focus to bring the right tools to make the communication easy, effective and more responsible. With parent apps and teacher apps in place, the communication is simpler and more authentic.
  </div>
  <div class="hidden lg:block md:block">
  <div class="flex flex-col lg:flex-row md:flex-row my-8 lg:my-24">
    <div class="w-full lg:w-1/3 md:w-1/3 bg-gray-200 py-4">
      <h3 class="ml-4 mb-4 text-sm font-exo font-extrabold">Parent - Teacher Communication Via App</h3>
      <ul class="lg:ml-8 md:ml-3 lg:text-base md:text-sm tabs course_tabs">
        <li data-tab="tab-1" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full current">Auto update daily attendance</li>
        <li data-tab="tab-2" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Auto update daily homeworks </li>
        <li data-tab="tab-3" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Update lesson plans</li>
        <li data-tab="tab-4" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Update class events </li>

      </ul>
       <h3 class="ml-4 mb-4 text-sm font-exo font-extrabold">School - Teacher Communication Via App</h3>
      <ul class="lg:ml-8 md:ml-3 lg:text-base md:text-sm tabs course_tabs">
        <li data-tab="tab-5" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Notice Board Updates</li>
        <li data-tab="tab-6" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Update School Events</li>
        <li data-tab="tab-7" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Update Disciplinary Records</li>
        <li data-tab="tab-8" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Fee Reminders</li>
        <li data-tab="tab-9" class="mb-2 py-4 pl-8 pr-0 border bg-white rounded-tl-full rounded-bl-full">Compliants & Feedback </li>

      </ul>
    </div>
    <div class="w-full lg:w-2/3 md:w-2/3 bg-white border px-4" >
    <!-- start -->
    <div id="tab-1" class="course_tab_content tab-content current">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Automated Student Attendance Alerts</h3>
     {{-- <p class="">With integrated attendance management module, the student absence is informed to the parent directly through SMS & Via App. No additional efforts needed from the teachers than recording the attendance. </p>--}}
     <p>Through the daily attendance module, parents will be sent a notification and SMS through the module every time their child is absent from school/class. The teacher requires to take the attendance through the module and the app automatically triggers a message to the parents if the child is marked absent.</p>
      <img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/attendance.jpg" class="my-4 mx-auto">
      </div>
      <!-- end -->
      <!-- start -->
       <div id="tab-2" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Auto update daily homeworks</h3>
      <p>Parents will get daily updates of their child’s home works through the app every day. Teachers need to update on the module the daily home works they give in the class. Parents will be able to monitor their ward’s academic progress through this module.</p>
      <img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/homeworks.jpg" class="my-4 mx-auto">
      </div>
      <!-- end -->
      <!-- start -->
      <div id="tab-3" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Update lesson plans</h3>
      <p>Parents will get daily updates of their child’s home works through the app every day. Teachers need to update on the module the daily home works they give in the class. Parents will be able to monitor their ward’s academic progress through this module.</p>
      <img src="{{asset('uploads/lesson-plan.png')}}" class="my-4 mx-auto">
      </div>
      <!-- end -->
       <!-- start -->
      <div id="tab-4" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Update class events</h3>
      <p>Through the parent – teacher communication app, parents will get updated on the events that are happening in the class every day. This will ensure that parents are able to know what academic activities are taking place for the welfare of their child in class.</p>
      <!-- <img src="{{asset('uploads/Images/home_2.png')}}" class="my-4 mx-auto"> -->
      <img src="{{asset('uploads/events.png')}}" class="my-4 mx-auto">
      </div>
      <!-- end -->
        <!-- start -->
    <div id="tab-5" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Notice board updates</h3>
      <p>Parents will be able to view everything that is put up on the school’s notice board through the app. With the notice board updates parents will be able to prepare their child for any event that is up and coming.</p>
      <img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/noticeboard.jpg" class="my-4 mx-auto">
      </div>
      <!-- end -->
          <!-- start -->
    <div id="tab-6" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Update school events</h3>
      <p>Event and functions that are happening at the school will be updated through the app for parents who have not been able to attend it. Through this module parents will be able to appreciate the various extra-curricular activities happening in the school.</p>
      <img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/schoolevents.jpg" class="my-4 mx-auto">
      </div>
      <!-- end -->
        <!-- start -->
    <div id="tab-7" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Update disciplinary records</h3>
      <p>Through the school – teacher communication app, parents will be sent regular updates on their ward’s disciplinary progress in school. Any update regarding a student’s disciplinary record will be sent to the parent through the app through SMS or notification.</p>
      <img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/discipline.jpg" class="my-4 mx-auto">
      </div>
      <!-- end -->
        <!-- start -->
    <div id="tab-8" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Fee reminders</h3>
      <p>The fee reminders module will automatically send in fee reminders for upcoming term, academic year or examination to parents through the app. Parents will be able to pay the school fees in time for the upcoming term/year.</p>
      <img src="{{asset('uploads/fees.png')}}" class="my-4 mx-auto">
      <!-- <img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/home_1.png" class="my-4 mx-auto"> -->
      </div>
      <!-- end -->
        <!-- start -->
    <div id="tab-9" class="course_tab_content tab-content">
      <h3 class="font-extrabold my-4 lg:text-2xl md:text-xl">Complaints & feedbacks</h3>
      <p>Parents will be able to send in any feedback or complaint to the admin through the app. The complaints & feedback module will enable parents to send in their grievances to the school admin for further actions.</p>
      <img src="https://gego-static.s3.ap-south-1.amazonaws.com/gegok12/feedback.jpg" class="my-4 mx-auto">
      </div>
      <!-- end -->
    </div>
  </div>
  </div>
  <div class="block lg:hidden md:hidden">
    <div>
<homeslider url="{{url('/')}}"></homeslider>
</div>
  </div>
</div>
