{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.main')

@section('title')
GegoK12 - teacher-parent-communication-app |  Online School Management 
@endsection

@section('content')
<!-- start -->
<div class="bg-red-600 py-8 lg:py-16 md:py-8">
	<div class="container mx-auto">
		<div class="text-center tracking-wider px-1">
		<h1 class="text-white font-plex text-2xl lg:text-4xl">Teacher Parent Communication App</h1>
		</div>
	</div>
</div>
<!-- end -->
<!-- <div class="bg-gray-400">
	<div class="container mx-auto py-16">
		<h1 class="text-4xl font-bold">Teacher Parent Communication App</h1>
	</div>
</div> -->
<div class="container mx-auto py-8 px-3">
<div class="flex flex-col lg:flex-row justify-between lg:items-center">
<div class="w-full lg:w-2/3">
<p class="leading-loose text-justify mb-8 text-gray-700">It's anything but a mystery that parents wish to be associated with their kids' school life. A lot of parents attempt to step over the limits and get as engaged with their kid's instruction as could reasonably be expected. Without parents being associated with the kid's school progress, it is truly inconceivable for any child to have decent instruction. In each educational organization, the correspondence among teacher and parent greatly affects the kid's training. Parent - teacher communication gives numerous advantages in different ways. Nonetheless, there are numerous realities that influence this procedure. The two players, parents and teachers, assume a significant job in the training of a child. They create the basic fundamental abilities. With jobs and other busy activities, parents are currently occupied with their work that they scarcely possess the energy for visiting the school and conversing with the teachers about their ward’s performance in school. Nowadays correspondence among parents and teachers has become a simple task. With the teacher parent chat app, parents can put forth any kind from questions they have, to teachers easily by sitting at home.</p>
<p class="leading-loose text-justify mb-8 text-gray-700">Gego K12 is a school management software that offers the best parent - teacher chat forum through applications which empower the two parties, parents and teachers to communicate directly from home even after school hours</p>
</div>
<div class="w-full lg:w-1/4">
	<img src="{{url('images/homework.png')}}" class="mx-auto">
</div>
</div>

<div class="flex flex-wrap">
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 417.986 417.986" xml:space="preserve" class="h-8 fill-current"><g><g><g><path d="M371.514,19.619c-1.062-0.035-2.125-0.035-3.188,0H126.433c-28.735,0-53.29,20.898-53.29,49.633v117.551H28.735
        C11.494,186.802,0,202.476,0,219.716v97.176c0,17.241,11.494,31.869,28.735,31.869h23.51l9.404,41.796
        c0.909,3.707,3.679,6.674,7.314,7.837h3.135c2.756-0.039,5.385-1.166,7.314-3.135l42.841-46.498h64.784
        c17.575-0.27,31.836-14.301,32.392-31.869V265.17h7.837l71.575,77.845c1.698,2.336,4.427,3.7,7.314,3.657h3.135
        c3.559-0.976,6.339-3.756,7.314-7.314l16.718-74.188h35.004c28.735,0,49.633-24.555,49.633-53.29V69.251
        C418.839,42.72,398.045,20.499,371.514,19.619z M198.531,316.892c-0.521,6.03-5.446,10.731-11.494,10.971h-69.486
        c-2.756,0.039-5.385,1.166-7.314,3.135l-32.914,35.526L70.531,335.7c-1.22-4.735-5.561-7.991-10.449-7.837H28.735
        c-5.747,0-7.837-5.224-7.837-10.971v-97.176c0-5.747,2.09-12.016,7.837-12.016h44.408v4.18
        c0.556,29.198,24.092,52.734,53.29,53.29h72.098V316.892z M397.061,69.251V211.88c0,17.241-11.494,32.392-28.735,32.392h-43.363
        c-4.834-0.335-9.131,3.057-9.927,7.837l-14.106,62.171l-61.649-66.873c-1.929-1.969-4.558-3.095-7.314-3.135H126.433
        c-17.659-0.544-31.848-14.732-32.392-32.392V69.251c0-17.241,15.151-28.735,32.392-28.735h241.894
        c14.978-0.892,27.843,10.526,28.735,25.504C397.125,67.096,397.125,68.175,397.061,69.251z"></path> <path d="M140.539,118.884h125.388c5.771,0,10.449-4.678,10.449-10.449s-4.678-10.449-10.449-10.449H140.539
        c-5.771,0-10.449,4.678-10.449,10.449S134.768,118.884,140.539,118.884z"></path> <path d="M349.518,160.68h-208.98c-5.771,0-10.449,4.678-10.449,10.449s4.678,10.449,10.449,10.449h208.98
        c5.771,0,10.449-4.678,10.449-10.449S355.289,160.68,349.518,160.68z"></path></g></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Chat room</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">The chat room module permits the parents to talk with any teacher who teaches their ward. In this module, they can send and get messages to each other. This module is exceptionally valuable for the parents and teachers in bridging the gap between their communication.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px" class="h-8 fill-current"><g><g><path d="m74.791 114.523c26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.441.561-16.425-6.881-20.067-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.115 8.283 6.507 15.091 14.79 15.207z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m202.593 176.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m202.593 236.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m309.407 116.126c-7.441 3.641-10.521 12.625-6.881 20.067 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 37.64-18.419 75.865-28.024 113.616-28.55 8.283-.115 14.905-6.924 14.789-15.208-.115-8.283-6.876-14.901-15.207-14.79-42.213.589-84.735 11.221-126.383 31.601z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m500.638 7.584c-18.59-4.713-37.148-7.584-60.591-7.584-.016 0-.035 0-.05 0-43.627.009-110.281 11.25-183.997 63.569-73.272-52-139.55-63.382-182.937-63.566-24.136-.104-43.055 2.852-61.7 7.581-6.678 1.67-11.363 7.669-11.363 14.552v294.5c0 4.619 2.128 8.98 5.769 11.823 6.635 5.182 13.606 2.463 13.981 2.448 41.952-10.63 127.258-17.266 227.25 57.729 2.667 2 5.833 3 9 3s6.333-1 9-3c31.188-23.391 63.401-40.556 96-51.235v159.599c0 8.284 6.716 15 15 15h60c8.284 0 15-6.716 15-15v-172.236c21.132 1.097 36.088 4.848 41.675 6.252.277.008 7.061 2.515 13.557-2.557 3.641-2.843 5.769-7.204 5.769-11.823v-294.5c-.001-6.883-4.685-12.882-11.363-14.552zm-470.638 290.414v-263.956c9.661-1.955 24.286-4.124 42.937-4.04 39.466.168 100.214 10.809 168.063 59.726v258.166c-45.801-29.614-93.332-47.095-141.641-52.035-29.797-3.047-53.622-.62-69.359 2.139zm385.485-56.998h-18.969l9.484-29.8zm5.515 241h-30v-211h30zm61-183.931c-8.266-1.429-18.763-2.783-31-3.342v-38.667c.009-1.64-.255-3.321-.813-4.942l-29.894-93.926c-2.22-6.938-9.127-11.275-16.273-10.32-31.752 4.227-63.585 14.069-94.613 29.253-7.441 3.641-10.521 12.625-6.881 20.066 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 20.297-9.932 40.912-17.319 61.544-22.097l-22.324 70.143c-.521 1.513-.806 3.135-.813 4.823v50.053c-30.537 8.934-60.681 22.965-90 41.91v-258.175c68.249-49.206 129.329-59.72 169.004-59.728h.043c18.182 0 32.464 2.124 41.954 4.043z" data-original="#000000" data-old_color="#000000" class="active-path"></path></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Home works</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">A student's day to day home work will be sent to the parent by means of the parent teacher app. This will empower parents with the knowledge of what work and preparation their child needs to accomplish for the day for the next day.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg class="h-8 fill-current" id="light" enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m23.5 10c-.1 0-.2 0-.3-.1l-2.5-1.7c-.2-.1-.5-.2-.8-.2h-6.4c-.8 0-1.5-.7-1.5-1.5v-5c0-.8.7-1.5 1.5-1.5h9c.8 0 1.5.7 1.5 1.5v8c0 .2-.1.4-.3.4 0 .1-.1.1-.2.1zm-10-9c-.3 0-.5.2-.5.5v5c0 .3.2.5.5.5h6.4c.5 0 1 .1 1.4.4l1.7 1.2v-7.1c0-.3-.2-.5-.5-.5z"/></g><g><path d="m.5 12c-.1 0-.2 0-.2-.1-.2 0-.3-.2-.3-.4v-8c0-.8.7-1.5 1.5-1.5h8c.3 0 .5.2.5.5s-.2.5-.5.5h-8c-.3 0-.5.2-.5.5v7.1l1.7-1.1c.4-.3.9-.5 1.4-.5h8.4c.3 0 .5.2.5.5s-.2.5-.5.5h-8.4c-.3 0-.6.1-.8.3l-2.5 1.7c-.1 0-.2 0-.3 0z"/></g><g><path d="m5.5 18c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3-1.3 3-3 3zm0-5c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"/></g><g><path d="m10.5 24c-.3 0-.5-.2-.5-.5v-2c0-.8-.7-1.5-1.5-1.5h-6c-.8 0-1.5.7-1.5 1.5v2c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-2c0-1.4 1.1-2.5 2.5-2.5h6c1.4 0 2.5 1.1 2.5 2.5v2c0 .3-.2.5-.5.5z"/></g><g><path d="m18.5 18c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3-1.3 3-3 3zm0-5c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"/></g><g><path d="m23.5 24c-.3 0-.5-.2-.5-.5v-2c0-.8-.7-1.5-1.5-1.5h-6c-.8 0-1.5.7-1.5 1.5v2c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-2c0-1.4 1.1-2.5 2.5-2.5h6c1.4 0 2.5 1.1 2.5 2.5v2c0 .3-.2.5-.5.5z"/></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Teacher parent app</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">This module in the tool empowers teachers and parents to discuss viably with one another at all times. The teacher can report any complaints or unfortunate behaviour by the student in class to the parents and the parents can put forth any doubts and questions related to the school.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-4 0 361 361.81333" class=" w-auto h-8 fill-current"><g><path d="m353.964844 143.359375c0-36.851563-29.984375-66.835937-66.839844-66.835937-8.195312 0-16.019531 1.554687-23.28125 4.269531-18.796875-22.527344-44.214844-37.734375-72.289062-43.746094v-6.328125c0-16.9375-13.78125-30.71875-30.722657-30.71875-16.9375 0-30.71875 13.78125-30.71875 30.71875v8.125c-54.988281 15.039062-95.574219 65.304688-95.574219 124.996094v102.398437h-3.414062c-16.9375 0-30.71875 13.78125-30.71875 30.722657 0 16.9375 13.78125 30.71875 30.71875 30.71875h93.390625c4.621094 19.832031 22.15625 34.132812 43.144531 34.132812 20.988282 0 38.527344-14.300781 43.144532-34.132812h86.5625c16.941406 0 30.71875-13.78125 30.71875-30.71875 0-16.941407-13.777344-30.722657-30.71875-30.722657h-3.414063v-56.386719c33.660156-3.433593 60.011719-31.941406 60.011719-66.492187zm-13.652344 0c0 29.328125-23.859375 53.183594-53.1875 53.183594-29.324219 0-53.183594-23.855469-53.183594-53.183594s23.859375-53.183594 53.183594-53.183594c29.328125 0 53.1875 23.855469 53.1875 53.183594zm-196.546875-112.640625c0-9.410156 7.652344-17.066406 17.066406-17.066406 9.414063 0 17.066407 7.65625 17.066407 17.066406v4.148438c-4.507813-.472657-9.0625-.734376-13.652344-.734376-6.984375 0-13.789063.710938-20.480469 1.777344zm23.894531 317.441406c-13.378906 0-24.65625-8.4375-28.875-20.480468h57.75c-4.21875 12.042968-15.496094 20.480468-28.875 20.480468zm129.707032-68.265625c9.414062 0 17.066406 7.65625 17.066406 17.066407 0 9.410156-7.652344 17.066406-17.066406 17.066406h-266.242188c-9.414062 0-17.066406-7.65625-17.066406-17.066406 0-9.410157 7.652344-17.066407 17.066406-17.066407h10.242188c3.773437 0 6.824218-3.058593 6.824218-6.828125v-109.226562c0-63.992188 52.0625-116.054688 116.054688-116.054688 33.46875 0 64.816406 14.363282 86.882812 39.351563-18.519531 11.894531-30.84375 32.628906-30.84375 56.222656 0 34.550781 26.355469 63.058594 60.011719 66.492187v63.214844c0 3.769532 3.054687 6.828125 6.828125 6.828125zm0 0" data-original="#000000" class="active-path"></path><path d="m268.859375 168.449219c1.746094 0 3.496094-.667969 4.828125-2l18.265625-18.261719c1.28125-1.28125 2-3.019531 2-4.828125v-26.09375c0-3.769531-3.054687-6.824219-6.828125-6.824219s-6.824219 3.054688-6.824219 6.824219v23.269531l-16.265625 16.261719c-2.667968 2.664063-2.667968 6.988281 0 9.652344 1.332032 1.335937 3.078125 2 4.824219 2zm0 0" data-original="#000000" class="active-path"></path><path d="m184.726562 266.238281h-13.652343c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h13.652343c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path"></path><path d="m146.039062 266.238281h-70.539062c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h70.539062c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path"></path></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Disciplinary record</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">This module sends a notice to the parents each time any update is made on their ward’s disciplinary record. Through this module parents will become more acquainted with how mannered their child is at school and can find a way to forestall any unruly behaviour later on.</p>
</div>
</div>
</div>
<!-- **** -->
</div>


</div>
@endsection 