{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.main')

@section('title')
GegoK12 - student-database-management-system |  Online School Management 
@endsection

@section('content')
<!-- start -->
<div class="bg-red-600 py-8 lg:py-16 md:py-8">
	<div class="container mx-auto">
		<div class="text-center tracking-wider px-1">
		<h1 class="text-white font-plex text-2xl lg:text-4xl">Student Database Management System</h1>
		</div>
	</div>
</div>
<!-- end -->
<!-- <div class="bg-gray-400">
	<div class="container mx-auto py-16">
		<h1 class="text-4xl font-bold">Student Database Management System</h1>
	</div>
</div> -->
<div class="container mx-auto py-8 px-3">
<p class="leading-loose text-justify mb-8 text-gray-700">A school is one place where Big Data gets collected almost every day and this set of data mostly includes a collection of all student-related information like class, register number, disciplinary records, timetable, examination, subjects, transport details, library, laboratories, parent detail, personal details, results, et cetera. Each student will have a huge recurring data which will impose a huge collection of data on the administrator. Handling this big data proves to be a tedious task while comprehending them on hand. With the enormous advancements in technology, the school administrator can now manage these huge overflows of data through the student database management system.<p>
<h3 class="text-xl lg:text-2xl text-gray-800 py-3 italic">Student Information System</h3>
<p class="leading-loose text-justify mb-8 text-gray-700">Information plays an important role in the development and management of every school. The huge amount of data that piles up every day is sent to different departments that manage the data independently. There are no common procedures or program for sorting through this vast data. In this way, the management faces challenges in areas of storing and managing the database, difficulty in updating and maintaining, security and backup.</p>
<p class="leading-loose text-justify mb-8 text-gray-700">A Student Database Management System is a tool which helps a school manage data, scheduling and communications. A school uses and stores a large amount of data. This must be properly communicated to faculty, students and parents.</p>
<p class="leading-loose text-justify mb-8 text-gray-700">Gego K12 is a school management software that provides the users with a Student Database Management System. This software manages to implement all the necessary operations and documentations with just a click of a fingertip.</p>

<div class="flex flex-wrap">
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" class="h-8 fill-current"><path fill-rule="evenodd" d="M13,22 L13,32 C16.5185185,31.6836983 18,29.7128954 18,27.1094891 C18,24.6034063 16.8477366,23.1192214 13,22 Z M10,17 L10,8 C6.72727273,8.41538462 5,10.3307692 5,12.4307692 C5,14.5307692 6.36363636,16.0769231 10,17 Z M12.8398058,17.7367206 L13.9116505,18.0138568 C19.784466,19.4226328 23,21.9168591 23,26.8360277 C23,32.4942263 18.5339806,35.704388 12.8398058,36.1200924 L12.8398058,40 L10.3165049,40 L10.3165049,36.1200924 C4.64466019,35.6812933 0.15631068,32.3787529 0,26.8360277 L4.6223301,26.8360277 C5.02427184,29.5381062 6.72135922,31.5242494 10.3165049,31.9168591 L10.3165049,21.8475751 L9.40097087,21.6166282 C3.72912621,20.2540416 0.669902913,17.6212471 0.669902913,12.9330254 C0.669902913,7.75981524 4.68932039,4.34180139 10.3165049,3.90300231 L10.3165049,0 L12.8398058,0 L12.8398058,3.90300231 C18.4223301,4.36489607 22.4640777,7.82909931 22.6427184,13.0715935 L17.9980583,13.0715935 C17.707767,10.1616628 15.6980583,8.47575058 12.8398058,8.10623557 L12.8398058,17.7367206 Z" transform="translate(16 8)"></path></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Fees records</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">The Fee records module in the tool displays the students who have not paid the fees on time and the long time defaulters. In this module, parents will also be able to see the upcoming term fees to be paid and also get notified on the fee that is pending.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-4 0 361 361.81333" class=" w-auto h-8 fill-current"><g><path d="m353.964844 143.359375c0-36.851563-29.984375-66.835937-66.839844-66.835937-8.195312 0-16.019531 1.554687-23.28125 4.269531-18.796875-22.527344-44.214844-37.734375-72.289062-43.746094v-6.328125c0-16.9375-13.78125-30.71875-30.722657-30.71875-16.9375 0-30.71875 13.78125-30.71875 30.71875v8.125c-54.988281 15.039062-95.574219 65.304688-95.574219 124.996094v102.398437h-3.414062c-16.9375 0-30.71875 13.78125-30.71875 30.722657 0 16.9375 13.78125 30.71875 30.71875 30.71875h93.390625c4.621094 19.832031 22.15625 34.132812 43.144531 34.132812 20.988282 0 38.527344-14.300781 43.144532-34.132812h86.5625c16.941406 0 30.71875-13.78125 30.71875-30.71875 0-16.941407-13.777344-30.722657-30.71875-30.722657h-3.414063v-56.386719c33.660156-3.433593 60.011719-31.941406 60.011719-66.492187zm-13.652344 0c0 29.328125-23.859375 53.183594-53.1875 53.183594-29.324219 0-53.183594-23.855469-53.183594-53.183594s23.859375-53.183594 53.183594-53.183594c29.328125 0 53.1875 23.855469 53.1875 53.183594zm-196.546875-112.640625c0-9.410156 7.652344-17.066406 17.066406-17.066406 9.414063 0 17.066407 7.65625 17.066407 17.066406v4.148438c-4.507813-.472657-9.0625-.734376-13.652344-.734376-6.984375 0-13.789063.710938-20.480469 1.777344zm23.894531 317.441406c-13.378906 0-24.65625-8.4375-28.875-20.480468h57.75c-4.21875 12.042968-15.496094 20.480468-28.875 20.480468zm129.707032-68.265625c9.414062 0 17.066406 7.65625 17.066406 17.066407 0 9.410156-7.652344 17.066406-17.066406 17.066406h-266.242188c-9.414062 0-17.066406-7.65625-17.066406-17.066406 0-9.410157 7.652344-17.066407 17.066406-17.066407h10.242188c3.773437 0 6.824218-3.058593 6.824218-6.828125v-109.226562c0-63.992188 52.0625-116.054688 116.054688-116.054688 33.46875 0 64.816406 14.363282 86.882812 39.351563-18.519531 11.894531-30.84375 32.628906-30.84375 56.222656 0 34.550781 26.355469 63.058594 60.011719 66.492187v63.214844c0 3.769532 3.054687 6.828125 6.828125 6.828125zm0 0" data-original="#000000" class="active-path"></path><path d="m268.859375 168.449219c1.746094 0 3.496094-.667969 4.828125-2l18.265625-18.261719c1.28125-1.28125 2-3.019531 2-4.828125v-26.09375c0-3.769531-3.054687-6.824219-6.828125-6.824219s-6.824219 3.054688-6.824219 6.824219v23.269531l-16.265625 16.261719c-2.667968 2.664063-2.667968 6.988281 0 9.652344 1.332032 1.335937 3.078125 2 4.824219 2zm0 0" data-original="#000000" class="active-path"></path><path d="m184.726562 266.238281h-13.652343c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h13.652343c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path"></path><path d="m146.039062 266.238281h-70.539062c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h70.539062c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path"></path></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Disciplinary records</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">A student’s most important record is his/her disciplinary record which will reflect in the future. In order to maintain this, the school should be able to record every disciplinary activity and actions that occurred in the school for every particular student. Parents will also be able to view their ward’s records and be notified of any update in the disciplinary record.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" class="h-8 fill-current"><path d="M 26.6875 12.6602 C 26.9687 12.6602 27.1094 12.4961 27.1797 12.2383 C 27.9062 8.3242 27.8594 8.2305 31.9375 7.4570 C 32.2187 7.4102 32.3828 7.2461 32.3828 6.9648 C 32.3828 6.6836 32.2187 6.5195 31.9375 6.4726 C 27.8828 5.6524 28.0000 5.5586 27.1797 1.6914 C 27.1094 1.4336 26.9687 1.2695 26.6875 1.2695 C 26.4062 1.2695 26.2656 1.4336 26.1953 1.6914 C 25.3750 5.5586 25.5156 5.6524 21.4375 6.4726 C 21.1797 6.5195 20.9922 6.6836 20.9922 6.9648 C 20.9922 7.2461 21.1797 7.4102 21.4375 7.4570 C 25.5156 8.2774 25.4687 8.3242 26.1953 12.2383 C 26.2656 12.4961 26.4062 12.6602 26.6875 12.6602 Z M 15.3438 28.7852 C 15.7891 28.7852 16.0938 28.5039 16.1406 28.0821 C 16.9844 21.8242 17.1953 21.8242 23.6641 20.5821 C 24.0860 20.5117 24.3906 20.2305 24.3906 19.7852 C 24.3906 19.3633 24.0860 19.0586 23.6641 18.9883 C 17.1953 18.0977 16.9609 17.8867 16.1406 11.5117 C 16.0938 11.0899 15.7891 10.7852 15.3438 10.7852 C 14.9219 10.7852 14.6172 11.0899 14.5703 11.5352 C 13.7969 17.8164 13.4687 17.7930 7.0469 18.9883 C 6.6250 19.0821 6.3203 19.3633 6.3203 19.7852 C 6.3203 20.2539 6.6250 20.5117 7.1406 20.5821 C 13.5156 21.6133 13.7969 21.7774 14.5703 28.0352 C 14.6172 28.5039 14.9219 28.7852 15.3438 28.7852 Z M 31.2344 54.7305 C 31.8438 54.7305 32.2891 54.2852 32.4062 53.6524 C 34.0703 40.8086 35.8750 38.8633 48.5781 37.4570 C 49.2344 37.3867 49.6797 36.8945 49.6797 36.2852 C 49.6797 35.6758 49.2344 35.2070 48.5781 35.1133 C 35.8750 33.7070 34.0703 31.7617 32.4062 18.9180 C 32.2891 18.2852 31.8438 17.8633 31.2344 17.8633 C 30.6250 17.8633 30.1797 18.2852 30.0860 18.9180 C 28.4219 31.7617 26.5938 33.7070 13.9140 35.1133 C 13.2344 35.2070 12.7891 35.6758 12.7891 36.2852 C 12.7891 36.8945 13.2344 37.3867 13.9140 37.4570 C 26.5703 39.1211 28.3281 40.8321 30.0860 53.6524 C 30.1797 54.2852 30.6250 54.7305 31.2344 54.7305 Z"></path></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Examination management system</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Through the examination management system, the admin will be able to update the upcoming exams and their schedule for each class. With this, the date, class and subject of the exam will be displayed for teachers, students and parents. Any changes to the exam schedule will be updated to the faculty, students and parents via a notification system.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" class="h-8 fill-current"><path d="M 23.6641 52.3985 C 26.6407 55.375 29.3594 55.3516 32.3126 52.3985 L 35.9219 48.8125 C 36.2969 48.4610 36.6250 48.3203 37.1172 48.3203 L 42.1797 48.3203 C 46.3749 48.3203 48.3204 46.3985 48.3204 42.1797 L 48.3204 37.1172 C 48.3204 36.625 48.4610 36.2969 48.8124 35.9219 L 52.3749 32.3125 C 55.3749 29.3594 55.3514 26.6407 52.3749 23.6641 L 48.8124 20.0547 C 48.4610 19.7031 48.3204 19.3516 48.3204 18.8829 L 48.3204 13.7969 C 48.3204 9.625 46.3985 7.6563 42.1797 7.6563 L 37.1172 7.6563 C 36.6250 7.6563 36.2969 7.5391 35.9219 7.1875 L 32.3126 3.6016 C 29.3594 .6250 26.6407 .6485 23.6641 3.6016 L 20.0547 7.1875 C 19.7032 7.5391 19.3516 7.6563 18.8828 7.6563 L 13.7969 7.6563 C 9.6016 7.6563 7.6563 9.5782 7.6563 13.7969 L 7.6563 18.8829 C 7.6563 19.3516 7.5391 19.7031 7.1876 20.0547 L 3.6016 23.6641 C .6251 26.6407 .6485 29.3594 3.6016 32.3125 L 7.1876 35.9219 C 7.5391 36.2969 7.6563 36.625 7.6563 37.1172 L 7.6563 42.1797 C 7.6563 46.3750 9.6016 48.3203 13.7969 48.3203 L 18.8828 48.3203 C 19.3516 48.3203 19.7032 48.4610 20.0547 48.8125 Z M 26.2891 49.7734 L 21.8828 45.3438 C 21.3672 44.8047 20.8282 44.5938 20.1016 44.5938 L 13.7969 44.5938 C 11.7110 44.5938 11.3828 44.2656 11.3828 42.1797 L 11.3828 35.875 C 11.3828 35.1719 11.1719 34.6329 10.6563 34.1172 L 6.2266 29.7109 C 4.7501 28.2109 4.7501 27.7891 6.2266 26.2891 L 10.6563 21.8829 C 11.1719 21.3672 11.3828 20.8282 11.3828 20.1016 L 11.3828 13.7969 C 11.3828 11.6875 11.6876 11.3829 13.7969 11.3829 L 20.1016 11.3829 C 20.8282 11.3829 21.3672 11.1953 21.8828 10.6563 L 26.2891 6.2266 C 27.7891 4.7500 28.2110 4.7500 29.7110 6.2266 L 34.1172 10.6563 C 34.6328 11.1953 35.1719 11.3829 35.8750 11.3829 L 42.1797 11.3829 C 44.2657 11.3829 44.5938 11.7109 44.5938 13.7969 L 44.5938 20.1016 C 44.5938 20.8282 44.8282 21.3672 45.3439 21.8829 L 49.7733 26.2891 C 51.2498 27.7891 51.2498 28.2109 49.7733 29.7109 L 45.3439 34.1172 C 44.8282 34.6329 44.5938 35.1719 44.5938 35.875 L 44.5938 42.1797 C 44.5938 44.2656 44.2657 44.5938 42.1797 44.5938 L 35.8750 44.5938 C 35.1719 44.5938 34.6328 44.8047 34.1172 45.3438 L 29.7110 49.7734 C 28.2110 51.2500 27.7891 51.2500 26.2891 49.7734 Z M 24.3438 39.2266 C 25.0235 39.2266 25.5391 38.9453 25.8907 38.5234 L 38.8985 20.3360 C 39.1563 19.9609 39.2969 19.5391 39.2969 19.1407 C 39.2969 18.1094 38.5001 17.2891 37.4219 17.2891 C 36.6485 17.2891 36.2266 17.5469 35.7579 18.2266 L 24.2735 34.3985 L 18.3438 27.8594 C 17.9454 27.4141 17.5001 27.2266 16.9141 27.2266 C 15.7657 27.2266 14.9454 28.0000 14.9454 29.0782 C 14.9454 29.5469 15.1094 29.9922 15.4376 30.3203 L 22.8907 38.6172 C 23.2423 38.9922 23.6876 39.2266 24.3438 39.2266 Z"></path></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Report card generation</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Many schools face the issue of the parents not being aware of the students’ report card. Through the school administrative tool, the admin, with the help of the teachers, will be able to update the students marks, grades, process the results, automate the grade system and generate report cards online which will be sent directly to the parents.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px" class="h-8 w-auto fill-current"><g><g><path d="m74.791 114.523c26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.441.561-16.425-6.881-20.067-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.115 8.283 6.507 15.091 14.79 15.207z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m202.593 176.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m202.593 236.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m309.407 116.126c-7.441 3.641-10.521 12.625-6.881 20.067 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 37.64-18.419 75.865-28.024 113.616-28.55 8.283-.115 14.905-6.924 14.789-15.208-.115-8.283-6.876-14.901-15.207-14.79-42.213.589-84.735 11.221-126.383 31.601z" data-original="#000000" data-old_color="#000000" class="active-path"></path><path d="m500.638 7.584c-18.59-4.713-37.148-7.584-60.591-7.584-.016 0-.035 0-.05 0-43.627.009-110.281 11.25-183.997 63.569-73.272-52-139.55-63.382-182.937-63.566-24.136-.104-43.055 2.852-61.7 7.581-6.678 1.67-11.363 7.669-11.363 14.552v294.5c0 4.619 2.128 8.98 5.769 11.823 6.635 5.182 13.606 2.463 13.981 2.448 41.952-10.63 127.258-17.266 227.25 57.729 2.667 2 5.833 3 9 3s6.333-1 9-3c31.188-23.391 63.401-40.556 96-51.235v159.599c0 8.284 6.716 15 15 15h60c8.284 0 15-6.716 15-15v-172.236c21.132 1.097 36.088 4.848 41.675 6.252.277.008 7.061 2.515 13.557-2.557 3.641-2.843 5.769-7.204 5.769-11.823v-294.5c-.001-6.883-4.685-12.882-11.363-14.552zm-470.638 290.414v-263.956c9.661-1.955 24.286-4.124 42.937-4.04 39.466.168 100.214 10.809 168.063 59.726v258.166c-45.801-29.614-93.332-47.095-141.641-52.035-29.797-3.047-53.622-.62-69.359 2.139zm385.485-56.998h-18.969l9.484-29.8zm5.515 241h-30v-211h30zm61-183.931c-8.266-1.429-18.763-2.783-31-3.342v-38.667c.009-1.64-.255-3.321-.813-4.942l-29.894-93.926c-2.22-6.938-9.127-11.275-16.273-10.32-31.752 4.227-63.585 14.069-94.613 29.253-7.441 3.641-10.521 12.625-6.881 20.066 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 20.297-9.932 40.912-17.319 61.544-22.097l-22.324 70.143c-.521 1.513-.806 3.135-.813 4.823v50.053c-30.537 8.934-60.681 22.965-90 41.91v-258.175c68.249-49.206 129.329-59.72 169.004-59.728h.043c18.182 0 32.464 2.124 41.954 4.043z" data-original="#000000" data-old_color="#000000" class="active-path"></path></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Homework module</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Students tend to skip out on their homework by dilly dallying doing other stuffs since their parents are ignorant to their school works. With the homework module, parents will be updated the daily homework given to their child in school each day. In this way they can make sure that their ward gets the best attention to education.</p>
</div>
</div>
</div>
<!-- **** -->
</div>

</div>
@endsection 