{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.main')

@section('title')
GegoK12 - school-inventory-management-software
@endsection

@section('content')
<!-- start -->
<div class="bg-red-600 py-8 lg:py-16 md:py-8">
	<div class="container mx-auto">
		<div class="text-center tracking-wider px-1">
		<h1 class="text-white font-plex text-2xl lg:text-4xl">School Inventory Management Software</h1>
		</div>
	</div>
</div>
<!-- end -->
<!-- <div class="bg-gray-400">
	<div class="container mx-auto py-16">
		<h1 class="text-4xl font-bold">School Inventory Management Software</h1>
	</div>
</div> -->
<div class="container mx-auto py-8 px-3">
<p class="leading-loose text-justify mb-8 text-gray-700">Inventory management is the process of managing assets or stock. In educational places like schools these inventories would include chairs, tables, stationary, electronic items like projectors, scanners, printers, library stock like books, magazines, etc. in a school inventory management refers to the task of management of these resources and ensuring that they are being properly cared for, utilized in the right way and labour on them and the returns on the expenditure are high. With inventory management a school expects a good return of the investment and every stakeholder benefits from the resource.</p>
<p class="leading-loose text-justify mb-8 text-gray-700">Many people assume that tracking and keeping in check all the school inventories is the job of a store manager. But in reality it is the task of the school admin. For example, when a teacher complains that the fan in a class she recently taught is not working, it is the work of a school admin to ensure that all the resources in the school are properly aligned and functioning. Issuing materials in a school happens on a daily basis and this makes tracking them difficult. In such cases small items might be missed and not get recorded properly. When manually tracking these inventories through paper management, they get subjected to human errors like getting lost and hard to analyse. Without proper management, school equipments are prone to get stolen by students and other employees or get pushed back to the storage and forgotten.</p>
<p class="leading-loose text-justify mb-8 text-gray-700">In order to solve such problems, going for a systemized method of managing these inventories is the right option. Gego K12 is a school management program which offers a quality school inventory management software.</p>

<div class="flex flex-wrap">
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg enable-background="new 0 0 64 64" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg" class="h-8 fill-current"><g><circle cx="16" cy="16" r="1"></circle><circle cx="24" cy="16" r="1"></circle><path d="m23.789 20.658.105-.211-1.789-.895-.105.212c-.381.762-1.147 1.236-2 1.236s-1.619-.474-2-1.236l-.105-.211-1.789.895.105.211c.722 1.444 2.174 2.341 3.789 2.341s3.067-.897 3.789-2.342z"></path><path d="m21.707 12.293c-.456-.456-.707-1.063-.707-1.707v-1.586h-2v1.586c0 1.179.459 2.287 1.293 3.121z"></path><path d="m25.707 12.293c-.456-.456-.707-1.063-.707-1.707v-1.586h-2v1.586c0 1.179.459 2.287 1.293 3.121z"></path><path d="m61 41h-4v-18h2c1.103 0 2-.897 2-2v-18c0-1.103-.897-2-2-2h-18c-1.103 0-2 .897-2 2v18h-2c-1.103 0-2 .897-2 2v7.832c-1.312-.994-2.872-1.681-4.586-1.926l-5.607-.801-.545-2.181c1.951-1.053 3.463-2.81 4.214-4.924h.524c2.206 0 4-1.794 4-4 0-.901-.31-1.724-.814-2.393l.322-.967c.326-.982.492-2.003.492-3.036 0-5.295-4.309-9.604-9.604-9.604h-6.793c-5.294 0-9.603 4.309-9.603 9.604 0 1.033.166 2.055.492 3.037l.322.967c-.504.668-.814 1.491-.814 2.392 0 2.206 1.794 4 4 4h.525c.751 2.114 2.262 3.871 4.214 4.924l-.545 2.181-5.607.801c-4.896.699-8.587 4.954-8.587 9.9v11.194c0 3.519 2.614 6.432 6 6.92v6.08h26v-6.08c3.386-.488 6-3.401 6-6.92v-7h2v18c0 1.103.897 2 2 2h18c1.103 0 2-.897 2-2v-18c0-1.103-.897-2-2-2zm-14-38h2v4h-2zm4 0h2v4h-2zm-10 0h4v6h10v-6h4v18h-18zm2 20h2v4h-2zm4 0h2v4h-2zm-21.464 7.23-1.149 3.448-2.607-1.043 2.574-2.574zm3.464-11.23h-.059c.037-.329.059-.662.059-1v-3c1.103 0 2 .897 2 2s-.897 2-2 2zm-18 0c-1.103 0-2-.897-2-2s.897-2 2-2v3c0 .338.022.671.059 1zm2-1v-4c0-1.654 1.346-3 3-3h1v-2h-1c-2.414 0-4.434 1.721-4.899 4h-.101c-.535 0-1.045.11-1.512.301l-.097-.292c-.26-.779-.391-1.587-.391-2.405 0-4.193 3.411-7.604 7.604-7.604h6.793c4.192 0 7.603 3.411 7.603 7.604 0 .818-.131 1.627-.391 2.404l-.098.293c-.466-.191-.976-.301-1.511-.301v-1h-2v6c0 3.859-3.141 7-7 7s-7-3.141-7-7zm7 9c.827 0 1.625-.121 2.387-.331l.506 2.024-2.893 2.893-2.893-2.893.506-2.024c.762.21 1.56.331 2.387.331zm-4.354 3.06 2.574 2.574-2.607 1.043-1.149-3.448zm-6.646 26.94h2v4h-2zm10-8c1.103 0 2 .897 2 2s-.897 2-2 2h-2v-4zm-2.184 6h2.184c2.206 0 4-1.794 4-4s-1.794-4-4-4h-6v-6h2v2c0 1.103.897 2 2 2h6c1.103 0 2-.897 2-2v-2h2v20h-14v-4h1c1.302 0 2.402-.839 2.816-2zm.184-14h6v2h-6zm12 20v-4h2v4zm8-11c0 2.757-2.243 5-5 5h-3v-6h6v-2h-2v-8h-2v8h-2v-6c0-1.103-.897-2-2-2h-14c-1.103 0-2 .897-2 2v6h-2v-8h-2v8h-2v2h10v5c0 .552-.448 1-1 1h-6c-2.757 0-5-2.243-5-5v-11.194c0-3.956 2.953-7.36 6.869-7.919l2.583-.369 1.934 5.805 5.614-2.246 5.613 2.245 1.934-5.805 2.583.369c3.917.559 6.87 3.964 6.87 7.92zm2-9v-2.194c0-2.214-.744-4.286-2-5.966v-9.84h4v6h10v-6h4v18zm10 2h2v4h-2zm4 0h2v4h-2zm8 18h-18v-18h4v6h10v-6h4z"></path></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Classroom Inventory management</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">In every class inventories such as stationary, tables, chairs, electric items like fan and projectors are bound to be present. Managing these manually is a difficult task. Through Gego K12’s school inventory management system, every resource in the classroom will get listed and accounted for.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
	<svg class="h-8 fill-current" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><g><path d="m15 110c-8.284 0-15-6.716-15-15v-65c0-16.542 13.458-30 30-30h65c8.284 0 15 6.716 15 15s-6.716 15-15 15h-65v65c0 8.284-6.716 15-15 15z"/></g><g><path d="m95 512h-65c-16.542 0-30-13.458-30-30v-65c0-8.284 6.716-15 15-15s15 6.716 15 15v65h65c8.284 0 15 6.716 15 15s-6.716 15-15 15z"/></g><g><path d="m482 512h-65c-8.284 0-15-6.716-15-15s6.716-15 15-15h65v-65c0-8.284 6.716-15 15-15s15 6.716 15 15v65c0 16.542-13.458 30-30 30z"/></g><g><path d="m497 110c-8.284 0-15-6.716-15-15v-65h-65c-8.284 0-15-6.716-15-15s6.716-15 15-15h65c16.542 0 30 13.458 30 30v65c0 8.284-6.716 15-15 15z"/></g></g><g><g><g><path d="m345.673 154.996c-29.302-17.475-59.671-26.54-89.673-26.54s-60.371 9.065-89.673 26.54z"/><path d="m438.037 244.996h-111.955c.561 3.588.858 7.262.858 11.004 0 39.116-31.823 70.94-70.94 70.94s-70.939-31.823-70.939-70.94c0-3.743.296-7.417.857-11.004h-111.955c-1.197 1.809-1.885 2.913-2.018 3.129-3.043 4.934-2.972 11.18.185 16.042.788 1.213 19.655 30.056 51.225 59.138 42.779 39.409 88.647 60.24 132.646 60.24s89.866-20.831 132.646-60.24c31.569-29.082 50.436-57.924 51.225-59.138 3.156-4.863 3.228-11.109.185-16.042-.136-.217-.823-1.321-2.02-3.129z"/></g><path d="m266.17 244.996c3.748 3.486 5.543 8.831 4.53 13.934-1.374 6.926-7.636 12.07-14.7 12.07-6.283 0-11.981-4.056-14.115-9.946-2.026-5.594-.404-12.041 3.933-16.058h-29.243c-.979 3.504-1.515 7.192-1.515 11.004 0 22.574 18.365 40.94 40.939 40.94s40.94-18.365 40.94-40.94c0-3.813-.535-7.5-1.515-11.004z"/></g><path d="m497 214.996h-482c-8.284 0-15-6.716-15-15s6.716-15 15-15h482c8.284 0 15 6.716 15 15s-6.716 15-15 15z"/></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Electronic asset</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Electronic assets in a school like scanner, printer, biometric system, fan, light, etc. will be recorded in the tool. These will be managed in the tool by IT management. Each of these resources will have a QR code printed out and struck on to them which will give their details like the date of purchasing, last serviced date and the next date when it should be sent to servicing.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 488.217 488.217" xml:space="preserve" class="h-8 fill-current"><g><path d="M340.817,121.226c0,2.998,2.43,5.442,5.443,5.442h15.932c3.015,0,5.442-2.444,5.442-5.442V92.995h-26.817V121.226z"></path> <path d="M277.122,227.963c1.938,0.754,3.92,1.104,5.871,1.104c6.649,0,12.902-4.048,15.426-10.624l11.98-31.427v5.292h19.295
    V136.49V94.431v-1.436h-4.934c0,0-0.018,0.008-0.033,0.008c-8.6,0-14.854,2.826-17.631,10.141L267.569,206.66
    c-0.855,2.285-1.125,4.61-0.967,6.895c4.3,3.697,7.695,8.434,9.743,13.924C276.63,227.605,276.806,227.852,277.122,227.963z"></path> <path d="M354.212,78.666c18.977,0,34.386-17.614,34.386-39.337C388.598,17.614,373.188,0,354.212,0
    c-18.979,0-34.402,17.614-34.402,39.329C319.809,61.053,335.232,78.666,354.212,78.666z"></path> <path d="M131.47,153.994c20.039,0,36.258-18.558,36.258-41.456c0-22.915-16.219-41.473-36.258-41.473
    c-19.994,0-36.213,18.558-36.213,41.473C95.257,135.436,111.475,153.994,131.47,153.994z"></path> <path d="M398.182,187.467l11.838,30.976c2.49,6.576,8.759,10.624,15.407,10.624c1.969,0,3.937-0.349,5.871-1.103
    c8.522-3.245,12.807-12.782,9.554-21.303l-39.527-103.516c-2.778-7.307-9.739-10.149-17.599-10.149h-4.95v99.313h19.326
    L398.182,187.467z"></path> <path d="M469.223,234.786h-71.042l-0.08-30.918h-13.171v25.604c0,2.046-0.809,3.84-1.982,5.315h-57.491
    c-1.173-1.475-1.999-3.269-1.999-5.315v-25.604h-13.06v30.918h-32.196c0.016,0.167,0.096,0.311,0.126,0.468
    c1.683,14.044-5.378,27.103-16.899,33.744h190.688v79.087H432.87v-15.059c0-6.3-5.11-11.409-11.41-11.409h-17.678v-13.997
    c0-6.3-5.108-11.409-11.408-11.409h-39.512c-6.299,0-11.41,5.109-11.41,11.409v13.997h-13.646c-6.3,0-11.411,5.109-11.411,11.409
    v15.059h-37.242v-15.059c0-6.3-5.125-11.409-11.408-11.409h-34.402c-6.3,0-11.425,5.109-11.425,11.409v15.059h-44.415l0.333-79.087
    v-33.213l12.407,18.17c3.254,4.777,8.65,7.577,14.361,7.577c0.683,0,1.381-0.039,2.094-0.119l39.75-4.792
    c9.523-1.15,16.33-9.814,15.188-19.351c-1.158-9.539-9.569-16.425-19.359-15.195l-29.277,3.531l-33.734-49.43
    c-4.143-6.063-10.698-7.07-18.25-7.07h-60.474c-8.829,0-15.98,3.08-18.804,10.965L42.034,289.698
    c-2.824,7.783,0.477,16.004,7.143,20.295v35.942H13.298c-3.871,0-7.475,1.96-9.568,5.22c-2.111,3.253-2.428,7.355-0.84,10.887
    l23.928,53.008c1.841,4.093,5.903,6.719,10.394,6.719h48.445v45.574c0,11.529,9.346,20.875,20.883,20.875
    c11.521,0,20.867-9.346,20.867-20.875V349.497h8.345v117.845c0,11.529,9.362,20.875,20.867,20.875
    c11.537,0,20.884-9.346,20.884-20.875v-5.078h288.262c11.33,0,20.564-9.22,20.564-20.565V251.893
    C486.329,242.442,478.681,234.786,469.223,234.786z M66.282,345.935v-35.021c3.761-1.943,6.902-5.078,8.457-9.362l10.568-29.206
    l0.35,73.59H66.282z M452.116,428.061h-48.334v-7.57c0-6.3-5.108-11.417-11.408-11.417h-24.818v-9.767
    c0-6.316-5.109-11.417-11.409-11.417h-57.331c-6.283,0-11.395,5.101-11.395,11.417v28.754h-36.877v-17.091
    c0-6.308-5.127-11.416-11.41-11.416h-37.527c-6.299,0-11.41,5.108-11.41,11.416v17.091h-12.693v-62.871h274.613V428.061z"></path></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Vendor Managament</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">In the Vendors management module, the tool will denote who the vendor for a product is, when the product was given to them for service, who to call for service, etc. All this will be possible by simply scanning the QR code given on the product.</p>
</div>
</div>
</div>
<!-- **** -->
</div>

</div>
@endsection 