{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.main')

@section('title')
GegoK12 - student-database-management | Online School Management 
@endsection

@section('content')
<div class="bg-red-600">
<div class="container mx-auto py-8 px-1">
	<h1 class="lg:text-4xl text-2xl font-bold  text-center text-white">School Student Database Management System</h1>
</div>

</div>
<div class="container mx-auto ">
<div class="leading-loose py-5 px-3"> <!-- w-full lg:w-2/3 lg:mx-auto -->
<div class="flex flex-col items-center lg:flex-row-reverse ">
<div class="w-full lg:w-1/3">
    <img src="{{url('images/img1.webp')}}" class="mx-auto">
    </div>
    <div class="w-full lg:w-2/3 px-5">
	<p class="text-base text-gray-700 my-3">
	It perfectly record, digitize, organise, edit, share, and protect the information and important data of students and staff. Here one can avoid manual paper documentation procedures by seamlessly scanning and uploading the necessary documents into the Cloud where the data is stored forever.</p>
	<p class="text-base text-gray-700 my-3">
	It is learnt that a student database management system in its simplest form uses a digital tracking system to maintain a record of all the students.They could maintaina record of every student-related data ranging from fees and financial records, examination records, transport facilities being provided by the school and availed by the students along with the usage of libraries, laboratory, computer lab and other school facilities used regularly by the students.</p>
	</div>
	</div>

	<p class="text-base text-gray-700 my-3 px-5">
	In addition a student database management system allows schools to save and access these records as needed by them, thus simplifying the work of the school administration team.</p>
	
	<div class="py-10">
	<h2 class="text-xl lg:text-3xl text-center font-plex font-extrabold text-black my-6">Key Features of School student database management system</h2>
	<!-- start -->
	<div class="flex flex-wrap">

<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5  py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg class="h-8 fill-current" xmlns="http://www.w3.org/2000/svg" height="512pt" version="1.1" viewBox="-38 0 512 512.00142" width="512pt">
<g id="surface1">
<path d="M 435.488281 138.917969 L 435.472656 138.519531 C 435.25 133.601562 435.101562 128.398438 435.011719 122.609375 C 434.59375 94.378906 412.152344 71.027344 383.917969 69.449219 C 325.050781 66.164062 279.511719 46.96875 240.601562 9.042969 L 240.269531 8.726562 C 227.578125 -2.910156 208.433594 -2.910156 195.738281 8.726562 L 195.40625 9.042969 C 156.496094 46.96875 110.957031 66.164062 52.089844 69.453125 C 23.859375 71.027344 1.414062 94.378906 0.996094 122.613281 C 0.910156 128.363281 0.757812 133.566406 0.535156 138.519531 L 0.511719 139.445312 C -0.632812 199.472656 -2.054688 274.179688 22.9375 341.988281 C 36.679688 379.277344 57.492188 411.691406 84.792969 438.335938 C 115.886719 468.679688 156.613281 492.769531 205.839844 509.933594 C 207.441406 510.492188 209.105469 510.945312 210.800781 511.285156 C 213.191406 511.761719 215.597656 512 218.003906 512 C 220.410156 512 222.820312 511.761719 225.207031 511.285156 C 226.902344 510.945312 228.578125 510.488281 230.1875 509.925781 C 279.355469 492.730469 320.039062 468.628906 351.105469 438.289062 C 378.394531 411.636719 399.207031 379.214844 412.960938 341.917969 C 438.046875 273.90625 436.628906 199.058594 435.488281 138.917969 Z M 384.773438 331.523438 C 358.414062 402.992188 304.605469 452.074219 220.273438 481.566406 C 219.972656 481.667969 219.652344 481.757812 219.320312 481.824219 C 218.449219 481.996094 217.5625 481.996094 216.679688 481.820312 C 216.351562 481.753906 216.03125 481.667969 215.734375 481.566406 C 131.3125 452.128906 77.46875 403.074219 51.128906 331.601562 C 28.09375 269.097656 29.398438 200.519531 30.550781 140.019531 L 30.558594 139.683594 C 30.792969 134.484375 30.949219 129.039062 31.035156 123.054688 C 31.222656 110.519531 41.207031 100.148438 53.765625 99.449219 C 87.078125 97.589844 116.34375 91.152344 143.234375 79.769531 C 170.089844 68.402344 193.941406 52.378906 216.144531 30.785156 C 217.273438 29.832031 218.738281 29.828125 219.863281 30.785156 C 242.070312 52.378906 265.921875 68.402344 292.773438 79.769531 C 319.664062 91.152344 348.929688 97.589844 382.246094 99.449219 C 394.804688 100.148438 404.789062 110.519531 404.972656 123.058594 C 405.0625 129.074219 405.21875 134.519531 405.453125 139.683594 C 406.601562 200.253906 407.875 268.886719 384.773438 331.523438 Z M 384.773438 331.523438 " style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" />
<path d="M 217.996094 128.410156 C 147.636719 128.410156 90.398438 185.652344 90.398438 256.007812 C 90.398438 326.367188 147.636719 383.609375 217.996094 383.609375 C 288.351562 383.609375 345.59375 326.367188 345.59375 256.007812 C 345.59375 185.652344 288.351562 128.410156 217.996094 128.410156 Z M 217.996094 353.5625 C 164.203125 353.5625 120.441406 309.800781 120.441406 256.007812 C 120.441406 202.214844 164.203125 158.453125 217.996094 158.453125 C 271.785156 158.453125 315.546875 202.214844 315.546875 256.007812 C 315.546875 309.800781 271.785156 353.5625 217.996094 353.5625 Z M 217.996094 353.5625 " style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" />
<path d="M 254.667969 216.394531 L 195.402344 275.660156 L 179.316406 259.574219 C 173.449219 253.707031 163.9375 253.707031 158.070312 259.574219 C 152.207031 265.441406 152.207031 274.953125 158.070312 280.816406 L 184.78125 307.527344 C 187.714844 310.460938 191.558594 311.925781 195.402344 311.925781 C 199.246094 311.925781 203.089844 310.460938 206.023438 307.527344 L 275.914062 237.636719 C 281.777344 231.769531 281.777344 222.257812 275.914062 216.394531 C 270.046875 210.523438 260.535156 210.523438 254.667969 216.394531 Z M 254.667969 216.394531 " style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" />
</g>
</svg>
	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">Quality Streamlined Activities</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	The student database management system allows for reminders to set up for the various events and activities that need to be performed by the school administration team.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
	<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5 py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg class="h-8 fill-current" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m163.922 284.788c17.166-14.685 28.078-36.48 28.078-60.788 0-44.112-35.888-80-80-80s-80 35.888-80 80c0 24.308 10.912 46.103 28.078 60.788-35.682 18.75-60.078 56.183-60.078 99.212v96.421c0 6.887 4.407 13.001 10.94 15.179 32.646 10.882 66.648 16.4 101.06 16.4s68.414-5.518 101.06-16.399c6.534-2.178 10.94-8.292 10.94-15.179v-96.422c0-43.029-24.396-80.462-60.078-99.212zm-99.922-60.788c0-26.467 21.533-48 48-48s48 21.533 48 48-21.533 48-48 48-48-21.533-48-48zm128 244.644c-51.997 15.012-108.003 15.012-160 0v-84.644c0-44.112 35.888-80 80-80s80 35.888 80 80z"/><path d="m451.922 284.788c17.166-14.685 28.078-36.48 28.078-60.788 0-44.112-35.888-80-80-80s-80 35.888-80 80c0 24.308 10.912 46.103 28.078 60.788-35.682 18.75-60.078 56.183-60.078 99.212v96.421c0 6.887 4.407 13.001 10.94 15.179 32.646 10.882 66.648 16.4 101.06 16.4s68.414-5.518 101.06-16.399c6.534-2.178 10.94-8.292 10.94-15.179v-96.422c0-43.029-24.396-80.462-60.078-99.212zm-99.922-60.788c0-26.467 21.533-48 48-48s48 21.533 48 48-21.533 48-48 48-48-21.533-48-48zm128 244.644c-51.997 15.012-108.003 15.012-160 0v-84.644c0-44.112 35.888-80 80-80s80 35.888 80 80z"/><path d="m340.85 67.15c-4.096 0-8.191-1.563-11.316-4.689-19.635-19.643-45.749-30.461-73.534-30.461s-53.899 10.818-73.534 30.461c-6.248 6.25-16.378 6.252-22.627.005-6.25-6.247-6.252-16.378-.005-22.627 25.679-25.691 59.831-39.839 96.166-39.839s70.487 14.148 96.167 39.839c6.247 6.25 6.245 16.38-.005 22.627-3.124 3.122-7.219 4.684-11.312 4.684z"/><path d="m301.26 106.74c-4.095 0-8.189-1.562-11.314-4.687-9.062-9.062-21.118-14.053-33.946-14.053s-24.884 4.991-33.946 14.054c-6.248 6.248-16.379 6.249-22.627 0-6.249-6.248-6.249-16.379 0-22.627 15.106-15.107 35.197-23.427 56.573-23.427s41.467 8.32 56.574 23.427c6.248 6.249 6.248 16.379 0 22.627-3.125 3.124-7.22 4.686-11.314 4.686z"/><path d="m256 176c-13.233 0-24-10.767-24-24s10.767-24 24-24 24 10.767 24 24-10.767 24-24 24z"/></g></svg>
	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">Act of Better Communication</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	A student database management system permits for simpler communication between students, parents-teachers, students-teachers and even allows for the school alumni to stay connected with each other.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
	<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5 py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg class="h-8 fill-current" height="462pt" viewBox="-1 0 462 462.3012" width="462pt" xmlns="http://www.w3.org/2000/svg"><path d="m343.851562 0c-40.429687.0390625-77.925781 21.101562-99 55.601562l-203-1.300781h-.199218c-10.933594.003907-21.425782 4.316407-29.203125 12-7.816407 7.667969-12.246094 18.148438-12.296875 29.097657v277.601562c0 15.300781 9 28.601562 21 35.699219v28.300781c.050781 6.753906 2.792968 13.210938 7.613281 17.9375 4.824219 4.730469 11.332031 7.34375 18.085937 7.261719h33.5c14.097657 0 25.800782-11.097657 25.800782-25.199219v-22.699219h172v22.800781c-.039063 6.710938 2.617187 13.160157 7.371094 17.894532 4.757812 4.738281 11.214843 7.371094 17.925781 7.304687h33.5c6.703125.0625 13.148437-2.574219 17.890625-7.3125 4.738281-4.738281 7.371094-11.1875 7.3125-17.886719v-28.300781c13.078125-7.085937 21.160156-20.828125 21-35.699219v-148c46.011718-16.539062 76.671875-60.207031 76.597656-109.101562 0-64-52-116-115.898438-116zm-323.699218 95.398438c.167968-11.753907 9.742187-21.191407 21.5-21.199219h.097656l193.402344 1.199219c-3.925782 10.269531-6.347656 21.042968-7.203125 32l-207.796875-1.296876zm0 30.703124 161 1.097657v118.902343l-161-.703124zm66 311c0 3.097657-2.800782 5.199219-5.800782 5.199219h-33.5c-1.449218.078125-2.867187-.429687-3.941406-1.40625-1.070312-.980469-1.703125-2.34375-1.757812-3.792969v-22.902343c.164062.042969.328125.078125.5.101562h44.5zm250.796875 5.199219h-33.5c-1.40625.0625-2.777344-.460937-3.78125-1.445312-1.003907-.988281-1.554688-2.347657-1.515625-3.753907v-22.800781h44v22.800781c.042968 1.390626-.492188 2.738282-1.476563 3.722657s-2.332031 1.519531-3.726562 1.476562zm26.203125-69.300781c.011718 11.691406-9.410156 21.203125-21.101563 21.300781h-300.398437c-11.773438-.066406-21.328125-9.53125-21.5-21.300781v-107.601562l166.097656.703124c1.472656.804688 3.125 1.21875 4.800781 1.199219 1.644531.019531 3.265625-.394531 4.699219-1.199219l167.402344.699219zm0-126.199219-162-.699219v-118.800781l27.296875.199219c6.003906 59.246094 55.851562 104.34375 115.402343 104.398438 6.5-.007813 12.984376-.542969 19.398438-1.597657v16.5zm-19.300782-34.902343c-53.019531 0-96-42.980469-96-96 0-53.019532 42.980469-96 96-96 53.019532 0 96 42.980468 96 96-.085937 52.984374-43.015624 95.917968-96 96zm0 0"/><path d="m285.152344 362.300781h54c5.515625-.015625 9.980468-4.484375 10-10v-37c-.019532-5.515625-4.484375-9.984375-10-10h-54c-5.519532.015625-9.984375 4.484375-10 10v37c.015625 5.515625 4.480468 9.984375 10 10zm10-37h35v17h-35zm0 0"/><path d="m98.152344 305.300781h-54c-5.519532.015625-9.984375 4.484375-10 10v37c.015625 5.515625 4.480468 9.984375 10 10h54c5.515625-.015625 9.980468-4.484375 10-10v-37c-.019532-5.515625-4.484375-9.984375-10-10zm-10 37h-34v-17h34zm0 0"/><path d="m242.851562 344.300781h-101.902343c-5.519531 0-10 4.476563-10 10 0 5.523438 4.480469 10 10 10h101.902343c5.523438 0 10-4.476562 10-10 0-5.523437-4.476562-10-10-10zm0 0"/><path d="m130.949219 319.300781c.015625 5.515625 4.484375 9.984375 10 10h101.902343c5.523438 0 10-4.476562 10-10 0-5.523437-4.476562-10-10-10h-101.902343c-2.652344-.011719-5.203125 1.039063-7.078125 2.917969-1.878906 1.878906-2.929688 4.425781-2.921875 7.082031zm0 0"/><path d="m359.550781 99.699219c14.324219-7.144531 21.851563-23.203125 18.179688-38.78125-3.667969-15.582031-17.574219-26.589844-33.578125-26.589844-16.007813 0-29.914063 11.007813-33.582032 26.589844-3.671874 15.578125 3.855469 31.636719 18.179688 38.78125-25.171875 6.96875-42.601562 29.878906-42.597656 56v15.402343c-.046875 5.535157 4.363281 10.078126 9.898437 10.199219h96.199219c5.535156-.121093 9.945312-4.664062 9.902344-10.199219v-15.402343c-.011719-26.117188-17.433594-49.023438-42.601563-56zm-15.398437-45.300781c7.980468.027343 14.425781 6.519531 14.398437 14.5-.027343 7.980468-6.519531 14.429687-14.5 14.402343-7.980469-.027343-14.429687-6.519531-14.398437-14.5.058594-7.96875 6.53125-14.394531 14.5-14.402343zm38 106.902343h-76v-5.601562c0-20.984375 17.011718-38 38-38 20.984375 0 38 17.015625 38 38zm0 0"/></svg>

	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">Simple Management of Transport</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	It perfectly allows schools to stay updated in real-time on the number of students using the school transport system along with their address.The system also helps the school and parents to keep track of the bus along the route and sends the parents regular updates in case of breakdowns, route changes or any delays.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
	<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5 py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg class="h-8 fill-current" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m497 482h-66v-147c0-16.542-13.458-30-30-30h-22.302c-5.877-25.639-17.576-47.653-34.259-64.191-10.5-10.409-22.708-18.363-36.247-23.714 29.019-25.038 47.958-68.322 47.958-107.429 0-35.488-9.872-63.341-29.341-82.782-17.611-17.588-42.096-26.884-70.809-26.884-28.712 0-53.198 9.296-70.81 26.884-19.469 19.441-29.341 47.294-29.341 82.782 0 39.106 18.939 82.391 47.958 107.429-13.538 5.351-25.746 13.305-36.246 23.714-16.683 16.538-28.382 38.553-34.258 64.191h-22.303c-16.542 0-30 13.458-30 30v147h-66c-8.284 0-15 6.716-15 15s6.716 15 15 15h482c8.284 0 15-6.716 15-15s-6.716-15-15-15zm-241-452c22.03 0 56.606 7.323 67.056 50.861-15.288-1.944-24.018-6.263-30.851-9.644-6.698-3.314-14.29-7.071-23.555-4.947-7.521 1.724-12.898 5.967-18.097 10.071-9.475 7.479-23.308 18.373-64.163 20.579 5.087-57.863 45.109-66.92 69.61-66.92zm-68.64 96.908c50.947-2.683 69.976-17.7 81.781-27.019 1.709-1.35 3.909-3.085 5.271-3.916 1.204.508 2.981 1.387 4.489 2.133 8.814 4.361 22.653 11.205 47.211 13.213-.392 22.087-8.603 46.584-22.173 65.885-13.848 19.698-31.322 30.996-47.939 30.996s-34.091-11.298-47.94-30.996c-10.435-14.843-17.715-32.764-20.7-50.296zm60.64 112.092h16c41.628 0 71.994 24.34 83.776 66h-183.552c11.782-41.66 42.148-66 83.776-66zm-137 243v-147h290v147z"/><circle cx="256" cy="399.997" r="15"/></g></svg>

	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">Facile Admission Process</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	The online system also makes it easy for the school to send students updates on admission tests, interview dates, reminders as well as the final admission status. It makes the admission process faster, error-free and more secure.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
		<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5 py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg class="h-8 fill-current" height="512pt" viewBox="0 -9 512.00001 512" width="512pt" xmlns="http://www.w3.org/2000/svg"><path d="m7.5 364.832031c4.140625 0 7.5-3.355469 7.5-7.5v-218.441406h443.128906v82.441406c0 4.144531 3.359375 7.5 7.5 7.5 4.144532 0 7.5-3.355469 7.5-7.5v-148.222656c0-25.144531-20.457031-45.601563-45.597656-45.601563h-19.667969v-9.289062c0-10.046875-8.171875-18.21875-18.21875-18.21875h-13.933593c-10.042969 0-18.214844 8.171875-18.214844 18.21875v9.289062h-49.742188v-9.289062c0-10.046875-8.171875-18.21875-18.21875-18.21875h-13.933594c-10.042968 0-18.214843 8.171875-18.214843 18.21875v9.289062h-49.746094v-9.289062c0-10.046875-8.171875-18.21875-18.21875-18.21875h-13.929687c-10.046876 0-18.21875 8.171875-18.21875 18.21875v9.289062h-49.742188v-9.289062c0-10.046875-8.171875-18.21875-18.21875-18.21875h-13.929688c-10.046874 0-18.21875 8.171875-18.21875 18.21875v9.289062h-11.5625c-25.144531 0-45.601562 20.457032-45.601562 45.601563v284.222656c0 4.144531 3.359375 7.5 7.5 7.5zm364.996094-346.613281c0-1.773438 1.445312-3.21875 3.21875-3.21875h13.933594c1.773437 0 3.214843 1.445312 3.214843 3.21875v36.4375c0 1.773438-1.441406 3.21875-3.214843 3.21875h-13.933594c-1.773438 0-3.21875-1.441406-3.21875-3.21875zm-100.109375 0c0-1.773438 1.441406-3.21875 3.214843-3.21875h13.933594c1.773438 0 3.21875 1.445312 3.21875 3.21875v36.4375c0 1.773438-1.445312 3.21875-3.21875 3.21875h-13.933594c-1.773437 0-3.214843-1.441406-3.214843-3.21875zm-100.113281 0c0-1.773438 1.445312-3.21875 3.21875-3.21875h13.933593c1.773438 0 3.21875 1.445312 3.21875 3.21875v36.4375c0 1.773438-1.445312 3.21875-3.21875 3.21875h-13.933593c-1.773438 0-3.21875-1.441406-3.21875-3.21875zm-100.109376 0c0-1.773438 1.445313-3.21875 3.21875-3.21875h13.933594c1.773438 0 3.214844 1.445312 3.214844 3.21875v36.4375c0 1.773438-1.441406 3.21875-3.214844 3.21875h-13.933594c-1.773437 0-3.21875-1.441406-3.21875-3.21875zm-26.5625 24.289062h11.5625v12.148438c0 10.046875 8.171876 18.21875 18.21875 18.21875h13.933594c10.042969 0 18.214844-8.171875 18.214844-18.21875v-12.148438h49.746094v12.148438c0 10.046875 8.171875 18.21875 18.214844 18.21875h13.933593c10.046875 0 18.21875-8.171875 18.21875-18.21875v-12.148438h49.742188v12.148438c0 10.046875 8.171875 18.21875 18.21875 18.21875h13.933593c10.042969 0 18.214844-8.171875 18.214844-18.21875v-12.148438h49.742188v12.148438c0 10.046875 8.171875 18.21875 18.21875 18.21875h13.933594c10.042968 0 18.214843-8.171875 18.214843-18.21875v-12.148438h19.667969c16.875 0 30.601562 13.726563 30.601562 30.601563v50.78125h-443.132812v-50.78125c0-16.875 13.726562-30.601563 30.601562-30.601563zm0 0"/><path d="m84.910156 434.582031h-65.398437c-2.488281 0-4.511719-2.023437-4.511719-4.511719v-38.558593c0-4.144531-3.359375-7.5-7.5-7.5s-7.5 3.355469-7.5 7.5v38.558593c0 10.757813 8.753906 19.511719 19.511719 19.511719h65.398437c4.140625 0 7.5-3.359375 7.5-7.5 0-4.144531-3.359375-7.5-7.5-7.5zm0 0"/><path d="m84.660156 160.761719h-26.070312c-4.140625 0-7.5 3.359375-7.5 7.5 0 4.144531 3.359375 7.5 7.5 7.5h26.070312c4.140625 0 7.5-3.355469 7.5-7.5 0-4.140625-3.359375-7.5-7.5-7.5zm0 0"/><path d="m138.707031 175.761719h26.070313c4.140625 0 7.5-3.355469 7.5-7.5 0-4.140625-3.359375-7.5-7.5-7.5h-26.070313c-4.140625 0-7.5 3.359375-7.5 7.5 0 4.144531 3.359375 7.5 7.5 7.5zm0 0"/><path d="m218.824219 175.761719h26.066406c4.140625 0 7.5-3.355469 7.5-7.5 0-4.140625-3.359375-7.5-7.5-7.5h-26.066406c-4.144531 0-7.5 3.359375-7.5 7.5 0 4.144531 3.355469 7.5 7.5 7.5zm0 0"/><path d="m298.9375 175.761719h26.070312c4.140626 0 7.5-3.355469 7.5-7.5 0-4.140625-3.359374-7.5-7.5-7.5h-26.070312c-4.140625 0-7.5 3.359375-7.5 7.5 0 4.144531 3.359375 7.5 7.5 7.5zm0 0"/><path d="m405.121094 160.761719h-26.066406c-4.144532 0-7.5 3.359375-7.5 7.5 0 4.144531 3.355468 7.5 7.5 7.5h26.066406c4.140625 0 7.5-3.355469 7.5-7.5 0-4.140625-3.359375-7.5-7.5-7.5zm0 0"/><path d="m84.660156 198.476562h-26.070312c-4.140625 0-7.5 3.355469-7.5 7.5 0 4.144532 3.359375 7.5 7.5 7.5h26.070312c4.140625 0 7.5-3.355468 7.5-7.5 0-4.144531-3.359375-7.5-7.5-7.5zm0 0"/><path d="m138.707031 213.476562h26.070313c4.140625 0 7.5-3.355468 7.5-7.5 0-4.144531-3.359375-7.5-7.5-7.5h-26.070313c-4.140625 0-7.5 3.355469-7.5 7.5 0 4.144532 3.359375 7.5 7.5 7.5zm0 0"/><path d="m218.824219 213.476562h26.066406c4.140625 0 7.5-3.355468 7.5-7.5 0-4.144531-3.359375-7.5-7.5-7.5h-26.066406c-4.144531 0-7.5 3.355469-7.5 7.5 0 4.144532 3.355469 7.5 7.5 7.5zm0 0"/><path d="m298.9375 213.476562h26.070312c4.140626 0 7.5-3.355468 7.5-7.5 0-4.144531-3.359374-7.5-7.5-7.5h-26.070312c-4.140625 0-7.5 3.355469-7.5 7.5 0 4.144532 3.359375 7.5 7.5 7.5zm0 0"/><path d="m405.121094 198.476562h-26.066406c-4.144532 0-7.5 3.355469-7.5 7.5 0 4.144532 3.355468 7.5 7.5 7.5h26.066406c4.140625 0 7.5-3.355468 7.5-7.5 0-4.144531-3.359375-7.5-7.5-7.5zm0 0"/><path d="m138.890625 360.714844 38.5625 38.5625c5.578125 5.578125 12.992187 8.648437 20.882813 8.648437 7.890624 0 15.308593-3.070312 20.882812-8.648437l105.605469-105.605469c11.515625-11.515625 11.515625-30.253906 0-41.769531s-30.253907-11.515625-41.769531 0l-84.71875 84.71875-17.679688-17.675782c-11.511719-11.515624-30.25-11.515624-41.769531 0-11.511719 11.515626-11.511719 30.253907.003906 41.769532zm10.605469-31.164063c2.832031-2.832031 6.554687-4.25 10.277344-4.25 3.722656 0 7.445312 1.417969 10.277343 4.25l22.980469 22.980469c2.929688 2.929688 7.675781 2.929688 10.605469 0l90.023437-90.019531c5.671875-5.667969 14.890625-5.667969 20.554688-.003907 5.667968 5.667969 5.667968 14.890626 0 20.558594l-105.601563 105.601563c-2.746093 2.746093-6.394531 4.257812-10.277343 4.257812-3.882813 0-7.53125-1.511719-10.277344-4.257812l-38.5625-38.5625c-5.667969-5.667969-5.667969-14.886719 0-20.554688zm0 0"/><path d="m473.128906 315.359375v-59.847656c0-4.144531-3.355468-7.5-7.5-7.5-4.140625 0-7.5 3.355469-7.5 7.5v50.28125c-13.675781-7.089844-29.195312-11.101563-45.632812-11.101563-54.867188 0-99.503906 44.636719-99.503906 99.503906 0 14.371094 3.066406 28.035157 8.570312 40.386719h-202.476562c-4.140626 0-7.5 3.355469-7.5 7.5 0 4.140625 3.359374 7.5 7.5 7.5h210.785156c17.878906 26.589844 48.242187 44.117188 82.625 44.117188 54.867187 0 99.503906-44.636719 99.503906-99.503907 0-32.0625-15.25-60.628906-38.871094-78.835937zm-60.632812 163.339844c-46.597656 0-84.503906-37.90625-84.503906-84.503907 0-46.597656 37.910156-84.503906 84.503906-84.503906s84.503906 37.90625 84.503906 84.503906c0 46.597657-37.910156 84.503907-84.503906 84.503907zm0 0"/><path d="m412.496094 320.527344c-40.621094 0-73.667969 33.050781-73.667969 73.667968 0 40.621094 33.046875 73.667969 73.667969 73.667969s73.664062-33.046875 73.664062-73.667969c0-40.617187-33.046875-73.667968-73.664062-73.667968zm6.714844 131.9375c.496093-1.003906.785156-2.128906.785156-3.324219v-9.136719c0-4.140625-3.359375-7.5-7.5-7.5s-7.5 3.359375-7.5 7.5v9.136719c0 1.195313.285156 2.320313.785156 3.324219-26.992188-3.089844-48.464844-24.5625-51.554688-51.554688 1 .5 2.128907.785156 3.324219.785156h9.132813c4.144531 0 7.5-3.355468 7.5-7.5 0-4.144531-3.355469-7.5-7.5-7.5h-9.132813c-1.195312 0-2.324219.289063-3.324219.785157 3.089844-26.992188 24.5625-48.464844 51.554688-51.554688-.5 1.003907-.785156 2.128907-.785156 3.324219v9.136719c0 4.144531 3.359375 7.5 7.5 7.5s7.5-3.355469 7.5-7.5v-9.136719c0-1.195312-.289063-2.320312-.785156-3.324219 26.992187 3.089844 48.464843 24.5625 51.554687 51.554688-1.003906-.496094-2.128906-.785157-3.324219-.785157h-9.136718c-4.140626 0-7.5 3.355469-7.5 7.5 0 4.144532 3.359374 7.5 7.5 7.5h9.136718c1.195313 0 2.320313-.285156 3.324219-.785156-3.09375 26.992188-24.5625 48.464844-51.554687 51.554688zm0 0"/><path d="m429.027344 386.695312h-9.03125v-7.691406c0-4.140625-3.359375-7.5-7.5-7.5-4.144532 0-7.5 3.359375-7.5 7.5v15.191406c0 4.144532 3.355468 7.5 7.5 7.5h16.53125c4.140625 0 7.5-3.355468 7.5-7.5 0-4.144531-3.359375-7.5-7.5-7.5zm0 0"/></svg>

	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">Effect of Faster Attendance Management</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	It is experienced that the system saves class teachers tedious minutes every morning calling out the class attendance and provides with the administration team on timely summaries and records of regular latecomers, absentees etc. when required.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
		<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5 py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" class="h-8 fill-current"><path d="M 23.6641 52.3985 C 26.6407 55.375 29.3594 55.3516 32.3126 52.3985 L 35.9219 48.8125 C 36.2969 48.4610 36.6250 48.3203 37.1172 48.3203 L 42.1797 48.3203 C 46.3749 48.3203 48.3204 46.3985 48.3204 42.1797 L 48.3204 37.1172 C 48.3204 36.625 48.4610 36.2969 48.8124 35.9219 L 52.3749 32.3125 C 55.3749 29.3594 55.3514 26.6407 52.3749 23.6641 L 48.8124 20.0547 C 48.4610 19.7031 48.3204 19.3516 48.3204 18.8829 L 48.3204 13.7969 C 48.3204 9.625 46.3985 7.6563 42.1797 7.6563 L 37.1172 7.6563 C 36.6250 7.6563 36.2969 7.5391 35.9219 7.1875 L 32.3126 3.6016 C 29.3594 .6250 26.6407 .6485 23.6641 3.6016 L 20.0547 7.1875 C 19.7032 7.5391 19.3516 7.6563 18.8828 7.6563 L 13.7969 7.6563 C 9.6016 7.6563 7.6563 9.5782 7.6563 13.7969 L 7.6563 18.8829 C 7.6563 19.3516 7.5391 19.7031 7.1876 20.0547 L 3.6016 23.6641 C .6251 26.6407 .6485 29.3594 3.6016 32.3125 L 7.1876 35.9219 C 7.5391 36.2969 7.6563 36.625 7.6563 37.1172 L 7.6563 42.1797 C 7.6563 46.3750 9.6016 48.3203 13.7969 48.3203 L 18.8828 48.3203 C 19.3516 48.3203 19.7032 48.4610 20.0547 48.8125 Z M 26.2891 49.7734 L 21.8828 45.3438 C 21.3672 44.8047 20.8282 44.5938 20.1016 44.5938 L 13.7969 44.5938 C 11.7110 44.5938 11.3828 44.2656 11.3828 42.1797 L 11.3828 35.875 C 11.3828 35.1719 11.1719 34.6329 10.6563 34.1172 L 6.2266 29.7109 C 4.7501 28.2109 4.7501 27.7891 6.2266 26.2891 L 10.6563 21.8829 C 11.1719 21.3672 11.3828 20.8282 11.3828 20.1016 L 11.3828 13.7969 C 11.3828 11.6875 11.6876 11.3829 13.7969 11.3829 L 20.1016 11.3829 C 20.8282 11.3829 21.3672 11.1953 21.8828 10.6563 L 26.2891 6.2266 C 27.7891 4.7500 28.2110 4.7500 29.7110 6.2266 L 34.1172 10.6563 C 34.6328 11.1953 35.1719 11.3829 35.8750 11.3829 L 42.1797 11.3829 C 44.2657 11.3829 44.5938 11.7109 44.5938 13.7969 L 44.5938 20.1016 C 44.5938 20.8282 44.8282 21.3672 45.3439 21.8829 L 49.7733 26.2891 C 51.2498 27.7891 51.2498 28.2109 49.7733 29.7109 L 45.3439 34.1172 C 44.8282 34.6329 44.5938 35.1719 44.5938 35.875 L 44.5938 42.1797 C 44.5938 44.2656 44.2657 44.5938 42.1797 44.5938 L 35.8750 44.5938 C 35.1719 44.5938 34.6328 44.8047 34.1172 45.3438 L 29.7110 49.7734 C 28.2110 51.2500 27.7891 51.2500 26.2891 49.7734 Z M 24.3438 39.2266 C 25.0235 39.2266 25.5391 38.9453 25.8907 38.5234 L 38.8985 20.3360 C 39.1563 19.9609 39.2969 19.5391 39.2969 19.1407 C 39.2969 18.1094 38.5001 17.2891 37.4219 17.2891 C 36.6485 17.2891 36.2266 17.5469 35.7579 18.2266 L 24.2735 34.3985 L 18.3438 27.8594 C 17.9454 27.4141 17.5001 27.2266 16.9141 27.2266 C 15.7657 27.2266 14.9454 28.0000 14.9454 29.0782 C 14.9454 29.5469 15.1094 29.9922 15.4376 30.3203 L 22.8907 38.6172 C 23.2423 38.9922 23.6876 39.2266 24.3438 39.2266 Z"></path></svg>

	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">Illustration of Report Management</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	The system permits for these important kinds of reports to be customized and presented in a manner that aids the decision-making process of the school administration and management team.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
		<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5 py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg  xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" class="h-8 fill-current"><path d="M 11.9923 49.5742 L 44.0079 49.5742 C 48.9066 49.5742 51.3671 47.1367 51.3671 42.3086 L 51.3671 13.6914 C 51.3671 8.8633 48.9066 6.4258 44.0079 6.4258 L 11.9923 6.4258 C 7.1173 6.4258 4.6329 8.8398 4.6329 13.6914 L 4.6329 42.3086 C 4.6329 47.1602 7.1173 49.5742 11.9923 49.5742 Z M 11.6642 45.8008 C 9.5782 45.8008 8.4064 44.6992 8.4064 42.5195 L 8.4064 20.4180 C 8.4064 18.2617 9.5782 17.1367 11.6642 17.1367 L 44.3126 17.1367 C 46.3985 17.1367 47.5938 18.2617 47.5938 20.4180 L 47.5938 42.5195 C 47.5938 44.6992 46.3985 45.8008 44.3126 45.8008 Z M 23.4064 25.5508 L 24.7892 25.5508 C 25.6095 25.5508 25.8907 25.3164 25.8907 24.4961 L 25.8907 23.1133 C 25.8907 22.2930 25.6095 22.0352 24.7892 22.0352 L 23.4064 22.0352 C 22.5860 22.0352 22.3282 22.2930 22.3282 23.1133 L 22.3282 24.4961 C 22.3282 25.3164 22.5860 25.5508 23.4064 25.5508 Z M 31.2111 25.5508 L 32.5704 25.5508 C 33.4142 25.5508 33.6720 25.3164 33.6720 24.4961 L 33.6720 23.1133 C 33.6720 22.2930 33.4142 22.0352 32.5704 22.0352 L 31.2111 22.0352 C 30.3907 22.0352 30.1095 22.2930 30.1095 23.1133 L 30.1095 24.4961 C 30.1095 25.3164 30.3907 25.5508 31.2111 25.5508 Z M 38.9923 25.5508 L 40.3751 25.5508 C 41.1954 25.5508 41.4767 25.3164 41.4767 24.4961 L 41.4767 23.1133 C 41.4767 22.2930 41.1954 22.0352 40.3751 22.0352 L 38.9923 22.0352 C 38.1720 22.0352 37.8907 22.2930 37.8907 23.1133 L 37.8907 24.4961 C 37.8907 25.3164 38.1720 25.5508 38.9923 25.5508 Z M 15.6251 33.2149 L 17.0079 33.2149 C 17.8282 33.2149 18.1095 32.9805 18.1095 32.1602 L 18.1095 30.7774 C 18.1095 29.9571 17.8282 29.7227 17.0079 29.7227 L 15.6251 29.7227 C 14.8048 29.7227 14.5235 29.9571 14.5235 30.7774 L 14.5235 32.1602 C 14.5235 32.9805 14.8048 33.2149 15.6251 33.2149 Z M 23.4064 33.2149 L 24.7892 33.2149 C 25.6095 33.2149 25.8907 32.9805 25.8907 32.1602 L 25.8907 30.7774 C 25.8907 29.9571 25.6095 29.7227 24.7892 29.7227 L 23.4064 29.7227 C 22.5860 29.7227 22.3282 29.9571 22.3282 30.7774 L 22.3282 32.1602 C 22.3282 32.9805 22.5860 33.2149 23.4064 33.2149 Z M 31.2111 33.2149 L 32.5704 33.2149 C 33.4142 33.2149 33.6720 32.9805 33.6720 32.1602 L 33.6720 30.7774 C 33.6720 29.9571 33.4142 29.7227 32.5704 29.7227 L 31.2111 29.7227 C 30.3907 29.7227 30.1095 29.9571 30.1095 30.7774 L 30.1095 32.1602 C 30.1095 32.9805 30.3907 33.2149 31.2111 33.2149 Z M 38.9923 33.2149 L 40.3751 33.2149 C 41.1954 33.2149 41.4767 32.9805 41.4767 32.1602 L 41.4767 30.7774 C 41.4767 29.9571 41.1954 29.7227 40.3751 29.7227 L 38.9923 29.7227 C 38.1720 29.7227 37.8907 29.9571 37.8907 30.7774 L 37.8907 32.1602 C 37.8907 32.9805 38.1720 33.2149 38.9923 33.2149 Z M 15.6251 40.9024 L 17.0079 40.9024 C 17.8282 40.9024 18.1095 40.6445 18.1095 39.8242 L 18.1095 38.4414 C 18.1095 37.6211 17.8282 37.3867 17.0079 37.3867 L 15.6251 37.3867 C 14.8048 37.3867 14.5235 37.6211 14.5235 38.4414 L 14.5235 39.8242 C 14.5235 40.6445 14.8048 40.9024 15.6251 40.9024 Z M 23.4064 40.9024 L 24.7892 40.9024 C 25.6095 40.9024 25.8907 40.6445 25.8907 39.8242 L 25.8907 38.4414 C 25.8907 37.6211 25.6095 37.3867 24.7892 37.3867 L 23.4064 37.3867 C 22.5860 37.3867 22.3282 37.6211 22.3282 38.4414 L 22.3282 39.8242 C 22.3282 40.6445 22.5860 40.9024 23.4064 40.9024 Z M 31.2111 40.9024 L 32.5704 40.9024 C 33.4142 40.9024 33.6720 40.6445 33.6720 39.8242 L 33.6720 38.4414 C 33.6720 37.6211 33.4142 37.3867 32.5704 37.3867 L 31.2111 37.3867 C 30.3907 37.3867 30.1095 37.6211 30.1095 38.4414 L 30.1095 39.8242 C 30.1095 40.6445 30.3907 40.9024 31.2111 40.9024 Z"></path></svg>

	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">School Event Calendar</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	By this key feature it can be viewed and updated by the school which helps parents to stay updated about the various events and activities organized by the school.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
		<!-- **** -->
	<div class="w-full lg:w-1/2 lg:px-5 py-2">
	<div class=" px-4 py-3 flex">
	<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
<svg class="h-8 fill-current" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m251.69 289.367c1.406.422 2.858.633 4.31.633s2.904-.211 4.31-.633c32.235-9.67 59.893-29.054 79.982-56.054 20.089-27.001 30.708-59.062 30.708-92.716v-85.597c0-8.284-6.716-15-15-15-18.955 0-35.996-10.532-44.472-27.484l-2.111-4.223c-2.541-5.083-7.735-8.293-13.417-8.293h-80c-5.682 0-10.876 3.21-13.417 8.292l-2.111 4.222c-8.476 16.954-25.517 27.486-44.472 27.486-8.284 0-15 6.716-15 15v85.597c0 33.654 10.619 65.715 30.708 92.716 20.089 27 47.747 46.384 79.982 56.054zm-80.69-220.764c22.701-4.285 42.437-18.2 54.125-38.603h61.75c11.688 20.402 31.424 34.318 54.125 38.603v71.995c0 54.256-33.971 101.385-85 118.66-51.029-17.275-85-64.404-85-118.66z"/><path d="m241.858 188.284c3.839 0 7.678-1.464 10.606-4.394l56.568-56.568c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-45.962 45.961-17.678-17.677c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l28.284 28.284c2.93 2.93 6.769 4.394 10.608 4.394z"/><path d="m453.162 352.709c11.637-11.752 18.838-27.903 18.838-45.709 0-35.841-29.159-65-65-65s-65 29.159-65 65c0 17.775 7.178 33.9 18.779 45.647-23.968 11.721-42.808 32.307-52.209 57.634-3.452-2.726-7.117-5.191-10.97-7.364 8.338-9.644 13.4-22.197 13.4-35.917 0-30.327-24.673-55-55-55s-55 24.673-55 55c0 13.72 5.062 26.273 13.4 35.917-3.853 2.172-7.518 4.638-10.97 7.364-9.401-25.327-28.242-45.913-52.209-57.634 11.601-11.747 18.779-27.872 18.779-45.647 0-35.841-29.159-65-65-65s-65 29.159-65 65c0 17.806 7.201 33.957 18.838 45.709-34.816 17.114-58.838 52.948-58.838 94.291v50c0 8.284 6.716 15 15 15h482c8.284 0 15-6.716 15-15v-50c0-41.343-24.022-77.177-58.838-94.291zm-81.162-45.709c0-19.299 15.701-35 35-35s35 15.701 35 35-15.701 35-35 35-35-15.701-35-35zm-141 60c0-13.785 11.215-25 25-25s25 11.215 25 25-11.215 25-25 25-25-11.215-25-25zm-161-60c0-19.299 15.701-35 35-35s35 15.701 35 35-15.701 35-35 35-35-15.701-35-35zm-40 140c0-41.355 33.645-75 75-75 38.898 0 70.974 29.436 74.644 67.696-5.528 11.27-8.644 23.928-8.644 37.304v5h-141zm281 35h-110v-5c0-30.327 24.673-55 55-55s55 24.673 55 55zm171 0h-141v-5c0-13.376-3.116-26.034-8.644-37.304 3.67-38.26 35.746-67.696 74.644-67.696 41.355 0 75 33.645 75 75z"/></g></svg>

	</div></div>
	<div class="w-full px-3">
    <h3 class="text-base text-gray-700 font-semibold ">Increased Data Security</h3>
    <p class="text-sm text-gray-700 my-1 text-justify">
	One of the key features of using technology to manage the student database is that it is very secure and ensures that all the secure school data is kept safe.</p>
	</div>
	</div>
	</div>
	<!-- **** -->
	
	
	
	<!-- end -->
	</div>
</div>
</div>
@endsection 