{{-- SPDX-License-Identifier: MIT --}}
<ul class="list-reset text-sm">
    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'dashboard' ? 'active':''}}">
        <a href="{{url('teacher/dashboard')}}" class="flex items-center">
            <svg class="w-5 h-5 text-white fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><g><path d="M366.292,215.99L241.417,325.781c-0.167,0.146-0.333,0.292-0.479,0.448c-4.042,4.021-6.271,9.385-6.271,15.104 c0,11.76,9.563,21.333,21.333,21.333c5.667,0,11.021-2.208,15.563-6.75l109.792-124.875c3.708-4.219,3.5-10.604-0.479-14.583 C376.896,212.49,370.542,212.281,366.292,215.99z"/><path d="M256,85.333c-141.167,0-256,114.844-256,256c0,26.479,4.104,52.688,12.167,77.917c1.417,4.417,5.521,7.417,10.167,7.417 h467.333c4.646,0,8.75-3,10.167-7.417C507.896,394.021,512,367.813,512,341.333C512,200.177,397.167,85.333,256,85.333z M458.667,352h31.26c-0.824,18.04-3.237,35.947-8.177,53.333H30.25c-4.94-17.387-7.353-35.293-8.177-53.333h31.26 C59.229,352,64,347.229,64,341.333c0-5.896-4.771-10.667-10.667-10.667h-31.46c1.581-34.919,10.68-67.865,25.948-97.208 l27.324,15.781c1.688,0.969,3.521,1.427,5.333,1.427c3.667,0,7.271-1.906,9.229-5.333c2.958-5.104,1.208-11.625-3.896-14.573 l-27.263-15.746c18.323-28.539,42.602-52.816,71.142-71.138l15.746,27.28c1.958,3.417,5.563,5.333,9.229,5.333 c1.813,0,3.646-0.458,5.333-1.427c5.104-2.948,6.854-9.469,3.896-14.573l-15.777-27.332c29.345-15.27,62.293-24.37,97.215-25.951 v31.46c0,5.896,4.771,10.667,10.667,10.667s10.667-4.771,10.667-10.667v-31.46c34.922,1.581,67.87,10.681,97.215,25.951 l-15.777,27.332c-2.958,5.104-1.208,11.625,3.896,14.573c1.688,0.969,3.521,1.427,5.333,1.427c3.667,0,7.271-1.917,9.229-5.333 l15.746-27.28c28.54,18.322,52.819,42.599,71.142,71.138l-27.263,15.746c-5.104,2.948-6.854,9.469-3.896,14.573 c1.958,3.427,5.563,5.333,9.229,5.333c1.812,0,3.646-0.458,5.333-1.427l27.324-15.781c15.268,29.344,24.367,62.289,25.948,97.208 h-31.46c-5.896,0-10.667,4.771-10.667,10.667C448,347.229,452.771,352,458.667,352z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Dashboard</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'standardLinks' ? 'active':''}} && {{Request::segment ('2') == 'standardLink' ? 'active':''}}">
        <a href="{{url('/teacher/standardLinks')}}" class="flex items-center whitespace-no-wrap">
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 511.998 511.998" style="enable-background:new 0 0 511.998 511.998;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M386.872,397.626c-2.031-5.158-7.859-7.698-13.02-5.663l-70.492,27.755c-5.159,2.031-7.695,7.86-5.663,13.02    c1.556,3.951,5.339,6.364,9.344,6.364c1.223,0,2.468-0.226,3.675-0.701l70.492-27.755    C386.368,408.615,388.904,402.786,386.872,397.626z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M402.433,381.438c-12.919,0-12.94,20.078,0,20.078C415.352,401.516,415.374,381.438,402.433,381.438z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M478.201,247.628c-0.138-0.66-0.34-1.295-0.6-1.9c0,0-0.001-0.002-0.001-0.003c-0.006-0.013-0.013-0.025-0.019-0.039 c-0.125-0.289-0.263-0.57-0.415-0.844c-0.064-0.117-0.139-0.228-0.208-0.341c-0.097-0.162-0.192-0.324-0.298-0.48 c-0.109-0.161-0.23-0.312-0.347-0.465c-0.077-0.099-0.151-0.203-0.232-0.3c-0.138-0.165-0.284-0.319-0.431-0.474 c-0.075-0.079-0.147-0.161-0.225-0.238c-0.149-0.147-0.304-0.282-0.46-0.419c-0.089-0.078-0.177-0.159-0.269-0.234 c-0.146-0.117-0.296-0.226-0.448-0.334c-0.115-0.083-0.229-0.17-0.347-0.248c-0.133-0.088-0.272-0.168-0.409-0.249 c-0.146-0.086-0.29-0.175-0.44-0.254c-0.12-0.063-0.246-0.118-0.368-0.178c-0.171-0.081-0.341-0.164-0.518-0.236 c-0.12-0.049-0.244-0.089-0.365-0.134c-0.181-0.065-0.36-0.133-0.546-0.189c-0.147-0.044-0.296-0.077-0.445-0.114 c-0.162-0.04-0.321-0.084-0.486-0.117c-0.221-0.044-0.444-0.073-0.668-0.102c-0.095-0.012-0.19-0.031-0.286-0.04    c-1.046-0.105-2.117-0.043-3.177,0.195c-0.616,0.137-1.213,0.326-1.781,0.571l-54.72,23.5 c-23.478-40.073-61.031-68.797-104.573-81.214c29.199-16.986,48.872-48.62,48.872-84.765C353.991,43.955,310.031,0,255.999,0 c-54.028,0-97.982,43.954-97.982,97.982c0,36.145,19.672,67.778,48.868,84.765c-43.537,12.416-81.091,41.139-104.576,81.212 l-54.722-23.498c-0.618-0.266-1.268-0.475-1.943-0.612c-0.673-0.139-1.35-0.204-2.021-0.204c-0.002,0-0.004,0-0.005,0 c-0.329,0-0.656,0.017-0.981,0.049c-0.122,0.012-0.241,0.035-0.362,0.051c-0.199,0.027-0.397,0.052-0.592,0.09 c-0.182,0.035-0.357,0.083-0.535,0.128c-0.133,0.034-0.266,0.063-0.397,0.102c-0.197,0.058-0.388,0.13-0.579,0.2 c-0.111,0.041-0.224,0.077-0.334,0.122c-0.184,0.075-0.361,0.161-0.54,0.246c-0.116,0.055-0.234,0.107-0.348,0.168 c-0.156,0.082-0.305,0.173-0.455,0.262c-0.133,0.079-0.266,0.156-0.396,0.24c-0.122,0.08-0.238,0.168-0.356,0.254 c-0.149,0.107-0.297,0.214-0.441,0.329c-0.093,0.076-0.182,0.158-0.272,0.237c-0.156,0.135-0.31,0.27-0.458,0.416 c-0.078,0.077-0.151,0.16-0.226,0.24c-0.147,0.155-0.292,0.308-0.43,0.472c-0.081,0.097-0.155,0.2-0.232,0.3 c-0.118,0.154-0.238,0.304-0.348,0.465c-0.106,0.155-0.201,0.318-0.298,0.479c-0.069,0.115-0.143,0.224-0.208,0.342 c-0.152,0.274-0.288,0.555-0.415,0.844c-0.006,0.013-0.013,0.025-0.019,0.039c0,0.001-0.001,0.002-0.001,0.002 c-0.26,0.606-0.463,1.242-0.6,1.901c-0.144,0.685-0.213,1.373-0.213,2.057V410.75c0,4.014,2.39,7.641,6.078,9.224l212.378,91.206 c0.348,0.15,0.702,0.274,1.056,0.383c0.059,0.018,0.12,0.029,0.179,0.046c0.377,0.107,0.756,0.189,1.136,0.25 c0.09,0.014,0.181,0.029,0.271,0.041c0.439,0.058,0.877,0.098,1.315,0.098c0.039,0,0.077-0.008,0.117-0.009 c0.385-0.004,0.77-0.035,1.153-0.084c0.128-0.016,0.254-0.036,0.38-0.058c0.344-0.057,0.686-0.132,1.024-0.226 c0.078-0.022,0.158-0.037,0.236-0.061c0.356-0.107,0.709-0.232,1.055-0.38l212.378-91.206c3.687-1.583,6.078-5.21,6.078-9.224 V249.685C478.415,249.001,478.346,248.313,478.201,247.628z M178.093,97.983c0-42.956,34.947-77.904,77.904-77.904 c42.962,0,77.914,34.948,77.914,77.904c0,42.963-34.951,77.914-77.914,77.914C213.04,175.897,178.093,140.946,178.093,97.983z M245.957,486.722l-192.3-82.583V264.92h0.001l48.648,20.89c0.134,0.064,0.27,0.126,0.407,0.186l143.245,61.51V486.722z M255.996,329.964l-135.104-58.013c28.622-47.125,79.447-75.975,135.105-75.975c55.666,0,106.49,28.848,135.103,75.969    L255.996,329.964z M458.336,404.138l-192.3,82.583V347.504l192.3-82.583V404.138z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Classes</span>
        </a>
    </li>

    <!--start-->
    <li class="py-3 px-3 hover:bg-purple-900  {{Request::segment ('2') == 'homeworks' ? 'active':''}} && {{Request::segment ('2') == 'homework' ? 'active':''}}">
        <a href="{{ url('/teacher/homeworks') }}" class="flex  items-center">
        <!--  <img src="{{asset('uploads/icons/sidebar/homework.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px"><g><g><path d="m74.791 114.523c26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.441.561-16.425-6.881-20.067-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.115 8.283 6.507 15.091 14.79 15.207z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m202.593 176.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m202.593 236.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m309.407 116.126c-7.441 3.641-10.521 12.625-6.881 20.067 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 37.64-18.419 75.865-28.024 113.616-28.55 8.283-.115 14.905-6.924 14.789-15.208-.115-8.283-6.876-14.901-15.207-14.79-42.213.589-84.735 11.221-126.383 31.601z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m500.638 7.584c-18.59-4.713-37.148-7.584-60.591-7.584-.016 0-.035 0-.05 0-43.627.009-110.281 11.25-183.997 63.569-73.272-52-139.55-63.382-182.937-63.566-24.136-.104-43.055 2.852-61.7 7.581-6.678 1.67-11.363 7.669-11.363 14.552v294.5c0 4.619 2.128 8.98 5.769 11.823 6.635 5.182 13.606 2.463 13.981 2.448 41.952-10.63 127.258-17.266 227.25 57.729 2.667 2 5.833 3 9 3s6.333-1 9-3c31.188-23.391 63.401-40.556 96-51.235v159.599c0 8.284 6.716 15 15 15h60c8.284 0 15-6.716 15-15v-172.236c21.132 1.097 36.088 4.848 41.675 6.252.277.008 7.061 2.515 13.557-2.557 3.641-2.843 5.769-7.204 5.769-11.823v-294.5c-.001-6.883-4.685-12.882-11.363-14.552zm-470.638 290.414v-263.956c9.661-1.955 24.286-4.124 42.937-4.04 39.466.168 100.214 10.809 168.063 59.726v258.166c-45.801-29.614-93.332-47.095-141.641-52.035-29.797-3.047-53.622-.62-69.359 2.139zm385.485-56.998h-18.969l9.484-29.8zm5.515 241h-30v-211h30zm61-183.931c-8.266-1.429-18.763-2.783-31-3.342v-38.667c.009-1.64-.255-3.321-.813-4.942l-29.894-93.926c-2.22-6.938-9.127-11.275-16.273-10.32-31.752 4.227-63.585 14.069-94.613 29.253-7.441 3.641-10.521 12.625-6.881 20.066 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 20.297-9.932 40.912-17.319 61.544-22.097l-22.324 70.143c-.521 1.513-.806 3.135-.813 4.823v50.053c-30.537 8.934-60.681 22.965-90 41.91v-258.175c68.249-49.206 129.329-59.72 169.004-59.728h.043c18.182 0 32.464 2.124 41.954 4.043z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Home Works</span>
        </a>
    </li>
    <!--end-->

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'assignments' ? 'active':''}} && {{Request::segment ('2') == 'assignment' ? 'active':''}}">
        <a href="{{url('teacher/assignments')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g id="Layer_27" data-name="Layer 27"><path d="m62 29h-24a1 1 0 0 0 -1 1v3.61a12.09 12.09 0 0 0 -6-1.61h-3v-2a10 10 0 0 0 3.83-6h.17a4 4 0 0 0 3-6.62v-3.38a13 13 0 0 0 -26 0v3.38a4 4 0 0 0 3 6.62h.2a10 10 0 0 0 3.8 6v2h-3a12 12 0 0 0 -12 12v18a1 1 0 0 0 1 1h33v-2h-8.15l-2.85-16.84 1.21-2.42 2.3 1.15a1 1 0 0 0 .49.11 1 1 0 0 0 .95-.68l2.76-8.32a10 10 0 0 1 5.29 2v26a1 1 0 0 0 1 1h24a1 1 0 0 0 1-1v-32a1 1 0 0 0 -1-1zm-30-7v-4a2 2 0 0 1 0 4zm-22-2a2 2 0 0 1 2-2v4a2 2 0 0 1 -2-2zm2-4a4.09 4.09 0 0 0 -1 .14v-2.14a11 11 0 0 1 22 0v2.14a4.09 4.09 0 0 0 -1-.14 1 1 0 0 0 -1-1 5 5 0 0 1 -4-2l-1.2-1.6a1 1 0 0 0 -1.6 0l-1.2 1.6a5 5 0 0 1 -4 2h-6a1 1 0 0 0 -1 1zm2 6v-5h5a7 7 0 0 0 5.6-2.8l.4-.53.4.53a7.06 7.06 0 0 0 4.6 2.73v5.07a8 8 0 0 1 -16 0zm8 10a9.92 9.92 0 0 0 4-.84v1.48l-4 4.8-4-4.8v-1.48a9.92 9.92 0 0 0 4 .84zm-5.42 8.59-2.19-6.59h2.14l3.89 4.67zm-13.58 3.41a10 10 0 0 1 9.29-10l2.76 8.28a1 1 0 0 0 .95.72 1 1 0 0 0 .45-.11l2.3-1.15 1.25 2.42-2.85 16.84h-8.15v-14h-2v14h-4zm16.18 17 2.67-16h.3l2.67 16zm3.2-18h-.76l-1.08-2.15 1.46-.73 1.46.73zm5-2.41-3.84-1.92 3.93-4.67h2.14zm17.62-9.59h10v2h-10zm16 30h-22v-30h4v3a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-3h4z"/><path d="m46 37h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 45h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 53h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m49 37h10v2h-10z"/><path d="m49 41h10v2h-10z"/><path d="m49 45h10v2h-10z"/><path d="m49 49h10v2h-10z"/><path d="m49 53h10v2h-10z"/><path d="m49 57h10v2h-10z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Assignment</span>
        </a>
    </li>
   @if(config('gvideoroom.enabled', false))
    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'video-conference' ? 'active':''}}">
        <a href="{{url('teacher/video-conference')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="_x31_" enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg"><g><g id="XMLID_1_"><path d="m16 15.5v4c0-.3-.2-.5-.5-.5h-.5v-3.5c0-.3.2-.5.5-.5s.5.2.5.5z"/><path d="m15.5 19c.3 0 .5.2.5.5s-.2.5-.5.5h-.5v-1z"/><path d="m15 19v1h-3.5c.3 0 .5-.2.5-.5v-.5z"/><path d="m23 11.4v-4.8l-2.2 1.8c-.1.1-.4.1-.5.1-.2-.1-.3-.3-.3-.5v-1.5c0-.3-.2-.5-.5-.5h-6c-.3 0-.5.2-.5.5v5c0 .3.2.5.5.5h6c.3 0 .5-.2.5-.5v-1.5c0-.2.1-.4.3-.4.2-.1.4-.1.5.1zm-2 .1c0 .8-.7 1.5-1.5 1.5h-4-2c-.8 0-1.5-.7-1.5-1.5v-5c0-.8.7-1.5 1.5-1.5h2 4c.8 0 1.5.7 1.5 1.5v.4l2.2-1.8c.1-.1.3-.1.5 0 .2 0 .3.2.3.4v7c0 .2-.1.4-.3.4-.1 0-.1.1-.2.1s-.2 0-.3-.1l-2.2-1.8z"/><path d="m11 19.5v-.5h1v.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5z"/><path d="m11.5 20h-7c.3 0 .5-.2.5-.5v-.5h6v.5c0 .3.2.5.5.5z"/><path d="m6 13c0-1.1.9-2 2-2s2 .9 2 2-.9 2-2 2-2-.9-2-2zm3 0c0-.6-.4-1-1-1s-1 .4-1 1 .4 1 1 1 1-.4 1-1z"/><path d="m5 19v.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-.5z"/><path d="m4 18.5c0-1.4 1.1-2.5 2.5-2.5h3c1.4 0 2.5 1.1 2.5 2.5v.5h-1v-.5c0-.8-.7-1.5-1.5-1.5h-3c-.8 0-1.5.7-1.5 1.5v.5h-1z"/><path d="m1 20v-1h3v.5c0 .3.2.5.5.5z"/><path d="m1 19v1h-.5c-.3 0-.5-.2-.5-.5s.2-.5.5-.5z"/><path d="m0 2.5c0-1.4 1.1-2.5 2.5-2.5h11c1.4 0 2.5 1.1 2.5 2.5 0 .3-.2.5-.5.5s-.5-.2-.5-.5c0-.8-.7-1.5-1.5-1.5h-11c-.8 0-1.5.7-1.5 1.5v16.5h-.5c-.3 0-.5.2-.5.5z"/><path d="m15 20h.5c.3 0 .5-.2.5-.5v2c0 1.4-1.1 2.5-2.5 2.5h-11c-1.4 0-2.5-1.1-2.5-2.5v-2c0 .3.2.5.5.5h.5v1.5c0 .8.7 1.5 1.5 1.5h11c.8 0 1.5-.7 1.5-1.5z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Video Room</span>
        </a>
    </li>
    @endif
    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'events' ? 'active':''}}">
        <a href="{{url('teacher/events')}}" class="flex items-center">
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 0 480 480" width="512px"><g><path d="m399.832031 54.398438c-.0625-.277344-.230469-.496094-.3125-.757813-.136719-.449219-.316406-.882813-.535156-1.296875-.25-.476562-.550781-.921875-.894531-1.335938-.277344-.34375-.582032-.664062-.914063-.960937-.402343-.339844-.84375-.632813-1.3125-.878906-.394531-.238281-.8125-.441407-1.246093-.609375-.519532-.164063-1.058594-.273438-1.601563-.328125-.332031-.097657-.671875-.175781-1.015625-.230469h-40.335938c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-40.335938c-4.417969 0-8 3.582031-8 8v416c0 4.417969 3.582031 8 8 8h384c4.417969 0 8-3.582031 8-8v-24h72c2.402344 0 4.675781-1.082031 6.191406-2.941406 1.519532-1.863282 2.121094-4.304688 1.640625-6.660156zm-79.832031-38.398438c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-64 48h32.335938c2.0625 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h79.617188v80h-368zm368 400h-368v-304h368zm16-32v-298.398438l62.167969 298.398438zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Calendar</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'notices' ? 'active':''}} || {{Request::segment ('2') == 'notice' ? 'active':''}} ">
        <a href="{{ url('/teacher/notices') }}" class="flex items-center">
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Layer_3" enable-background="new 0 0 64 64" height="512px" viewBox="0 0 64 64" width="512px"><g><path d="m21 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m35 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 51h26c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1zm1-4h24v2h-24z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 53h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 57h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m62 9c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-12v-1c0-.553-.447-1-1-1h-34c-.553 0-1 .447-1 1v1h-12c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h1v46h-1c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h12v1c0 .553.447 1 1 1h34c.553 0 1-.447 1-1v-1h12c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-1v-46zm-59-4h11v2h-11zm11 4v46h-5v-46zm-9 0h2v46h-2zm-2 50v-2h11v2zm45 2h-32v-58h32zm13-56v2h-11v-2zm-11 50v-46h5v46zm11 4h-11v-2h11zm-2-4h-2v-46h2z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 31h26c.553 0 1-.447 1-1v-24c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v24c0 .553.447 1 1 1zm10-17c0-1.654 1.346-3 3-3s3 1.346 3 3-1.346 3-3 3-3-1.346-3-3zm8 15h-10v-5c0-2.757 2.243-5 5-5s5 2.243 5 5zm-17-22h24v22h-5v-5c0-2.698-1.537-5.04-3.779-6.208 1.079-.918 1.779-2.268 1.779-3.792 0-2.757-2.243-5-5-5s-5 2.243-5 5c0 1.524.7 2.874 1.779 3.792-2.242 1.168-3.779 3.51-3.779 6.208v5h-5z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Notice Board</span>
        </a>
    </li>
    @if(config('gchat.enabled', false))
    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'chats' ? 'active':''}} && {{Request::segment ('2') == 'chat' ? 'active':''}}">
        <a href="{{url('teacher/chats')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 417.986 417.986" style="enable-background:new 0 0 417.986 417.986;" xml:space="preserve"><g><g><g><path d="M371.514,19.619c-1.062-0.035-2.125-0.035-3.188,0H126.433c-28.735,0-53.29,20.898-53.29,49.633v117.551H28.735 C11.494,186.802,0,202.476,0,219.716v97.176c0,17.241,11.494,31.869,28.735,31.869h23.51l9.404,41.796 c0.909,3.707,3.679,6.674,7.314,7.837h3.135c2.756-0.039,5.385-1.166,7.314-3.135l42.841-46.498h64.784 c17.575-0.27,31.836-14.301,32.392-31.869V265.17h7.837l71.575,77.845c1.698,2.336,4.427,3.7,7.314,3.657h3.135 c3.559-0.976,6.339-3.756,7.314-7.314l16.718-74.188h35.004c28.735,0,49.633-24.555,49.633-53.29V69.251 C418.839,42.72,398.045,20.499,371.514,19.619z M198.531,316.892c-0.521,6.03-5.446,10.731-11.494,10.971h-69.486 c-2.756,0.039-5.385,1.166-7.314,3.135l-32.914,35.526L70.531,335.7c-1.22-4.735-5.561-7.991-10.449-7.837H28.735 c-5.747,0-7.837-5.224-7.837-10.971v-97.176c0-5.747,2.09-12.016,7.837-12.016h44.408v4.18 c0.556,29.198,24.092,52.734,53.29,53.29h72.098V316.892z M397.061,69.251V211.88c0,17.241-11.494,32.392-28.735,32.392h-43.363 c-4.834-0.335-9.131,3.057-9.927,7.837l-14.106,62.171l-61.649-66.873c-1.929-1.969-4.558-3.095-7.314-3.135H126.433 c-17.659-0.544-31.848-14.732-32.392-32.392V69.251c0-17.241,15.151-28.735,32.392-28.735h241.894 c14.978-0.892,27.843,10.526,28.735,25.504C397.125,67.096,397.125,68.175,397.061,69.251z"/><path d="M140.539,118.884h125.388c5.771,0,10.449-4.678,10.449-10.449s-4.678-10.449-10.449-10.449H140.539 c-5.771,0-10.449,4.678-10.449,10.449S134.768,118.884,140.539,118.884z"/><path d="M349.518,160.68h-208.98c-5.771,0-10.449,4.678-10.449,10.449s4.678,10.449,10.449,10.449h208.98 c5.771,0,10.449-4.678,10.449-10.449S355.289,160.68,349.518,160.68z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Chat Room</span>
        </a>
    </li>
    @endif

    <!-- <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'privatechatroom' ? 'active':''}}">
        <a href="{{url('teacher/conversations')}}" class="flex items-center">
            <svg id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 fill-current text-white"><g><path d="m80 282c-8.284 0-15 6.716-15 15s6.716 15 15 15h250c8.284 0 15-6.716 15-15s-6.716-15-15-15z"></path><path d="m330 352h-250c-8.284 0-15 6.716-15 15s6.716 15 15 15h250c8.284 0 15-6.716 15-15s-6.716-15-15-15z"></path><path d="m497 100h-5v-25c0-41.355-33.645-75-75-75s-75 33.645-75 75v25h-5c-8.284 0-15 6.716-15 15v27h-307c-8.284 0-15 6.716-15 15v340c0 6.067 3.655 11.537 9.26 13.858 1.856.769 3.805 1.142 5.737 1.142 3.904 0 7.741-1.524 10.61-4.394l55.607-55.606h313.786c8.284 0 15-6.716 15-15v-167h87c8.284 0 15-6.716 15-15v-140c0-8.284-6.716-15-15-15zm-125-25c0-24.813 20.187-45 45-45s45 20.187 45 45v25h-90zm8 347h-305c-3.978 0-7.793 1.581-10.606 4.394l-34.394 34.393v-288.787h292v40h-242c-8.284 0-15 6.716-15 15s6.716 15 15 15h242v13c0 8.284 6.716 15 15 15h43zm102-182h-130v-110h130z"></path><path d="m402 180v25c0 8.284 6.716 15 15 15s15-6.716 15-15v-25c8.284 0 15-6.716 15-15s-6.716-15-15-15h-30c-8.284 0-15 6.716-15 15s6.716 15 15 15z"></path></g></svg>
            <span class="mx-3 whitespace-no-wrap">Private Chat Room</span>
        </a>
    </li> -->
    
    <!--start-->
    @php
        $class='';
        $array=array('visitorlog','calllog','postalrecord');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3 hover:bg-purple-900 {{$class}}">
        <a href="#" class="flex items-center">
            <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" class="w-5 h-5 fill-current text-white"><g><g><g><path d="M412,120c33.084,0,60-26.916,60-60S445.084,0,412,0c-33.084,0-60,26.916-60,60S378.916,120,412,120z M412,40 c11.028,0,20,8.972,20,20s-8.972,20-20,20s-20-8.972-20-20S400.972,40,412,40z"></path> <path d="M292,472H40V327h212c11.046,0,20-8.954,20-20c0-11.046-8.954-20-20-20H76v-83c0-11.028,8.972-20,20-20h80 c11.028,0,20,8.972,20,20v23c0,11.046,8.954,20,20,20s20-8.954,20-20v-23c0-33.084-26.916-60-60-60H96c-33.084,0-60,26.916-60,60 v83H20c-11.046,0-20,8.954-20,20v205h292c11.046,0,20-8.954,20-20C312,480.954,303.046,472,292,472z"></path><path d="M141,121c33.084,0,60-26.916,60-60S174.084,1,141,1S81,27.916,81,61S107.916,121,141,121z M141,41 c11.028,0,20,8.972,20,20s-8.972,20-20,20s-20-8.972-20-20S129.972,41,141,41z"></path> <path d="M452,139h-80c-33.084,0-60,26.916-60,60v109c0,26.075,16.719,48.319,40,56.573V492c0,11.046,8.954,20,20,20 c11.046,0,20-8.954,20-20V348c0-11.046-8.954-20-20-20c-11.028,0-20-8.972-20-20V199c0-11.028,8.972-20,20-20h80 c11.028,0,20,8.972,20,20v109c0,11.028-8.972,20-20,20c-11.046,0-20,8.954-20,20v144c0,11.046,8.954,20,20,20 c11.046,0,20-8.954,20-20V364.573c23.281-8.255,40-30.498,40-56.573V199C512,165.916,485.084,139,452,139z"></path></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Reception <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar">
            <li class="py-3 px-3 hover:font-semibold hover:bg-purple-900 {{Request::segment ('2') == 'visitorlog' ? 'active':''}}">
                <a href="{{url('/admin/visitorlog')}}">
                <a href="{{ url('/teacher/visitorlog') }}" class="flex items-center whitespace-no-wrap">
                    <svg id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 fill-current text-white"><g><circle cx="502" cy="255.86" r="10"></circle><path d="m508.07 111.54c-2.52-5.96-6.12-11.3-10.72-15.89-4.59-4.6-9.93-8.2-15.89-10.72-6.16-2.61-12.71-3.93-19.46-3.93h-412c-6.75 0-13.3 1.32-19.46 3.93-5.96 2.52-11.3 6.12-15.89 10.72-4.6 4.59-8.2 9.93-10.72 15.89-2.61 6.16-3.93 12.71-3.93 19.46v250c0 6.75 1.32 13.3 3.93 19.46 2.52 5.96 6.12 11.3 10.72 15.89 4.59 4.6 9.93 8.2 15.89 10.72 6.16 2.61 12.71 3.93 19.46 3.93h412c6.75 0 13.3-1.32 19.46-3.93 5.96-2.52 11.3-6.12 15.89-10.72 4.6-4.59 8.2-9.93 10.72-15.89 2.61-6.16 3.93-12.71 3.93-19.46v-80.14c0-5.52-4.49-10-10-10s-10 4.48-10 10v14.14h-472v-184c.03-16.51 13.49-29.97 30-30h412c16.51.03 29.97 13.49 30 30v79.86c0 5.51 4.49 10 10 10s10-4.49 10-10v-79.86c0-6.75-1.32-13.3-3.93-19.46zm-46.07 299.46h-412c-15.154-.028-27.729-11.371-29.718-26h471.435c-1.989 14.629-14.564 25.972-29.717 26zm30-76v30h-472v-30z"></path><path d="m60 150c-5.523 0-10 4.477-10 10v100c0 5.523 4.477 10 10 10h100c5.523 0 10-4.477 10-10v-100c0-5.523-4.477-10-10-10zm90 100h-80v-80h80z"></path><path d="m210 245h200c5.523 0 10-4.477 10-10s-4.477-10-10-10h-200c-5.523 0-10 4.477-10 10s4.477 10 10 10z"></path><path d="m350 195c5.523 0 10-4.477 10-10s-4.477-10-10-10h-47c-5.523 0-10 4.477-10 10s4.477 10 10 10z"></path><path d="m210 195h48c5.523 0 10-4.477 10-10s-4.477-10-10-10h-48c-5.523 0-10 4.477-10 10s4.477 10 10 10z"></path></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Visitor Log</span>
                </a>
            </li> 
            <li class="py-3 px-2 hover:font-semibold hover:bg-purple-900 {{Request::segment ('2') == 'calllog' ? 'active':''}}"> 
                <a href="{{ url('admin/calllog') }}"> 
                <a href="{{ url('teacher/calllog') }}" class="flex items-center">
                    <svg id="Layer_1" enable-background="new 0 0 512.021 512.021" height="512" viewBox="0 0 512.021 512.021" width="512" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 fill-current text-white"><g><path d="m367.988 512.021c-16.528 0-32.916-2.922-48.941-8.744-70.598-25.646-136.128-67.416-189.508-120.795s-95.15-118.91-120.795-189.508c-8.241-22.688-10.673-46.108-7.226-69.612 3.229-22.016 11.757-43.389 24.663-61.809 12.963-18.501 30.245-33.889 49.977-44.5 21.042-11.315 44.009-17.053 68.265-17.053 7.544 0 14.064 5.271 15.645 12.647l25.114 117.199c1.137 5.307-.494 10.829-4.331 14.667l-42.913 42.912c40.482 80.486 106.17 146.174 186.656 186.656l42.912-42.913c3.837-3.837 9.36-5.466 14.667-4.331l117.199 25.114c7.377 1.581 12.647 8.101 12.647 15.645 0 24.256-5.738 47.224-17.054 68.266-10.611 19.732-25.999 37.014-44.5 49.977-18.419 12.906-39.792 21.434-61.809 24.663-6.899 1.013-13.797 1.518-20.668 1.519zm-236.349-479.321c-31.995 3.532-60.393 20.302-79.251 47.217-21.206 30.265-26.151 67.49-13.567 102.132 49.304 135.726 155.425 241.847 291.151 291.151 34.641 12.584 71.867 7.64 102.132-13.567 26.915-18.858 43.685-47.256 47.217-79.251l-95.341-20.43-44.816 44.816c-4.769 4.769-12.015 6.036-18.117 3.168-95.19-44.72-172.242-121.772-216.962-216.962-2.867-6.103-1.601-13.349 3.168-18.117l44.816-44.816z"></path><path d="m496.02 272c-8.836 0-16-7.164-16-16 0-123.514-100.486-224-224-224-8.836 0-16-7.164-16-16s7.164-16 16-16c68.381 0 132.668 26.628 181.02 74.98s74.98 112.639 74.98 181.02c0 8.836-7.163 16-16 16z"></path><path d="m432.02 272c-8.836 0-16-7.164-16-16 0-88.224-71.776-160-160-160-8.836 0-16-7.164-16-16s7.164-16 16-16c105.869 0 192 86.131 192 192 0 8.836-7.163 16-16 16z"></path><path d="m368.02 272c-8.836 0-16-7.164-16-16 0-52.935-43.065-96-96-96-8.836 0-16-7.164-16-16s7.164-16 16-16c70.58 0 128 57.42 128 128 0 8.836-7.163 16-16 16z"></path></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Call Log</span>
                </a> 
            </li>

            <li class="py-3 px-2 hover:font-semibold hover:bg-purple-900 {{Request::segment ('2') == 'postalrecord' ? 'active':''}}"> 
                <a href="{{ url('admin/postalrecord') }}"> 
                <a href="{{ url('teacher/postalrecord') }}" class="flex items-center">
                    <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 470.161 470.161" xml:space="preserve" class="w-5 h-5 fill-current text-white"><g><path d="M463.247,55.313H6.914c-2.773,0-5.282,1.66-6.368,4.218C0.173,60.409-0.007,61.35,0,62.276v345.658 c0,0.007,0,0.014,0,0.021c0,0.926,0.187,1.811,0.518,2.613c0.339,0.823,0.836,1.583,1.507,2.254 c0.671,0.67,1.431,1.168,2.254,1.507c0.802,0.332,1.688,0.519,2.614,0.519c0.007,0,0.014,0,0.021,0h456.333 c0.968,0,1.881-0.193,2.708-0.552c0.768-0.324,1.487-0.795,2.116-1.41c0.021-0.021,0.014-0.014,0.014-0.014 c0.007-0.007,0.014-0.007,0.014-0.014c0,0,0,0,0.007,0c0-0.028,0.007-0.021,0.014-0.021c0.007,0,0.007-0.007,0.014-0.014 c0.007-0.007,0.014-0.007,0.014-0.014c0,0,0.007,0,0.007-0.007l0.014-0.014c0.007-0.007,0.007-0.007,0.014-0.014 c0,0,0,0,0.007-0.007c0.643-0.65,1.12-1.397,1.452-2.192c0.339-0.816,0.519-1.708,0.519-2.641V62.227 C470.161,58.404,467.071,55.313,463.247,55.313z M446.902,69.141L287.988,232.84l-0.007,0.007l-52.928,54.566l-53.336-54.165 L23.204,69.141H446.902z M13.828,79.34l153.245,158.659L13.828,391.244V79.34z M23.605,401.02l153.12-153.127l53.432,54.262 c1.307,1.327,3.077,2.067,4.93,2.067c0.007,0,0.021,0,0.028,0c1.86-0.007,3.637-0.768,4.937-2.102l52.976-54.608L446.556,401.02 H23.605z M456.333,391.244l-153.674-153.66L456.333,79.278V391.244z"></path></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Postal Record</span>
                </a> 
            </li>
        </ul>
    </li>
    <!--end-->

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'leaves' ? 'active':''}} && {{Request::segment ('2') == 'leave' ? 'active':''}}">
        <a href="{{ url('teacher/leaves') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m205.182 143.679h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m366.03 0h-351.03c-8.284 0-15 6.716-15 15v482c0 8.284 6.716 15 15 15h351.03c8.284 0 15-6.716 15-15v-482c0-8.284-6.716-15-15-15zm-15 482h-321.03v-452h321.03z"/><path d="m512 363.502v-312.591c0-28.072-22.839-50.911-50.911-50.911-28.073 0-50.912 22.839-50.912 50.911v312.59c0 7.826 5.996 14.245 13.643 14.931l-12.748 35.22c-1.34 3.703-1.171 7.784.472 11.362l35.912 78.242c2.445 5.328 7.771 8.743 13.633 8.743s11.188-3.415 13.633-8.743l35.911-78.242c1.643-3.579 1.812-7.66.472-11.362l-12.748-35.22c7.647-.686 13.643-7.104 13.643-14.93zm-71.823-15v-223.596h41.823v223.595h-41.823zm20.912-318.502c11.53 0 20.911 9.381 20.911 20.911v43.995h-41.823v-43.995c0-11.53 9.381-20.911 20.912-20.911zm0 431.041-19.716-42.956 14.327-39.584h10.777l14.328 39.584z"/><path d="m90.701 157.197c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.563c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-34.956 34.956-10.866-10.868c-5.856-5.858-15.354-5.858-21.213 0-5.858 5.858-5.858 15.355 0 21.213z"/><path d="m205.182 234.684h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m90.701 248.201c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.563c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-34.956 34.956-10.866-10.866c-5.856-5.858-15.354-5.858-21.213 0-5.858 5.858-5.858 15.355 0 21.213z"/><path d="m205.182 325.688h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m205.182 420.178h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m90.701 339.206c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.562c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.857-21.213 0l-34.956 34.956-10.866-10.868c-5.856-5.858-15.354-5.858-21.213 0s-5.858 15.355 0 21.213z"/></g></svg>
            @if(Auth::user()->hasRole('leave_checker'))
                <span class="mx-2 whitespace-no-wrap">Leave Approvals <pending-count></pending-count></span>
            @else
                <span class="mx-3 whitespace-no-wrap">Leaves</span>
            @endif
        </a>
    </li>
  
    @if(Auth::user()->hasRole('leave_checker'))
        <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'myleaves' ? 'active':''}}">
            <a href="{{ url('teacher/myleaves') }}" class="flex items-center">
                <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m205.182 143.679h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m366.03 0h-351.03c-8.284 0-15 6.716-15 15v482c0 8.284 6.716 15 15 15h351.03c8.284 0 15-6.716 15-15v-482c0-8.284-6.716-15-15-15zm-15 482h-321.03v-452h321.03z"/><path d="m512 363.502v-312.591c0-28.072-22.839-50.911-50.911-50.911-28.073 0-50.912 22.839-50.912 50.911v312.59c0 7.826 5.996 14.245 13.643 14.931l-12.748 35.22c-1.34 3.703-1.171 7.784.472 11.362l35.912 78.242c2.445 5.328 7.771 8.743 13.633 8.743s11.188-3.415 13.633-8.743l35.911-78.242c1.643-3.579 1.812-7.66.472-11.362l-12.748-35.22c7.647-.686 13.643-7.104 13.643-14.93zm-71.823-15v-223.596h41.823v223.595h-41.823zm20.912-318.502c11.53 0 20.911 9.381 20.911 20.911v43.995h-41.823v-43.995c0-11.53 9.381-20.911 20.912-20.911zm0 431.041-19.716-42.956 14.327-39.584h10.777l14.328 39.584z"/><path d="m90.701 157.197c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.563c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-34.956 34.956-10.866-10.868c-5.856-5.858-15.354-5.858-21.213 0-5.858 5.858-5.858 15.355 0 21.213z"/><path d="m205.182 234.684h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m90.701 248.201c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.563c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-34.956 34.956-10.866-10.866c-5.856-5.858-15.354-5.858-21.213 0-5.858 5.858-5.858 15.355 0 21.213z"/><path d="m205.182 325.688h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m205.182 420.178h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m90.701 339.206c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.562c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.857-21.213 0l-34.956 34.956-10.866-10.868c-5.856-5.858-15.354-5.858-21.213 0s-5.858 15.355 0 21.213z"/></g></svg>
                <span class="mx-3 whitespace-no-wrap">My Leaves</span>
            </a>
        </li>
    @endif

    @if(Auth::user()->hasRole('student_leave_checker'))
        <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'studentLeaves' ? 'active':''}} && {{Request::segment ('2') == 'studentLeave' ? 'active':''}}">
            <a href="{{url('teacher/studentLeaves')}}" class="flex items-center">
                <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m205.182 143.679h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m366.03 0h-351.03c-8.284 0-15 6.716-15 15v482c0 8.284 6.716 15 15 15h351.03c8.284 0 15-6.716 15-15v-482c0-8.284-6.716-15-15-15zm-15 482h-321.03v-452h321.03z"/><path d="m512 363.502v-312.591c0-28.072-22.839-50.911-50.911-50.911-28.073 0-50.912 22.839-50.912 50.911v312.59c0 7.826 5.996 14.245 13.643 14.931l-12.748 35.22c-1.34 3.703-1.171 7.784.472 11.362l35.912 78.242c2.445 5.328 7.771 8.743 13.633 8.743s11.188-3.415 13.633-8.743l35.911-78.242c1.643-3.579 1.812-7.66.472-11.362l-12.748-35.22c7.647-.686 13.643-7.104 13.643-14.93zm-71.823-15v-223.596h41.823v223.595h-41.823zm20.912-318.502c11.53 0 20.911 9.381 20.911 20.911v43.995h-41.823v-43.995c0-11.53 9.381-20.911 20.912-20.911zm0 431.041-19.716-42.956 14.327-39.584h10.777l14.328 39.584z"/><path d="m90.701 157.197c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.563c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-34.956 34.956-10.866-10.868c-5.856-5.858-15.354-5.858-21.213 0-5.858 5.858-5.858 15.355 0 21.213z"/><path d="m205.182 234.684h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m90.701 248.201c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.563c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-34.956 34.956-10.866-10.866c-5.856-5.858-15.354-5.858-21.213 0-5.858 5.858-5.858 15.355 0 21.213z"/><path d="m205.182 325.688h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m205.182 420.178h95.259c8.284 0 15-6.716 15-15s-6.716-15-15-15h-95.259c-8.284 0-15 6.716-15 15s6.715 15 15 15z"/><path d="m90.701 339.206c2.813 2.813 6.628 4.394 10.606 4.394s7.794-1.581 10.606-4.393l45.563-45.562c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.857-21.213 0l-34.956 34.956-10.866-10.868c-5.856-5.858-15.354-5.858-21.213 0s-5.858 15.355 0 21.213z"/></g></svg>
                <span class="mx-3 whitespace-no-wrap">Student Leaves</span>
            </a>
        </li>
    @endif

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'holidays' ? 'active':''}} && {{Request::segment ('2') == 'holiday' ? 'active':''}}">
        <a href="{{ url('/teacher/holidays') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g id="XMLID_2374_"><g id="XMLID_707_"><g id="XMLID_708_"><path id="XMLID_713_" d="m482 108h-14v-14c0-16.542-13.458-30-30-30h-24v-12c0-17.645-14.355-32-32-32s-32 14.355-32 32v12h-84v-12c0-17.645-14.355-32-32-32s-32 14.355-32 32v12h-84v-12c0-17.645-14.355-32-32-32s-32 14.355-32 32v12h-24c-16.542 0-30 13.458-30 30v324c0 16.542 13.458 30 30 30h14v14c0 16.542 13.458 30 30 30h408c16.542 0 30-13.458 30-30v-324c0-16.542-13.458-30-30-30zm-112-56c0-6.617 5.383-12 12-12s12 5.383 12 12v44c0 6.617-5.383 12-12 12s-12-5.383-12-12zm-148 0c0-6.617 5.383-12 12-12s12 5.383 12 12v44c0 6.617-5.383 12-12 12s-12-5.383-12-12zm-148 0c0-6.617 5.383-12 12-12s12 5.383 12 12v44c0 6.617-5.383 12-12 12s-12-5.383-12-12zm-44 32h24v12c0 17.645 14.355 32 32 32s32-14.355 32-32v-12h84v12c0 17.645 14.355 32 32 32s32-14.355 32-32v-12h84v12c0 17.645 14.355 32 32 32s32-14.355 32-32v-12h24c5.514 0 10 4.486 10 10v90h-428v-90c0-5.514 4.486-10 10-10zm462 378c0 5.514-4.486 10-10 10h-408c-5.514 0-10-4.486-10-10v-14h125c5.523 0 10-4.478 10-10s-4.477-10-10-10h-159c-5.514 0-10-4.486-10-10v-214h428v214c0 5.514-4.486 10-10 10h-159c-5.523 0-10 4.478-10 10s4.477 10 10 10h159c16.542 0 30-13.458 30-30v-290h14c5.514 0 10 4.486 10 10z"/><path id="XMLID_710_" d="m271.214 389.279c1.463.769 3.06 1.148 4.652 1.148 2.073 0 4.137-.645 5.879-1.91 3.08-2.237 4.622-6.028 3.978-9.78l-7.107-41.439 30.107-29.347c2.726-2.657 3.707-6.631 2.531-10.251s-4.306-6.259-8.073-6.807l-41.607-6.045-18.607-37.703c-1.685-3.413-5.161-5.574-8.967-5.574-3.807 0-7.283 2.161-8.967 5.574l-18.607 37.703-41.607 6.045c-3.767.548-6.896 3.187-8.073 6.807-1.176 3.62-.195 7.594 2.531 10.251l30.107 29.347-7.107 41.439c-.644 3.752.898 7.543 3.978 9.78s7.163 2.532 10.531.762l37.214-19.565zm-65.8-27.132 4.571-26.65c.557-3.244-.519-6.554-2.876-8.851l-19.362-18.873 26.758-3.888c3.257-.474 6.073-2.52 7.529-5.471l11.966-24.246 11.966 24.247c1.457 2.951 4.272 4.997 7.529 5.471l26.758 3.888-19.362 18.873c-2.357 2.298-3.433 5.607-2.876 8.851l4.571 26.65-23.933-12.583c-1.456-.766-3.055-1.149-4.653-1.149-1.599 0-3.197.383-4.653 1.149z"/><path id="XMLID_709_" d="m234 428c-2.63 0-5.21 1.069-7.07 2.93-1.86 1.86-2.93 4.44-2.93 7.07s1.07 5.21 2.93 7.069c1.86 1.86 4.44 2.931 7.07 2.931s5.21-1.07 7.07-2.931c1.86-1.859 2.93-4.439 2.93-7.069s-1.07-5.21-2.93-7.07c-1.86-1.861-4.44-2.93-7.07-2.93z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Holiday</span>
        </a>
    </li>
@if(config('gquiz.enabled', false))
    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'quiz' ? 'active':''}} && {{Request::segment ('2') == 'quiz' ? 'active':''}}">
        <a href="{{ url('teacher/quiz') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512" height="512"><g id="XMLID_1203_"><g id="XMLID_1116_"><g id="XMLID_386_"><path id="XMLID_387_" d="M171.759,128h14.518c5.522,0,10-4.477,10-10s-4.478-10-10-10h-14.518c-1.266,0-2.296-1.03-2.296-2.296 V96h12.993c5.522,0,10-4.477,10-10s-4.478-10-10-10h-12.993v-9.704c0-1.266,1.03-2.296,2.296-2.296h14.518     c5.522,0,10-4.477,10-10s-4.478-10-10-10h-14.518c-12.294,0-22.296,10.002-22.296,22.296v39.408     C149.463,117.998,159.465,128,171.759,128z"/><path id="XMLID_388_" d="M239.254,108h-17.167c-5.522,0-10,4.477-10,10s4.478,10,10,10h17.167c14.337,0,26-11.664,26-26 s-11.663-26-26-26h-1.167c-3.309,0-6-2.691-6-6s2.691-6,6-6h11.512c5.522,0,10-4.477,10-10s-4.478-10-10-10h-11.512     c-14.337,0-26,11.664-26,26s11.663,26,26,26h1.167c3.309,0,6,2.691,6,6S242.563,108,239.254,108z"/><path id="XMLID_389_" d="M129.254,44h-33c-5.522,0-10,4.477-10,10s4.478,10,10,10h6.5v54c0,5.523,4.478,10,10,10s10-4.477,10-10 V64h6.5c5.522,0,10-4.477,10-10S134.777,44,129.254,44z"/><path id="XMLID_390_" d="M288.754,64h6.5v54c0,5.523,4.478,10,10,10s10-4.477,10-10V64h6.5c5.522,0,10-4.477,10-10     s-4.478-10-10-10h-33c-5.522,0-10,4.477-10,10S283.232,64,288.754,64z"/><path id="XMLID_895_" d="M120.462,168h-40c-5.522,0-10,4.477-10,10v40c0,5.523,4.478,10,10,10h40c5.522,0,10-4.477,10-10v-40     C130.462,172.477,125.985,168,120.462,168z M110.462,208h-20v-20h20V208z"/><path id="XMLID_896_" d="M323.626,218c0,2.63,1.069,5.21,2.93,7.07s4.44,2.93,7.07,2.93s5.21-1.07,7.069-2.93 c1.87-1.86,2.931-4.44,2.931-7.07c0-2.63-1.061-5.21-2.931-7.07c-1.859-1.86-4.43-2.93-7.069-2.93c-2.63,0-5.21,1.07-7.07,2.93 C324.695,212.79,323.626,215.37,323.626,218z"/><path id="XMLID_897_" d="M293.629,208h-133.5c-5.522,0-10,4.477-10,10s4.478,10,10,10h133.5c5.522,0,10-4.477,10-10     S299.152,208,293.629,208z"/><path id="XMLID_941_" d="M120.462,272h-40c-5.522,0-10,4.477-10,10v40c0,5.523,4.478,10,10,10h40c5.522,0,10-4.477,10-10v-40 C130.462,276.477,125.985,272,120.462,272z M110.462,312h-20v-20h20V312z"/><path id="XMLID_982_" d="M120.462,376h-40c-5.522,0-10,4.477-10,10v40c0,5.523,4.478,10,10,10h40c5.522,0,10-4.477,10-10v-40     C130.462,380.477,125.985,376,120.462,376z M110.462,416h-20v-20h20V416z"/><path id="XMLID_983_" d="M246.004,416h-85.875c-5.522,0-10,4.477-10,10s4.478,10,10,10h85.875c5.522,0,10-4.477,10-10     S251.527,416,246.004,416z"/><path id="XMLID_1111_" d="M486.004,79.59c-8.791-5.076-19.033-6.423-28.836-3.796c-9.805,2.627-17.999,8.915-23.073,17.706 l-9.625,16.67l0,0.001l0,0.001l-13.465,23.323V34c0-18.748-15.252-34-34-34h-336c-18.748,0-34,15.252-34,34v444 c0,18.748,15.252,34,34,34h336c18.748,0,34-15.252,34-34V287c0-0.454-0.041-0.897-0.1-1.335l79.383-137.495l9.625-16.671 C510.389,113.353,504.15,90.067,486.004,79.59z M462.345,95.112c4.644-1.246,9.495-0.606,13.659,1.798 c8.596,4.963,11.551,15.993,6.588,24.589l-4.625,8.011l-31.177-18l4.625-8.011C453.82,99.335,457.7,96.356,462.345,95.112z      M340.627,367.39l-31.177-18l127.34-220.56l31.177,18L340.627,367.39z M303.717,369.173l22.644,13.074l-27.213,20.988 L303.717,369.173z M391.004,478c0,7.72-6.28,14-14,14h-336c-7.72,0-14-6.28-14-14V34c0-7.72,6.28-14,14-14h336 c7.72,0,14,6.28,14,14v134c0,0.042,0.006,0.082,0.006,0.123L307.944,312H160.129c-5.522,0-10,4.477-10,10s4.478,10,10,10h136.268 l-9.267,16.05c-0.652,1.13-1.077,2.377-1.251,3.67l-9.786,72.95c-0.539,4.018,1.4,7.963,4.911,9.99 c1.554,0.897,3.279,1.34,4.999,1.34c2.164,0,4.319-0.702,6.108-2.082l58.283-44.95c1.033-0.797,1.9-1.789,2.553-2.918 l38.057-65.916V478z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Online Assessment</span>
        </a>
    </li>
    @endif

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'lessonplan' ? 'active':''}} && {{Request::segment ('2') == 'lessonplans' ? 'active':''}}">
        <a href="{{ url('teacher/lessonplans') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="511pt" viewBox="0 -48 511.99864 511" width="511pt" xmlns="http://www.w3.org/2000/svg"><path d="m24.859375 312.96875c3.820313 1.910156 7.933594 3.230469 12.175781 3.96875l-6.609375 9.4375c-1.335937 1.910156-2.207031 4.101562-2.550781 6.402344l-9.839844 66.359375c-.832031 5.621093 1.578125 11.230469 6.234375 14.488281 4.660157 3.261719 10.753907 3.605469 15.746094.902344l55.574219-30.09375c7.675781 13.867187 22.457031 23.28125 39.398437 23.28125 11.515625 0 22.035157-4.347656 30-11.484375 7.96875 7.136719 18.488281 11.484375 30 11.484375 24.816407 0 45.003907-20.1875 45.003907-45v-5.742188c27.902343 13.578125 58.972656 20.742188 90 20.742188 32.050781 0 63.835937-7.351563 92.003906-21.246094v36.246094c0 5.199218 2.691406 10.027344 7.113281 12.761718 4.414063 2.726563 9.9375 2.984376 14.59375.65625l60.003906-30c5.082031-2.542968 8.292969-7.734374 8.292969-13.417968v-180.003906c0-8.285157-6.71875-15-15-15-23.894531 0-81.863281 0-103.53125 0l-105.816406-51.777344 40.203125-57.414063c4.746093-6.78125 3.101562-16.140625-3.6875-20.890625l-49.148438-34.417968c-6.78125-4.746094-16.140625-3.101563-20.890625 3.683593-6.351562 9.070313-46.882812 66.957031-53.191406 75.964844-12.304688-6.464844-27.058594-6.433594-36.417969-2.371094l-57.078125 24.796875c-8.273437 3.597656-15.207031 9.519532-20.042968 17.132813l-81.90625 128.828125c-5.320313 8.371094-7.523438 22.734375-3.203126 35.699218 3.800782 11.402344 11.816407 20.644532 22.570313 26.023438zm27.253906 60.894531 4.921875-33.179687 13.414063-19.160156c5.75 8.394531 13.574219 15.25 22.730469 19.84375l-11.570313 16.523437zm82.875 3.855469c-8.269531 0-15-6.730469-15-15.003906v-7.332032l5.371094-7.667968h24.628906v15c0 8.273437-6.726562 15.003906-15 15.003906zm60.003907 0c-8.273438 0-15-6.730469-15-15.003906v-15h30v15c0 8.273437-6.730469 15.003906-15 15.003906zm287.007812-24.273438-30.003906 15v-170.734374h30.003906zm-98.597656-157.261718c2.054687 1.003906 4.308594 1.527344 6.59375 1.527344h32v125.53125c-10.109375 3.929687-41.5 24.472656-92 24.472656-53.535156 0-86.507813-23.710938-98.296875-28.417969-2.140625-1.070313-4.5-1.582031-6.707031-1.582031h-105.003907c-15.339843 0-28.019531-11.574219-29.78125-26.449219.46875-2.175781.425781-4.410156-.070312-6.546875 1.507812-15.140625 14.320312-27.003906 29.851562-27.003906h92.578125c31.363282 0 60.855469-12.214844 83.035156-34.394532 5.855469-5.859374 5.855469-15.355468 0-21.214843-5.859374-5.859375-15.355468-5.859375-21.214843 0-16.515625 16.511719-38.46875 25.609375-61.820313 25.609375h-3.179687l60.84375-86.898438zm-147.71875-110.640625 24.574218 17.210937-87.496093 124.960938h-36.625c12.753906-18.214844 87.847656-125.460938 99.546875-142.171875zm34.414062-49.148438 24.578125 17.207031-17.210937 24.578126-24.574219-17.210938zm-238.804687 230.1875 81.421875-128.066406c1.613281-2.539063 3.925781-4.511719 6.683594-5.710937l56.363281-24.488282c2.503906-.734375 5.085937-.785156 7.523437-.242187l-87.289062 124.660156c-18.449219 8.082031-32.082032 25.175781-35.285156 45.691406-2.742188 7.703125-14.660157 11.59375-22.433594 7.707031-7.316406-3.65625-10.222656-12.339843-6.984375-19.550781zm0 0"/></svg>
            <span class="mx-3 whitespace-no-wrap">Lesson Plans</span>
        </a>
    </li>
    @if(config('gexam.enabled', false))
    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'exam' ? 'active':''}} || {{Request::segment ('2') == 'exam' ? 'active':''}}">
        <a href="{{ url('/teacher/exam') }}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m60 512h272c33.084 0 60-26.916 60-60v-407c0-8.284-6.716-15-15-15h-75v-15c0-8.284-6.716-15-15-15h-121c-8.284 0-15 6.716-15 15v15h-75c-8.284 0-15 6.716-15 15v377h-46c-8.284 0-15 6.716-15 15v15c0 33.084 26.916 60 60 60zm121-482h91v30h-91zm-90 30h60v15c0 8.284 6.716 15 15 15h121c8.284 0 15-6.716 15-15v-15h60v392c0 16.542-13.458 30-30 30s-30-13.458-30-30v-15c0-8.284-6.716-15-15-15h-196zm181 392c0 10.92 2.934 21.17 8.052 30h-220.052c-16.542 0-30-13.458-30-30z"/><path d="m467 61c-24.813 0-45 20.187-45 45v270c0 1.588.324 3.407.754 4.696l30 91c2.027 6.15 7.771 10.304 14.246 10.304s12.219-4.154 14.246-10.304l30-91c.424-1.273.754-3.073.754-4.696v-270c0-24.813-20.187-45-45-45zm-15 300v-210h30v210zm15-270c8.271 0 15 6.729 15 15v15h-30v-15c0-8.271 6.729-15 15-15zm-9.261 300h18.521l-9.26 28.091z"/><path d="m226 181h91c8.284 0 15-6.716 15-15s-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/><path d="m317 241h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m332 346c0-8.284-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15z"/><path d="m155.394 176.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m155.394 266.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m206.606 305.394c-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.393-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l30 30c2.929 2.929 6.768 4.393 10.607 4.393s7.678-1.464 10.606-4.394l30-30c5.859-5.857 5.859-15.355 0-21.212z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Exam</span>
        </a>
    </li>
    @endif

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'tasks' ? 'active':''}} || {{Request::segment ('2') == 'task' ? 'active':''}}">
        <a href="{{ url('/teacher/tasks') }}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m60 512h272c33.084 0 60-26.916 60-60v-407c0-8.284-6.716-15-15-15h-75v-15c0-8.284-6.716-15-15-15h-121c-8.284 0-15 6.716-15 15v15h-75c-8.284 0-15 6.716-15 15v377h-46c-8.284 0-15 6.716-15 15v15c0 33.084 26.916 60 60 60zm121-482h91v30h-91zm-90 30h60v15c0 8.284 6.716 15 15 15h121c8.284 0 15-6.716 15-15v-15h60v392c0 16.542-13.458 30-30 30s-30-13.458-30-30v-15c0-8.284-6.716-15-15-15h-196zm181 392c0 10.92 2.934 21.17 8.052 30h-220.052c-16.542 0-30-13.458-30-30z"/><path d="m467 61c-24.813 0-45 20.187-45 45v270c0 1.588.324 3.407.754 4.696l30 91c2.027 6.15 7.771 10.304 14.246 10.304s12.219-4.154 14.246-10.304l30-91c.424-1.273.754-3.073.754-4.696v-270c0-24.813-20.187-45-45-45zm-15 300v-210h30v210zm15-270c8.271 0 15 6.729 15 15v15h-30v-15c0-8.271 6.729-15 15-15zm-9.261 300h18.521l-9.26 28.091z"/><path d="m226 181h91c8.284 0 15-6.716 15-15s-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/><path d="m317 241h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m332 346c0-8.284-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15z"/><path d="m155.394 176.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m155.394 266.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m206.606 305.394c-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.393-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l30 30c2.929 2.929 6.768 4.393 10.607 4.393s7.678-1.464 10.606-4.394l30-30c5.859-5.857 5.859-15.355 0-21.212z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">To Do List</span>
        </a>
    </li>

    <!-- class wall start -->
    @php
        $class='';
        $array=array('pages','page','posts','post');
        if(in_array(\Request()->segment('3'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3 hover:bg-purple-900 {{$class}}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g id="XMLID_1153_"><g id="XMLID_452_"><path id="XMLID_957_" d="m469.885 359.996c23.343-.714 42.115-19.912 42.115-43.424v-253.084c0-23.963-19.495-43.458-43.458-43.458h-167.479c-5.522 0-10 4.477-10 10s4.478 10 10 10h167.479c12.935 0 23.458 10.523 23.458 23.458v253.084c0 12.487-9.808 22.723-22.124 23.417-2.993-24.73-24.097-43.959-49.622-43.959-25.539 0-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44s-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44-25.529 0-46.636 19.236-49.624 43.973-12.436-.568-22.378-10.859-22.378-23.431v-253.084c0-12.935 10.523-23.458 23.458-23.458h167.605c5.522 0 10-4.477 10-10s-4.478-10-10-10h-167.605c-23.963 0-43.458 19.495-43.458 43.458v253.084c0 23.598 18.909 42.849 42.369 43.43 1.437 12.009 7.141 22.72 15.557 30.572-33.909 13.57-57.926 46.759-57.926 85.456v6c0 5.523 4.478 10 10 10h492c5.522 0 10-4.477 10-10v-6c0-38.629-23.933-71.769-57.748-85.383 8.459-7.859 14.194-18.602 15.633-30.651zm-79.631-13.966c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-100.091 44.581c8.43-7.849 14.147-18.564 15.591-30.581h64.872c1.438 11.961 7.11 22.633 15.477 30.472-20.849 8.292-37.973 23.996-48.104 43.841-10.086-19.76-27.108-35.412-47.836-43.732zm-64.036-44.581c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-4.112 44.508c-20.808 8.301-37.899 23.988-48.015 43.805-10.101-19.789-27.158-35.458-47.926-43.769 8.409-7.846 14.111-18.547 15.553-30.545h64.873c1.44 11.981 7.127 22.667 15.515 30.509zm-160.015-36.508v-8c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-41.891 118c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm164 0c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm307.782 0h-143.782c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68z"/><path id="XMLID_1515_" d="m151.855 98.03c-5.522 0-10 4.477-10 10v16.127h-16.755c-5.522 0-10 4.477-10 10s4.478 10 10 10h16.756v16.756c0 5.523 4.478 10 10 10s10-4.477 10-10v-16.756h16.127c5.522 0 10-4.477 10-10s-4.478-10-10-10h-16.127v-16.127c-.001-5.523-4.478-10-10.001-10z"/><path id="XMLID_1623_" d="m81.1 191.609c5.522 0 10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.1c-5.522 0-10 4.477-10 10s4.478 10 10 10h7.1v70c0 5.523 4.477 10 10 10z"/><path id="XMLID_1852_" d="m194.884 101.609c0 5.523 4.478 10 10 10h7.099v70c0 5.523 4.478 10 10 10s10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.099c-5.523 0-10 4.477-10 10z"/><path id="XMLID_1853_" d="m288.333 184.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1921_" d="m288.333 116.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1922_" d="m64 252.03h384c5.522 0 10-4.477 10-10s-4.478-10-10-10h-384c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1923_" d="m256.06 39.97c2.63 0 5.21-1.07 7.07-2.93 1.87-1.86 2.93-4.44 2.93-7.07 0-2.64-1.06-5.21-2.93-7.07-1.86-1.87-4.43-2.93-7.07-2.93-2.63 0-5.21 1.06-7.069 2.93-1.86 1.86-2.931 4.43-2.931 7.07 0 2.63 1.07 5.21 2.931 7.07 1.859 1.86 4.439 2.93 7.069 2.93z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Class Wall <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar">
            <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('3') == 'pages' ? 'active':''}}  {{Request::segment ('3') == 'page' ? 'active':''}}">
                <a href="{{ url('/teacher/classwall/pages') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 480 480" style="enable-background:new 0 0 480 480;" xml:space="preserve"><g><g><path d="M160,344h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,344,160,344z"/></g></g><g><g><path d="M384,344H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,344,384,344z"/></g></g><g><g><path d="M160,296h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,296,160,296z"/></g></g><g><g><path d="M384,296H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,296,384,296z"/></g></g><g><g><path d="M160,248h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,248,160,248z"/></g></g><g><g><path d="M384,248H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,248,384,248z"/></g></g><g><g><path d="M160,200h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,200,160,200z"/></g></g><g><g><path d="M384,200H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,200,384,200z"/></g></g><g><g><path d="M160,152h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,152,160,152z"/></g></g><g><g><path d="M384,152H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,152,384,152z"/></g></g><g><g><path d="M439.896,119.496c-0.04-0.701-0.177-1.393-0.408-2.056c-0.088-0.256-0.152-0.504-0.264-0.752 c-0.389-0.87-0.931-1.664-1.6-2.344l-112-112c-0.68-0.669-1.474-1.211-2.344-1.6c-0.248-0.112-0.496-0.176-0.744-0.264 c-0.669-0.23-1.366-0.37-2.072-0.416C320.328,0.088,320.176,0,320,0H96c-4.418,0-8,3.582-8,8v24H48c-4.418,0-8,3.582-8,8v432 c0,4.418,3.582,8,8,8h336c4.418,0,8-3.582,8-8v-40h40c4.418,0,8-3.582,8-8V120C440,119.824,439.912,119.672,439.896,119.496z M328,27.312L412.688,112H328V27.312z M376,464H56V48h32v376c0,4.418,3.582,8,8,8h280V464z M424,416H104V16h208v104 c0,4.418,3.582,8,8,8h104V416z"/></g></g><g><g><path d="M192,72h-48c-4.418,0-8,3.582-8,8v48c0,4.418,3.582,8,8,8h48c4.418,0,8-3.582,8-8V80C200,75.582,196.418,72,192,72z M184,120h-32V88h32V120z"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Pages</span>
                </a>
            </li>

            <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('3') == 'posts' ? 'active':''}} || {{Request::segment ('3') == 'post' ? 'active':''}} ">
                <a href="{{ url('/teacher/classwall/posts') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M0,30v452h512V30H0z M482,452H30V120h452V452z M482,90H30V60h452V90z"/></g></g><g><g><path d="M271,160v252h181V160H271z M422,382H301V190h121V382z"/></g></g><g><g><rect x="60" y="160" width="181" height="30"/></g></g><g><g><rect x="60" y="220" width="121" height="30"/></g></g><g><g><rect x="60" y="300" width="181" height="30"/></g></g><g><g><rect x="60" y="360" width="121" height="30"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Posts</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'feeds' ? 'active':''}} || {{Request::segment ('2') == 'feed' ? 'active':''}} ">
                <a href="{{url('/teacher/feeds')}}" class="flex items-center">
                   <svg height="460pt" viewBox="-11 0 460 460.11908" width="460pt" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 fill-current text-white"><path d="m204.636719 0h-3.378907c-13.730468 0-25.351562 11.054688-25.351562 24.785156v23.875l-72.027344-20.976562c-2.023437-.589844-4.199218-.347656-6.039062.675781-1.84375 1.027344-3.195313 2.746094-3.761719 4.777344l-93.714844 322.976562c-1.203125 4.253907 1.25 8.683594 5.496094 9.914063l322.988281 93.773437c4.226563 1.230469 8.65625-1.183593 9.917969-5.402343l10-34.398438h80.941406c4.476563-.03125 8.113281-3.625 8.199219-8.101562v-336.316407c0-4.417969-3.78125-7.582031-8.199219-7.582031h-188.175781l-11.625-3.898438v-39.316406c0-13.730468-11.539062-24.785156-25.269531-24.785156zm-12.730469 24.785156c0-4.90625 4.441406-8.785156 9.351562-8.785156h3.378907c4.910156 0 9.269531 3.878906 9.269531 8.785156v34.667969l-22-6.148437zm161.507812 379.214844 68.492188-235.332031v235.332031zm68.492188-320v35.890625l-125.265625-35.890625zm-6.78125 50.589844-89.402344 307.609375-307.660156-89.304688 89.46875-307.617187 106.375 30.835937v54.585938c0 4.972656-4.03125 9-9 9-4.972656 0-9-4.027344-9-9v-33.238281c0-4.417969-3.582031-8-8-8s-8 3.582031-8 8v33.238281c0 13.808593 11.191406 25 25 25 13.804688 0 25-11.191407 25-25v-49.9375zm0 0"></path></svg>
                    <span class="mx-3 whitespace-no-wrap">Feeds</span>
                </a>
            </li>
        </ul>
    </li>
    <!-- class wall end -->

    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'activity' ? 'active':''}}">
        <a href="{{ url('/teacher/activity') }}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-1 0 512 512" width="512px" class="w-5 h-5"><g><path d="m360 242.839844v-207.839844c0-19.300781-15.699219-35-35-35h-290c-19.300781 0-35 15.699219-35 35v381c0 19.300781 15.699219 35 35 35h227.148438c24.152343 36.710938 65.714843 61 112.851562 61 74.4375 0 135-60.5625 135-135 0-79.980469-69.660156-143.085938-150-134.160156zm-325 178.160156c-2.757812 0-5-2.242188-5-5v-381c0-2.757812 2.242188-5 5-5h290c2.757812 0 5 2.242188 5 5v214.722656c-14.539062 5.15625-27.941406 12.734375-39.71875 22.253906-3.734375-1.410156 6.6875-.976562-155.28125-.976562-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h128.484375c-6.320313 9.242188-11.523437 19.308594-15.410156 30h-113.074219c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h105.953125c-2.425781 20.433594-.191406 40.886719 6.414063 60zm340 61c-57.898438 0-105-47.101562-105-105s47.101562-105 105-105 105 47.101562 105 105-47.101562 105-105 105zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 121h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 181h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 241h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 106c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 166c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 226c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 286c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 346c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m375 301c-8.285156 0-15 6.714844-15 15v45h-30c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h45c8.285156 0 15-6.714844 15-15v-60c0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path></g></svg>
            <span class="mx-3 whitespace-no-wrap">Activity Log</span>
        </a>
    </li>
</ul>