{{-- SPDX-License-Identifier: MIT --}}
<ul class="list-reset text-sm">
    <li class="py-3 px-3 {{ Request::segment ('2') == 'dashboard' ? 'active':'' }}">
        <a href="{{ url('/receptionist/dashboard') }}" class="flex items-center">
            <svg class="w-5 h-5 text-white fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><g><path d="M366.292,215.99L241.417,325.781c-0.167,0.146-0.333,0.292-0.479,0.448c-4.042,4.021-6.271,9.385-6.271,15.104 c0,11.76,9.563,21.333,21.333,21.333c5.667,0,11.021-2.208,15.563-6.75l109.792-124.875c3.708-4.219,3.5-10.604-0.479-14.583 C376.896,212.49,370.542,212.281,366.292,215.99z"/><path d="M256,85.333c-141.167,0-256,114.844-256,256c0,26.479,4.104,52.688,12.167,77.917c1.417,4.417,5.521,7.417,10.167,7.417 h467.333c4.646,0,8.75-3,10.167-7.417C507.896,394.021,512,367.813,512,341.333C512,200.177,397.167,85.333,256,85.333z M458.667,352h31.26c-0.824,18.04-3.237,35.947-8.177,53.333H30.25c-4.94-17.387-7.353-35.293-8.177-53.333h31.26 C59.229,352,64,347.229,64,341.333c0-5.896-4.771-10.667-10.667-10.667h-31.46c1.581-34.919,10.68-67.865,25.948-97.208 l27.324,15.781c1.688,0.969,3.521,1.427,5.333,1.427c3.667,0,7.271-1.906,9.229-5.333c2.958-5.104,1.208-11.625-3.896-14.573 l-27.263-15.746c18.323-28.539,42.602-52.816,71.142-71.138l15.746,27.28c1.958,3.417,5.563,5.333,9.229,5.333 c1.813,0,3.646-0.458,5.333-1.427c5.104-2.948,6.854-9.469,3.896-14.573l-15.777-27.332c29.345-15.27,62.293-24.37,97.215-25.951 v31.46c0,5.896,4.771,10.667,10.667,10.667s10.667-4.771,10.667-10.667v-31.46c34.922,1.581,67.87,10.681,97.215,25.951 l-15.777,27.332c-2.958,5.104-1.208,11.625,3.896,14.573c1.688,0.969,3.521,1.427,5.333,1.427c3.667,0,7.271-1.917,9.229-5.333 l15.746-27.28c28.54,18.322,52.819,42.599,71.142,71.138l-27.263,15.746c-5.104,2.948-6.854,9.469-3.896,14.573 c1.958,3.427,5.563,5.333,9.229,5.333c1.812,0,3.646-0.458,5.333-1.427l27.324-15.781c15.268,29.344,24.367,62.289,25.948,97.208 h-31.46c-5.896,0-10.667,4.771-10.667,10.667C448,347.229,452.771,352,458.667,352z"/></g></g></g></svg>
            <span class="mx-3">Dashboard</span>
        </a>
    </li>

    <!-- start -->
    <li class="px-2 py-2 {{ Request::segment ('2') == 'feeds' ? 'active':'' }}">
        <a href="{{ url('/receptionist/feeds') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="460pt" viewBox="-11 0 460 460.11908" width="460pt" xmlns="http://www.w3.org/2000/svg"><path d="m204.636719 0h-3.378907c-13.730468 0-25.351562 11.054688-25.351562 24.785156v23.875l-72.027344-20.976562c-2.023437-.589844-4.199218-.347656-6.039062.675781-1.84375 1.027344-3.195313 2.746094-3.761719 4.777344l-93.714844 322.976562c-1.203125 4.253907 1.25 8.683594 5.496094 9.914063l322.988281 93.773437c4.226563 1.230469 8.65625-1.183593 9.917969-5.402343l10-34.398438h80.941406c4.476563-.03125 8.113281-3.625 8.199219-8.101562v-336.316407c0-4.417969-3.78125-7.582031-8.199219-7.582031h-188.175781l-11.625-3.898438v-39.316406c0-13.730468-11.539062-24.785156-25.269531-24.785156zm-12.730469 24.785156c0-4.90625 4.441406-8.785156 9.351562-8.785156h3.378907c4.910156 0 9.269531 3.878906 9.269531 8.785156v34.667969l-22-6.148437zm161.507812 379.214844 68.492188-235.332031v235.332031zm68.492188-320v35.890625l-125.265625-35.890625zm-6.78125 50.589844-89.402344 307.609375-307.660156-89.304688 89.46875-307.617187 106.375 30.835937v54.585938c0 4.972656-4.03125 9-9 9-4.972656 0-9-4.027344-9-9v-33.238281c0-4.417969-3.582031-8-8-8s-8 3.582031-8 8v33.238281c0 13.808593 11.191406 25 25 25 13.804688 0 25-11.191407 25-25v-49.9375zm0 0"/></svg>
            <span class="mx-3 whitespace-no-wrap">Feed</span>
        </a>
    </li>
    <!-- end -->

    <li class="py-3 px-3 {{ Request::segment ('2') == 'events' ? 'active':'' }}">
        <a href="{{ url('receptionist/events') }}" class="flex items-center">
            <!-- <img src="{{asset('uploads/icons/sidebar/calendar.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 0 480 480" width="512px"><g><path d="m399.832031 54.398438c-.0625-.277344-.230469-.496094-.3125-.757813-.136719-.449219-.316406-.882813-.535156-1.296875-.25-.476562-.550781-.921875-.894531-1.335938-.277344-.34375-.582032-.664062-.914063-.960937-.402343-.339844-.84375-.632813-1.3125-.878906-.394531-.238281-.8125-.441407-1.246093-.609375-.519532-.164063-1.058594-.273438-1.601563-.328125-.332031-.097657-.671875-.175781-1.015625-.230469h-40.335938c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-40.335938c-4.417969 0-8 3.582031-8 8v416c0 4.417969 3.582031 8 8 8h384c4.417969 0 8-3.582031 8-8v-24h72c2.402344 0 4.675781-1.082031 6.191406-2.941406 1.519532-1.863282 2.121094-4.304688 1.640625-6.660156zm-79.832031-38.398438c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-64 48h32.335938c2.0625 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h79.617188v80h-368zm368 400h-368v-304h368zm16-32v-298.398438l62.167969 298.398438zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Calendar</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:font-semibold {{ Request::segment ('2') == 'visitorlog' ? 'active':'' }}">
        <a href="{{ url('/receptionist/visitorlog') }}" class="flex items-center whitespace-no-wrap">
            <!-- <img src="{{asset('uploads/icons/sidebar/school.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><circle cx="502" cy="255.86" r="10"/><path d="m508.07 111.54c-2.52-5.96-6.12-11.3-10.72-15.89-4.59-4.6-9.93-8.2-15.89-10.72-6.16-2.61-12.71-3.93-19.46-3.93h-412c-6.75 0-13.3 1.32-19.46 3.93-5.96 2.52-11.3 6.12-15.89 10.72-4.6 4.59-8.2 9.93-10.72 15.89-2.61 6.16-3.93 12.71-3.93 19.46v250c0 6.75 1.32 13.3 3.93 19.46 2.52 5.96 6.12 11.3 10.72 15.89 4.59 4.6 9.93 8.2 15.89 10.72 6.16 2.61 12.71 3.93 19.46 3.93h412c6.75 0 13.3-1.32 19.46-3.93 5.96-2.52 11.3-6.12 15.89-10.72 4.6-4.59 8.2-9.93 10.72-15.89 2.61-6.16 3.93-12.71 3.93-19.46v-80.14c0-5.52-4.49-10-10-10s-10 4.48-10 10v14.14h-472v-184c.03-16.51 13.49-29.97 30-30h412c16.51.03 29.97 13.49 30 30v79.86c0 5.51 4.49 10 10 10s10-4.49 10-10v-79.86c0-6.75-1.32-13.3-3.93-19.46zm-46.07 299.46h-412c-15.154-.028-27.729-11.371-29.718-26h471.435c-1.989 14.629-14.564 25.972-29.717 26zm30-76v30h-472v-30z"/><path d="m60 150c-5.523 0-10 4.477-10 10v100c0 5.523 4.477 10 10 10h100c5.523 0 10-4.477 10-10v-100c0-5.523-4.477-10-10-10zm90 100h-80v-80h80z"/><path d="m210 245h200c5.523 0 10-4.477 10-10s-4.477-10-10-10h-200c-5.523 0-10 4.477-10 10s4.477 10 10 10z"/><path d="m350 195c5.523 0 10-4.477 10-10s-4.477-10-10-10h-47c-5.523 0-10 4.477-10 10s4.477 10 10 10z"/><path d="m210 195h48c5.523 0 10-4.477 10-10s-4.477-10-10-10h-48c-5.523 0-10 4.477-10 10s4.477 10 10 10z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Visitor Log</span>
        </a>
    </li> 

    <li class="py-3 px-2 hover:font-semibold {{ Request::segment ('2') == 'calllog' ? 'active':'' }}"> 
        <a href="{{ url('receptionist/calllog') }}" class="flex items-center">
            <!--<img src="{{asset('uploads/icons/sidebar/academic.svg')}}" class="w-5 h-5">   -->
            <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512.021 512.021" height="512" viewBox="0 0 512.021 512.021" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m367.988 512.021c-16.528 0-32.916-2.922-48.941-8.744-70.598-25.646-136.128-67.416-189.508-120.795s-95.15-118.91-120.795-189.508c-8.241-22.688-10.673-46.108-7.226-69.612 3.229-22.016 11.757-43.389 24.663-61.809 12.963-18.501 30.245-33.889 49.977-44.5 21.042-11.315 44.009-17.053 68.265-17.053 7.544 0 14.064 5.271 15.645 12.647l25.114 117.199c1.137 5.307-.494 10.829-4.331 14.667l-42.913 42.912c40.482 80.486 106.17 146.174 186.656 186.656l42.912-42.913c3.837-3.837 9.36-5.466 14.667-4.331l117.199 25.114c7.377 1.581 12.647 8.101 12.647 15.645 0 24.256-5.738 47.224-17.054 68.266-10.611 19.732-25.999 37.014-44.5 49.977-18.419 12.906-39.792 21.434-61.809 24.663-6.899 1.013-13.797 1.518-20.668 1.519zm-236.349-479.321c-31.995 3.532-60.393 20.302-79.251 47.217-21.206 30.265-26.151 67.49-13.567 102.132 49.304 135.726 155.425 241.847 291.151 291.151 34.641 12.584 71.867 7.64 102.132-13.567 26.915-18.858 43.685-47.256 47.217-79.251l-95.341-20.43-44.816 44.816c-4.769 4.769-12.015 6.036-18.117 3.168-95.19-44.72-172.242-121.772-216.962-216.962-2.867-6.103-1.601-13.349 3.168-18.117l44.816-44.816z"/><path d="m496.02 272c-8.836 0-16-7.164-16-16 0-123.514-100.486-224-224-224-8.836 0-16-7.164-16-16s7.164-16 16-16c68.381 0 132.668 26.628 181.02 74.98s74.98 112.639 74.98 181.02c0 8.836-7.163 16-16 16z"/><path d="m432.02 272c-8.836 0-16-7.164-16-16 0-88.224-71.776-160-160-160-8.836 0-16-7.164-16-16s7.164-16 16-16c105.869 0 192 86.131 192 192 0 8.836-7.163 16-16 16z"/><path d="m368.02 272c-8.836 0-16-7.164-16-16 0-52.935-43.065-96-96-96-8.836 0-16-7.164-16-16s7.164-16 16-16c70.58 0 128 57.42 128 128 0 8.836-7.163 16-16 16z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Call Log</span>
        </a> 
    </li>

    <li class="py-3 px-2 hover:font-semibold {{ Request::segment ('2') == 'postalrecord' ? 'active':'' }}"> 
        <a href="{{ url('receptionist/postalrecord') }}" class="flex items-center">
            <!--<img src="{{asset('uploads/icons/sidebar/academic.svg')}}" class="w-5 h-5">-->
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 470.161 470.161" style="enable-background:new 0 0 470.161 470.161;" xml:space="preserve"><g><path d="M463.247,55.313H6.914c-2.773,0-5.282,1.66-6.368,4.218C0.173,60.409-0.007,61.35,0,62.276v345.658 c0,0.007,0,0.014,0,0.021c0,0.926,0.187,1.811,0.518,2.613c0.339,0.823,0.836,1.583,1.507,2.254 c0.671,0.67,1.431,1.168,2.254,1.507c0.802,0.332,1.688,0.519,2.614,0.519c0.007,0,0.014,0,0.021,0h456.333 c0.968,0,1.881-0.193,2.708-0.552c0.768-0.324,1.487-0.795,2.116-1.41c0.021-0.021,0.014-0.014,0.014-0.014 c0.007-0.007,0.014-0.007,0.014-0.014c0,0,0,0,0.007,0c0-0.028,0.007-0.021,0.014-0.021c0.007,0,0.007-0.007,0.014-0.014 c0.007-0.007,0.014-0.007,0.014-0.014c0,0,0.007,0,0.007-0.007l0.014-0.014c0.007-0.007,0.007-0.007,0.014-0.014 c0,0,0,0,0.007-0.007c0.643-0.65,1.12-1.397,1.452-2.192c0.339-0.816,0.519-1.708,0.519-2.641V62.227 C470.161,58.404,467.071,55.313,463.247,55.313z M446.902,69.141L287.988,232.84l-0.007,0.007l-52.928,54.566l-53.336-54.165 L23.204,69.141H446.902z M13.828,79.34l153.245,158.659L13.828,391.244V79.34z M23.605,401.02l153.12-153.127l53.432,54.262 c1.307,1.327,3.077,2.067,4.93,2.067c0.007,0,0.021,0,0.028,0c1.86-0.007,3.637-0.768,4.937-2.102l52.976-54.608L446.556,401.02 H23.605z M456.333,391.244l-153.674-153.66L456.333,79.278V391.244z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Postal Record</span>
        </a> 
    </li>

    <li class="py-3 px-3 hover:bg-blue-900 {{ Request::segment ('2') == 'tasks' ? 'active':'' }} && {{ Request::segment ('2') == 'task' ? 'active':'' }}">
        <a href="{{ url('/receptionist/tasks') }}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m60 512h272c33.084 0 60-26.916 60-60v-407c0-8.284-6.716-15-15-15h-75v-15c0-8.284-6.716-15-15-15h-121c-8.284 0-15 6.716-15 15v15h-75c-8.284 0-15 6.716-15 15v377h-46c-8.284 0-15 6.716-15 15v15c0 33.084 26.916 60 60 60zm121-482h91v30h-91zm-90 30h60v15c0 8.284 6.716 15 15 15h121c8.284 0 15-6.716 15-15v-15h60v392c0 16.542-13.458 30-30 30s-30-13.458-30-30v-15c0-8.284-6.716-15-15-15h-196zm181 392c0 10.92 2.934 21.17 8.052 30h-220.052c-16.542 0-30-13.458-30-30z"/><path d="m467 61c-24.813 0-45 20.187-45 45v270c0 1.588.324 3.407.754 4.696l30 91c2.027 6.15 7.771 10.304 14.246 10.304s12.219-4.154 14.246-10.304l30-91c.424-1.273.754-3.073.754-4.696v-270c0-24.813-20.187-45-45-45zm-15 300v-210h30v210zm15-270c8.271 0 15 6.729 15 15v15h-30v-15c0-8.271 6.729-15 15-15zm-9.261 300h18.521l-9.26 28.091z"/><path d="m226 181h91c8.284 0 15-6.716 15-15s-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/><path d="m317 241h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m332 346c0-8.284-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15z"/><path d="m155.394 176.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m155.394 266.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m206.606 305.394c-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.393-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l30 30c2.929 2.929 6.768 4.393 10.607 4.393s7.678-1.464 10.606-4.394l30-30c5.859-5.857 5.859-15.355 0-21.212z"/></g></svg>
            <!-- <img src="{{asset('uploads/icons/sidebar/activity.svg')}}" class="w-5 h-5"> -->
            <span class="mx-3 whitespace-no-wrap">To Do List</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:bg-blue-900 {{Request::segment ('2') == 'holidaylist' ? 'active':''}}">
        <a href="{{ url('/receptionist/holidaylist') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g id="Layer_27" data-name="Layer 27"><path d="m62 29h-24a1 1 0 0 0 -1 1v3.61a12.09 12.09 0 0 0 -6-1.61h-3v-2a10 10 0 0 0 3.83-6h.17a4 4 0 0 0 3-6.62v-3.38a13 13 0 0 0 -26 0v3.38a4 4 0 0 0 3 6.62h.2a10 10 0 0 0 3.8 6v2h-3a12 12 0 0 0 -12 12v18a1 1 0 0 0 1 1h33v-2h-8.15l-2.85-16.84 1.21-2.42 2.3 1.15a1 1 0 0 0 .49.11 1 1 0 0 0 .95-.68l2.76-8.32a10 10 0 0 1 5.29 2v26a1 1 0 0 0 1 1h24a1 1 0 0 0 1-1v-32a1 1 0 0 0 -1-1zm-30-7v-4a2 2 0 0 1 0 4zm-22-2a2 2 0 0 1 2-2v4a2 2 0 0 1 -2-2zm2-4a4.09 4.09 0 0 0 -1 .14v-2.14a11 11 0 0 1 22 0v2.14a4.09 4.09 0 0 0 -1-.14 1 1 0 0 0 -1-1 5 5 0 0 1 -4-2l-1.2-1.6a1 1 0 0 0 -1.6 0l-1.2 1.6a5 5 0 0 1 -4 2h-6a1 1 0 0 0 -1 1zm2 6v-5h5a7 7 0 0 0 5.6-2.8l.4-.53.4.53a7.06 7.06 0 0 0 4.6 2.73v5.07a8 8 0 0 1 -16 0zm8 10a9.92 9.92 0 0 0 4-.84v1.48l-4 4.8-4-4.8v-1.48a9.92 9.92 0 0 0 4 .84zm-5.42 8.59-2.19-6.59h2.14l3.89 4.67zm-13.58 3.41a10 10 0 0 1 9.29-10l2.76 8.28a1 1 0 0 0 .95.72 1 1 0 0 0 .45-.11l2.3-1.15 1.25 2.42-2.85 16.84h-8.15v-14h-2v14h-4zm16.18 17 2.67-16h.3l2.67 16zm3.2-18h-.76l-1.08-2.15 1.46-.73 1.46.73zm5-2.41-3.84-1.92 3.93-4.67h2.14zm17.62-9.59h10v2h-10zm16 30h-22v-30h4v3a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-3h4z"/><path d="m46 37h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 45h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 53h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m49 37h10v2h-10z"/><path d="m49 41h10v2h-10z"/><path d="m49 45h10v2h-10z"/><path d="m49 49h10v2h-10z"/><path d="m49 53h10v2h-10z"/><path d="m49 57h10v2h-10z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Holiday</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:font-semibold {{ Request::segment ('2') == 'notices' ? 'active':'' }}">
        <a href="{{ url('/receptionist/notices') }}" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/noticeboard.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Layer_3" enable-background="new 0 0 64 64" height="512px" viewBox="0 0 64 64" width="512px"><g><path d="m21 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m35 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 51h26c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1zm1-4h24v2h-24z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 53h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 57h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m62 9c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-12v-1c0-.553-.447-1-1-1h-34c-.553 0-1 .447-1 1v1h-12c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h1v46h-1c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h12v1c0 .553.447 1 1 1h34c.553 0 1-.447 1-1v-1h12c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-1v-46zm-59-4h11v2h-11zm11 4v46h-5v-46zm-9 0h2v46h-2zm-2 50v-2h11v2zm45 2h-32v-58h32zm13-56v2h-11v-2zm-11 50v-46h5v46zm11 4h-11v-2h11zm-2-4h-2v-46h2z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 31h26c.553 0 1-.447 1-1v-24c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v24c0 .553.447 1 1 1zm10-17c0-1.654 1.346-3 3-3s3 1.346 3 3-1.346 3-3 3-3-1.346-3-3zm8 15h-10v-5c0-2.757 2.243-5 5-5s5 2.243 5 5zm-17-22h24v22h-5v-5c0-2.698-1.537-5.04-3.779-6.208 1.079-.918 1.779-2.268 1.779-3.792 0-2.757-2.243-5-5-5s-5 2.243-5 5c0 1.524.7 2.874 1.779 3.792-2.242 1.168-3.779 3.51-3.779 6.208v5h-5z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Notice Board</span>
        </a>
    </li>

    <li class="py-3 px-3 {{ Request::segment ('2') == 'activity' ? 'active':'' }}">
        <a href="{{ url('/receptionist/activity') }}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-1 0 512 512" width="512px" class="w-5 h-5"><g><path d="m360 242.839844v-207.839844c0-19.300781-15.699219-35-35-35h-290c-19.300781 0-35 15.699219-35 35v381c0 19.300781 15.699219 35 35 35h227.148438c24.152343 36.710938 65.714843 61 112.851562 61 74.4375 0 135-60.5625 135-135 0-79.980469-69.660156-143.085938-150-134.160156zm-325 178.160156c-2.757812 0-5-2.242188-5-5v-381c0-2.757812 2.242188-5 5-5h290c2.757812 0 5 2.242188 5 5v214.722656c-14.539062 5.15625-27.941406 12.734375-39.71875 22.253906-3.734375-1.410156 6.6875-.976562-155.28125-.976562-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h128.484375c-6.320313 9.242188-11.523437 19.308594-15.410156 30h-113.074219c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h105.953125c-2.425781 20.433594-.191406 40.886719 6.414063 60zm340 61c-57.898438 0-105-47.101562-105-105s47.101562-105 105-105 105 47.101562 105 105-47.101562 105-105 105zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 121h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 181h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 241h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 106c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 166c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 226c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 286c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 346c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m375 301c-8.285156 0-15 6.714844-15 15v45h-30c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h45c8.285156 0 15-6.714844 15-15v-60c0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path></g></svg>
            <span class="mx-3 whitespace-no-wrap">Activity Log</span>
        </a>
    </li>
</ul>