{{-- SPDX-License-Identifier: MIT --}}
<ul class="list-reset text-sm"> 
    <li class="py-3 px-3  {{Request::segment ('2') == 'dashboard' ? 'active':''}}"> <!-- hover:bg-red-900 -->
        <a href="{{url('admin/dashboard')}}" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/dashboard.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><g><path d="M256,298.66c-10.527,0.031-20.665,3.982-28.437,11.083l-72.896-41.685c-5.116-2.946-11.652-1.186-14.597,3.931     c-2.945,5.116-1.186,11.652,3.931,14.597l71.755,41.003c-1.565,4.413-2.383,9.056-2.421,13.739     c0,23.564,19.102,42.667,42.667,42.667s42.667-19.102,42.667-42.667C298.667,317.762,279.564,298.66,256,298.66z M256,362.66 c-11.782,0-21.333-9.551-21.333-21.333c0-11.782,9.551-21.333,21.333-21.333c11.782,0,21.333,9.551,21.333,21.333 C277.333,353.109,267.782,362.66,256,362.66z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M436.501,158.233c-50.187-48.853-117.141-74.549-187.68-72.811C111.616,89.103,0,203.727,0,340.975v57.227 c0.123,15.799,13,28.524,28.8,28.459h454.4c15.796,0.065,28.671-12.653,28.8-28.448v-62.219     C512,268.793,485.184,205.625,436.501,158.233z M490.667,398.233c-0.116,4.018-3.448,7.192-7.467,7.115H28.8     c-4.019,0.078-7.35-3.097-7.467-7.115v-57.259c0-125.781,102.304-230.869,228.053-234.229     c64.12-2.218,126.352,21.907,172.224,66.763c44.523,43.36,69.056,101.056,69.056,162.485V398.233z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M256,181.327c5.891,0,10.667-4.776,10.667-10.667v-42.667c0-5.891-4.776-10.667-10.667-10.667     c-5.891,0-10.667,4.776-10.667,10.667v42.667C245.333,176.551,250.109,181.327,256,181.327z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M416,341.327c0,5.891,4.776,10.667,10.667,10.667h42.667c5.891,0,10.667-4.776,10.667-10.667     s-4.776-10.667-10.667-10.667h-42.667C420.776,330.66,416,335.436,416,341.327z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M85.333,330.66H42.667c-5.891,0-10.667,4.776-10.667,10.667s4.776,10.667,10.667,10.667h42.667     c5.891,0,10.667-4.776,10.667-10.667S91.224,330.66,85.333,330.66z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M160.491,195.193c2.993,5.075,9.533,6.763,14.608,3.771c5.075-2.993,6.763-9.533,3.771-14.608l-18.133-30.795     c-2.993-5.075-9.533-6.763-14.608-3.771c-5.075,2.993-6.763,9.533-3.771,14.608L160.491,195.193z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M396.224,256.783c2.893,5.13,9.397,6.945,14.528,4.053l31.477-17.771c5.179-2.807,7.102-9.281,4.295-14.46 c-2.807-5.179-9.281-7.102-14.46-4.295c-0.104,0.056-0.207,0.115-0.31,0.175l-31.477,17.771     C395.147,245.148,393.332,251.651,396.224,256.783z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M111.723,242.244h0.011l-31.488-17.771c-5.083-2.978-11.618-1.272-14.596,3.811c-2.978,5.083-1.272,11.617,3.811,14.596     c0.102,0.06,0.206,0.118,0.31,0.175l31.477,17.771c5.179,2.807,11.654,0.884,14.46-4.296     C118.449,251.472,116.686,245.152,111.723,242.244z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M365.915,149.782c-0.016-0.01-0.032-0.019-0.048-0.028c-5.075-2.989-11.612-1.298-14.603,3.776l-18.133,30.795     c-3.001,5.075-1.32,11.623,3.755,14.624c5.075,3.001,11.623,1.32,14.624-3.755l18.133-30.795     C372.65,159.333,370.981,152.788,365.915,149.782z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Dashboard</span>
        </a>
    </li>

    <!-- start -->
    @php
        $class='';
        $array=array('students','student','parents','parent','teachers','teacher','staff','staffs','alumni','blocked_students');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3  {{$class}}">
        <a href="#" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/settings.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.869 477.869" style="enable-background:new 0 0 477.869 477.869;" xml:space="preserve"><g><g><path d="M387.415,233.496c48.976-44.029,52.987-119.424,8.958-168.4C355.991,20.177,288.4,12.546,239.02,47.332 c-53.83-37.99-128.264-25.149-166.254,28.68c-34.859,49.393-27.259,117.054,17.689,157.483 c-55.849,29.44-90.706,87.481-90.453,150.613v51.2c0,9.426,7.641,17.067,17.067,17.067h443.733 c9.426,0,17.067-7.641,17.067-17.067v-51.2C478.121,320.976,443.264,262.935,387.415,233.496z M307.201,59.842 c47.062-0.052,85.256,38.057,85.309,85.119c0.037,33.564-19.631,64.023-50.237,77.799c-1.314,0.597-2.628,1.143-3.959,1.707 c-4.212,1.699-8.556,3.051-12.988,4.045c-0.853,0.188-1.707,0.29-2.577,0.461c-4.952,0.949-9.977,1.457-15.019,1.519 c-2.27,0-4.557-0.171-6.827-0.375c-0.853,0-1.707,0-2.56-0.171c-9.7-1.142-19.136-3.923-27.904-8.226 c-0.324-0.154-0.7-0.137-1.024-0.273c-1.707-0.819-3.413-1.536-4.932-2.458c0.137-0.171,0.222-0.358,0.358-0.529 c7.826-10.056,13.996-21.296,18.278-33.297l0.529-1.434c1.947-5.732,3.459-11.602,4.523-17.562c0.154-0.87,0.273-1.707,0.41-2.645 c0.987-6.067,1.506-12.2,1.553-18.347c-0.049-6.135-0.568-12.257-1.553-18.313c-0.137-0.887-0.256-1.707-0.41-2.645 c-1.064-5.959-2.576-11.83-4.523-17.562l-0.529-1.434c-4.282-12.001-10.453-23.241-18.278-33.297 c-0.137-0.171-0.222-0.358-0.358-0.529C277.449,63.831,292.19,59.843,307.201,59.842z M85.335,145.176 c-0.121-47.006,37.886-85.21,84.892-85.331c22.034-0.057,43.232,8.434,59.134,23.686c0.99,0.956,1.963,1.911,2.918,2.901 c2.931,3.071,5.634,6.351,8.09,9.813c0.751,1.058,1.434,2.185,2.133,3.277c2.385,3.671,4.479,7.523,6.263,11.52 c0.427,0.973,0.751,1.963,1.126,2.935c1.799,4.421,3.215,8.989,4.233,13.653c0.12,0.512,0.154,1.024,0.256,1.553 c2.162,10.597,2.162,21.522,0,32.119c-0.102,0.529-0.137,1.041-0.256,1.553c-1.017,4.664-2.433,9.232-4.233,13.653 c-0.375,0.973-0.7,1.963-1.126,2.935c-1.786,3.991-3.88,7.837-6.263,11.503c-0.7,1.092-1.382,2.219-2.133,3.277 c-2.455,3.463-5.159,6.742-8.09,9.813c-0.956,0.99-1.929,1.946-2.918,2.901c-6.91,6.585-14.877,11.962-23.569,15.906 c-1.382,0.631-2.782,1.212-4.198,1.707c-4.114,1.633-8.347,2.945-12.663,3.925c-1.075,0.239-2.185,0.375-3.277,0.563 c-4.634,0.863-9.333,1.336-14.046,1.417h-1.877c-4.713-0.08-9.412-0.554-14.046-1.417c-1.092-0.188-2.202-0.324-3.277-0.563 c-4.316-0.98-8.55-2.292-12.663-3.925c-1.417-0.563-2.816-1.143-4.198-1.707C105.013,209.057,85.374,178.677,85.335,145.176z M307.201,418.242H34.135v-34.133c-0.25-57.833,36.188-109.468,90.76-128.614c29.296,12.197,62.249,12.197,91.546,0 c5.698,2.082,11.251,4.539,16.623,7.356c3.55,1.826,6.827,3.908,10.24,6.007c2.219,1.382,4.471,2.731,6.605,4.25 c3.294,2.338,6.4,4.881,9.455,7.492c1.963,1.707,3.908,3.413,5.751,5.12c2.816,2.662,5.461,5.478,8.004,8.363 c1.826,2.082,3.601,4.198,5.291,6.383c2.236,2.867,4.369,5.803,6.349,8.823c1.707,2.56,3.226,5.222,4.727,7.885 c1.707,2.935,3.277,5.871,4.71,8.926c1.434,3.055,2.697,6.4,3.925,9.66c1.075,2.833,2.219,5.649,3.106,8.533 c1.195,3.959,2.031,8.055,2.867,12.151c0.512,2.423,1.178,4.796,1.553,7.253c1.011,6.757,1.53,13.579,1.553,20.412V418.242z M443.735,418.242h-102.4v-34.133c0-5.342-0.307-10.633-0.785-15.872c-0.137-1.536-0.375-3.055-0.546-4.591 c-0.461-3.772-0.99-7.509-1.707-11.213c-0.307-1.581-0.631-3.169-0.973-4.762c-0.819-3.8-1.769-7.566-2.85-11.298 c-0.358-1.229-0.683-2.475-1.058-3.686c-4.779-15.277-11.704-29.797-20.565-43.127l-0.666-0.973 c-2.935-4.358-6.07-8.573-9.404-12.646l-0.119-0.154c-3.413-4.232-7.117-8.346-11.008-12.237c0.222,0,0.461,0,0.7,0 c4.816,0.633,9.666,0.975,14.524,1.024h0.939c4.496-0.039,8.985-0.33,13.449-0.87c1.399-0.171,2.782-0.427,4.181-0.649 c3.63-0.557,7.214-1.28,10.752-2.167c1.007-0.256,2.031-0.495,3.055-0.785c4.643-1.263,9.203-2.814,13.653-4.642 c54.612,19.127,91.083,70.785,90.829,128.649V418.242z"/></g></g></svg>

            <span class="ml-3 whitespace-no-wrap flex items-center justify-between w-10/12">Users
            <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>

        </a>
        <ul class="list-reset sites-sidebar">
            <!-- start -->
            @php
                $class='';
                $array=array('teachers','teacher','staff','staffs');
                if(in_array(\Request()->segment('2'),$array))
                {
                    $class='active';
                }
            @endphp
            <li class="relative py-3 px-3  {{$class}}">
                <a href="#" class="flex items-center">
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 -32 512 512" width="512px"><g><path d="m464.867188 0h-224.933594c-25.988282 0-47.132813 21.144531-47.132813 47.132812v144.292969l-41.765625-20.769531c-1.410156-.703125-2.84375-1.367188-4.289062-1.996094 12.261718-12.800781 19.820312-30.144531 19.820312-49.226562 0-39.277344-31.953125-71.234375-71.230468-71.234375-39.28125 0-71.234376 31.957031-71.234376 71.234375 0 21.34375 9.449219 40.515625 24.371094 53.582031-27.480468 15.460937-48.472656 45.621094-48.472656 82.984375v48.199219c0 20.75 13.472656 38.410156 32.132812 44.6875v83.847656c0 8.28125 6.714844 15 15 15h96.398438c8.285156 0 15-6.71875 15-15v-168.535156l48.023438 24.007812c18.378906 9.1875 43.308593 3.710938 54.582031-17.207031h53.78125l-56.949219 156.605469c-2.832031 7.785156 1.1875 16.394531 8.972656 19.222656 8.898438 3.238281 16.8125-2.34375 19.222656-8.96875l60.675782-166.859375h10.515625l61.296875 166.90625c2.328125 6.332031 10.183594 12.238281 19.253906 8.90625 7.773438-2.855469 11.765625-11.472656 8.90625-19.25l-57.5-156.5625h75.554688c25.484374 0 47.132812-20.558594 47.132812-47.132812v-176.734376c0-26.578124-21.648438-47.132812-47.132812-47.132812zm-410.765626 119.433594c0-22.738282 18.496094-41.234375 41.230469-41.234375 22.738281 0 41.234375 18.496093 41.234375 41.234375 0 22.734375-18.496094 41.230468-41.234375 41.230468-22.734375 0-41.230469-18.496093-41.230469-41.230468zm181.398438 135.527344c-.039062.109374-.078125.222656-.113281.335937-1.023438 2.855469-3.335938 5.261719-6.167969 6.425781-2.996094 1.21875-6.367188 1.089844-9.246094-.347656-28.523437-14.269531-69.738281-34.859375-69.738281-34.859375-9.953125-4.976563-21.703125 2.273437-21.703125 13.417969v177.800781h-66.398438v-81.402344c0-8.28125-6.71875-15-15-15-9.449218 0-17.132812-7.683593-17.132812-17.132812v-48.199219c0-36.652344 29.84375-65.332031 65.332031-65.332031h13.253907c10.054687 0 20.097656 2.359375 29.070312 6.839843 0 0 74.402344 37 93.351562 46.4375 4.058594 2.015626 5.988282 6.75 4.492188 11.015626zm246.5-31.09375c0 4.582031-1.777344 8.882812-5.011719 12.117187-3.183593 3.1875-7.601562 5.015625-12.121093 5.015625h-200.46875c-.027344-.082031-.046876-.164062-.074219-.242188l37.226562-74.449218c3.703125-7.410156.703125-16.417969-6.707031-20.125-7.40625-3.703125-16.417969-.703125-20.125 6.707031l-31.75 63.496094c-5.917969-2.949219-12.796875-6.375-20.167969-10.039063v-159.214844c0-9.445312 7.683594-17.132812 17.132813-17.132812h224.933594c4.519531 0 8.9375 1.828125 12.125 5.023438 3.230468 3.226562 5.007812 7.527343 5.007812 12.109374zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 64.265625h-160.667969c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h160.667969c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 120.5h-80.335937c-8.28125 0-15 6.714844-15 15s6.71875 15 15 15h80.335937c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 176.734375h-80.335937c-8.28125 0-15 6.714844-15 15 0 8.28125 6.71875 15 15 15h80.335937c8.28125 0 15-6.71875 15-15 0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
                    <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Staffs<img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
                </a>
                <ul class="list-reset sites-sidebar">
                    <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'teachers' ? 'active':''}} && {{Request::segment ('2') == 'teacher' ? 'active':''}} ">
                        <a href="{{ url('/admin/teachers') }}" class="flex items-center">
                            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 -32 512 512" width="512px"><g><path d="m464.867188 0h-224.933594c-25.988282 0-47.132813 21.144531-47.132813 47.132812v144.292969l-41.765625-20.769531c-1.410156-.703125-2.84375-1.367188-4.289062-1.996094 12.261718-12.800781 19.820312-30.144531 19.820312-49.226562 0-39.277344-31.953125-71.234375-71.230468-71.234375-39.28125 0-71.234376 31.957031-71.234376 71.234375 0 21.34375 9.449219 40.515625 24.371094 53.582031-27.480468 15.460937-48.472656 45.621094-48.472656 82.984375v48.199219c0 20.75 13.472656 38.410156 32.132812 44.6875v83.847656c0 8.28125 6.714844 15 15 15h96.398438c8.285156 0 15-6.71875 15-15v-168.535156l48.023438 24.007812c18.378906 9.1875 43.308593 3.710938 54.582031-17.207031h53.78125l-56.949219 156.605469c-2.832031 7.785156 1.1875 16.394531 8.972656 19.222656 8.898438 3.238281 16.8125-2.34375 19.222656-8.96875l60.675782-166.859375h10.515625l61.296875 166.90625c2.328125 6.332031 10.183594 12.238281 19.253906 8.90625 7.773438-2.855469 11.765625-11.472656 8.90625-19.25l-57.5-156.5625h75.554688c25.484374 0 47.132812-20.558594 47.132812-47.132812v-176.734376c0-26.578124-21.648438-47.132812-47.132812-47.132812zm-410.765626 119.433594c0-22.738282 18.496094-41.234375 41.230469-41.234375 22.738281 0 41.234375 18.496093 41.234375 41.234375 0 22.734375-18.496094 41.230468-41.234375 41.230468-22.734375 0-41.230469-18.496093-41.230469-41.230468zm181.398438 135.527344c-.039062.109374-.078125.222656-.113281.335937-1.023438 2.855469-3.335938 5.261719-6.167969 6.425781-2.996094 1.21875-6.367188 1.089844-9.246094-.347656-28.523437-14.269531-69.738281-34.859375-69.738281-34.859375-9.953125-4.976563-21.703125 2.273437-21.703125 13.417969v177.800781h-66.398438v-81.402344c0-8.28125-6.71875-15-15-15-9.449218 0-17.132812-7.683593-17.132812-17.132812v-48.199219c0-36.652344 29.84375-65.332031 65.332031-65.332031h13.253907c10.054687 0 20.097656 2.359375 29.070312 6.839843 0 0 74.402344 37 93.351562 46.4375 4.058594 2.015626 5.988282 6.75 4.492188 11.015626zm246.5-31.09375c0 4.582031-1.777344 8.882812-5.011719 12.117187-3.183593 3.1875-7.601562 5.015625-12.121093 5.015625h-200.46875c-.027344-.082031-.046876-.164062-.074219-.242188l37.226562-74.449218c3.703125-7.410156.703125-16.417969-6.707031-20.125-7.40625-3.703125-16.417969-.703125-20.125 6.707031l-31.75 63.496094c-5.917969-2.949219-12.796875-6.375-20.167969-10.039063v-159.214844c0-9.445312 7.683594-17.132812 17.132813-17.132812h224.933594c4.519531 0 8.9375 1.828125 12.125 5.023438 3.230468 3.226562 5.007812 7.527343 5.007812 12.109374zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 64.265625h-160.667969c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h160.667969c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 120.5h-80.335937c-8.28125 0-15 6.714844-15 15s6.71875 15 15 15h80.335937c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 176.734375h-80.335937c-8.28125 0-15 6.714844-15 15 0 8.28125 6.71875 15 15 15h80.335937c8.28125 0 15-6.71875 15-15 0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
                            <span class="mx-3 whitespace-no-wrap">Teaching</span>
                        </a>
                    </li>
                    <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'staffs' ? 'active':''}} && {{Request::segment ('2') == 'staff' ? 'active':''}} ">
                        <a href="{{ url('/admin/staffs') }}" class="flex items-center">
                            <svg class="w-5 h-5 fill-current text-white" viewBox="0 -12 480 480"  xmlns="http://www.w3.org/2000/svg"><path d="m56 232c-4.417969 0-8 3.582031-8 8v128c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-128c0-4.417969-3.582031-8-8-8zm0 0"/><path d="m115.519531 168c4.417969 0 8-3.582031 8-8 .003907-.875-.160156-1.746094-.480469-2.558594-.953124-3.085937-3.664062-5.292968-6.878906-5.601562-19.410156-1.816406-34.683594-17.359375-36.160156-36.800782.042969-.289062.042969-.585937 0-.878906v-.878906c-.039062-.425781-.039062-.855469 0-1.28125v-40h32.800781c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-40.800781c-4.417969 0-8 3.582031-8 8v35.679688c-10.15625-9.082032-15.972656-22.054688-16-35.679688v-48h96c15.691406.007812 30.390625 7.683594 39.359375 20.558594 2.609375 3.367187 7.394531 4.097656 10.890625 1.667968 3.496094-2.429687 4.476562-7.167968 2.230469-10.785156-11.957031-17.179687-31.554688-27.425781-52.480469-27.441406h-96c-8.835938 0-16 7.164062-16 16v48c-.109375 23.167969 12.316406 44.589844 32.480469 56 1.691406 12.128906 7.3125 23.371094 16 32h-24.480469c-30.929688 0-56 25.070312-56 56v160c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-160c0-22.089844 17.910156-40 40-40zm0 0"/><path d="m112 222.078125-5.761719-22.078125h26.082031c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-36.320312c-2.460938-.011719-4.792969 1.109375-6.320312 3.039062-1.515626 1.949219-2.046876 4.488282-1.441407 6.882813l8 32c1.0625 4.351563 5.449219 7.019531 9.800781 5.957031 4.351563-1.058594 7.019532-5.445312 5.960938-9.800781zm0 0"/><path d="m424 232c-4.417969 0-8 3.582031-8 8v128c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-128c0-4.417969-3.582031-8-8-8zm0 0"/><path d="m448 157.441406v-77.441406c0-44.183594-35.816406-80-80-80h-16c-23.585938.0429688-45.953125 10.496094-61.121094 28.558594-2.082031 2.15625-2.785156 5.292968-1.824218 8.128906.960937 2.835938 3.425781 4.898438 6.386718 5.34375 2.964844.445312 5.925782-.800781 7.679688-3.230469 12.136718-14.429687 30.023437-22.773437 48.878906-22.800781h16c35.347656 0 64 28.652344 64 64v72.558594c-1.8125 0-3.652344-.160156-5.519531-.480469h-27.199219c10.738281-10.566406 16.761719-25.011719 16.71875-40.078125v-48c0-4.417969-3.582031-8-8-8h-60.160156c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h52.160156v40c.09375 20.675781-15.582031 38.015625-36.160156 40-3.214844.308594-5.925782 2.515625-6.878906 5.601562-.320313.8125-.484376 1.683594-.480469 2.558594 0 4.417969 3.582031 8 8 8h21.917969l-30.398438 54.640625c-2.144531 3.863281-.746094 8.738281 3.121094 10.878907 1.195312.679687 2.542968 1.035156 3.917968 1.039062 2.886719-.003906 5.546876-1.5625 6.960938-4.078125l34.71875-62.640625h21.042969c3.957031.15625 7.867187.910156 11.597656 2.238281h.640625c15.734375 5.878907 26.121094 20.964844 26 37.761719v160c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-160c-.015625-21.617188-12.46875-41.296875-32-50.558594zm0 0"/><path d="m312 232h-26.800781c12.46875-10.0625 21.226562-24 24.878906-39.601562 20.847656-11.097657 33.886719-32.78125 33.921875-56.398438v-16c0-35.347656-28.652344-64-64-64h-128c-8.835938 0-16 7.164062-16 16v64c.035156 23.617188 13.074219 45.300781 33.921875 56.398438 3.652344 15.601562 12.410156 29.539062 24.878906 39.601562h-26.800781c-30.929688 0-56 25.070312-56 56v160c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-160c0-22.089844 17.910156-40 40-40h144c22.089844 0 40 17.910156 40 40v160c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-160c0-30.929688-25.070312-56-56-56zm-160-96v-64h128c26.507812 0 48 21.492188 48 48v16c-.027344 13.625-5.84375 26.597656-16 35.679688v-59.679688c0-4.417969-3.582031-8-8-8h-128c-4.417969 0-8 3.582031-8 8v59.679688c-10.15625-9.082032-15.972656-22.054688-16-35.679688zm32.960938 50.558594c.042968-.289063.042968-.585938 0-.878906-.5-2.804688-.820313-5.636719-.960938-8.480469v-57.199219h112v57.199219c-.117188 2.84375-.410156 5.675781-.878906 8.480469-.046875.292968-.046875.589843 0 .878906-4.96875 26.484375-28.09375 45.675781-55.042969 45.675781-26.945313 0-50.070313-19.191406-55.039063-45.675781zm0 0"/><path d="m265.921875 264c-4.285156-1.058594-8.617187 1.554688-9.683594 5.839844l-6.476562 26.160156h-19.523438l-6.238281-25.921875c-.59375-2.871094-2.710938-5.1875-5.515625-6.035156-2.808594-.851563-5.851563-.097657-7.941406 1.964843-2.085938 2.058594-2.875 5.09375-2.0625 7.914063l8 30.71875-8.480469 89.679687c-.21875 2.546876.792969 5.042969 2.71875 6.71875l24 20.960938c3.019531 2.652344 7.542969 2.652344 10.5625 0l24-20.960938c1.925781-1.675781 2.9375-4.171874 2.71875-6.71875l-8-89.679687 8-30.71875c.574219-2.128906.25-4.394531-.902344-6.273437-1.148437-1.875-3.023437-3.195313-5.175781-3.648438zm-25.921875 141.359375-16-13.359375 7.039062-80h17.28125l7.679688 80zm0 0"/><path d="m168 312c-4.417969 0-8 3.582031-8 8v128c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-128c0-4.417969-3.582031-8-8-8zm0 0"/><path d="m312 312c-4.417969 0-8 3.582031-8 8v128c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-128c0-4.417969-3.582031-8-8-8zm0 0"/></svg>
                            <span class="mx-3 whitespace-no-wrap">Non-Teaching</span>
                        </a>
                    </li>
                </ul>
            </li>

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'students' ? 'active':''}} && {{Request::segment ('2') == 'student' ? 'active':''}}">
                <a href="{{ url('/admin/students') }}" class="flex items-center">
                    <!--  <img src="{{asset('uploads/icons/sidebar/student.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M466,242.581c0-168.832,0.472-158.076-1.102-161.96c3.369-8.323-1.27-17.612-9.777-20.043l-210-60 c-2.693-0.77-5.548-0.77-8.241,0l-210,60C20.439,62.417,16,68.303,16,75.001s4.439,12.583,10.879,14.423L106,112.029 c0,0.679,0,1.306,0,1.891c0,5.083,0,6.755,0,6.727c0,8.27,0,25.579,0,59.353c0,58.278,30.068,108.896,73.87,133.718l-8.275,16.55 c-40.483,2.316-78.308,19.564-107.364,49.156C33.129,411.1,16,452.855,16,497.001c0,8.284,6.716,15,15,15h420 c8.284,0,15-6.716,15-15c0-44.145-17.129-85.9-48.231-117.575c-29.054-29.59-66.879-46.827-107.359-49.146l-8.281-16.561 C345.932,288.897,376,238.279,376,180.001c0-3.699,0-66.967,0-67.971l60-17.143v147.694c-17.459,6.192-30,22.865-30,42.42v30 c0,8.284,6.716,15,15,15h60c8.284,0,15-6.716,15-15v-30C496,265.446,483.459,248.772,466,242.581z M226,482.001H46.804 c7.103-65.907,60.46-117.899,126.328-121.761L226,439.543V482.001z M198.309,343.923l9.286-18.573 c10.687,3.034,21.879,4.651,33.405,4.651s22.717-1.617,33.404-4.65l9.286,18.572L241,407.959L198.309,343.923z M308.868,360.241    c65.868,3.86,119.225,55.853,126.328,121.76H256v-42.458L308.868,360.241z M241,300.001c-50.888,0-93.431-41.589-102.988-96.587 c31.678,14.133,67.086,21.587,102.988,21.587c35.9,0,71.308-7.453,102.987-21.584C334.43,258.413,291.887,300.001,241,300.001z M345.672,163.069c-0.872,4.334-3.441,7.986-7.037,9.752c-29.533,14.51-63.294,22.179-97.635,22.179 c-34.344,0-68.106-7.671-97.637-22.183c-4.892-2.403-7.363-7.967-7.363-13.031V120.6c108.861,31.103,101.999,29.4,105,29.4 c3,0-3.883,1.71,105-29.4C346,163.657,346.119,160.868,345.672,163.069z M241,119.401l-155.399-44.4L241,30.6l155.399,44.4 L241,119.401z M466,300.001h-30v-15c0-8.271,6.729-15,15-15s15,6.729,15,15V300.001z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M361,420.001h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S369.284,420.001,361,420.001z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">Students</span>
                </a>
            </li>
       <!--   <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'students' ? 'active':''}} && {{Request::segment ('2') == 'student' ? 'active':''}}">
                <a href="{{ url('/admin/students/blockedstudents') }}" class="flex items-center">
                  <img src="{{asset('uploads/icons/sidebar/student.svg')}}" class="w-5 h-5"> -->
                   <!-- <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M466,242.581c0-168.832,0.472-158.076-1.102-161.96c3.369-8.323-1.27-17.612-9.777-20.043l-210-60 c-2.693-0.77-5.548-0.77-8.241,0l-210,60C20.439,62.417,16,68.303,16,75.001s4.439,12.583,10.879,14.423L106,112.029 c0,0.679,0,1.306,0,1.891c0,5.083,0,6.755,0,6.727c0,8.27,0,25.579,0,59.353c0,58.278,30.068,108.896,73.87,133.718l-8.275,16.55 c-40.483,2.316-78.308,19.564-107.364,49.156C33.129,411.1,16,452.855,16,497.001c0,8.284,6.716,15,15,15h420 c8.284,0,15-6.716,15-15c0-44.145-17.129-85.9-48.231-117.575c-29.054-29.59-66.879-46.827-107.359-49.146l-8.281-16.561 C345.932,288.897,376,238.279,376,180.001c0-3.699,0-66.967,0-67.971l60-17.143v147.694c-17.459,6.192-30,22.865-30,42.42v30 c0,8.284,6.716,15,15,15h60c8.284,0,15-6.716,15-15v-30C496,265.446,483.459,248.772,466,242.581z M226,482.001H46.804 c7.103-65.907,60.46-117.899,126.328-121.761L226,439.543V482.001z M198.309,343.923l9.286-18.573 c10.687,3.034,21.879,4.651,33.405,4.651s22.717-1.617,33.404-4.65l9.286,18.572L241,407.959L198.309,343.923z M308.868,360.241    c65.868,3.86,119.225,55.853,126.328,121.76H256v-42.458L308.868,360.241z M241,300.001c-50.888,0-93.431-41.589-102.988-96.587 c31.678,14.133,67.086,21.587,102.988,21.587c35.9,0,71.308-7.453,102.987-21.584C334.43,258.413,291.887,300.001,241,300.001z M345.672,163.069c-0.872,4.334-3.441,7.986-7.037,9.752c-29.533,14.51-63.294,22.179-97.635,22.179 c-34.344,0-68.106-7.671-97.637-22.183c-4.892-2.403-7.363-7.967-7.363-13.031V120.6c108.861,31.103,101.999,29.4,105,29.4 c3,0-3.883,1.71,105-29.4C346,163.657,346.119,160.868,345.672,163.069z M241,119.401l-155.399-44.4L241,30.6l155.399,44.4 L241,119.401z M466,300.001h-30v-15c0-8.271,6.729-15,15-15s15,6.729,15,15V300.001z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M361,420.001h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S369.284,420.001,361,420.001z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">Blocked Students</span>
                </a>
            </li> --> 

            <li class="py-3 px-3 hover:font-semibold{{Request::segment ('2') == 'parents' ? 'active':''}} && {{Request::segment ('2') == 'parent' ? 'active':''}}">
                <a href="{{ url('/admin/parents') }}" class="flex items-center">
                    <!--  <img src="{{asset('uploads/icons/sidebar/student.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M71.069,354.63c-1.859-1.86-4.439-2.92-7.069-2.92s-5.21,1.06-7.07,2.92c-1.86,1.86-2.93,4.439-2.93,7.08 c0,2.63,1.069,5.2,2.93,7.06c1.86,1.87,4.44,2.94,7.07,2.94s5.21-1.07,7.069-2.94c1.861-1.86,2.931-4.44,2.931-7.06 C74,359.08,72.93,356.5,71.069,354.63z"/></g></g><g><g><path d="M484.095,282.754l-0.716-0.743c-3.845-3.965-10.177-4.063-14.141-0.217c-3.965,3.845-4.062,10.176-0.217,14.141 l0.594,0.616c1.966,2.063,4.602,3.102,7.242,3.102c2.478,0,4.96-0.916,6.896-2.76 C487.751,293.083,487.904,286.753,484.095,282.754z"/></g></g><g><g><path d="M505.89,317.818c-1.895-5.188-7.635-7.857-12.823-5.964c-5.188,1.895-7.858,7.636-5.964,12.823 c3.25,8.899,4.897,18.265,4.897,27.835V465h-34V361.705c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10V465h-79.464v-77.749 c0-33.581-22.735-62.688-55.289-70.781c-0.137-0.034-0.273-0.065-0.411-0.094l-0.786-0.161 c8.261-8.487,14.198-19.236,16.772-31.222l34.632,55.38c1.828,2.923,5.032,4.698,8.479,4.698c3.447,0,6.651-1.776,8.479-4.699 l43.097-68.946c8.763,0.281,17.332,1.934,25.502,4.957c1.145,0.423,2.316,0.624,3.469,0.624c4.065,0,7.887-2.498,9.38-6.533 c1.916-5.181-0.729-10.933-5.909-12.849c-9.599-3.551-19.628-5.592-29.877-6.112c18.239-15.421,29.85-38.448,29.85-64.146v-31.431 v-17.814V133c0-0.933-0.137-1.832-0.376-2.688c-3.955-42.668-39.941-76.189-83.624-76.189h-0.001 c-43.683,0-79.668,33.521-83.623,76.189c-0.239,0.856-0.376,1.755-0.376,2.688v5.123v17.814v31.431 c0,4.391,0.342,8.702,0.994,12.913c-5.805-2.224-12.01-3.625-18.478-4.069v-58.468C260.44,76.679,210.762,27,149.697,27 S38.953,76.679,38.953,137.744v135.059C15.259,291.331,0,320.172,0,352.513V475c0,5.522,4.478,10,10,10h492 c5.522,0,10-4.478,10-10V352.513C512,340.595,509.944,328.922,505.89,317.818z M361.931,316.208l-32.013-51.191 c9.871,4.084,20.677,6.351,32.006,6.351h28.036L361.931,316.208z M297.925,138.123c-0.001-35.29,28.709-64,63.999-64 c35.29,0,64,28.71,64,64v0.341l-34.438-20.232c-4.211-2.475-9.593-1.544-12.73,2.199c-13.583,16.209-33.502,25.506-54.65,25.506 h-26.181V138.123z M297.924,165.937h26.181c24.218,0,47.177-9.521,64.2-26.378l37.619,22.101v25.708c0,35.29-28.711,64-64.001,64 c-35.289,0-63.999-28.71-63.999-64V165.937z M150.076,251.368c-35.29,0-64-28.71-64-64v-21.431h26.182 c24.218,0,47.177-9.521,64.2-26.378l37.618,22.101v25.708C214.076,222.658,185.366,251.368,150.076,251.368z M181.578,265.216 l-31.874,50.992l-28.041-44.84h28.413C161.215,271.368,171.843,269.17,181.578,265.216z M211.742,261.333H243.6 c6.688,0,13.166-1.783,18.829-4.999l17.178,4.652c0.853,0.231,1.731,0.349,2.614,0.349h18.037v10.19 c0,24.356-19.854,44.172-44.258,44.172s-44.258-19.815-44.258-44.172V261.333z M295.98,241.334h-12.429l-5.961-1.614 c0.94-4.127-0.824-8.56-4.663-10.828c-4.755-2.809-10.886-1.232-13.696,3.522c-3.251,5.502-9.24,8.92-15.631,8.92h-27.58 c7.116-14.941,22.359-25.293,39.98-25.293C273.621,216.041,288.864,226.394,295.98,241.334z M58.953,137.744 C58.953,87.708,99.661,47,149.697,47s90.743,40.708,90.743,90.744v60.212c-2.515,0.628-4.969,1.409-7.358,2.325 c0.652-4.21,0.994-8.522,0.994-12.913v-31.431c0-3.497-1.92-6.851-4.935-8.622l-49.503-29.083 c-4.211-2.474-9.592-1.544-12.73,2.199c-13.583,16.209-33.502,25.506-54.65,25.506H76.076c-5.522,0-10,4.477-10,10v31.431 c0,25.692,11.606,48.714,29.837,64.135c-13.133,0.672-25.609,3.866-36.96,9.098V137.744z M153.464,465H74v-59.333 c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10V465H20V352.513c0-43.73,34.776-79.471,78.123-81.068l43.104,68.928 c1.828,2.923,5.032,4.698,8.479,4.698c3.447,0,6.651-1.776,8.479-4.699l34.891-55.818c2.522,12.161,8.509,23.064,16.868,31.655 l-0.86,0.183c-0.111,0.024-0.222,0.05-0.331,0.077c-32.554,8.094-55.289,37.2-55.289,70.781V465z M338.536,465h-29.229v-62 c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10v62h-76v-62c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10v62h-19.844v-77.749 c0-24.319,16.423-45.404,39.957-51.333l20.106-4.281c6.999,2.618,14.57,4.059,22.473,4.059c7.793,0,15.266-1.395,22.183-3.945 l20.433,4.176c23.517,5.94,39.921,27.016,39.921,51.324V465z"/></g></g><g><g><path d="M337.16,175.83c-1.86-1.86-4.44-2.93-7.07-2.93c-2.64,0-5.21,1.07-7.07,2.93c-1.87,1.86-2.93,4.44-2.93,7.07 c0,2.64,1.06,5.21,2.93,7.07c1.86,1.87,4.431,2.93,7.07,2.93c2.63,0,5.21-1.06,7.07-2.93c1.859-1.86,2.93-4.43,2.93-7.07 C340.09,180.27,339.02,177.69,337.16,175.83z"/></g></g><g><g><path d="M400.83,175.83c-1.86-1.86-4.44-2.93-7.07-2.93s-5.21,1.07-7.07,2.93c-1.859,1.86-2.93,4.44-2.93,7.07 c0,2.64,1.07,5.21,2.93,7.07c1.86,1.87,4.44,2.93,7.07,2.93s5.21-1.06,7.07-2.93c1.859-1.86,2.93-4.44,2.93-7.07 S402.69,177.69,400.83,175.83z"/></g></g><g><g><path d="M380.686,207.885c-3.906-3.905-10.236-3.905-14.142,0c-2.629,2.63-6.908,2.63-9.537,0c-3.906-3.905-10.236-3.905-14.143,0 c-3.905,3.905-3.905,10.237,0,14.143c5.214,5.213,12.063,7.82,18.911,7.82s13.697-2.607,18.911-7.82 C384.591,218.123,384.591,211.791,380.686,207.885z"/></g></g><g><g><path d="M125.309,175.83c-1.859-1.86-4.439-2.93-7.069-2.93c-2.631,0-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07 s1.069,5.21,2.93,7.07c1.86,1.87,4.439,2.93,7.07,2.93c2.63,0,5.21-1.06,7.069-2.93c1.86-1.86,2.931-4.44,2.931-7.07 S127.17,177.69,125.309,175.83z"/></g></g><g><g><path d="M188.979,175.83c-1.859-1.86-4.43-2.93-7.069-2.93c-2.63,0-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07 s1.069,5.21,2.93,7.07c1.861,1.86,4.44,2.93,7.07,2.93c2.64,0,5.21-1.07,7.069-2.93c1.87-1.86,2.931-4.44,2.931-7.07 S190.849,177.69,188.979,175.83z"/></g></g><g><g><path d="M168.84,207.885c-3.906-3.905-10.236-3.905-14.143,0c-2.629,2.63-6.908,2.63-9.537,0c-3.906-3.905-10.236-3.905-14.143,0 c-3.905,3.906-3.905,10.238,0.001,14.143c5.214,5.213,12.063,7.82,18.911,7.82c6.848,0,13.697-2.607,18.911-7.82 C172.745,218.123,172.745,211.791,168.84,207.885z"/></g></g><g><g><path d="M274.911,282.7c-3.906-3.904-10.236-3.904-14.143,0c-2.629,2.631-6.908,2.631-9.537,0c-3.906-3.904-10.236-3.904-14.143,0 c-3.905,3.905-3.905,10.237,0,14.143c5.215,5.214,12.063,7.82,18.912,7.82s13.697-2.606,18.911-7.82 C278.816,292.938,278.816,286.606,274.911,282.7z"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Parents</span>
                </a>
            </li>
@if(config('galumni.enabled', false))
            <li class="py-3 px-3 hover:font-semibold">
                <a href="{{ url('/admin/alumni') }}" class="flex items-center">
                    <!--  <img src="{{asset('uploads/icons/sidebar/teacher.svg')}}" class="w-5 h-5"> -->
                    <svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="225.000000pt" height="225.000000pt" viewBox="0 0 225.000000 225.000000" preserveAspectRatio="xMidYMid meet" class="w-6 h-6" style="enable-background:new 0 0 512.001 512.001; filter: invert(1);"><g transform="translate(0.000000,225.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none"><path d="M503 1835 c-166 -34 -309 -65 -317 -68 -19 -8 -21 -43 -4 -54 7 -4 78 -21 157 -38 l143 -30 -1 -135 -2 -135 -30 -30 c-28 -30 -29 -34 -29 -132 l0 -101 35 -31 c20 -17 42 -31 50 -31 8 0 15 -9 15 -20 0 -12 7 -55 16 -96 l15 -76 -42 -64 -41 -64 -64 0 c-128 0 -253 -47 -316 -119 -66 -74 -108 -222 -73 -251 27 -22 49 0 56 56 12 96 72 174 164 215 37 17 74 24 145 27 l95 3 172 -120 c94 -67 176 -121 183 -121 6 0 89 54 183 121 l172 121 95 -4 c180 -8 286 -90 308 -239 8 -59 30 -81 57 -59 13 11 15 24 10 64 -24 185 -181 306 -395 306 l-66 0 -43 61 -43 61 16 79 c9 44 16 88 16 99 0 11 7 20 15 20 8 0 30 14 50 31 l35 31 0 114 c0 101 -2 116 -20 134 -11 11 -24 20 -29 20 -6 0 -11 57 -13 130 -3 124 -2 131 17 135 51 12 167 35 176 35 5 0 9 -59 9 -137 0 -120 -5 -158 -34 -288 -24 -105 -31 -154 -24 -162 16 -19 187 -18 194 1 5 12 -32 203 -51 266 -4 13 15 18 108 28 62 6 135 18 162 27 27 8 53 11 57 7 4 -4 17 -44 28 -87 24 -95 47 -151 105 -255 l42 -77 -32 -43 c-18 -24 -50 -56 -71 -73 -45 -34 -171 -97 -194 -97 -51 0 -52 -62 -2 -155 l37 -70 135 -11 c143 -12 202 -24 263 -55 41 -21 77 -71 77 -105 0 -42 52 -57 66 -20 3 8 0 33 -6 57 -32 117 -189 189 -411 189 l-75 0 -27 52 -27 51 88 42 c98 47 188 122 229 192 25 43 25 46 9 79 -9 19 -16 37 -16 39 0 3 27 5 60 5 46 0 62 4 67 16 3 9 -11 91 -31 183 -31 143 -36 185 -36 293 l0 126 29 7 c31 7 44 25 35 49 -3 8 -29 20 -57 25 -29 6 -182 36 -340 67 l-288 55 -153 -31 -154 -32 -153 31 c-84 17 -160 31 -168 30 -9 0 -152 -29 -318 -64z m559 -48 c119 -23 219 -45 222 -48 3 -3 -98 -26 -224 -52 l-229 -46 -225 47 c-123 25 -223 48 -221 51 6 5 415 89 440 90 11 0 118 -19 237 -42z m607 3 c113 -22 217 -43 231 -46 17 -4 -54 -23 -210 -55 -129 -26 -236 -48 -237 -49 -2 0 -3 13 -3 28 0 22 7 30 30 39 20 8 30 18 30 32 0 25 -18 33 -115 52 l-70 13 50 12 c72 17 70 18 294 -26z m341 -231 c0 -93 -6 -146 -25 -232 -37 -162 -34 -156 -60 -99 -12 27 -26 64 -30 83 -13 67 -47 159 -71 195 -20 29 -24 46 -22 87 l3 52 80 16 c137 29 125 38 125 -102z m-1317 42 l136 -29 118 24 c65 13 128 26 141 29 21 5 22 3 22 -68 l0 -74 -62 -14 c-39 -9 -123 -14 -218 -14 -95 0 -179 5 -217 14 l-63 14 0 73 c0 41 2 74 3 74 2 0 65 -13 140 -29z m1037 -29 c0 -32 5 -63 11 -69 8 -8 2 -14 -23 -21 -56 -18 -148 -32 -210 -32 l-59 0 3 62 3 62 130 27 c72 15 133 27 138 28 4 1 7 -25 7 -57z m-1045 -183 c110 -16 249 -10 387 16 l37 7 3 -43 c3 -40 6 -44 33 -49 l30 -5 3 -84 c3 -92 -3 -106 -51 -117 -47 -10 -57 -22 -57 -70 0 -109 -55 -252 -117 -303 -20 -17 -56 -34 -80 -39 -58 -13 -121 2 -166 39 -62 51 -117 194 -117 303 0 47 -9 60 -55 70 -49 12 -55 23 -55 103 0 74 0 74 35 94 31 18 35 26 35 61 l0 40 38 -7 c20 -4 64 -11 97 -16z m61 -747 c108 -31 188 -9 271 74 l61 62 25 -37 25 -38 -141 -99 c-78 -54 -147 -100 -153 -102 -9 -2 -258 163 -296 197 -4 4 4 23 17 44 l25 37 63 -63 c43 -43 75 -67 103 -75z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Alumni</span>
                </a>
            </li>
            @endif
        </ul>
    </li>
    <!-- end -->

    <!--start-->
    <li class="py-3 px-3  {{Request::segment ('2') == 'standardlinks' ? 'active':''}} && {{Request::segment ('2') == 'standardlink' ? 'active':''}} && {{Request::segment ('2') == 'standardLink' ? 'active':''}}">
        <a href="{{url('/admin/standardlinks')}}" class="flex items-center whitespace-no-wrap">
            <!--  <img src="{{asset('uploads/icons/sidebar/reader.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 511.998 511.998" style="enable-background:new 0 0 511.998 511.998;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M386.872,397.626c-2.031-5.158-7.859-7.698-13.02-5.663l-70.492,27.755c-5.159,2.031-7.695,7.86-5.663,13.02 c1.556,3.951,5.339,6.364,9.344,6.364c1.223,0,2.468-0.226,3.675-0.701l70.492-27.755    C386.368,408.615,388.904,402.786,386.872,397.626z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M402.433,381.438c-12.919,0-12.94,20.078,0,20.078C415.352,401.516,415.374,381.438,402.433,381.438z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M478.201,247.628c-0.138-0.66-0.34-1.295-0.6-1.9c0,0-0.001-0.002-0.001-0.003c-0.006-0.013-0.013-0.025-0.019-0.039 c-0.125-0.289-0.263-0.57-0.415-0.844c-0.064-0.117-0.139-0.228-0.208-0.341c-0.097-0.162-0.192-0.324-0.298-0.48 c-0.109-0.161-0.23-0.312-0.347-0.465c-0.077-0.099-0.151-0.203-0.232-0.3c-0.138-0.165-0.284-0.319-0.431-0.474 c-0.075-0.079-0.147-0.161-0.225-0.238c-0.149-0.147-0.304-0.282-0.46-0.419c-0.089-0.078-0.177-0.159-0.269-0.234 c-0.146-0.117-0.296-0.226-0.448-0.334c-0.115-0.083-0.229-0.17-0.347-0.248c-0.133-0.088-0.272-0.168-0.409-0.249 c-0.146-0.086-0.29-0.175-0.44-0.254c-0.12-0.063-0.246-0.118-0.368-0.178c-0.171-0.081-0.341-0.164-0.518-0.236 c-0.12-0.049-0.244-0.089-0.365-0.134c-0.181-0.065-0.36-0.133-0.546-0.189c-0.147-0.044-0.296-0.077-0.445-0.114 c-0.162-0.04-0.321-0.084-0.486-0.117c-0.221-0.044-0.444-0.073-0.668-0.102c-0.095-0.012-0.19-0.031-0.286-0.04 c-1.046-0.105-2.117-0.043-3.177,0.195c-0.616,0.137-1.213,0.326-1.781,0.571l-54.72,23.5 c-23.478-40.073-61.031-68.797-104.573-81.214c29.199-16.986,48.872-48.62,48.872-84.765C353.991,43.955,310.031,0,255.999,0 c-54.028,0-97.982,43.954-97.982,97.982c0,36.145,19.672,67.778,48.868,84.765c-43.537,12.416-81.091,41.139-104.576,81.212 l-54.722-23.498c-0.618-0.266-1.268-0.475-1.943-0.612c-0.673-0.139-1.35-0.204-2.021-0.204c-0.002,0-0.004,0-0.005,0 c-0.329,0-0.656,0.017-0.981,0.049c-0.122,0.012-0.241,0.035-0.362,0.051c-0.199,0.027-0.397,0.052-0.592,0.09 c-0.182,0.035-0.357,0.083-0.535,0.128c-0.133,0.034-0.266,0.063-0.397,0.102c-0.197,0.058-0.388,0.13-0.579,0.2 c-0.111,0.041-0.224,0.077-0.334,0.122c-0.184,0.075-0.361,0.161-0.54,0.246c-0.116,0.055-0.234,0.107-0.348,0.168 c-0.156,0.082-0.305,0.173-0.455,0.262c-0.133,0.079-0.266,0.156-0.396,0.24c-0.122,0.08-0.238,0.168-0.356,0.254 c-0.149,0.107-0.297,0.214-0.441,0.329c-0.093,0.076-0.182,0.158-0.272,0.237c-0.156,0.135-0.31,0.27-0.458,0.416 c-0.078,0.077-0.151,0.16-0.226,0.24c-0.147,0.155-0.292,0.308-0.43,0.472c-0.081,0.097-0.155,0.2-0.232,0.3 c-0.118,0.154-0.238,0.304-0.348,0.465c-0.106,0.155-0.201,0.318-0.298,0.479c-0.069,0.115-0.143,0.224-0.208,0.342 c-0.152,0.274-0.288,0.555-0.415,0.844c-0.006,0.013-0.013,0.025-0.019,0.039c0,0.001-0.001,0.002-0.001,0.002 c-0.26,0.606-0.463,1.242-0.6,1.901c-0.144,0.685-0.213,1.373-0.213,2.057V410.75c0,4.014,2.39,7.641,6.078,9.224l212.378,91.206 c0.348,0.15,0.702,0.274,1.056,0.383c0.059,0.018,0.12,0.029,0.179,0.046c0.377,0.107,0.756,0.189,1.136,0.25 c0.09,0.014,0.181,0.029,0.271,0.041c0.439,0.058,0.877,0.098,1.315,0.098c0.039,0,0.077-0.008,0.117-0.009 c0.385-0.004,0.77-0.035,1.153-0.084c0.128-0.016,0.254-0.036,0.38-0.058c0.344-0.057,0.686-0.132,1.024-0.226 c0.078-0.022,0.158-0.037,0.236-0.061c0.356-0.107,0.709-0.232,1.055-0.38l212.378-91.206c3.687-1.583,6.078-5.21,6.078-9.224    V249.685C478.415,249.001,478.346,248.313,478.201,247.628z M178.093,97.983c0-42.956,34.947-77.904,77.904-77.904 c42.962,0,77.914,34.948,77.914,77.904c0,42.963-34.951,77.914-77.914,77.914C213.04,175.897,178.093,140.946,178.093,97.983z M245.957,486.722l-192.3-82.583V264.92h0.001l48.648,20.89c0.134,0.064,0.27,0.126,0.407,0.186l143.245,61.51V486.722z M255.996,329.964l-135.104-58.013c28.622-47.125,79.447-75.975,135.105-75.975c55.666,0,106.49,28.848,135.103,75.969 L255.996,329.964z M458.336,404.138l-192.3,82.583V347.504l192.3-82.583V404.138z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Classes</span>
        </a>
    </li>
    <!--end-->
    @if(config('gcertificate.enabled', false))
    <!--start-->
        <li class="py-3 px-3  {{Request::segment ('2') == 'certificate' ? 'active':''}}">
        <a href="{{url('/admin/certificate/index')}}" class="flex items-center whitespace-no-wrap">
            <!--  <img src="{{asset('uploads/icons/sidebar/reader.svg')}}" class="w-5 h-5"> -->
           <img src="{{asset('uploads/certificate.png')}}" class="w-5 h-5">
            <span class="mx-3 whitespace-no-wrap">Certificates</span>
        </a>
    </li>
    @endif
    <!--end-->

    @php
        $class='';
        $array=array('timetable');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
        {{--<li class="relative py-3 px-3  {{$class}}">
    <a href="#" class="flex items-center cursor-not-allowed">
            <!--  <img src="{{asset('uploads/icons/sidebar/settings.svg')}}" class="w-5 h-5"> -->
           <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512.012 512.012" height="512" viewBox="0 0 512.012 512.012" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m511.978 38.997h-40.959v-38.997h-30v38.997h-70.006v-38.997h-30v38.997h-70.006v-38.997h-30v38.997h-70.007v-38.997h-30v38.997h-70.007v-38.997h-30v38.997h-40.959v369.708h120.086c16.532 59.505 71.186 103.307 135.886 103.307s119.354-43.802 135.886-103.307h120.086zm-30 30v49.857h-451.944v-49.857zm-225.972 413.015c-61.212 0-111.013-49.8-111.013-111.013s49.8-111.013 111.013-111.013 111.013 49.801 111.013 111.014-49.8 111.012-111.013 111.012zm140.8-103.307c.138-2.552.213-5.12.213-7.706 0-77.755-63.258-141.013-141.013-141.013s-141.013 63.259-141.013 141.014c0 2.586.075 5.154.213 7.706h-85.172v-229.852h451.943v229.852h-85.171z"/><path d="m271.006 294.129h-30v91.871h65.147v-30h-35.147z"/></g></svg>

            <span class="ml-3 whitespace-no-wrap flex items-center justify-between w-10/12">TimeTable
            <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>

        </a>

    <ul class="list-reset sites-sidebar">
         @php
                $class='';
                $array=array('detail');
                if(in_array(\Request()->segment('3'),$array))
                {
                    $class_detail='active';
                }
            @endphp
            <li class="py-3 px-3  {{$class_detail}}">
             <a href="{{ url('/admin/timetable/detail') }}" class="flex  items-center">

         <!--  <img src="{{asset('uploads/icons/sidebar/student.svg')}}" class="w-5 h-5"> -->
         <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 511.996 511.996" height="512" viewBox="0 0 511.996 511.996" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m40.353 511.996h428.195c13.015 0 23.604-10.659 23.604-23.761v-12.053c0-6.067-4.921-11.004-10.97-11.004h-9.36c1.882-3.799 2.945-8.029 2.945-12.427v-156.499c0-15.596-12.688-28.285-28.284-28.285h-97.077c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h97.077c7.325 0 13.284 5.959 13.284 13.285v156.499c0 5.502-3.5 10.48-8.623 12.427h-229.337c-5.29-2.026-8.636-7.106-8.636-12.427 0-15.342 0-141.27 0-156.499 0-7.325 5.96-13.285 13.285-13.285h87.95c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5h-55.218l-.016-19.279c17.179-12.574 29.077-31.932 31.736-54.099 19.515-1.711 34.036-17.268 34.036-35.4 0-12.417-6.299-23.904-16.102-30.579 1.042-2.496 1.622-5.231 1.622-8.101v-14.699c0-4.142-3.357-7.5-7.5-7.5s-7.5 3.358-7.5 7.5v14.701c0 3.26-2.599 6.156-6.375 6.094-10.322-.151-18.194-8.706-18.194-18.447 0-4.063-2.754-7.591-6.697-8.58-4.021-1.005-8.07.913-9.937 4.4-7.466 13.965-21.925 22.641-37.734 22.641h-85.865c-7.192 0-13.668-5.844-13.668-13.668v-55.177c0-23.586 19.188-42.774 42.774-42.774h75.654c17.569 0 20.542 7.759 22.232 16.404 1.999 10.223 11.572 17.311 22.287 16.487 7.525-.578 15.521 5.941 15.521 15.042v7.877c0 4.142 3.357 7.5 7.5 7.5s7.5-3.358 7.5-7.5v-7.877c0-18.073-15.671-31.228-31.672-29.998-3.174.252-5.868-1.611-6.416-4.41-3.753-19.194-15.84-28.525-36.953-28.525h-75.654c-31.856 0-57.774 25.917-57.774 57.774v55.176c0 7.854 3.177 14.979 8.311 20.162-7.256 6.847-11.698 16.362-11.698 26.173 0 18.063 14.473 33.647 34.031 35.313 2.587 21.77 14.057 41.242 31.681 54.002v19.365c-20.046 7.829-80.417 31.408-100.662 39.314-.042.016-.084.033-.126.05-21.04 8.659-43.685 33.472-43.685 67.487v116.669c-.001 11.31 9.199 20.511 20.508 20.511zm251.138-370.485c2.347-.247 4.709-.923 6.654-1.824 6.983 3.552 11.798 11.295 11.798 19.503 0 10.254-8.151 18.514-18.452 20.221zm-159.434 37.918c-10.305-1.668-18.452-9.918-18.452-20.144 0-7.176 4.422-14.39 11.004-18.316 3.241.699 5.482.649 7.448.649zm345.095 300.749v8.057c0 4.831-3.859 8.761-8.604 8.761h-264.16c-4.744 0-8.604-3.93-8.604-8.761v-8.057zm-250.696-212.211c-13.184 0-24.288 9.067-27.409 21.292l-19.789-19.789c.079-1.246.059 1.038.059-12.333 10.814 4.671 22.143 6.719 33.487 6.719 11.149 0 21.756-2.345 31.375-6.545l.009 10.656zm-79.399-82.797v-43.552h69.469c16.579 0 31.984-7.077 42.718-18.875 3.521 7.24 9.586 13.011 17.016 16.185.078.033.153.071.231.104v46.139c0 21.619-11 41.567-28.861 53.281-42.963 27.209-100.573-1.966-100.573-53.282zm23.247 96.561 27.866 27.865v14.33l-7.483 7.483c-.972.973-2.608.973-3.58 0l-40.445-40.444zm-135.46 93.086c0-28.912 20.51-47.873 34.334-53.592l62.228-24.303 45.093 45.093c5.873 5.873 14.888 6.704 21.671 2.465v108.271c0 4.137.989 8.521 2.923 12.427h-9.338c-6.049 0-10.971 4.937-10.971 11.004v12.053c0 3.108.623 6.132 1.662 8.761h-84.487c0-12.675 0-92.766 0-111.665 0-4.142-3.357-7.5-7.5-7.5s-7.5 3.358-7.5 7.5v18.416h-48.115zm0 43.93h48.115v18.667h-48.115zm0 33.667h48.115v44.583h-42.606c-3.037 0-5.509-2.472-5.509-5.509z"/><path d="m252.708 337.573c-4.419 2.214-7.164 6.66-7.164 11.603s2.745 9.389 7.165 11.604l17.314 8.675v41.11c0 6.947 3.741 13.281 9.764 16.528 32.483 17.514 71.824 17.477 104.238 0 1.959-1.057 3.672-2.444 5.099-4.069l-.498 1.9c-2.565 9.784 4.808 19.351 14.933 19.351h14.42c10.113 0 17.501-9.557 14.934-19.351 0 0 0 0 0-.001l-3.205-12.226c-1.557-5.939-5.881-10.574-11.438-12.773v-50.748c0-4.943-2.745-9.389-7.165-11.604l-70.289-35.218c-5.578-2.795-12.238-2.794-17.816 0zm158.06 75.948c2.44-.014 3.995 1.327 4.429 2.979l3.205 12.227c.073.282-.132.548-.424.548h-14.42c-.289 0-.498-.264-.423-.548l3.205-12.228c.436-1.661 1.949-2.995 4.428-2.978zm-16.979-44.066 9.479-4.75v35.21c-3.979 1.576-7.328 4.409-9.479 8.084zm-15 41.11c0 1.403-.739 2.708-1.883 3.325-28.035 15.117-62.023 15.086-90 0-1.144-.617-1.883-1.922-1.883-3.325v-33.595l37.975 19.027c5.461 2.738 12.126 2.851 17.816 0l37.975-19.027zm-44.694-94.799 51.712 25.91h-53.901c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h53.903c-5.239 2.625-45.896 22.996-51.714 25.911-1.371.687-3.008.687-4.379 0l-66.682-33.411 66.682-33.41c1.371-.687 3.008-.687 4.379 0z"/></g></svg>
          <span class="mx-3 whitespace-no-wrap">Teacher Detail</span>
        </a>
      </li>
      @php
                $class='';
                $array=array('creator');
                if(in_array(\Request()->segment('3'),$array))
                {
                    $class_creator='active';
                }
            @endphp
            <li class="py-3 px-3  {{$class_creator}}">
                <a  href="{{ url('/admin/timetable/creator') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 512.05 512.05" style="enable-background:new 0 0 512.05 512.05;" xml:space="preserve" width="512" height="512">
<g id="XMLID_1315_">
    <g id="XMLID_1295_">
        <g id="XMLID_1296_">
            <g id="XMLID_1297_">
                <path id="XMLID_1314_" d="M233.235,305h-24.373v-92.12c0-4.044-2.437-7.691-6.173-9.239c-3.737-1.548-8.038-0.691-10.898,2.167      l-26.144,26.144c-3.905,3.905-3.905,10.237,0,14.143c3.905,3.905,10.237,3.905,14.143,0l9.072-9.073V305h-24.374      c-5.523,0-10,4.477-10,10s4.477,10,10,10h68.747c5.523,0,10-4.477,10-10S238.758,305,233.235,305z"/>
                <path id="XMLID_1313_" d="M226.028,389.995c-2.63,0-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.08      c0,2.63,1.07,5.2,2.93,7.07c1.86,1.86,4.44,2.92,7.07,2.92c2.63,0,5.21-1.06,7.07-2.92c1.86-1.87,2.93-4.44,2.93-7.07      c0-2.64-1.07-5.22-2.93-7.08C231.238,391.065,228.658,389.995,226.028,389.995z"/>
                <path id="XMLID_1311_" d="M351.207,154.075c1.86-1.87,2.93-4.44,2.93-7.08c0-2.63-1.07-5.2-2.93-7.07      c-1.86-1.86-4.44-2.93-7.07-2.93s-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07c0,2.64,1.07,5.22,2.93,7.08      c1.86,1.86,4.44,2.92,7.07,2.92S349.347,155.935,351.207,154.075z"/>
                <path id="XMLID_1303_" d="M474.593,293.601c-22.428-22.428-51.177-34.77-80.565-37.04V70c0-16.542-13.458-30-30-30h-54.063v-6      c0-18.748-15.252-34-34-34s-34,15.252-34,34v6h-89.873v-6c0-18.748-15.252-34-34-34s-34,15.252-34,34v6H30.028      c-16.542,0-30,13.458-30,30v310c0,16.542,13.458,30,30,30h156c5.523,0,10-4.477,10-10s-4.477-10-10-10h-156      c-5.514,0-10-4.486-10-10V157h284.109c5.523,0,10-4.477,10-10s-4.477-10-10-10H20.028V70c0-5.514,4.486-10,10-10h54.063v16.5      c0,18.748,15.252,34,34,34s34-15.252,34-34V60h89.873v16.5c0,18.748,15.252,34,34,34s34-15.252,34-34V60h54.063      c5.514,0,10,4.486,10,10v186.57c-29.35,2.292-58.055,14.631-80.455,37.031c-24.176,24.176-37.49,56.32-37.49,90.51      s13.314,66.333,37.49,90.51c24.954,24.954,57.732,37.43,90.51,37.43c32.778,0,65.556-12.477,90.51-37.43      C524.499,424.713,524.499,343.508,474.593,293.601z M132.091,76.5c0,7.72-6.28,14-14,14s-14-6.28-14-14V34c0-7.72,6.28-14,14-14      s14,6.28,14,14V76.5z M289.964,76.5c0,7.72-6.28,14-14,14s-14-6.28-14-14V34c0-7.72,6.28-14,14-14s14,6.28,14,14V76.5z       M460.45,460.478c-42.108,42.109-110.626,42.11-152.735,0c-42.109-42.109-42.109-110.625,0-152.734      c21.054-21.055,48.711-31.582,76.367-31.582c27.657,0,55.313,10.527,76.368,31.582      C502.559,349.852,502.559,418.369,460.45,460.478z"/>
                <path id="XMLID_1302_" d="M383.988,450.073c-5.523,0-10,4.477-10,10v7.207c0,5.523,4.477,10,10,10s10-4.477,10-10v-7.207      C393.988,454.55,389.511,450.073,383.988,450.073z"/>
                <path id="XMLID_1301_" d="M383.988,318.147c5.523,0,10-4.477,10-10v-7.207c0-5.523-4.477-10-10-10s-10,4.477-10,10v7.207      C373.988,313.67,378.465,318.147,383.988,318.147z"/>
                <path id="XMLID_1300_" d="M308.12,374.015h-7.207c-5.523,0-10,4.477-10,10s4.477,10,10,10h7.207c5.523,0,10-4.477,10-10      S313.643,374.015,308.12,374.015z"/>
                <path id="XMLID_1299_" d="M467.252,374.206h-7.207c-5.523,0-10,4.477-10,10s4.477,10,10,10h7.207c5.523,0,10-4.477,10-10      S472.775,374.206,467.252,374.206z"/>
                <path id="XMLID_1298_" d="M430.032,323.854l-45.867,46.01l-18.405-19.271c-3.813-3.994-10.144-4.141-14.138-0.325      c-3.994,3.814-4.14,10.144-0.325,14.138l25.415,26.61c1.887,1.976,4.5,3.093,7.231,3.093h0.14c2.658,0,5.206-1.058,7.082-2.94      l53.031-53.196c3.899-3.911,3.889-10.243-0.022-14.142C440.263,319.933,433.931,319.942,430.032,323.854z"/>
            </g>
        </g>
    </g>
</g>
 </svg>
                    <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">TimeTable Creator </span>
                </a>
            </li>
  @php
                $class='';
                $array=array('teacher');
                if(in_array(\Request()->segment('3'),$array))
                {
                    $class_teacher='active';
                }
            @endphp
            <li class="py-3 px-3  {{$class_teacher}}">
        <a href="{{url('/admin/timetable/teacher')}}" class="flex items-center">
         <!--  <img src="{{asset('uploads/icons/sidebar/student.svg')}}" class="w-5 h-5"> -->
         <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M71.069,354.63c-1.859-1.86-4.439-2.92-7.069-2.92s-5.21,1.06-7.07,2.92c-1.86,1.86-2.93,4.439-2.93,7.08 c0,2.63,1.069,5.2,2.93,7.06c1.86,1.87,4.44,2.94,7.07,2.94s5.21-1.07,7.069-2.94c1.861-1.86,2.931-4.44,2.931-7.06 C74,359.08,72.93,356.5,71.069,354.63z"/></g></g><g><g><path d="M484.095,282.754l-0.716-0.743c-3.845-3.965-10.177-4.063-14.141-0.217c-3.965,3.845-4.062,10.176-0.217,14.141 l0.594,0.616c1.966,2.063,4.602,3.102,7.242,3.102c2.478,0,4.96-0.916,6.896-2.76 C487.751,293.083,487.904,286.753,484.095,282.754z"/></g></g><g><g><path d="M505.89,317.818c-1.895-5.188-7.635-7.857-12.823-5.964c-5.188,1.895-7.858,7.636-5.964,12.823 c3.25,8.899,4.897,18.265,4.897,27.835V465h-34V361.705c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10V465h-79.464v-77.749 c0-33.581-22.735-62.688-55.289-70.781c-0.137-0.034-0.273-0.065-0.411-0.094l-0.786-0.161 c8.261-8.487,14.198-19.236,16.772-31.222l34.632,55.38c1.828,2.923,5.032,4.698,8.479,4.698c3.447,0,6.651-1.776,8.479-4.699 l43.097-68.946c8.763,0.281,17.332,1.934,25.502,4.957c1.145,0.423,2.316,0.624,3.469,0.624c4.065,0,7.887-2.498,9.38-6.533 c1.916-5.181-0.729-10.933-5.909-12.849c-9.599-3.551-19.628-5.592-29.877-6.112c18.239-15.421,29.85-38.448,29.85-64.146v-31.431 v-17.814V133c0-0.933-0.137-1.832-0.376-2.688c-3.955-42.668-39.941-76.189-83.624-76.189h-0.001 c-43.683,0-79.668,33.521-83.623,76.189c-0.239,0.856-0.376,1.755-0.376,2.688v5.123v17.814v31.431 c0,4.391,0.342,8.702,0.994,12.913c-5.805-2.224-12.01-3.625-18.478-4.069v-58.468C260.44,76.679,210.762,27,149.697,27 S38.953,76.679,38.953,137.744v135.059C15.259,291.331,0,320.172,0,352.513V475c0,5.522,4.478,10,10,10h492 c5.522,0,10-4.478,10-10V352.513C512,340.595,509.944,328.922,505.89,317.818z M361.931,316.208l-32.013-51.191 c9.871,4.084,20.677,6.351,32.006,6.351h28.036L361.931,316.208z M297.925,138.123c-0.001-35.29,28.709-64,63.999-64 c35.29,0,64,28.71,64,64v0.341l-34.438-20.232c-4.211-2.475-9.593-1.544-12.73,2.199c-13.583,16.209-33.502,25.506-54.65,25.506 h-26.181V138.123z M297.924,165.937h26.181c24.218,0,47.177-9.521,64.2-26.378l37.619,22.101v25.708c0,35.29-28.711,64-64.001,64 c-35.289,0-63.999-28.71-63.999-64V165.937z M150.076,251.368c-35.29,0-64-28.71-64-64v-21.431h26.182 c24.218,0,47.177-9.521,64.2-26.378l37.618,22.101v25.708C214.076,222.658,185.366,251.368,150.076,251.368z M181.578,265.216 l-31.874,50.992l-28.041-44.84h28.413C161.215,271.368,171.843,269.17,181.578,265.216z M211.742,261.333H243.6 c6.688,0,13.166-1.783,18.829-4.999l17.178,4.652c0.853,0.231,1.731,0.349,2.614,0.349h18.037v10.19 c0,24.356-19.854,44.172-44.258,44.172s-44.258-19.815-44.258-44.172V261.333z M295.98,241.334h-12.429l-5.961-1.614 c0.94-4.127-0.824-8.56-4.663-10.828c-4.755-2.809-10.886-1.232-13.696,3.522c-3.251,5.502-9.24,8.92-15.631,8.92h-27.58 c7.116-14.941,22.359-25.293,39.98-25.293C273.621,216.041,288.864,226.394,295.98,241.334z M58.953,137.744 C58.953,87.708,99.661,47,149.697,47s90.743,40.708,90.743,90.744v60.212c-2.515,0.628-4.969,1.409-7.358,2.325 c0.652-4.21,0.994-8.522,0.994-12.913v-31.431c0-3.497-1.92-6.851-4.935-8.622l-49.503-29.083 c-4.211-2.474-9.592-1.544-12.73,2.199c-13.583,16.209-33.502,25.506-54.65,25.506H76.076c-5.522,0-10,4.477-10,10v31.431 c0,25.692,11.606,48.714,29.837,64.135c-13.133,0.672-25.609,3.866-36.96,9.098V137.744z M153.464,465H74v-59.333 c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10V465H20V352.513c0-43.73,34.776-79.471,78.123-81.068l43.104,68.928 c1.828,2.923,5.032,4.698,8.479,4.698c3.447,0,6.651-1.776,8.479-4.699l34.891-55.818c2.522,12.161,8.509,23.064,16.868,31.655 l-0.86,0.183c-0.111,0.024-0.222,0.05-0.331,0.077c-32.554,8.094-55.289,37.2-55.289,70.781V465z M338.536,465h-29.229v-62 c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10v62h-76v-62c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10v62h-19.844v-77.749 c0-24.319,16.423-45.404,39.957-51.333l20.106-4.281c6.999,2.618,14.57,4.059,22.473,4.059c7.793,0,15.266-1.395,22.183-3.945 l20.433,4.176c23.517,5.94,39.921,27.016,39.921,51.324V465z"/></g></g><g><g><path d="M337.16,175.83c-1.86-1.86-4.44-2.93-7.07-2.93c-2.64,0-5.21,1.07-7.07,2.93c-1.87,1.86-2.93,4.44-2.93,7.07 c0,2.64,1.06,5.21,2.93,7.07c1.86,1.87,4.431,2.93,7.07,2.93c2.63,0,5.21-1.06,7.07-2.93c1.859-1.86,2.93-4.43,2.93-7.07 C340.09,180.27,339.02,177.69,337.16,175.83z"/></g></g><g><g><path d="M400.83,175.83c-1.86-1.86-4.44-2.93-7.07-2.93s-5.21,1.07-7.07,2.93c-1.859,1.86-2.93,4.44-2.93,7.07 c0,2.64,1.07,5.21,2.93,7.07c1.86,1.87,4.44,2.93,7.07,2.93s5.21-1.06,7.07-2.93c1.859-1.86,2.93-4.44,2.93-7.07 S402.69,177.69,400.83,175.83z"/></g></g><g><g><path d="M380.686,207.885c-3.906-3.905-10.236-3.905-14.142,0c-2.629,2.63-6.908,2.63-9.537,0c-3.906-3.905-10.236-3.905-14.143,0 c-3.905,3.905-3.905,10.237,0,14.143c5.214,5.213,12.063,7.82,18.911,7.82s13.697-2.607,18.911-7.82 C384.591,218.123,384.591,211.791,380.686,207.885z"/></g></g><g><g><path d="M125.309,175.83c-1.859-1.86-4.439-2.93-7.069-2.93c-2.631,0-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07 s1.069,5.21,2.93,7.07c1.86,1.87,4.439,2.93,7.07,2.93c2.63,0,5.21-1.06,7.069-2.93c1.86-1.86,2.931-4.44,2.931-7.07 S127.17,177.69,125.309,175.83z"/></g></g><g><g><path d="M188.979,175.83c-1.859-1.86-4.43-2.93-7.069-2.93c-2.63,0-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07 s1.069,5.21,2.93,7.07c1.861,1.86,4.44,2.93,7.07,2.93c2.64,0,5.21-1.07,7.069-2.93c1.87-1.86,2.931-4.44,2.931-7.07 S190.849,177.69,188.979,175.83z"/></g></g><g><g><path d="M168.84,207.885c-3.906-3.905-10.236-3.905-14.143,0c-2.629,2.63-6.908,2.63-9.537,0c-3.906-3.905-10.236-3.905-14.143,0 c-3.905,3.906-3.905,10.238,0.001,14.143c5.214,5.213,12.063,7.82,18.911,7.82c6.848,0,13.697-2.607,18.911-7.82 C172.745,218.123,172.745,211.791,168.84,207.885z"/></g></g><g><g><path d="M274.911,282.7c-3.906-3.904-10.236-3.904-14.143,0c-2.629,2.631-6.908,2.631-9.537,0c-3.906-3.904-10.236-3.904-14.143,0 c-3.905,3.905-3.905,10.237,0,14.143c5.215,5.214,12.063,7.82,18.912,7.82s13.697-2.606,18.911-7.82 C278.816,292.938,278.816,286.606,274.911,282.7z"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>
          <span class="mx-3 whitespace-no-wrap">Teacher</span>
        </a>
      </li>
     @php
                $class='';
                $array=array('class');
                if(in_array(\Request()->segment('3'),$array))
                {
                    $class_class='active';
                }
            @endphp
            <li class="py-3 px-3  {{$class_class}}">
        <a href="{{url('/admin/timetable/class')}}" class="flex items-center">
       
<svg class="w-5 h-5 fill-current text-white" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 511.998 511.998" xml:space="preserve" width="512px" height="512px" class="w-5 h-5"><g><g><g><path d="M386.872,397.626c-2.031-5.158-7.859-7.698-13.02-5.663l-70.492,27.755c-5.159,2.031-7.695,7.86-5.663,13.02 c1.556,3.951,5.339,6.364,9.344,6.364c1.223,0,2.468-0.226,3.675-0.701l70.492-27.755    C386.368,408.615,388.904,402.786,386.872,397.626z" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path></g></g><g><g><path d="M402.433,381.438c-12.919,0-12.94,20.078,0,20.078C415.352,401.516,415.374,381.438,402.433,381.438z" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path></g></g><g><g><path d="M478.201,247.628c-0.138-0.66-0.34-1.295-0.6-1.9c0,0-0.001-0.002-0.001-0.003c-0.006-0.013-0.013-0.025-0.019-0.039 c-0.125-0.289-0.263-0.57-0.415-0.844c-0.064-0.117-0.139-0.228-0.208-0.341c-0.097-0.162-0.192-0.324-0.298-0.48 c-0.109-0.161-0.23-0.312-0.347-0.465c-0.077-0.099-0.151-0.203-0.232-0.3c-0.138-0.165-0.284-0.319-0.431-0.474 c-0.075-0.079-0.147-0.161-0.225-0.238c-0.149-0.147-0.304-0.282-0.46-0.419c-0.089-0.078-0.177-0.159-0.269-0.234 c-0.146-0.117-0.296-0.226-0.448-0.334c-0.115-0.083-0.229-0.17-0.347-0.248c-0.133-0.088-0.272-0.168-0.409-0.249 c-0.146-0.086-0.29-0.175-0.44-0.254c-0.12-0.063-0.246-0.118-0.368-0.178c-0.171-0.081-0.341-0.164-0.518-0.236 c-0.12-0.049-0.244-0.089-0.365-0.134c-0.181-0.065-0.36-0.133-0.546-0.189c-0.147-0.044-0.296-0.077-0.445-0.114 c-0.162-0.04-0.321-0.084-0.486-0.117c-0.221-0.044-0.444-0.073-0.668-0.102c-0.095-0.012-0.19-0.031-0.286-0.04 c-1.046-0.105-2.117-0.043-3.177,0.195c-0.616,0.137-1.213,0.326-1.781,0.571l-54.72,23.5 c-23.478-40.073-61.031-68.797-104.573-81.214c29.199-16.986,48.872-48.62,48.872-84.765C353.991,43.955,310.031,0,255.999,0 c-54.028,0-97.982,43.954-97.982,97.982c0,36.145,19.672,67.778,48.868,84.765c-43.537,12.416-81.091,41.139-104.576,81.212 l-54.722-23.498c-0.618-0.266-1.268-0.475-1.943-0.612c-0.673-0.139-1.35-0.204-2.021-0.204c-0.002,0-0.004,0-0.005,0 c-0.329,0-0.656,0.017-0.981,0.049c-0.122,0.012-0.241,0.035-0.362,0.051c-0.199,0.027-0.397,0.052-0.592,0.09 c-0.182,0.035-0.357,0.083-0.535,0.128c-0.133,0.034-0.266,0.063-0.397,0.102c-0.197,0.058-0.388,0.13-0.579,0.2 c-0.111,0.041-0.224,0.077-0.334,0.122c-0.184,0.075-0.361,0.161-0.54,0.246c-0.116,0.055-0.234,0.107-0.348,0.168 c-0.156,0.082-0.305,0.173-0.455,0.262c-0.133,0.079-0.266,0.156-0.396,0.24c-0.122,0.08-0.238,0.168-0.356,0.254 c-0.149,0.107-0.297,0.214-0.441,0.329c-0.093,0.076-0.182,0.158-0.272,0.237c-0.156,0.135-0.31,0.27-0.458,0.416 c-0.078,0.077-0.151,0.16-0.226,0.24c-0.147,0.155-0.292,0.308-0.43,0.472c-0.081,0.097-0.155,0.2-0.232,0.3 c-0.118,0.154-0.238,0.304-0.348,0.465c-0.106,0.155-0.201,0.318-0.298,0.479c-0.069,0.115-0.143,0.224-0.208,0.342 c-0.152,0.274-0.288,0.555-0.415,0.844c-0.006,0.013-0.013,0.025-0.019,0.039c0,0.001-0.001,0.002-0.001,0.002 c-0.26,0.606-0.463,1.242-0.6,1.901c-0.144,0.685-0.213,1.373-0.213,2.057V410.75c0,4.014,2.39,7.641,6.078,9.224l212.378,91.206 c0.348,0.15,0.702,0.274,1.056,0.383c0.059,0.018,0.12,0.029,0.179,0.046c0.377,0.107,0.756,0.189,1.136,0.25 c0.09,0.014,0.181,0.029,0.271,0.041c0.439,0.058,0.877,0.098,1.315,0.098c0.039,0,0.077-0.008,0.117-0.009 c0.385-0.004,0.77-0.035,1.153-0.084c0.128-0.016,0.254-0.036,0.38-0.058c0.344-0.057,0.686-0.132,1.024-0.226 c0.078-0.022,0.158-0.037,0.236-0.061c0.356-0.107,0.709-0.232,1.055-0.38l212.378-91.206c3.687-1.583,6.078-5.21,6.078-9.224    V249.685C478.415,249.001,478.346,248.313,478.201,247.628z M178.093,97.983c0-42.956,34.947-77.904,77.904-77.904 c42.962,0,77.914,34.948,77.914,77.904c0,42.963-34.951,77.914-77.914,77.914C213.04,175.897,178.093,140.946,178.093,97.983z M245.957,486.722l-192.3-82.583V264.92h0.001l48.648,20.89c0.134,0.064,0.27,0.126,0.407,0.186l143.245,61.51V486.722z M255.996,329.964l-135.104-58.013c28.622-47.125,79.447-75.975,135.105-75.975c55.666,0,106.49,28.848,135.103,75.969 L255.996,329.964z M458.336,404.138l-192.3,82.583V347.504l192.3-82.583V404.138z" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path></g></g></g></svg>

          <span class="mx-3 whitespace-no-wrap">Class</span>
        </a>
      </li>

       @php
                $class='';
                $array=array('day');
                if(in_array(\Request()->segment('3'),$array))
                {
                    $class_class='active';
                }
            @endphp
            <li class="py-3 px-3  {{$class_class}}">
        <a href="{{url('/admin/timetable/day')}}" class="flex items-center">
       
<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5 text-white">
  <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 012.25-2.25h13.5A2.25 2.25 0 0121 7.5v11.25m-18 0A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75m-18 0v-7.5A2.25 2.25 0 015.25 9h13.5A2.25 2.25 0 0121 11.25v7.5m-9-6h.008v.008H12v-.008zM12 15h.008v.008H12V15zm0 2.25h.008v.008H12v-.008zM9.75 15h.008v.008H9.75V15zm0 2.25h.008v.008H9.75v-.008zM7.5 15h.008v.008H7.5V15zm0 2.25h.008v.008H7.5v-.008zm6.75-4.5h.008v.008h-.008v-.008zm0 2.25h.008v.008h-.008V15zm0 2.25h.008v.008h-.008v-.008zm2.25-4.5h.008v.008H16.5v-.008zm0 2.25h.008v.008H16.5V15z" />
</svg>


          <span class="mx-3 whitespace-no-wrap">Day</span>
        </a>
      </li>

       @php
                $class='';
                $array=array('work_allotment');
                if(in_array(\Request()->segment('3'),$array))
                {
                    $class_class='active';
                }
            @endphp
            <li class="py-3 px-3 {{$class_class}}">
        <a href="{{url('/admin/timetable/work_allotment')}}" class="flex items-center">
       
 <img src="{{asset('uploads/schedule.png')}}" class="w-5 h-5">

          <span class="mx-3 whitespace-no-wrap">Work Allotment</span>
        </a>
      </li>

      </ul>

      </li>--}}

    <!--start-->
    @php
        $class='';
        $array=array('homeworks','homework');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="py-3 px-3  {{$class}}">
        <a href="{{ url('/admin/homeworks') }}" class="flex items-center">
        <!--  <img src="{{asset('uploads/icons/sidebar/homework.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px"><g><g><path d="m74.791 114.523c26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.441.561-16.425-6.881-20.067-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.115 8.283 6.507 15.091 14.79 15.207z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m202.593 176.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m202.593 236.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m309.407 116.126c-7.441 3.641-10.521 12.625-6.881 20.067 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 37.64-18.419 75.865-28.024 113.616-28.55 8.283-.115 14.905-6.924 14.789-15.208-.115-8.283-6.876-14.901-15.207-14.79-42.213.589-84.735 11.221-126.383 31.601z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m500.638 7.584c-18.59-4.713-37.148-7.584-60.591-7.584-.016 0-.035 0-.05 0-43.627.009-110.281 11.25-183.997 63.569-73.272-52-139.55-63.382-182.937-63.566-24.136-.104-43.055 2.852-61.7 7.581-6.678 1.67-11.363 7.669-11.363 14.552v294.5c0 4.619 2.128 8.98 5.769 11.823 6.635 5.182 13.606 2.463 13.981 2.448 41.952-10.63 127.258-17.266 227.25 57.729 2.667 2 5.833 3 9 3s6.333-1 9-3c31.188-23.391 63.401-40.556 96-51.235v159.599c0 8.284 6.716 15 15 15h60c8.284 0 15-6.716 15-15v-172.236c21.132 1.097 36.088 4.848 41.675 6.252.277.008 7.061 2.515 13.557-2.557 3.641-2.843 5.769-7.204 5.769-11.823v-294.5c-.001-6.883-4.685-12.882-11.363-14.552zm-470.638 290.414v-263.956c9.661-1.955 24.286-4.124 42.937-4.04 39.466.168 100.214 10.809 168.063 59.726v258.166c-45.801-29.614-93.332-47.095-141.641-52.035-29.797-3.047-53.622-.62-69.359 2.139zm385.485-56.998h-18.969l9.484-29.8zm5.515 241h-30v-211h30zm61-183.931c-8.266-1.429-18.763-2.783-31-3.342v-38.667c.009-1.64-.255-3.321-.813-4.942l-29.894-93.926c-2.22-6.938-9.127-11.275-16.273-10.32-31.752 4.227-63.585 14.069-94.613 29.253-7.441 3.641-10.521 12.625-6.881 20.066 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 20.297-9.932 40.912-17.319 61.544-22.097l-22.324 70.143c-.521 1.513-.806 3.135-.813 4.823v50.053c-30.537 8.934-60.681 22.965-90 41.91v-258.175c68.249-49.206 129.329-59.72 169.004-59.728h.043c18.182 0 32.464 2.124 41.954 4.043z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Home Works</span>
        </a>
    </li>
    <!--end-->

    {{-- <li class="py-3 px-3  {{Request::segment ('2') == 'task' ? 'active':''}} || {{Request::segment ('2') == 'tasks' ? 'active':''}}">
        <a href="{{ url('/admin/tasks') }}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m60 512h272c33.084 0 60-26.916 60-60v-407c0-8.284-6.716-15-15-15h-75v-15c0-8.284-6.716-15-15-15h-121c-8.284 0-15 6.716-15 15v15h-75c-8.284 0-15 6.716-15 15v377h-46c-8.284 0-15 6.716-15 15v15c0 33.084 26.916 60 60 60zm121-482h91v30h-91zm-90 30h60v15c0 8.284 6.716 15 15 15h121c8.284 0 15-6.716 15-15v-15h60v392c0 16.542-13.458 30-30 30s-30-13.458-30-30v-15c0-8.284-6.716-15-15-15h-196zm181 392c0 10.92 2.934 21.17 8.052 30h-220.052c-16.542 0-30-13.458-30-30z"/><path d="m467 61c-24.813 0-45 20.187-45 45v270c0 1.588.324 3.407.754 4.696l30 91c2.027 6.15 7.771 10.304 14.246 10.304s12.219-4.154 14.246-10.304l30-91c.424-1.273.754-3.073.754-4.696v-270c0-24.813-20.187-45-45-45zm-15 300v-210h30v210zm15-270c8.271 0 15 6.729 15 15v15h-30v-15c0-8.271 6.729-15 15-15zm-9.261 300h18.521l-9.26 28.091z"/><path d="m226 181h91c8.284 0 15-6.716 15-15s-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/><path d="m317 241h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m332 346c0-8.284-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15z"/><path d="m155.394 176.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m155.394 266.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m206.606 305.394c-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.393-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l30 30c2.929 2.929 6.768 4.393 10.607 4.393s7.678-1.464 10.606-4.394l30-30c5.859-5.857 5.859-15.355 0-21.212z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">To Do List</span>
        </a>
    </li> --}}
     @if(config('gexam.enabled', false))
    <!--start-->
    <li class="py-3 px-3  {{Request::segment ('2') == 'exam' ? 'active':''}}">
        <a href="{{ url('/admin/exam') }}" class="flex  items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/exam.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M347,61h-46V45c0-8.284-6.716-15-15-15h-47.57C232.239,12.539,215.556,0,196,0c-19.556,0-36.239,12.539-42.43,30H105 c-8.284,0-15,6.716-15,15v16H45C20.187,61,0,81.187,0,106v361c0,24.813,20.187,45,45,45h302c24.813,0,45-20.187,45-45V106 C392,81.187,371.813,61,347,61z M120,60h46c8.284,0,15-6.716,15-15c0-8.271,6.729-15,15-15s15,6.729,15,15c0,8.284,6.716,15,15,15    h45v16c0,8.271-6.729,15-15,15H135c-8.271,0-15-6.729-15-15V60z M362,467c0,8.271-6.729,15-15,15H45c-8.271,0-15-6.729-15-15V106 c0-8.271,6.729-15,15-15h47.58c6.192,17.459,22.865,30,42.42,30h121c19.555,0,36.228-12.541,42.42-30H347c8.271,0,15,6.729,15,15 V467z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M176.693,260.482c-5.808-5.906-15.306-5.985-21.212-0.175l-50.394,49.568l-19.481-19.481    c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213l30.001,30C97.321,344.534,101.16,346,105,346    c3.798,0,7.599-1.434,10.518-4.306l61-60C182.424,275.885,182.502,266.388,176.693,260.482z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M176.693,365.482c-5.808-5.906-15.306-5.985-21.212-0.175l-50.394,49.568l-19.481-19.481    c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213l30.001,30C97.321,449.534,101.16,451,105,451 c3.798,0,7.599-1.434,10.518-4.306l61-60C182.424,380.885,182.502,371.388,176.693,365.482z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M145.607,215.394L126.213,196l19.393-19.393c5.858-5.858,5.858-15.355,0-21.213c-5.857-5.858-15.355-5.858-21.213,0 L105,174.787l-19.394-19.393c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213L83.787,196l-19.393,19.393    c-5.858,5.858-5.858,15.356,0,21.214c5.857,5.857,15.355,5.858,21.213,0L105,217.213l19.394,19.394    c5.857,5.857,15.355,5.858,21.213,0C151.465,230.749,151.465,221.252,145.607,215.394z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M317,181h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,181,317,181z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M317,286h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,286,317,286z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M317,391h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,391,317,391z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M467,91c-24.813,0-45,20.187-45,45c0,9.542,0,230.112,0,240c0,1.614,0.289,3.286,0.754,4.697l30,91 C454.781,477.845,460.525,482,467,482c6.475,0,12.219-4.155,14.246-10.303l30-91C511.75,379.165,512,377.465,512,376 c0-9.872,0-230.419,0-240C512,111.187,491.813,91,467,91z M467,419.091l-12.388-37.576c3.792-1.924,8.012-2.942,12.388-2.942    c4.376,0,8.596,1.018,12.388,2.942L467,419.091z M482,350.558c-4.832-1.299-9.862-1.985-15-1.985s-10.168,0.685-15,1.984V211h30 V350.558z M482,181h-30v-45c0-8.271,6.729-15,15-15s15,6.729,15,15V181z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Exam</span>
        </a>
    </li>
    <!--end-->
    @endif

    <!--start-->
    <li class="py-3 px-3  {{Request::segment ('2') == 'events' ? 'active':''}} || {{Request::segment ('2') == 'event' ? 'active':''}}">
        <a href="{{ url('admin/events') }}" class="flex items-center">
            <!-- <img src="{{asset('uploads/icons/sidebar/calendar.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 0 480 480" width="512px"><g><path d="m399.832031 54.398438c-.0625-.277344-.230469-.496094-.3125-.757813-.136719-.449219-.316406-.882813-.535156-1.296875-.25-.476562-.550781-.921875-.894531-1.335938-.277344-.34375-.582032-.664062-.914063-.960937-.402343-.339844-.84375-.632813-1.3125-.878906-.394531-.238281-.8125-.441407-1.246093-.609375-.519532-.164063-1.058594-.273438-1.601563-.328125-.332031-.097657-.671875-.175781-1.015625-.230469h-40.335938c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-40.335938c-4.417969 0-8 3.582031-8 8v416c0 4.417969 3.582031 8 8 8h384c4.417969 0 8-3.582031 8-8v-24h72c2.402344 0 4.675781-1.082031 6.191406-2.941406 1.519532-1.863282 2.121094-4.304688 1.640625-6.660156zm-79.832031-38.398438c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-64 48h32.335938c2.0625 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h79.617188v80h-368zm368 400h-368v-304h368zm16-32v-298.398438l62.167969 298.398438zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Calendar</span>
        </a>
    </li>
    <!--end-->

    <!--start-->

    <!-- admin/video-conference -->
    @if(config('gvideoroom.enabled', false))
    <li class="py-3 px-3  fade-out-menu {{Request::segment ('2') == 'video-conference' ? 'active':''}}"><!--cursor-not-allowed -->
         <a href="{{ url('admin/video-conference') }}" class="flex items-center"> <!--cursor-not-allowed -->
            <svg class="w-5 h-5 fill-current text-white" id="_x31_" enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg"><g><g id="XMLID_1_"><path d="m16 15.5v4c0-.3-.2-.5-.5-.5h-.5v-3.5c0-.3.2-.5.5-.5s.5.2.5.5z"/><path d="m15.5 19c.3 0 .5.2.5.5s-.2.5-.5.5h-.5v-1z"/><path d="m15 19v1h-3.5c.3 0 .5-.2.5-.5v-.5z"/><path d="m23 11.4v-4.8l-2.2 1.8c-.1.1-.4.1-.5.1-.2-.1-.3-.3-.3-.5v-1.5c0-.3-.2-.5-.5-.5h-6c-.3 0-.5.2-.5.5v5c0 .3.2.5.5.5h6c.3 0 .5-.2.5-.5v-1.5c0-.2.1-.4.3-.4.2-.1.4-.1.5.1zm-2 .1c0 .8-.7 1.5-1.5 1.5h-4-2c-.8 0-1.5-.7-1.5-1.5v-5c0-.8.7-1.5 1.5-1.5h2 4c.8 0 1.5.7 1.5 1.5v.4l2.2-1.8c.1-.1.3-.1.5 0 .2 0 .3.2.3.4v7c0 .2-.1.4-.3.4-.1 0-.1.1-.2.1s-.2 0-.3-.1l-2.2-1.8z"/><path d="m11 19.5v-.5h1v.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5z"/><path d="m11.5 20h-7c.3 0 .5-.2.5-.5v-.5h6v.5c0 .3.2.5.5.5z"/><path d="m6 13c0-1.1.9-2 2-2s2 .9 2 2-.9 2-2 2-2-.9-2-2zm3 0c0-.6-.4-1-1-1s-1 .4-1 1 .4 1 1 1 1-.4 1-1z"/><path d="m5 19v.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-.5z"/><path d="m4 18.5c0-1.4 1.1-2.5 2.5-2.5h3c1.4 0 2.5 1.1 2.5 2.5v.5h-1v-.5c0-.8-.7-1.5-1.5-1.5h-3c-.8 0-1.5.7-1.5 1.5v.5h-1z"/><path d="m1 20v-1h3v.5c0 .3.2.5.5.5z"/><path d="m1 19v1h-.5c-.3 0-.5-.2-.5-.5s.2-.5.5-.5z"/><path d="m0 2.5c0-1.4 1.1-2.5 2.5-2.5h11c1.4 0 2.5 1.1 2.5 2.5 0 .3-.2.5-.5.5s-.5-.2-.5-.5c0-.8-.7-1.5-1.5-1.5h-11c-.8 0-1.5.7-1.5 1.5v16.5h-.5c-.3 0-.5.2-.5.5z"/><path d="m15 20h.5c.3 0 .5-.2.5-.5v2c0 1.4-1.1 2.5-2.5 2.5h-11c-1.4 0-2.5-1.1-2.5-2.5v-2c0 .3.2.5.5.5h.5v1.5c0 .8.7 1.5 1.5 1.5h11c.8 0 1.5-.7 1.5-1.5z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Video Room</span>
        </a>
    </li>
    @endif
    <!--end-->

    <!-- start -->
    <!--@php
        $class='';
        $array=array('chat','room','privatechatroom','conversations');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp -->
    @if(config('gchat.enabled', false))
    <li class="relative py-3 px-3  {{Request::segment ('2') == 'chat' ? 'active':''}} || {{Request::segment ('2') == 'room' ? 'active':''}}">
        <a href="{{ url('admin/chat') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M352,0H64C28.704,0,0,28.704,0,64v192c0,35.296,28.704,64,64,64v80c0,6.24,3.648,11.936,9.312,14.528 C75.456,415.52,77.728,416,80,416c3.744,0,7.456-1.312,10.4-3.872L197.92,320H352c35.296,0,64-28.704,64-64V64 C416,28.704,387.296,0,352,0z M384,256c0,17.632-14.368,32-32,32H192c-3.808,0-7.52,1.344-10.4,3.872L96,365.216V304 c0-8.832-7.168-16-16-16H64c-17.632,0-32-14.368-32-32V64c0-17.632,14.368-32,32-32h288c17.632,0,32,14.368,32,32V256z"/></g></g><g><g><path d="M469.216,99.744c-8.352-2.88-17.472,1.568-20.352,9.92s1.536,17.44,9.92,20.352C471.456,134.368,480,146.432,480,160v192 c0,17.632-14.368,32-32,32h-16c-8.832,0-16,7.168-16,16v61.216l-85.6-73.344c-2.88-2.528-6.592-3.872-10.4-3.872H178.24 c-8.832,0-16,7.168-16,16c0,8.832,7.136,16,16,16h135.84l107.52,92.128c2.944,2.56,6.656,3.872,10.4,3.872 c2.272,0,4.544-0.48,6.688-1.472C444.352,507.936,448,502.24,448,496v-80c35.296,0,64-28.704,64-64V160 C512,132.8,494.816,108.576,469.216,99.744z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Chat Room</span>
        </a>
        <!--<ul class="list-reset sites-sidebar">
            <li class="py-3 px-3 hover:font-semibold">
                <a href="{{ url('admin/chat') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 417.986 417.986" style="enable-background:new 0 0 417.986 417.986;" xml:space="preserve"><g><g><g><path d="M371.514,19.619c-1.062-0.035-2.125-0.035-3.188,0H126.433c-28.735,0-53.29,20.898-53.29,49.633v117.551H28.735 C11.494,186.802,0,202.476,0,219.716v97.176c0,17.241,11.494,31.869,28.735,31.869h23.51l9.404,41.796 c0.909,3.707,3.679,6.674,7.314,7.837h3.135c2.756-0.039,5.385-1.166,7.314-3.135l42.841-46.498h64.784 c17.575-0.27,31.836-14.301,32.392-31.869V265.17h7.837l71.575,77.845c1.698,2.336,4.427,3.7,7.314,3.657h3.135 c3.559-0.976,6.339-3.756,7.314-7.314l16.718-74.188h35.004c28.735,0,49.633-24.555,49.633-53.29V69.251 C418.839,42.72,398.045,20.499,371.514,19.619z M198.531,316.892c-0.521,6.03-5.446,10.731-11.494,10.971h-69.486 c-2.756,0.039-5.385,1.166-7.314,3.135l-32.914,35.526L70.531,335.7c-1.22-4.735-5.561-7.991-10.449-7.837H28.735 c-5.747,0-7.837-5.224-7.837-10.971v-97.176c0-5.747,2.09-12.016,7.837-12.016h44.408v4.18 c0.556,29.198,24.092,52.734,53.29,53.29h72.098V316.892z M397.061,69.251V211.88c0,17.241-11.494,32.392-28.735,32.392h-43.363 c-4.834-0.335-9.131,3.057-9.927,7.837l-14.106,62.171l-61.649-66.873c-1.929-1.969-4.558-3.095-7.314-3.135H126.433 c-17.659-0.544-31.848-14.732-32.392-32.392V69.251c0-17.241,15.151-28.735,32.392-28.735h241.894 c14.978-0.892,27.843,10.526,28.735,25.504C397.125,67.096,397.125,68.175,397.061,69.251z"/><path d="M140.539,118.884h125.388c5.771,0,10.449-4.678,10.449-10.449s-4.678-10.449-10.449-10.449H140.539 c-5.771,0-10.449,4.678-10.449,10.449S134.768,118.884,140.539,118.884z"/><path d="M349.518,160.68h-208.98c-5.771,0-10.449,4.678-10.449,10.449s4.678,10.449,10.449,10.449h208.98 c5.771,0,10.449-4.678,10.449-10.449S355.289,160.68,349.518,160.68z"/></g></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Chat Room</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold">
                <a href="{{ url('admin/conversations') }}" class="flex items-center">        
                    <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m80 282c-8.284 0-15 6.716-15 15s6.716 15 15 15h250c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m330 352h-250c-8.284 0-15 6.716-15 15s6.716 15 15 15h250c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m497 100h-5v-25c0-41.355-33.645-75-75-75s-75 33.645-75 75v25h-5c-8.284 0-15 6.716-15 15v27h-307c-8.284 0-15 6.716-15 15v340c0 6.067 3.655 11.537 9.26 13.858 1.856.769 3.805 1.142 5.737 1.142 3.904 0 7.741-1.524 10.61-4.394l55.607-55.606h313.786c8.284 0 15-6.716 15-15v-167h87c8.284 0 15-6.716 15-15v-140c0-8.284-6.716-15-15-15zm-125-25c0-24.813 20.187-45 45-45s45 20.187 45 45v25h-90zm8 347h-305c-3.978 0-7.793 1.581-10.606 4.394l-34.394 34.393v-288.787h292v40h-242c-8.284 0-15 6.716-15 15s6.716 15 15 15h242v13c0 8.284 6.716 15 15 15h43zm102-182h-130v-110h130z"/><path d="m402 180v25c0 8.284 6.716 15 15 15s15-6.716 15-15v-25c8.284 0 15-6.716 15-15s-6.716-15-15-15h-30c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Private Chat Room</span>
                </a>
            </li>
        </ul> -->
    </li>
@endif
    <li class="py-3 px-3  {{Request::segment ('2') == 'notices' ? 'active':''}} || {{Request::segment ('2') == 'notice' ? 'active':''}} ">
        <a href="{{ url('/admin/notices') }}" class="flex items-center">
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Layer_3" enable-background="new 0 0 64 64" height="512px" viewBox="0 0 64 64" width="512px"><g><path d="m21 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m35 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 51h26c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1zm1-4h24v2h-24z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 53h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 57h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m62 9c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-12v-1c0-.553-.447-1-1-1h-34c-.553 0-1 .447-1 1v1h-12c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h1v46h-1c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h12v1c0 .553.447 1 1 1h34c.553 0 1-.447 1-1v-1h12c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-1v-46zm-59-4h11v2h-11zm11 4v46h-5v-46zm-9 0h2v46h-2zm-2 50v-2h11v2zm45 2h-32v-58h32zm13-56v2h-11v-2zm-11 50v-46h5v46zm11 4h-11v-2h11zm-2-4h-2v-46h2z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 31h26c.553 0 1-.447 1-1v-24c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v24c0 .553.447 1 1 1zm10-17c0-1.654 1.346-3 3-3s3 1.346 3 3-1.346 3-3 3-3-1.346-3-3zm8 15h-10v-5c0-2.757 2.243-5 5-5s5 2.243 5 5zm-17-22h24v22h-5v-5c0-2.698-1.537-5.04-3.779-6.208 1.079-.918 1.779-2.268 1.779-3.792 0-2.757-2.243-5-5-5s-5 2.243-5 5c0 1.524.7 2.874 1.779 3.792-2.242 1.168-3.779 3.51-3.779 6.208v5h-5z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Notice Board</span>
        </a>
    </li>

    <!-- start -->
    @php
        $class='';
        $array=array('sentmessages','feedbacks','feedback','emergency'); 
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp<!-- 'notice','notices', -->
    <li class="relative py-3 px-3  {{$class}}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m298.748 168.073c0-4.142-3.357-7.5-7.5-7.5h-208.868c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h208.868c4.143 0 7.5-3.358 7.5-7.5z"/><path d="m255.902 229.496h-173.522c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h173.521c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.499-7.5z"/><path d="m255.902 298.419h-173.522c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h173.521c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.499-7.5z"/><path d="m505.458 214.869c-25.223-20.342-39.689-50.595-39.689-83.001v-8.891c0-24.836-13.919-46.481-34.364-57.55v-10.305c0-17.112-13.922-31.033-31.034-31.033-17.111 0-31.033 13.922-31.033 31.033v10.305c-20.445 11.069-34.364 32.714-34.364 57.551v8.891c0 32.407-14.467 62.659-39.687 82.999-6.815 5.492-8.594 15.076-3.976 22.627 3.182 5.202 8.722 8.308 14.819 8.308h47.944c6.444 19.781 25.009 33.573 46.298 33.573s39.853-13.792 46.297-33.573h47.944c6.098 0 11.637-3.105 14.818-8.307 4.627-7.567 2.825-17.151-3.973-22.627zm-121.12-159.747c0-8.841 7.193-16.034 16.034-16.034s16.033 7.193 16.033 16.034v4.454c-10.411-2.634-21.446-2.687-32.067 0zm16.034 209.253c-12.997 0-24.523-7.428-30.12-18.573h60.239c-5.596 11.145-17.121 18.573-30.119 18.573zm94.241-33.573c-21.35 0-154.924 0-188.482 0-2.125 0-3.34-2.715-1.43-4.257 28.772-23.203 45.273-57.712 45.273-94.677v-8.891c0-27.789 22.608-50.397 50.397-50.397 27.79 0 50.398 22.608 50.398 50.397v8.891c0 36.965 16.501 71.474 45.275 94.679 1.909 1.538.694 4.255-1.431 4.255z"/><path d="m445.596 269.099c-4.143 0-7.5 3.358-7.5 7.5v64.184c0 24.82-20.192 45.013-45.012 45.013h-227.451c-6.31 0-12.306 2.393-16.882 6.737l-81.169 77.052 11.954-66.377c1.636-9.079-5.346-17.411-14.555-17.411h-4.969c-24.82 0-45.012-20.193-45.012-45.013v-204.986c0-24.82 20.192-45.012 45.012-45.012h260.791c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5h-260.791c-33.09 0-60.012 26.921-60.012 60.012v204.985c0 33.091 26.922 60.013 60.012 60.013h4.717l-12.893 71.593c-1.013 5.623 1.686 11.224 6.713 13.936 5.005 2.699 11.17 1.912 15.334-2.041l85.195-80.873c1.777-1.687 4.105-2.616 6.556-2.616h227.451c33.091 0 60.012-26.922 60.012-60.013v-64.184c-.001-4.141-3.359-7.499-7.501-7.499z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Messages <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar">
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'sentmessages' ? 'active':''}}">
                <a href="{{ url('/admin/sentmessages') }}" class="flex items-center">
                    <!-- <img src="{{asset('uploads/icons/sidebar/send_msg.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 511.999 511.999" style="enable-background:new 0 0 511.999 511.999;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M455.517,94.082H126.866c-31.145,0-56.483,25.338-56.483,56.483v81.624h-54.21C7.241,232.189,0,239.431,0,248.363    c0,8.932,7.241,16.173,16.173,16.173h54.21v43.425H43.336c-8.932,0-16.173,7.241-16.173,16.173 c0,8.932,7.241,16.173,16.173,16.173h27.046v21.127c0,31.145,25.338,56.483,56.483,56.483h328.651 c31.145,0,56.483-25.338,56.483-56.483V150.566C512,119.421,486.662,94.082,455.517,94.082z M126.866,126.429h328.651 c5.736,0,11.008,2.015,15.154,5.369L313.698,246.985c-13.251,9.724-31.762,9.724-45.013,0L111.712,131.798 C115.857,128.444,121.13,126.429,126.866,126.429z M479.654,361.434c0,13.309-10.827,24.137-24.137,24.137H126.866 c-13.309,0-24.137-10.827-24.137-24.137v-21.127h60.902c8.932,0,16.173-7.241,16.173-16.173s-7.241-16.173-16.173-16.173h-60.902 V165.327l146.82,107.736c12.26,8.998,26.949,13.494,41.642,13.494c14.689,0,29.384-4.498,41.642-13.494l146.82-107.736V361.434z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Sent Messages</span>
                </a>
            </li>
             <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'emergency' ? 'active':''}}">
                <a href="{{ url('/admin/emergency') }}" class="flex items-center">
                    <!-- <img src="{{asset('uploads/icons/sidebar/send_msg.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 511.999 511.999" style="enable-background:new 0 0 511.999 511.999;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M455.517,94.082H126.866c-31.145,0-56.483,25.338-56.483,56.483v81.624h-54.21C7.241,232.189,0,239.431,0,248.363    c0,8.932,7.241,16.173,16.173,16.173h54.21v43.425H43.336c-8.932,0-16.173,7.241-16.173,16.173 c0,8.932,7.241,16.173,16.173,16.173h27.046v21.127c0,31.145,25.338,56.483,56.483,56.483h328.651 c31.145,0,56.483-25.338,56.483-56.483V150.566C512,119.421,486.662,94.082,455.517,94.082z M126.866,126.429h328.651 c5.736,0,11.008,2.015,15.154,5.369L313.698,246.985c-13.251,9.724-31.762,9.724-45.013,0L111.712,131.798 C115.857,128.444,121.13,126.429,126.866,126.429z M479.654,361.434c0,13.309-10.827,24.137-24.137,24.137H126.866 c-13.309,0-24.137-10.827-24.137-24.137v-21.127h60.902c8.932,0,16.173-7.241,16.173-16.173s-7.241-16.173-16.173-16.173h-60.902 V165.327l146.82,107.736c12.26,8.998,26.949,13.494,41.642,13.494c14.689,0,29.384-4.498,41.642-13.494l146.82-107.736V361.434z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Emergency Messages</span>
                </a>
            </li>

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'feedbacks' ? 'active':''}} || {{Request::segment ('2') == 'feedback' ? 'active':''}}">
                <a href="{{ url('/admin/feedbacks') }}" class="flex  items-center">
                    <!--<img src="{{asset('uploads/icons/sidebar/feedback.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><g><path d="M117.333,149.333H352c5.896,0,10.667-4.771,10.667-10.667c0-5.896-4.771-10.667-10.667-10.667H117.333 c-5.896,0-10.667,4.771-10.667,10.667C106.667,144.563,111.438,149.333,117.333,149.333z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M245.333,256h-128c-5.896,0-10.667,4.771-10.667,10.667c0,5.896,4.771,10.667,10.667,10.667h128     c5.896,0,10.667-4.771,10.667-10.667C256,260.771,251.229,256,245.333,256z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M471.167,64c-0.618,0-1.217,0.155-1.833,0.184V64c0-23.531-19.146-42.667-42.667-42.667h-384 C19.146,21.333,0,40.469,0,64v416c0,4.313,2.604,8.208,6.583,9.854c1.313,0.552,2.708,0.813,4.083,0.813 c2.771,0,5.5-1.083,7.542-3.125L121.75,384h304.917c23.521,0,42.667-19.135,42.667-42.667V164.411l30.708-30.703c0,0,0,0,0-0.01 c7.604-7.604,11.958-18.125,11.958-28.865C512,82.313,493.688,64,471.167,64z M448,341.333c0,11.76-9.563,21.333-21.333,21.333 H117.333c-2.833,0-5.542,1.125-7.542,3.125L21.333,454.25V64c0-11.76,9.563-21.333,21.333-21.333h384 C438.438,42.667,448,52.24,448,64v7.286c-2.025,1.392-3.962,2.923-5.708,4.672L326.232,192H117.333 c-5.896,0-10.667,4.771-10.667,10.667c0,5.896,4.771,10.667,10.667,10.667h191.785l-10.243,51.24 c-0.708,3.5,0.396,7.115,2.917,9.635c2.021,2.021,4.75,3.125,7.542,3.125c0.688,0,1.396-0.073,2.083-0.208l53.313-10.667 c2.083-0.417,3.979-1.427,5.458-2.917L448,185.742V341.333z M357.396,246.177l-34.458,6.896l6.896-34.5l96.828-96.828 l27.587,27.587L357.396,246.177z M484.958,118.625l-15.625,15.625l-27.589-27.589l15.63-15.63 c3.625-3.615,8.646-5.698,13.792-5.698c10.75,0,19.5,8.75,19.5,19.5C490.667,109.958,488.583,114.99,484.958,118.625z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Feedbacks</span>
                </a>
            </li>
        </ul>
    </li>
    <!-- end -->

    <!-- start -->
    @php
        $class='';
        $array=array('files','file','magazines','magazine','videos');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
      
    <li class="relative py-3 px-3  {{$class}}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 407.51 407.51" style="enable-background:new 0 0 407.51 407.51;" xml:space="preserve"><g><g><g><path d="M365.714,57.469c-0.542-5.937-5.533-10.474-11.494-10.449H83.069c-5.162-0.577-9.814,3.139-10.391,8.301 c-0.041,0.366-0.06,0.735-0.058,1.103l-2.09,246.596H11.494C5.196,303.987,0.416,309.201,0,315.559V332.8 c0.79,37.441,30.505,67.842,67.918,69.486h228.833c38.087,0.001,68.964-30.874,68.965-68.961c0-0.175-0.001-0.35-0.002-0.524 V57.469z M70.531,381.388c-27.008,0.006-49.064-21.585-49.633-48.588v-8.882h203.755v8.882 c0.054,18.367,7.602,35.916,20.898,48.588H70.531z M344.816,332.8c0,27.411-22.221,49.633-49.633,49.633 c-27.411,0-49.633-22.221-49.633-49.633v-17.241c0-5.747-3.657-12.539-9.404-12.539H91.429l2.09-235.102h251.298V332.8z"/><path d="M126.955,141.061h80.98c5.771,0,10.449-4.678,10.449-10.449c0-5.771-4.678-10.449-10.449-10.449h-80.98 c-5.771,0-10.449,4.678-10.449,10.449C116.506,136.383,121.184,141.061,126.955,141.061z"/><path d="M126.955,198.531h164.571c5.771,0,10.449-4.678,10.449-10.449s-4.678-10.449-10.449-10.449H126.955 c-5.771,0-10.449,4.678-10.449,10.449S121.184,198.531,126.955,198.531z"/><path d="M126.955,261.225h164.571c5.771,0,10.449-4.678,10.449-10.449s-4.678-10.449-10.449-10.449H126.955 c-5.771,0-10.449,4.678-10.449,10.449S121.184,261.225,126.955,261.225z"/><path d="M396.016,5.225H124.865c-5.771,0-10.449,4.678-10.449,10.449c0,5.771,4.678,10.449,10.449,10.449h261.747v264.882 c0,5.771,4.678,10.449,10.449,10.449s10.449-4.678,10.449-10.449V15.674C406.968,9.737,401.978,5.2,396.016,5.225z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Media Files <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"></span>
        </a>
        <ul class="list-reset sites-sidebar">
            @if(config('gvideoroom.enabled', false))
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'files' ? 'active':''}} || {{Request::segment ('2') == 'file' ? 'active':''}}">
                <a href="{{ url('admin/files') }}" class="flex items-center">
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M256,31C115.39,31,0,145.39,0,286v120c0,24.814,20.186,45,45,45h15V301H45c-5.284,0-10.285,1.082-15,2.763V286 C30,161.928,131.928,61,256,61s226,100.928,226,225v17.763c-4.715-1.681-9.716-2.763-15-2.763h-15v150h15 c24.814,0,45-20.186,45-45V286C512,145.39,396.61,31,256,31z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M135,271h-15c-16.569,0-30,13.431-30,30v150c0,16.569,13.431,30,30,30h15c8.284,0,15-6.716,15-15V286 C150,277.716,143.284,271,135,271z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M392,271h-15c-8.284,0-15,6.716-15,15v180c0,8.284,6.716,15,15,15h15c16.569,0,30-13.431,30-30V301 C422,284.431,408.569,271,392,271z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">Media Files</span>
                </a>
            </li>
            @endif

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'magazines' ? 'active':''}} || {{Request::segment ('2') == 'magazine' ? 'active':''}}">
                <a href="{{ url('/admin/magazines') }}" class="flex  items-center">
                    <!--  <img src="{{asset('uploads/icons/sidebar/magazine.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M439.652,66.783h-51.767C380.129,28.725,346.4,0,306.087,0c-9.22,0-16.696,7.475-16.696,16.696v50.087H72.348 c-9.22,0-16.696,7.475-16.696,16.696v411.826c0,9.22,7.475,16.696,16.696,16.696c11.834,0,362.155,0,367.304,0 c9.22,0,16.696-7.475,16.696-16.696V83.478C456.348,74.258,448.873,66.783,439.652,66.783z M89.043,100.174h200.348v100.174 H139.13c-9.22,0-16.696,7.475-16.696,16.696c0,9.22,7.475,16.696,16.696,16.696h150.261v112.484 c-17.175,2.434-33.414,8.61-47.77,18.15c-10.197-21.483-25.498-40.557-44.476-55.121c-26.42-20.275-58.027-30.992-91.406-30.992 c-5.591,0-11.165,0.326-16.696,0.939V100.174z M322.783,478.609H89.043V312.85c5.51-0.787,11.09-1.198,16.696-1.198 c52.06,0,98.31,34.941,112.467,84.97c3.517,12.428,19.128,16.249,28.033,7.095c11.896-12.232,26.832-20.34,43.152-23.627v15.041 c0,9.22,7.475,16.696,16.696,16.696h16.696c18.412,0,33.391,14.979,33.391,33.391    C356.174,463.629,341.195,478.609,322.783,478.609z M356.174,387.397c-9.828-5.698-21.237-8.962-33.391-8.962V36.252    c19.435,6.891,33.391,25.46,33.391,47.226V387.397z M422.957,478.609h-42.376c5.702-9.832,8.984-21.231,8.984-33.391V100.174 h33.391V478.609z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M205.913,133.565H139.13c-9.22,0-16.696,7.475-16.696,16.696s7.475,16.696,16.696,16.696h66.783 c9.22,0,16.696-7.475,16.696-16.696S215.133,133.565,205.913,133.565z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Magazine</span>
                </a>
            </li>
        </ul>
    </li>
    
    <!-- end -->
@if(config('gfee.enabled', false))
    <li class="py-3 px-3 hover:bg-red-900 {{Request::segment ('2') == 'fees' ? 'active':''}} || {{ Request::segment ('2') == 'fee' ? 'active':'' }} || {{ Request::segment ('2') == 'feedetail' ? 'active':'' }}">
            <a href="{{url('/admin/fees')}}" class="flex  items-center">
                <svg class="w-5 h-5 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56"><path fill-rule="evenodd" d="M13,22 L13,32 C16.5185185,31.6836983 18,29.7128954 18,27.1094891 C18,24.6034063 16.8477366,23.1192214 13,22 Z M10,17 L10,8 C6.72727273,8.41538462 5,10.3307692 5,12.4307692 C5,14.5307692 6.36363636,16.0769231 10,17 Z M12.8398058,17.7367206 L13.9116505,18.0138568 C19.784466,19.4226328 23,21.9168591 23,26.8360277 C23,32.4942263 18.5339806,35.704388 12.8398058,36.1200924 L12.8398058,40 L10.3165049,40 L10.3165049,36.1200924 C4.64466019,35.6812933 0.15631068,32.3787529 0,26.8360277 L4.6223301,26.8360277 C5.02427184,29.5381062 6.72135922,31.5242494 10.3165049,31.9168591 L10.3165049,21.8475751 L9.40097087,21.6166282 C3.72912621,20.2540416 0.669902913,17.6212471 0.669902913,12.9330254 C0.669902913,7.75981524 4.68932039,4.34180139 10.3165049,3.90300231 L10.3165049,0 L12.8398058,0 L12.8398058,3.90300231 C18.4223301,4.36489607 22.4640777,7.82909931 22.6427184,13.0715935 L17.9980583,13.0715935 C17.707767,10.1616628 15.6980583,8.47575058 12.8398058,8.10623557 L12.8398058,17.7367206 Z" transform="translate(16 8)"/></svg>
                <span class="mx-3 whitespace-no-wrap">Fee Record</span>
            </a>
    </li>
@endif
    <!-- start -->
    @php
        $class='';
        $array=array('discipline','disciplines'); 
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    <!-- 'fees','feedetail','fee', -->
    <li class="relative py-3 px-3  {{$class}}">
        <a href="#" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/settings.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m467 227h-16v-152c0-3.978-1.58-7.793-4.394-10.606l-60-60c-2.812-2.813-6.627-4.394-10.606-4.394-13.307 0-291.326 0-300 0-8.284 0-15 6.716-15 15v152h-16c-8.284 0-15 6.716-15 15v285c0 24.813 20.187 45 45 45h362c24.813 0 45-20.187 45-45v-225c0-8.284-6.716-15-15-15zm-151 0v-152c0-3.978-1.58-7.793-4.394-10.606l-34.393-34.394h68.787v61c0 8.284 6.716 15 15 15h60v121zm-75-190.787 39.787 39.787h-39.787zm174.787 39.787h-39.787v-39.787zm-324.787-46h120v61c0 8.284 6.716 15 15 15h60v121h-35.729l-25.854-51.708c-2.541-5.082-7.735-8.292-13.417-8.292h-120zm361 437c0 8.271-6.729 15-15 15h-362c-8.271 0-15-6.729-15-15v-270h141.729l25.854 51.708c2.541 5.082 7.735 8.292 13.417 8.292h211z"/><path d="m301 391h105c8.284 0 15-6.716 15-15s-6.716-15-15-15h-105c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/><path d="m301 451h105c8.284 0 15-6.716 15-15s-6.716-15-15-15h-105c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Records <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar">
            <!-- <li class="py-3 px-3 hover:font-semibold">
                <a href="{{url('/admin/fees')}}" class="flex  items-center">
                    <svg class="w-5 h-5 fill-current" xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56"><path fill-rule="evenodd" d="M13,22 L13,32 C16.5185185,31.6836983 18,29.7128954 18,27.1094891 C18,24.6034063 16.8477366,23.1192214 13,22 Z M10,17 L10,8 C6.72727273,8.41538462 5,10.3307692 5,12.4307692 C5,14.5307692 6.36363636,16.0769231 10,17 Z M12.8398058,17.7367206 L13.9116505,18.0138568 C19.784466,19.4226328 23,21.9168591 23,26.8360277 C23,32.4942263 18.5339806,35.704388 12.8398058,36.1200924 L12.8398058,40 L10.3165049,40 L10.3165049,36.1200924 C4.64466019,35.6812933 0.15631068,32.3787529 0,26.8360277 L4.6223301,26.8360277 C5.02427184,29.5381062 6.72135922,31.5242494 10.3165049,31.9168591 L10.3165049,21.8475751 L9.40097087,21.6166282 C3.72912621,20.2540416 0.669902913,17.6212471 0.669902913,12.9330254 C0.669902913,7.75981524 4.68932039,4.34180139 10.3165049,3.90300231 L10.3165049,0 L12.8398058,0 L12.8398058,3.90300231 C18.4223301,4.36489607 22.4640777,7.82909931 22.6427184,13.0715935 L17.9980583,13.0715935 C17.707767,10.1616628 15.6980583,8.47575058 12.8398058,8.10623557 L12.8398058,17.7367206 Z" transform="translate(16 8)"/></svg>
                    <span class="mx-3 whitespace-no-wrap">Fees Records</span>
                </a>
            </li> -->

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'disciplines' ? 'active':''}} || {{Request::segment ('2') == 'discipline' ? 'active':''}}">
                <a href="{{ url('/admin/disciplines') }}" class="flex  items-center">
                    <!--  <img src="{{asset('uploads/icons/reminder_.svg')}}" class="w-5 h-5"> -->
                    <svg xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-4 0 361 361.81333" class="text-white w-5 h-5 fill-current"><g><path d="m353.964844 143.359375c0-36.851563-29.984375-66.835937-66.839844-66.835937-8.195312 0-16.019531 1.554687-23.28125 4.269531-18.796875-22.527344-44.214844-37.734375-72.289062-43.746094v-6.328125c0-16.9375-13.78125-30.71875-30.722657-30.71875-16.9375 0-30.71875 13.78125-30.71875 30.71875v8.125c-54.988281 15.039062-95.574219 65.304688-95.574219 124.996094v102.398437h-3.414062c-16.9375 0-30.71875 13.78125-30.71875 30.722657 0 16.9375 13.78125 30.71875 30.71875 30.71875h93.390625c4.621094 19.832031 22.15625 34.132812 43.144531 34.132812 20.988282 0 38.527344-14.300781 43.144532-34.132812h86.5625c16.941406 0 30.71875-13.78125 30.71875-30.71875 0-16.941407-13.777344-30.722657-30.71875-30.722657h-3.414063v-56.386719c33.660156-3.433593 60.011719-31.941406 60.011719-66.492187zm-13.652344 0c0 29.328125-23.859375 53.183594-53.1875 53.183594-29.324219 0-53.183594-23.855469-53.183594-53.183594s23.859375-53.183594 53.183594-53.183594c29.328125 0 53.1875 23.855469 53.1875 53.183594zm-196.546875-112.640625c0-9.410156 7.652344-17.066406 17.066406-17.066406 9.414063 0 17.066407 7.65625 17.066407 17.066406v4.148438c-4.507813-.472657-9.0625-.734376-13.652344-.734376-6.984375 0-13.789063.710938-20.480469 1.777344zm23.894531 317.441406c-13.378906 0-24.65625-8.4375-28.875-20.480468h57.75c-4.21875 12.042968-15.496094 20.480468-28.875 20.480468zm129.707032-68.265625c9.414062 0 17.066406 7.65625 17.066406 17.066407 0 9.410156-7.652344 17.066406-17.066406 17.066406h-266.242188c-9.414062 0-17.066406-7.65625-17.066406-17.066406 0-9.410157 7.652344-17.066407 17.066406-17.066407h10.242188c3.773437 0 6.824218-3.058593 6.824218-6.828125v-109.226562c0-63.992188 52.0625-116.054688 116.054688-116.054688 33.46875 0 64.816406 14.363282 86.882812 39.351563-18.519531 11.894531-30.84375 32.628906-30.84375 56.222656 0 34.550781 26.355469 63.058594 60.011719 66.492187v63.214844c0 3.769532 3.054687 6.828125 6.828125 6.828125zm0 0" data-original="#000000" class="active-path"></path><path d="m268.859375 168.449219c1.746094 0 3.496094-.667969 4.828125-2l18.265625-18.261719c1.28125-1.28125 2-3.019531 2-4.828125v-26.09375c0-3.769531-3.054687-6.824219-6.828125-6.824219s-6.824219 3.054688-6.824219 6.824219v23.269531l-16.265625 16.261719c-2.667968 2.664063-2.667968 6.988281 0 9.652344 1.332032 1.335937 3.078125 2 4.824219 2zm0 0" data-original="#000000" class="active-path"></path><path d="m184.726562 266.238281h-13.652343c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h13.652343c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path"></path><path d="m146.039062 266.238281h-70.539062c-3.773438 0-6.828125 3.058594-6.828125 6.828125 0 3.769532 3.054687 6.828125 6.828125 6.828125h70.539062c3.773438 0 6.828126-3.058593 6.828126-6.828125 0-3.769531-3.054688-6.828125-6.828126-6.828125zm0 0" data-original="#000000" class="active-path"></path></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Disciplinary Records</span>
                </a>
            </li>
        </ul>
    </li> 
    <!-- end -->   
@if(config('ginventory.enabled', false))
    <!-- inventory menu -->
    @php
        $class='';
        $array=array('category','vendor','location','product');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3  {{$class}}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white"  enable-background="new 0 0 64 64"  viewBox="0 0 64 64"  xmlns="http://www.w3.org/2000/svg"><g><circle cx="16" cy="16" r="1"/><circle cx="24" cy="16" r="1"/><path d="m23.789 20.658.105-.211-1.789-.895-.105.212c-.381.762-1.147 1.236-2 1.236s-1.619-.474-2-1.236l-.105-.211-1.789.895.105.211c.722 1.444 2.174 2.341 3.789 2.341s3.067-.897 3.789-2.342z"/><path d="m21.707 12.293c-.456-.456-.707-1.063-.707-1.707v-1.586h-2v1.586c0 1.179.459 2.287 1.293 3.121z"/><path d="m25.707 12.293c-.456-.456-.707-1.063-.707-1.707v-1.586h-2v1.586c0 1.179.459 2.287 1.293 3.121z"/><path d="m61 41h-4v-18h2c1.103 0 2-.897 2-2v-18c0-1.103-.897-2-2-2h-18c-1.103 0-2 .897-2 2v18h-2c-1.103 0-2 .897-2 2v7.832c-1.312-.994-2.872-1.681-4.586-1.926l-5.607-.801-.545-2.181c1.951-1.053 3.463-2.81 4.214-4.924h.524c2.206 0 4-1.794 4-4 0-.901-.31-1.724-.814-2.393l.322-.967c.326-.982.492-2.003.492-3.036 0-5.295-4.309-9.604-9.604-9.604h-6.793c-5.294 0-9.603 4.309-9.603 9.604 0 1.033.166 2.055.492 3.037l.322.967c-.504.668-.814 1.491-.814 2.392 0 2.206 1.794 4 4 4h.525c.751 2.114 2.262 3.871 4.214 4.924l-.545 2.181-5.607.801c-4.896.699-8.587 4.954-8.587 9.9v11.194c0 3.519 2.614 6.432 6 6.92v6.08h26v-6.08c3.386-.488 6-3.401 6-6.92v-7h2v18c0 1.103.897 2 2 2h18c1.103 0 2-.897 2-2v-18c0-1.103-.897-2-2-2zm-14-38h2v4h-2zm4 0h2v4h-2zm-10 0h4v6h10v-6h4v18h-18zm2 20h2v4h-2zm4 0h2v4h-2zm-21.464 7.23-1.149 3.448-2.607-1.043 2.574-2.574zm3.464-11.23h-.059c.037-.329.059-.662.059-1v-3c1.103 0 2 .897 2 2s-.897 2-2 2zm-18 0c-1.103 0-2-.897-2-2s.897-2 2-2v3c0 .338.022.671.059 1zm2-1v-4c0-1.654 1.346-3 3-3h1v-2h-1c-2.414 0-4.434 1.721-4.899 4h-.101c-.535 0-1.045.11-1.512.301l-.097-.292c-.26-.779-.391-1.587-.391-2.405 0-4.193 3.411-7.604 7.604-7.604h6.793c4.192 0 7.603 3.411 7.603 7.604 0 .818-.131 1.627-.391 2.404l-.098.293c-.466-.191-.976-.301-1.511-.301v-1h-2v6c0 3.859-3.141 7-7 7s-7-3.141-7-7zm7 9c.827 0 1.625-.121 2.387-.331l.506 2.024-2.893 2.893-2.893-2.893.506-2.024c.762.21 1.56.331 2.387.331zm-4.354 3.06 2.574 2.574-2.607 1.043-1.149-3.448zm-6.646 26.94h2v4h-2zm10-8c1.103 0 2 .897 2 2s-.897 2-2 2h-2v-4zm-2.184 6h2.184c2.206 0 4-1.794 4-4s-1.794-4-4-4h-6v-6h2v2c0 1.103.897 2 2 2h6c1.103 0 2-.897 2-2v-2h2v20h-14v-4h1c1.302 0 2.402-.839 2.816-2zm.184-14h6v2h-6zm12 20v-4h2v4zm8-11c0 2.757-2.243 5-5 5h-3v-6h6v-2h-2v-8h-2v8h-2v-6c0-1.103-.897-2-2-2h-14c-1.103 0-2 .897-2 2v6h-2v-8h-2v8h-2v2h10v5c0 .552-.448 1-1 1h-6c-2.757 0-5-2.243-5-5v-11.194c0-3.956 2.953-7.36 6.869-7.919l2.583-.369 1.934 5.805 5.614-2.246 5.613 2.245 1.934-5.805 2.583.369c3.917.559 6.87 3.964 6.87 7.92zm2-9v-2.194c0-2.214-.744-4.286-2-5.966v-9.84h4v6h10v-6h4v18zm10 2h2v4h-2zm4 0h2v4h-2zm8 18h-18v-18h4v6h10v-6h4z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Inventory <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar bottom-0" style="top: auto;">
            <li class="py-3 px-3 {{Request::segment ('2') == 'category' ? 'active':''}} && {{Request::segment ('2') == 'categoryvendor' ? 'active':''}}">
                <a href="{{ url('/admin/category/show') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" height="512pt" viewBox="0 -52 512.00001 512" width="512pt" xmlns="http://www.w3.org/2000/svg"><path d="m0 113.292969h113.292969v-113.292969h-113.292969zm30.003906-83.289063h53.289063v53.289063h-53.289063zm0 0"/><path d="m149.296875 0v113.292969h362.703125v-113.292969zm332.699219 83.292969h-302.695313v-53.289063h302.695313zm0 0"/><path d="m0 260.300781h113.292969v-113.292969h-113.292969zm30.003906-83.292969h53.289063v53.289063h-53.289063zm0 0"/><path d="m149.296875 260.300781h362.703125v-113.292969h-362.703125zm30.003906-83.292969h302.695313v53.289063h-302.695313zm0 0"/><path d="m0 407.308594h113.292969v-113.296875h-113.292969zm30.003906-83.292969h53.289063v53.289063h-53.289063zm0 0"/><path d="m149.296875 407.308594h362.703125v-113.296875h-362.703125zm30.003906-83.292969h302.695313v53.289063h-302.695313zm0 0"/></svg>
                    <span class="mx-3 whitespace-no-wrap">Categories</span>
                </a>
            </li>

            <li class="py-3 px-3 {{Request::segment ('2') == 'vendor' ? 'active':''}}">
                <a href="{{ url('/admin/vendor/show') }}" class="flex items-center">
                    <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" class="w-5 h-5 fill-current text-white" viewBox="0 0 488.217 488.217" style="enable-background:new 0 0 488.217 488.217;" xml:space="preserve"><g><path d="M340.817,121.226c0,2.998,2.43,5.442,5.443,5.442h15.932c3.015,0,5.442-2.444,5.442-5.442V92.995h-26.817V121.226z"/><path d="M277.122,227.963c1.938,0.754,3.92,1.104,5.871,1.104c6.649,0,12.902-4.048,15.426-10.624l11.98-31.427v5.292h19.295 V136.49V94.431v-1.436h-4.934c0,0-0.018,0.008-0.033,0.008c-8.6,0-14.854,2.826-17.631,10.141L267.569,206.66 c-0.855,2.285-1.125,4.61-0.967,6.895c4.3,3.697,7.695,8.434,9.743,13.924C276.63,227.605,276.806,227.852,277.122,227.963z"/><path d="M354.212,78.666c18.977,0,34.386-17.614,34.386-39.337C388.598,17.614,373.188,0,354.212,0 c-18.979,0-34.402,17.614-34.402,39.329C319.809,61.053,335.232,78.666,354.212,78.666z"/><path d="M131.47,153.994c20.039,0,36.258-18.558,36.258-41.456c0-22.915-16.219-41.473-36.258-41.473 c-19.994,0-36.213,18.558-36.213,41.473C95.257,135.436,111.475,153.994,131.47,153.994z"/><path d="M398.182,187.467l11.838,30.976c2.49,6.576,8.759,10.624,15.407,10.624c1.969,0,3.937-0.349,5.871-1.103 c8.522-3.245,12.807-12.782,9.554-21.303l-39.527-103.516c-2.778-7.307-9.739-10.149-17.599-10.149h-4.95v99.313h19.326 L398.182,187.467z"/><path d="M469.223,234.786h-71.042l-0.08-30.918h-13.171v25.604c0,2.046-0.809,3.84-1.982,5.315h-57.491 c-1.173-1.475-1.999-3.269-1.999-5.315v-25.604h-13.06v30.918h-32.196c0.016,0.167,0.096,0.311,0.126,0.468 c1.683,14.044-5.378,27.103-16.899,33.744h190.688v79.087H432.87v-15.059c0-6.3-5.11-11.409-11.41-11.409h-17.678v-13.997 c0-6.3-5.108-11.409-11.408-11.409h-39.512c-6.299,0-11.41,5.109-11.41,11.409v13.997h-13.646c-6.3,0-11.411,5.109-11.411,11.409 v15.059h-37.242v-15.059c0-6.3-5.125-11.409-11.408-11.409h-34.402c-6.3,0-11.425,5.109-11.425,11.409v15.059h-44.415l0.333-79.087 v-33.213l12.407,18.17c3.254,4.777,8.65,7.577,14.361,7.577c0.683,0,1.381-0.039,2.094-0.119l39.75-4.792 c9.523-1.15,16.33-9.814,15.188-19.351c-1.158-9.539-9.569-16.425-19.359-15.195l-29.277,3.531l-33.734-49.43 c-4.143-6.063-10.698-7.07-18.25-7.07h-60.474c-8.829,0-15.98,3.08-18.804,10.965L42.034,289.698 c-2.824,7.783,0.477,16.004,7.143,20.295v35.942H13.298c-3.871,0-7.475,1.96-9.568,5.22c-2.111,3.253-2.428,7.355-0.84,10.887 l23.928,53.008c1.841,4.093,5.903,6.719,10.394,6.719h48.445v45.574c0,11.529,9.346,20.875,20.883,20.875 c11.521,0,20.867-9.346,20.867-20.875V349.497h8.345v117.845c0,11.529,9.362,20.875,20.867,20.875 c11.537,0,20.884-9.346,20.884-20.875v-5.078h288.262c11.33,0,20.564-9.22,20.564-20.565V251.893 C486.329,242.442,478.681,234.786,469.223,234.786z M66.282,345.935v-35.021c3.761-1.943,6.902-5.078,8.457-9.362l10.568-29.206 l0.35,73.59H66.282z M452.116,428.061h-48.334v-7.57c0-6.3-5.108-11.417-11.408-11.417h-24.818v-9.767 c0-6.316-5.109-11.417-11.409-11.417h-57.331c-6.283,0-11.395,5.101-11.395,11.417v28.754h-36.877v-17.091 c0-6.308-5.127-11.416-11.41-11.416h-37.527c-6.299,0-11.41,5.108-11.41,11.416v17.091h-12.693v-62.871h274.613V428.061z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Vendors</span>
                </a>
            </li>

            <li class="py-3 px-3 {{Request::segment ('2') == 'location' ? 'active':''}}">
                <a href="{{ url('/admin/location/show') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M256,0C148.773,0,61.538,87.235,61.538,194.462c0,57.897,36.036,139.279,69.759,196.134 C152.949,427.099,208.441,512,256,512s103.051-84.901,124.703-121.404c33.723-56.856,69.759-138.237,69.759-196.134 C450.462,87.235,363.227,0,256,0z M355.297,375.527c-41.64,70.202-81.472,106.934-99.298,106.934s-57.657-36.732-99.297-106.934 c-39.866-67.212-65.626-138.284-65.626-181.066c0-90.938,73.985-164.923,164.923-164.923s164.923,73.985,164.923,164.923 C420.923,237.243,395.164,308.316,355.297,375.527z"/></g></g><g><g><path d="M358.816,183.019l-19.692-68.923c-1.812-6.341-7.607-10.712-14.201-10.712H187.077c-6.594,0-12.389,4.371-14.201,10.712 l-19.692,68.923c-0.377,1.32-0.568,2.685-0.568,4.058c0,19.254,12.348,35.671,29.539,41.767v66.54 c0,8.156,6.613,14.769,14.769,14.769h118.154c8.157,0,14.769-6.613,14.769-14.769v-66.54c17.19-6.097,29.539-22.513,29.539-41.767 C359.385,185.704,359.194,184.34,358.816,183.019z M300.308,280.615h-88.615v-51.772c0.678-0.24,1.349-0.498,2.012-0.77 c0.012-0.005,0.025-0.01,0.036-0.015c0.638-0.263,1.269-0.541,1.891-0.832c0.048-0.023,0.096-0.045,0.145-0.069 c0.58-0.274,1.152-0.559,1.718-0.858c0.086-0.045,0.171-0.09,0.256-0.135c0.517-0.277,1.027-0.563,1.532-0.86 c0.126-0.074,0.253-0.147,0.379-0.223c0.449-0.27,0.891-0.548,1.329-0.833c0.169-0.11,0.341-0.218,0.508-0.33 c0.371-0.248,0.735-0.506,1.099-0.765c0.223-0.159,0.447-0.314,0.667-0.477c0.265-0.197,0.524-0.402,0.784-0.605 c0.303-0.235,0.608-0.467,0.906-0.709c0.022-0.018,0.043-0.037,0.065-0.055c0.487-0.4,0.97-0.805,1.44-1.226 c1.211,1.083,2.487,2.089,3.808,3.032c0.304,0.218,0.607,0.44,0.917,0.65c0.005,0.003,0.009,0.006,0.014,0.009 c6.543,4.436,14.328,7.17,22.716,7.561c0.692,0.033,1.386,0.049,2.084,0.049c0.698,0,1.392-0.017,2.084-0.049 c8.388-0.39,16.173-3.125,22.716-7.561c0.005-0.003,0.009-0.006,0.014-0.009c0.31-0.211,0.611-0.432,0.917-0.65 c1.32-0.943,2.596-1.95,3.809-3.032c0.471,0.42,0.953,0.826,1.44,1.226c0.022,0.019,0.043,0.037,0.065,0.055 c0.296,0.242,0.602,0.474,0.904,0.708c0.262,0.203,0.521,0.409,0.787,0.607c0.219,0.161,0.443,0.316,0.665,0.475 c0.364,0.26,0.729,0.518,1.101,0.767c0.168,0.112,0.339,0.22,0.508,0.33c0.438,0.285,0.881,0.564,1.329,0.833 c0.126,0.075,0.252,0.149,0.379,0.223c0.504,0.296,1.015,0.583,1.532,0.86c0.086,0.045,0.17,0.091,0.256,0.135 c0.566,0.298,1.139,0.584,1.719,0.858c0.047,0.023,0.096,0.045,0.144,0.068c0.623,0.292,1.254,0.569,1.892,0.832 c0.012,0.005,0.025,0.01,0.036,0.015c0.663,0.273,1.333,0.53,2.012,0.77V280.615z M315.077,201.846 c-0.458,0-0.908-0.028-1.355-0.069c-0.153-0.014-0.303-0.035-0.454-0.054c-0.293-0.036-0.585-0.081-0.872-0.134 c-0.172-0.031-0.345-0.064-0.515-0.102c-0.279-0.062-0.552-0.135-0.824-0.213c-0.154-0.043-0.31-0.082-0.463-0.13 c-0.39-0.124-0.773-0.266-1.148-0.421c-0.156-0.064-0.306-0.139-0.459-0.209c-0.246-0.112-0.489-0.227-0.728-0.351 c-0.155-0.081-0.307-0.166-0.46-0.252c-0.246-0.14-0.487-0.288-0.725-0.441c-0.121-0.078-0.244-0.155-0.362-0.236 c-0.725-0.5-1.405-1.061-2.029-1.68c-0.047-0.047-0.093-0.096-0.139-0.145c-0.269-0.274-0.527-0.557-0.774-0.852 c-0.054-0.064-0.107-0.129-0.161-0.195c-0.246-0.304-0.481-0.617-0.703-0.94c-0.032-0.047-0.067-0.094-0.099-0.141 c-0.502-0.748-0.935-1.545-1.296-2.381c-0.042-0.098-0.08-0.201-0.12-0.3c-0.692-1.708-1.083-3.571-1.083-5.526 c0-8.157-6.613-14.769-14.769-14.769s-14.769,6.613-14.769,14.769c0,1.953-0.39,3.816-1.082,5.525 c-0.04,0.1-0.078,0.204-0.121,0.302c-0.36,0.836-0.794,1.632-1.296,2.38c-0.033,0.048-0.067,0.094-0.099,0.141 c-0.223,0.323-0.457,0.636-0.703,0.94c-0.053,0.065-0.106,0.13-0.16,0.195c-0.247,0.294-0.505,0.578-0.774,0.852 c-0.046,0.047-0.092,0.097-0.139,0.145c-0.623,0.618-1.304,1.18-2.028,1.68c-0.119,0.082-0.241,0.159-0.362,0.236 c-0.237,0.154-0.479,0.3-0.725,0.441c-0.152,0.086-0.304,0.171-0.46,0.252c-0.238,0.124-0.482,0.239-0.727,0.351 c-0.154,0.07-0.304,0.145-0.46,0.209c-0.375,0.156-0.758,0.296-1.148,0.42c-0.153,0.048-0.308,0.086-0.463,0.13 c-0.272,0.077-0.545,0.151-0.824,0.213c-0.17,0.038-0.343,0.071-0.515,0.102c-0.288,0.053-0.579,0.097-0.873,0.134 c-0.152,0.019-0.302,0.04-0.454,0.054c-0.447,0.041-0.898,0.069-1.355,0.069c-0.457,0-0.908-0.028-1.355-0.069 c-0.153-0.014-0.303-0.035-0.454-0.054c-0.293-0.036-0.585-0.081-0.873-0.134c-0.172-0.031-0.345-0.064-0.515-0.102 c-0.279-0.062-0.552-0.135-0.824-0.213c-0.154-0.043-0.31-0.082-0.463-0.13c-0.39-0.124-0.773-0.266-1.148-0.421 c-0.156-0.064-0.306-0.139-0.459-0.209c-0.246-0.112-0.489-0.226-0.728-0.351c-0.155-0.081-0.307-0.166-0.46-0.252 c-0.246-0.14-0.487-0.287-0.725-0.441c-0.121-0.078-0.244-0.155-0.362-0.236c-0.725-0.5-1.405-1.061-2.028-1.68 c-0.047-0.047-0.093-0.096-0.139-0.145c-0.269-0.274-0.528-0.557-0.774-0.852c-0.054-0.064-0.107-0.129-0.16-0.195 c-0.246-0.304-0.482-0.617-0.703-0.94c-0.032-0.047-0.067-0.094-0.099-0.141c-0.502-0.748-0.935-1.545-1.296-2.381 c-0.042-0.099-0.08-0.201-0.12-0.3c-0.692-1.708-1.083-3.571-1.083-5.526c0-8.157-6.613-14.769-14.769-14.769 s-14.769,6.613-14.769,14.769c0,1.953-0.39,3.816-1.082,5.525c-0.04,0.1-0.078,0.204-0.121,0.302 c-0.36,0.836-0.794,1.633-1.296,2.38c-0.032,0.048-0.067,0.094-0.099,0.141c-0.223,0.323-0.457,0.636-0.703,0.94 c-0.053,0.065-0.106,0.13-0.161,0.195c-0.247,0.294-0.505,0.578-0.774,0.852c-0.046,0.047-0.092,0.097-0.139,0.145 c-0.623,0.618-1.304,1.18-2.028,1.68c-0.119,0.082-0.241,0.159-0.362,0.236c-0.237,0.154-0.479,0.3-0.725,0.441 c-0.152,0.086-0.304,0.171-0.46,0.252c-0.238,0.124-0.481,0.239-0.727,0.351c-0.154,0.07-0.304,0.145-0.46,0.209 c-0.375,0.156-0.758,0.296-1.148,0.42c-0.153,0.048-0.308,0.086-0.463,0.13c-0.272,0.077-0.545,0.151-0.824,0.213 c-0.17,0.038-0.343,0.071-0.515,0.102c-0.289,0.053-0.579,0.097-0.873,0.134c-0.152,0.019-0.302,0.04-0.454,0.054 c-0.447,0.041-0.898,0.069-1.355,0.069c-7.563,0-13.815-5.713-14.669-13.049l15.959-55.872h115.565l15.964,55.874 C328.892,196.133,322.64,201.846,315.077,201.846z"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Locations</span>
                </a>
            </li>

            <li class="py-3 px-3 {{Request::segment ('2') == 'product' ? 'active':''}}">
                <a href="{{ url('/admin/product/show') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="96.903px" height="96.904px" viewBox="0 0 96.903 96.904" style="enable-background:new 0 0 96.903 96.904;" xml:space="preserve"><g><path d="M96.123,52.261l-22.984-8.418v-25.62c0-0.494-0.313-0.934-0.781-1.096L48.826,8.508c-0.244-0.086-0.518-0.084-0.762,0 l-23.488,8.381c-0.237,0.084-0.441,0.238-0.542,0.398c-0.172,0.207-0.267,0.471-0.267,0.738v25.807l-22.958,8.19 c-0.237,0.085-0.441,0.239-0.542,0.399C0.095,52.628,0,52.892,0,53.16v26.043c0,0.49,0.313,0.932,0.778,1.094l23.502,8.1 c0.245,0.084,0.518,0.084,0.763,0l23.409-8.062l23.36,8.062c0.244,0.084,0.518,0.084,0.763,0l23.508-8.11 c0.489-0.15,0.82-0.596,0.82-1.109V53.357C96.903,52.863,96.592,52.423,96.123,52.261z M69.042,42.082l-18.063,6.113V28.822 l18.063-6.625V42.082z M48.444,12.712l16.801,6.277l-16.781,6.215l-17.73-6.119L48.444,12.712z M24.698,60.339L6.968,54.22 l17.711-6.373l16.801,6.277L24.698,60.339z M45.276,77.216L27.212,83.33V63.957l18.064-6.625V77.216z M72.229,60.339L54.499,54.22 l17.711-6.373l16.802,6.277L72.229,60.339z M92.807,77.216L74.743,83.33V63.957l18.063-6.625V77.216z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Products</span>
                </a>
            </li>
        </ul>
    </li>
    <!-- inventory menu -->

    <!--stock module-->
    @php
        $class='';
        $array=array('products','purchase','sales','return','stockproduct');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3  {{$class}}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m502 453.134h-58.623v-208.537c0-5.523-4.477-10-10-10h-72.01c-5.523 0-10 4.477-10 10v208.538h-34.006v-136.02c0-5.523-4.477-10-10-10h-72.01c-5.523 0-10 4.477-10 10v136.02h-30.673v-255.249c0-5.523-4.477-10-10-10h-72.009c-5.523 0-10 4.477-10 10v255.248h-40.008v-306.242c0-5.523-4.477-10-10-10s-10 4.477-10 10v306.243h-32.661c-5.523 0-10 4.477-10 10s4.477 10 10 10h32.661v28.865c0 5.523 4.477 10 10 10s10-4.477 10-10v-28.866h439.339c5.523 0 10-4.477 10-10s-4.477-10-10-10zm-379.331 0v-245.248h52.009v245.248zm122.683 0v-126.02h52.01v126.02zm126.015 0v-198.537h52.01v198.538h-52.01z"/><path d="m52.661 69.462c5.523 0 10-4.477 10-10v-49.462c0-5.523-4.477-10-10-10s-10 4.477-10 10v49.462c0 5.523 4.477 10 10 10z"/><path d="m477.44 0h-224.196c-19.057 0-34.56 15.503-34.56 34.56v139.156c0 19.056 15.503 34.56 34.56 34.56h8.112v42.724c0 8.586 10.658 13.196 16.904 7.234l52.343-49.958h59.289c5.523 0 10-4.477 10-10s-4.477-10-10-10h-63.295c-2.571 0-5.044.991-6.904 2.766l-38.337 36.59v-29.356c0-5.523-4.477-10-10-10h-18.112c-8.028 0-14.56-6.531-14.56-14.56v-139.156c0-8.028 6.532-14.56 14.56-14.56h224.196c8.028 0 14.56 6.532 14.56 14.56v139.156c0 7.888-6.417 14.416-14.304 14.55-5.522.094-9.922 4.647-9.828 10.169s4.618 9.924 10.169 9.828c18.727-.32 33.962-15.818 33.962-34.547v-139.156c.001-19.057-15.502-34.56-34.559-34.56z"/><path d="m43.43 106.18c2.066 5.045 8.036 7.49 13.06 5.41 5.028-2.081 7.491-8.036 5.4-13.06-2.094-5.032-8.01-7.491-13.05-5.41-5.027 2.076-7.505 8.036-5.41 13.06z"/><path d="m329.466 92.359c-2.299 0-4.528.792-6.311 2.243l-49.19 40.022c-4.284 3.485-4.932 9.784-1.446 14.068 1.977 2.43 4.857 3.689 7.763 3.689 2.218 0 4.451-.734 6.305-2.244l46.434-37.779h65.9c2.39 0 4.701-.856 6.514-2.413l35.742-30.686v8.229c0 5.523 4.477 10 10 10s10-4.477 10-10v-32.263c0-5.523-4.477-10-10-10h-34.083c-5.523 0-10 4.477-10 10s4.477 10 10 10h9.728l-31.605 27.134z"/><path d="m443.37 194.06c-3.435-8.246-15.614-7.988-18.646.455-1.437 4.002-.102 8.646 3.261 11.253 3.257 2.525 7.807 2.793 11.332.665 4.166-2.514 5.926-7.879 4.053-12.373z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Stocks <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar bottom-0" style="top: auto;">
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'product' ? 'active':''}}">
                <a href="{{ url('/admin/stockproduct/show') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" height="476pt" viewBox="0 -22 476.44406 476" width="476pt" xmlns="http://www.w3.org/2000/svg"><path d="m444.632812 57.085938c-19.15625 1.847656-33.480468 18.414062-32.542968 37.636718l1.4375 58.9375c-15.757813 1.566406-29.550782 11.257813-36.367188 25.550782l-21.539062 45.222656c-3.347656 7.011718-8.234375 13.183594-14.289063 18.050781l-4.476562 3.589844c-22.765625 18.167969-35.453125 46.140625-34.117188 75.234375l-8.800781-4.1875c-3.988281-1.902344-8.765625-.207032-10.664062 3.78125l-23.613282 49.582031c-1.898437 3.992187-.207031 8.765625 3.78125 10.664063l108.820313 51.824218c1.914062.914063 4.113281 1.03125 6.113281.320313 2-.710938 3.636719-2.183594 4.546875-4.101563l23.617187-49.589844c1.898438-3.988281.207032-8.761718-3.78125-10.660156l-4.644531-2.210937-1.160156-15.511719c-.464844-6.058594 1.445313-12.0625 5.324219-16.742188l56.351562-68.191406c.113282-.136718.222656-.277344.328125-.421875 11.617188-16.21875 17.742188-35.726562 17.480469-55.671875-.007812-.378906-.042969-.757812-.101562-1.132812l-23.023438-145.261719c-.664062-4.179687-4.46875-7.121094-8.679688-6.710937zm-72.714843 358-94.371094-44.945313 16.734375-35.140625 94.371094 44.945312zm74.203125-158.78125-56.175782 67.980468c-6.519531 7.859375-9.726562 17.945313-8.949218 28.125l.480468 6.394532-61.855468-29.457032c-4.394532-26.789062 6.023437-53.863281 27.242187-70.792968l4.476563-3.589844c7.9375-6.378906 14.339844-14.464844 18.730468-23.652344l21.535157-45.222656c5.632812-11.78125 18.386719-18.414063 31.269531-16.257813l-31.480469 66.105469c-1.871093 3.984375-.175781 8.730469 3.800781 10.625 3.972657 1.890625 8.730469.21875 10.644532-3.746094l35.398437-74.332031c1.898438-3.992187.207031-8.765625-3.785156-10.664063-2.535156-1.203124-5.175781-2.167968-7.890625-2.886718l-1.480469-60.699219c0-.070313 0-.140625-.007812-.207031-.410157-7.875 3.832031-15.257813 10.835937-18.875l21.535156 135.832031c.09375 16.238281-4.914062 32.089844-14.324218 45.320313zm0 0"/><path d="m17.816406 266.285156 56.351563 68.191406c3.878906 4.679688 5.789062 10.683594 5.324219 16.742188l-1.160157 15.511719-4.644531 2.210937c-3.988281 1.898438-5.679688 6.671875-3.78125 10.660156l23.617188 49.589844c.910156 1.917969 2.546874 3.390625 4.546874 4.101563 2 .710937 4.199219.59375 6.117188-.320313l108.816406-51.824218c3.988282-1.898438 5.679688-6.671876 3.78125-10.664063l-23.617187-49.585937c-1.898438-3.988282-6.671875-5.683594-10.660157-3.78125l-8.800781 4.1875c1.332031-29.09375-11.351562-57.066407-34.117187-75.234376l-4.476563-3.589843c-6.058593-4.867188-10.941406-11.035157-14.292969-18.046875l-21.539062-45.222656c-6.816406-14.292969-20.609375-23.984376-36.367188-25.550782l1.441407-58.9375c.9375-19.21875-13.386719-35.789062-32.542969-37.636718-4.210938-.410157-8.015625 2.53125-8.679688 6.710937l-23.023437 145.261719c-.0625.375-.09375.753906-.1015625 1.132812-.2617185 19.945313 5.8632815 39.453125 17.4804685 55.671875.105469.144531.214844.285157.328125.421875zm181.082032 103.859375-94.371094 44.941407-16.734375-35.140626 94.371093-44.945312zm-161.363282-294.996093c7.003906 3.617187 11.246094 11.003906 10.835938 18.875 0 .070312-.003906.140624-.007813.210937l-1.480469 60.699219c-2.714843.714844-5.359374 1.679687-7.894531 2.886718-3.988281 1.898438-5.683593 6.675782-3.78125 10.664063l35.398438 74.335937c1.914062 3.964844 6.671875 5.636719 10.644531 3.742188 3.972656-1.890625 5.671875-6.636719 3.800781-10.621094l-31.480469-66.109375c12.882813-2.160156 25.640626 4.472657 31.269532 16.257813l21.539062 45.222656c4.390625 9.1875 10.789063 17.273438 18.726563 23.652344l4.476562 3.589844c21.21875 16.929687 31.636719 44.003906 27.242188 70.792968l-61.855469 29.457032.480469-6.394532c.777343-10.179687-2.429688-20.265625-8.945313-28.125l-56.179687-67.980468c-9.40625-13.230469-14.417969-29.082032-14.320313-45.320313zm0 0"/><path d="m333.628906 172.601562c3.316406-1.058593 5.574219-4.132812 5.59375-7.617187v-126.796875c-.019531-3.480469-2.277344-6.554688-5.59375-7.613281l-92.925781-29.964844c-1.601563-.515625-3.324219-.515625-4.925781 0l-92.953125 29.960937c-3.320313 1.058594-5.578125 4.132813-5.601563 7.617188v126.796875c.019532 3.484375 2.277344 6.554687 5.59375 7.617187l92.925782 29.960938c.796874.253906 1.632812.382812 2.46875.382812.84375 0 1.683593-.128906 2.484374-.382812zm-87.40625 11.363282v-110l77-24.800782v110zm-8-167.335938 66.839844 21.558594-66.839844 21.550781-66.839844-21.550781zm-85 32.539063 77 24.800781v110l-77-24.800781zm0 0"/></svg>
                    <span class="mx-3 whitespace-no-wrap">Products</span>
                </a>
            </li>

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'purchase' ? 'active':''}}">
                <a href="{{ url('/admin/purchase/show') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g id="Shopping_Bag-Hands-Bag-Purchase-Buy" data-name="Shopping Bag-Hands-Bag-Purchase-Buy"><path d="m43 12h-4v-3a7 7 0 0 0 -14 0v3h-4a1 1 0 0 0 -1 1v22a3.009 3.009 0 0 0 3 3h13v-2h-13a1 1 0 0 1 -1-1v-1h14v-2h-14v-18h3v3h2v-3h10v3h2v-3h3v3h2v-4a1 1 0 0 0 -1-1zm-6 0h-10v-3a5 5 0 0 1 10 0z"/><path d="m57 19h-18a1 1 0 0 0 -1 1v15a3.009 3.009 0 0 0 3 3h14a3.009 3.009 0 0 0 3-3v-15a1 1 0 0 0 -1-1zm-1 16a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1-1v-1h16zm0-3h-16v-11h16z"/><path d="m48 30a5.006 5.006 0 0 0 5-5v-2h-2v2a3 3 0 0 1 -6 0v-2h-2v2a5.006 5.006 0 0 0 5 5z"/><path d="m62.332 44.55a4.109 4.109 0 0 0 -5.176-2.062l-8.93 3.25a4 4 0 0 0 -3.174-2.959l-12.063-2.127a15.018 15.018 0 0 0 -7.735.677l-1.554.571a16.917 16.917 0 0 0 -4.1 2.179l-.221-.607a1 1 0 0 0 -1.281-.6l-11.277 4.1a1 1 0 0 0 -.6 1.281l-4.7 1.71.684 1.879 4.7-1.71 4.079 11.208 1.879-.684-4.416-12.146 9.4-3.42 5.131 14.1-2.4.875.684 1.878 3.338-1.22a1 1 0 0 0 .6-1.282l-.342-.94 2.3-.838a10.943 10.943 0 0 1 4.523-.638l4.744.329a12.842 12.842 0 0 0 5.345-.753l18.28-6.653a4 4 0 0 0 2.281-5.4zm-1.838 2.483a1.984 1.984 0 0 1 -1.127 1.035l-18.28 6.654a10.893 10.893 0 0 1 -4.523.637l-4.744-.329a12.959 12.959 0 0 0 -5.344.753l-2.306.839-3.855-10.592a14.922 14.922 0 0 1 4.07-2.256l1.552-.565a13.015 13.015 0 0 1 6.705-.587l12.058 2.127a2 2 0 1 1 -.694 3.939l-10.833-1.91-.348 1.97 10.833 1.91a3.982 3.982 0 0 0 4.506-2.77l9.672-3.521a2.13 2.13 0 0 1 2.667 1 2.01 2.01 0 0 1 -.009 1.666z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Purchases</span>
                </a>
            </li>

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'sales' ? 'active':''}}">
                <a href="{{ url('/admin/sales/show') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" height="512pt" viewBox="0 0 512 512" width="512pt" xmlns="http://www.w3.org/2000/svg"><path d="m456.828125 0h-118.472656c-26.007813 0-60.789063 14.40625-79.175781 32.796875l-243.070313 243.066406c-10.390625 10.386719-16.109375 24.238281-16.109375 39.007813 0 14.769531 5.722656 28.621094 16.109375 39.007812l142.007813 142.011719c10.386718 10.386719 24.238281 16.109375 39.007812 16.109375 14.765625 0 28.621094-5.722656 39.011719-16.109375l243.066406-243.070313c18.390625-18.386718 32.796875-53.167968 32.796875-79.175781v-118.480469c-.003906-30.417968-24.753906-55.164062-55.171875-55.164062zm25.171875 173.644531c0 18.089844-11.21875 45.175781-24.007812 57.964844l-243.070313 243.066406c-4.722656 4.722657-11.042969 7.324219-17.796875 7.324219s-13.070312-2.601562-17.792969-7.320312l-142.007812-142.015626c-4.722657-4.722656-7.324219-11.042968-7.324219-17.792968 0-6.753906 2.597656-13.074219 7.320312-17.792969l243.070313-243.070313c12.789063-12.789062 39.875-24.007812 57.964844-24.007812h118.472656c13.878906 0 25.167969 11.289062 25.171875 25.164062zm0 0"/><path d="m139.308594 331.492188c-5.453125-5.449219-4.089844-13.402344 4.085937-21.585938 9.546875-9.542969 16.476563-7.839844 20-11.359375 4.089844-4.089844.679688-11.136719-1.933593-13.746094-7.5-7.5-23.972657 5.792969-30.675782 12.496094-13.066406 13.066406-21.8125 33.402344-4.886718 50.332031 26.925781 26.925782 58.171874-14.769531 75.214843 2.273438 6.816407 6.816406 3.976563 15.789062-2.839843 22.609375-11.589844 11.585937-23.40625 5.90625-28.0625 10.5625-3.523438 3.523437-1.703126 11.25 1.476562 14.433593 6.589844 6.589844 25.449219 2.726563 40.332031-12.160156 15.679688-15.675781 18.632813-35.449218 2.386719-51.695312-29.425781-29.421875-61.011719 11.933594-75.097656-2.160156zm0 0"/><path d="m298.136719 282.644531-93.394531-49.535156c-4.429688-2.386719-10.226563.226563-14.542969 4.546875-4.203125 4.199219-6.816407 9.996094-4.429688 14.429688l49.535157 93.390624c.339843.566407.683593 1.132813.910156 1.363282 3.636718 3.632812 11.476562.792968 15.449218-3.183594 2.5-2.496094 3.640626-5.226562 2.046876-7.953125l-10.792969-19.425781 26.019531-26.019532 19.425781 10.796876c2.730469 1.585937 5.453125.453124 7.953125-2.046876 3.976563-3.976562 6.703125-11.933593 3.179688-15.453124-.335938-.339844-.792969-.570313-1.359375-.910157zm-63.738281 18.976563-24.996094-44.769532 44.765625 25zm0 0"/><path d="m343.007812 226.410156-27.722656 27.722656-65.554687-65.558593c-3.183594-3.179688-8.292969-.792969-11.929688 2.839843-3.746093 3.75-6.023437 8.75-2.839843 11.933594l73.847656 73.851563c3.070312 3.066406 7.839844 1.476562 11.136718-1.820313l36.015626-36.015625c2.953124-2.953125 1.136718-7.726562-2.046876-10.90625-3.292968-3.296875-7.949218-5.003906-10.90625-2.046875zm0 0"/><path d="m402.425781 166.992188-32.152343 32.152343-22.835938-22.835937 17.269531-17.269532c3.179688-3.179687 1.589844-7.726562-1.023437-10.339843-3.066406-3.066407-7.613282-4.199219-10.566406-1.246094l-17.269532 17.265625-22.722656-22.722656 32.152344-32.148438c2.953125-2.957031 1.589844-7.726562-1.929688-11.25-3.070312-3.066406-7.839844-4.886718-11.023437-1.707031l-40.445313 40.449219c-3.292968 3.292968-4.886718 8.066406-1.816406 11.132812l73.738281 73.734375c3.066407 3.070313 7.835938 1.480469 11.132813-1.816406l40.445312-40.445313c3.183594-3.179687 1.363282-7.953124-1.703125-11.019531-3.523437-3.523437-8.296875-4.886719-11.25-1.933593zm0 0"/><path d="m417.46875 80.398438c-3.949219 0-7.820312 1.601562-10.609375 4.390624-2.789063 2.789063-4.390625 6.660157-4.390625 10.609376 0 3.953124 1.601562 7.8125 4.390625 10.601562 2.789063 2.800781 6.660156 4.398438 10.609375 4.398438s7.808594-1.597657 10.601562-4.398438c2.796876-2.789062 4.398438-6.660156 4.398438-10.601562 0-3.949219-1.601562-7.820313-4.398438-10.609376-2.792968-2.789062-6.652343-4.390624-10.601562-4.390624zm0 0"/></svg>
                    <span class="mx-3 whitespace-no-wrap">Sales</span>
                </a>
            </li>

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'returnorder' ? 'active':''}}">
                <a href="{{ url('/admin/returnorder/show') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" height="511pt" viewBox="0 1 511.99981 511" width="511pt" xmlns="http://www.w3.org/2000/svg"><path d="m506.8125 111.230469-199.40625-109.496094c-2.996094-1.6445312-6.628906-1.6445312-9.625 0l-75.160156 41.269531c-1.585938.417969-3.066406 1.214844-4.292969 2.359375l-119.949219 65.867188c-3.199218 1.753906-5.1875 5.113281-5.1875 8.765625v132.429687c-20.234375 6.328125-38.777344 17.488281-54.195312 32.910157-40.1875 40.183593-50.433594 101.472656-25.496094 152.507812 2.421875 4.960938 8.410156 7.019531 13.371094 4.59375 4.964844-2.425781 7.019531-8.414062 4.597656-13.375-21.1875-43.363281-12.480469-95.4375 21.667969-129.585938 21.355469-21.355468 49.746093-33.117187 79.945312-33.117187s58.589844 11.761719 79.945313 33.117187c21.351562 21.351563 33.113281 49.742188 33.113281 79.941407s-11.761719 58.589843-33.117187 79.945312c-34.148438 34.148438-86.222657 42.855469-129.585938 21.667969-4.960938-2.425781-10.949219-.367188-13.371094 4.59375-2.425781 4.964844-.371094 10.953125 4.59375 13.375 18.589844 9.085938 38.535156 13.5 58.335938 13.5 34.542968-.003906 68.625-13.449219 94.171875-38.996094 11.714843-11.714844 20.972656-25.230468 27.523437-39.921875l43.089844 23.660157c1.5.824218 3.15625 1.234374 4.8125 1.234374s3.316406-.410156 4.8125-1.234374l199.40625-109.492188c3.199219-1.757812 5.1875-5.117188 5.1875-8.765625v-69.496094c0-5.523437-4.476562-10-10-10s-10 4.476563-10 10v63.578125l-179.375 98.496094v-196.171875l59.199219-32.507813v51.53125c0 3.539063 1.867187 6.8125 4.910156 8.609376 1.570313.925781 3.328125 1.390624 5.089844 1.390624 1.65625 0 3.316406-.410156 4.820312-1.238281l42.730469-23.519531c3.195312-1.757812 5.175781-5.113281 5.175781-8.757812v-62.460938l57.449219-31.542969v52.597657c0 5.523437 4.476562 10 10 10s10-4.476563 10-10v-69.496094c0-3.648438-1.988281-7.011719-5.1875-8.765625zm-204.21875-89.324219 178.628906 98.089844-56.347656 30.941406-178.628906-98.089844zm0 196.175781-178.628906-98.085937 58.414062-32.078125 178.632813 98.085937zm79.191406-43.484375-178.628906-98.085937 22.3125-12.253907 178.632812 98.085938zm-154.617187 110.738282c-25.132813-25.132813-58.546875-38.972657-94.085938-38.972657-6.722656 0-13.363281.496094-19.890625 1.46875v-110.9375l179.4375 98.53125v196.171875l-31.144531-17.101562c3.066406-11.289063 4.652344-23.0625 4.652344-35.078125 0-35.539063-13.839844-68.953125-38.96875-94.082031zm187.386719-60.347657-22.730469 12.511719v-45.597656l22.730469-12.480469zm0 0"/><path d="m502 219.441406c-2.628906 0-5.210938 1.070313-7.070312 2.929688-1.859376 1.859375-2.929688 4.4375-2.929688 7.070312 0 2.628906 1.070312 5.207032 2.929688 7.066406 1.859374 1.863282 4.441406 2.929688 7.070312 2.929688s5.210938-1.066406 7.070312-2.929688c1.859376-1.859374 2.929688-4.4375 2.929688-7.066406 0-2.632812-1.070312-5.210937-2.929688-7.070312-1.859374-1.859375-4.441406-2.929688-7.070312-2.929688zm0 0"/><path d="m99.457031 389.417969c2.558594 0 5.121094-.976563 7.070313-2.925781 3.90625-3.90625 3.90625-10.238282 0-14.144532l-6.925782-6.929687h59.101563c14.335937 0 26 11.664062 26 26 0 14.335937-11.664063 26-26 26h-35.019531c-5.523438 0-10 4.476562-10 10 0 5.519531 4.476562 9.996093 10 9.996093h35.019531c25.363281 0 46-20.632812 46-45.996093s-20.636719-45.996094-46-45.996094h-59.101563l6.925782-6.929687c3.90625-3.90625 3.90625-10.238282 0-14.144532-3.902344-3.902344-10.234375-3.902344-14.140625 0l-24 24c-3.902344 3.90625-3.902344 10.238282 0 14.144532l24 23.996093c1.953125 1.953125 4.511719 2.929688 7.070312 2.929688zm0 0"/><path d="m46.074219 476.449219c-2.84375 0-5.667969-1.210938-7.640625-3.558594l-.019532-.023437c-3.554687-4.226563-3.007812-10.53125 1.21875-14.085938 4.226563-3.558594 10.535157-3.011719 14.089844 1.214844 3.550782 4.230468 3.015625 10.546875-1.210937 14.101562-1.878907 1.578125-4.164063 2.351563-6.4375 2.351563zm0 0"/></svg>
                    <span class="mx-3 whitespace-no-wrap">Returns</span>
                </a>
            </li>
        </ul>
    </li>
    <!--stock module-->
@endif
    <!--start-->
    @php
        $class='';
        $array=array('visitorlog','calllog','postalrecord');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    {{-- <li class="relative py-3 px-3 hover:bg-red-900 {{$class}}">
        <a href="#" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/settings.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><g><path d="M412,120c33.084,0,60-26.916,60-60S445.084,0,412,0c-33.084,0-60,26.916-60,60S378.916,120,412,120z M412,40 c11.028,0,20,8.972,20,20s-8.972,20-20,20s-20-8.972-20-20S400.972,40,412,40z"/><path d="M292,472H40V327h212c11.046,0,20-8.954,20-20c0-11.046-8.954-20-20-20H76v-83c0-11.028,8.972-20,20-20h80 c11.028,0,20,8.972,20,20v23c0,11.046,8.954,20,20,20s20-8.954,20-20v-23c0-33.084-26.916-60-60-60H96c-33.084,0-60,26.916-60,60 v83H20c-11.046,0-20,8.954-20,20v205h292c11.046,0,20-8.954,20-20C312,480.954,303.046,472,292,472z"/><path d="M141,121c33.084,0,60-26.916,60-60S174.084,1,141,1S81,27.916,81,61S107.916,121,141,121z M141,41 c11.028,0,20,8.972,20,20s-8.972,20-20,20s-20-8.972-20-20S129.972,41,141,41z"/><path d="M452,139h-80c-33.084,0-60,26.916-60,60v109c0,26.075,16.719,48.319,40,56.573V492c0,11.046,8.954,20,20,20 c11.046,0,20-8.954,20-20V348c0-11.046-8.954-20-20-20c-11.028,0-20-8.972-20-20V199c0-11.028,8.972-20,20-20h80 c11.028,0,20,8.972,20,20v109c0,11.028-8.972,20-20,20c-11.046,0-20,8.954-20,20v144c0,11.046,8.954,20,20,20 c11.046,0,20-8.954,20-20V364.573c23.281-8.255,40-30.498,40-56.573V199C512,165.916,485.084,139,452,139z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Reception <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar">
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'visitorlog' ? 'active':''}}">
                <a href="{{url('/admin/visitorlog')}}" class="flex items-center whitespace-no-wrap">
                    <!-- <img src="{{asset('uploads/icons/sidebar/school.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><circle cx="502" cy="255.86" r="10"/><path d="m508.07 111.54c-2.52-5.96-6.12-11.3-10.72-15.89-4.59-4.6-9.93-8.2-15.89-10.72-6.16-2.61-12.71-3.93-19.46-3.93h-412c-6.75 0-13.3 1.32-19.46 3.93-5.96 2.52-11.3 6.12-15.89 10.72-4.6 4.59-8.2 9.93-10.72 15.89-2.61 6.16-3.93 12.71-3.93 19.46v250c0 6.75 1.32 13.3 3.93 19.46 2.52 5.96 6.12 11.3 10.72 15.89 4.59 4.6 9.93 8.2 15.89 10.72 6.16 2.61 12.71 3.93 19.46 3.93h412c6.75 0 13.3-1.32 19.46-3.93 5.96-2.52 11.3-6.12 15.89-10.72 4.6-4.59 8.2-9.93 10.72-15.89 2.61-6.16 3.93-12.71 3.93-19.46v-80.14c0-5.52-4.49-10-10-10s-10 4.48-10 10v14.14h-472v-184c.03-16.51 13.49-29.97 30-30h412c16.51.03 29.97 13.49 30 30v79.86c0 5.51 4.49 10 10 10s10-4.49 10-10v-79.86c0-6.75-1.32-13.3-3.93-19.46zm-46.07 299.46h-412c-15.154-.028-27.729-11.371-29.718-26h471.435c-1.989 14.629-14.564 25.972-29.717 26zm30-76v30h-472v-30z"/><path d="m60 150c-5.523 0-10 4.477-10 10v100c0 5.523 4.477 10 10 10h100c5.523 0 10-4.477 10-10v-100c0-5.523-4.477-10-10-10zm90 100h-80v-80h80z"/><path d="m210 245h200c5.523 0 10-4.477 10-10s-4.477-10-10-10h-200c-5.523 0-10 4.477-10 10s4.477 10 10 10z"/><path d="m350 195c5.523 0 10-4.477 10-10s-4.477-10-10-10h-47c-5.523 0-10 4.477-10 10s4.477 10 10 10z"/><path d="m210 195h48c5.523 0 10-4.477 10-10s-4.477-10-10-10h-48c-5.523 0-10 4.477-10 10s4.477 10 10 10z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Visitor Log</span>
                </a>
            </li> 

            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'calllog' ? 'active':''}}"> 
                <a href="{{ url('admin/calllog') }}" class="flex items-center">
                    <!--<img src="{{asset('uploads/icons/sidebar/academic.svg')}}" class="w-5 h-5">   -->
                    <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512.021 512.021" height="512" viewBox="0 0 512.021 512.021" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m367.988 512.021c-16.528 0-32.916-2.922-48.941-8.744-70.598-25.646-136.128-67.416-189.508-120.795s-95.15-118.91-120.795-189.508c-8.241-22.688-10.673-46.108-7.226-69.612 3.229-22.016 11.757-43.389 24.663-61.809 12.963-18.501 30.245-33.889 49.977-44.5 21.042-11.315 44.009-17.053 68.265-17.053 7.544 0 14.064 5.271 15.645 12.647l25.114 117.199c1.137 5.307-.494 10.829-4.331 14.667l-42.913 42.912c40.482 80.486 106.17 146.174 186.656 186.656l42.912-42.913c3.837-3.837 9.36-5.466 14.667-4.331l117.199 25.114c7.377 1.581 12.647 8.101 12.647 15.645 0 24.256-5.738 47.224-17.054 68.266-10.611 19.732-25.999 37.014-44.5 49.977-18.419 12.906-39.792 21.434-61.809 24.663-6.899 1.013-13.797 1.518-20.668 1.519zm-236.349-479.321c-31.995 3.532-60.393 20.302-79.251 47.217-21.206 30.265-26.151 67.49-13.567 102.132 49.304 135.726 155.425 241.847 291.151 291.151 34.641 12.584 71.867 7.64 102.132-13.567 26.915-18.858 43.685-47.256 47.217-79.251l-95.341-20.43-44.816 44.816c-4.769 4.769-12.015 6.036-18.117 3.168-95.19-44.72-172.242-121.772-216.962-216.962-2.867-6.103-1.601-13.349 3.168-18.117l44.816-44.816z"/><path d="m496.02 272c-8.836 0-16-7.164-16-16 0-123.514-100.486-224-224-224-8.836 0-16-7.164-16-16s7.164-16 16-16c68.381 0 132.668 26.628 181.02 74.98s74.98 112.639 74.98 181.02c0 8.836-7.163 16-16 16z"/><path d="m432.02 272c-8.836 0-16-7.164-16-16 0-88.224-71.776-160-160-160-8.836 0-16-7.164-16-16s7.164-16 16-16c105.869 0 192 86.131 192 192 0 8.836-7.163 16-16 16z"/><path d="m368.02 272c-8.836 0-16-7.164-16-16 0-52.935-43.065-96-96-96-8.836 0-16-7.164-16-16s7.164-16 16-16c70.58 0 128 57.42 128 128 0 8.836-7.163 16-16 16z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Call Log</span>
                </a> 
            </li>

            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'postalrecord' ? 'active':''}}"> 
                <a href="{{ url('admin/postalrecord') }}" class="flex items-center">
                    <!--<img src="{{asset('uploads/icons/sidebar/academic.svg')}}" class="w-5 h-5">-->
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 470.161 470.161" style="enable-background:new 0 0 470.161 470.161;" xml:space="preserve"><g><path d="M463.247,55.313H6.914c-2.773,0-5.282,1.66-6.368,4.218C0.173,60.409-0.007,61.35,0,62.276v345.658 c0,0.007,0,0.014,0,0.021c0,0.926,0.187,1.811,0.518,2.613c0.339,0.823,0.836,1.583,1.507,2.254 c0.671,0.67,1.431,1.168,2.254,1.507c0.802,0.332,1.688,0.519,2.614,0.519c0.007,0,0.014,0,0.021,0h456.333 c0.968,0,1.881-0.193,2.708-0.552c0.768-0.324,1.487-0.795,2.116-1.41c0.021-0.021,0.014-0.014,0.014-0.014 c0.007-0.007,0.014-0.007,0.014-0.014c0,0,0,0,0.007,0c0-0.028,0.007-0.021,0.014-0.021c0.007,0,0.007-0.007,0.014-0.014 c0.007-0.007,0.014-0.007,0.014-0.014c0,0,0.007,0,0.007-0.007l0.014-0.014c0.007-0.007,0.007-0.007,0.014-0.014 c0,0,0,0,0.007-0.007c0.643-0.65,1.12-1.397,1.452-2.192c0.339-0.816,0.519-1.708,0.519-2.641V62.227 C470.161,58.404,467.071,55.313,463.247,55.313z M446.902,69.141L287.988,232.84l-0.007,0.007l-52.928,54.566l-53.336-54.165 L23.204,69.141H446.902z M13.828,79.34l153.245,158.659L13.828,391.244V79.34z M23.605,401.02l153.12-153.127l53.432,54.262 c1.307,1.327,3.077,2.067,4.93,2.067c0.007,0,0.021,0,0.028,0c1.86-0.007,3.637-0.768,4.937-2.102l52.976-54.608L446.556,401.02 H23.605z M456.333,391.244l-153.674-153.66L456.333,79.278V391.244z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Postal Record</span>
                </a> 
            </li>
        </ul>
    </li> --}}
    <!--end-->

<!-- Phone book start -->
     <li class="py-3 px-3 {{Request::segment ('2') == 'phonenumbers' ? 'active':''}} ">
        <a href="{{url('/admin/phonenumbers')}}" class="flex items-center">
         <!--  <img src="{{asset('uploads/icons/sidebar/teacher.svg')}}" class="w-5 h-5"> -->
         <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 -32 512 512" width="512px"><g><path d="m464.867188 0h-224.933594c-25.988282 0-47.132813 21.144531-47.132813 47.132812v144.292969l-41.765625-20.769531c-1.410156-.703125-2.84375-1.367188-4.289062-1.996094 12.261718-12.800781 19.820312-30.144531 19.820312-49.226562 0-39.277344-31.953125-71.234375-71.230468-71.234375-39.28125 0-71.234376 31.957031-71.234376 71.234375 0 21.34375 9.449219 40.515625 24.371094 53.582031-27.480468 15.460937-48.472656 45.621094-48.472656 82.984375v48.199219c0 20.75 13.472656 38.410156 32.132812 44.6875v83.847656c0 8.28125 6.714844 15 15 15h96.398438c8.285156 0 15-6.71875 15-15v-168.535156l48.023438 24.007812c18.378906 9.1875 43.308593 3.710938 54.582031-17.207031h53.78125l-56.949219 156.605469c-2.832031 7.785156 1.1875 16.394531 8.972656 19.222656 8.898438 3.238281 16.8125-2.34375 19.222656-8.96875l60.675782-166.859375h10.515625l61.296875 166.90625c2.328125 6.332031 10.183594 12.238281 19.253906 8.90625 7.773438-2.855469 11.765625-11.472656 8.90625-19.25l-57.5-156.5625h75.554688c25.484374 0 47.132812-20.558594 47.132812-47.132812v-176.734376c0-26.578124-21.648438-47.132812-47.132812-47.132812zm-410.765626 119.433594c0-22.738282 18.496094-41.234375 41.230469-41.234375 22.738281 0 41.234375 18.496093 41.234375 41.234375 0 22.734375-18.496094 41.230468-41.234375 41.230468-22.734375 0-41.230469-18.496093-41.230469-41.230468zm181.398438 135.527344c-.039062.109374-.078125.222656-.113281.335937-1.023438 2.855469-3.335938 5.261719-6.167969 6.425781-2.996094 1.21875-6.367188 1.089844-9.246094-.347656-28.523437-14.269531-69.738281-34.859375-69.738281-34.859375-9.953125-4.976563-21.703125 2.273437-21.703125 13.417969v177.800781h-66.398438v-81.402344c0-8.28125-6.71875-15-15-15-9.449218 0-17.132812-7.683593-17.132812-17.132812v-48.199219c0-36.652344 29.84375-65.332031 65.332031-65.332031h13.253907c10.054687 0 20.097656 2.359375 29.070312 6.839843 0 0 74.402344 37 93.351562 46.4375 4.058594 2.015626 5.988282 6.75 4.492188 11.015626zm246.5-31.09375c0 4.582031-1.777344 8.882812-5.011719 12.117187-3.183593 3.1875-7.601562 5.015625-12.121093 5.015625h-200.46875c-.027344-.082031-.046876-.164062-.074219-.242188l37.226562-74.449218c3.703125-7.410156.703125-16.417969-6.707031-20.125-7.40625-3.703125-16.417969-.703125-20.125 6.707031l-31.75 63.496094c-5.917969-2.949219-12.796875-6.375-20.167969-10.039063v-159.214844c0-9.445312 7.683594-17.132812 17.132813-17.132812h224.933594c4.519531 0 8.9375 1.828125 12.125 5.023438 3.230468 3.226562 5.007812 7.527343 5.007812 12.109374zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 64.265625h-160.667969c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h160.667969c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 120.5h-80.335937c-8.28125 0-15 6.714844-15 15s6.71875 15 15 15h80.335937c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m432.734375 176.734375h-80.335937c-8.28125 0-15 6.714844-15 15 0 8.28125 6.71875 15 15 15h80.335937c8.28125 0 15-6.71875 15-15 0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
          <span class="mx-3 whitespace-no-wrap">Telephone Directory</span>
        </a>
      </li>
<!-- Phone book end -->

<!-- payroll start -->
    @php
      $class='';
      $array=array('template','templates','payslip','payslips');
      if(in_array(\Request()->segment('4'),$array))
      {
        $class='active';
      }
    @endphp
     {{--<li class="relative py-3 px-3 hover:bg-light-green-900 {{$class}}">
     <a href="#" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/settings.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><g><path d="M412,120c33.084,0,60-26.916,60-60S445.084,0,412,0c-33.084,0-60,26.916-60,60S378.916,120,412,120z M412,40 c11.028,0,20,8.972,20,20s-8.972,20-20,20s-20-8.972-20-20S400.972,40,412,40z"/><path d="M292,472H40V327h212c11.046,0,20-8.954,20-20c0-11.046-8.954-20-20-20H76v-83c0-11.028,8.972-20,20-20h80 c11.028,0,20,8.972,20,20v23c0,11.046,8.954,20,20,20s20-8.954,20-20v-23c0-33.084-26.916-60-60-60H96c-33.084,0-60,26.916-60,60 v83H20c-11.046,0-20,8.954-20,20v205h292c11.046,0,20-8.954,20-20C312,480.954,303.046,472,292,472z"/><path d="M141,121c33.084,0,60-26.916,60-60S174.084,1,141,1S81,27.916,81,61S107.916,121,141,121z M141,41 c11.028,0,20,8.972,20,20s-8.972,20-20,20s-20-8.972-20-20S129.972,41,141,41z"/><path d="M452,139h-80c-33.084,0-60,26.916-60,60v109c0,26.075,16.719,48.319,40,56.573V492c0,11.046,8.954,20,20,20 c11.046,0,20-8.954,20-20V348c0-11.046-8.954-20-20-20c-11.028,0-20-8.972-20-20V199c0-11.028,8.972-20,20-20h80 c11.028,0,20,8.972,20,20v109c0,11.028-8.972,20-20,20c-11.046,0-20,8.954-20,20v144c0,11.046,8.954,20,20,20 c11.046,0,20-8.954,20-20V364.573c23.281-8.255,40-30.498,40-56.573V199C512,165.916,485.084,139,452,139z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Payroll <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
      </a>
      <ul class="list-reset sites-sidebar bottom-0" style="top: auto;">
        <li class="py-3 px-3 hover:font-semibold {{Request::segment ('4') == 'templates' ? 'active':''}} || {{Request::segment ('3') == 'template' ? 'active':''}} ">
          <a href="{{url('/accountant/payroll/template')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m467 0h-422c-24.813 0-45 20.187-45 45v422c0 24.813 20.187 45 45 45h422c24.813 0 45-20.187 45-45v-422c0-24.813-20.187-45-45-45zm-422 30h422c8.271 0 15 6.729 15 15v75h-452v-75c0-8.271 6.729-15 15-15zm422 452h-422c-8.271 0-15-6.729-15-15v-317h452v317c0 8.271-6.729 15-15 15z"/><circle cx="106" cy="75" r="15"/><circle cx="166" cy="75" r="15"/><circle cx="226" cy="75" r="15"/><path d="m407 180h-301c-8.284 0-15 6.716-15 15v91c0 8.284 6.716 15 15 15h301c8.284 0 15-6.716 15-15v-91c0-8.284-6.716-15-15-15zm-15 91h-271v-61h271z"/><path d="m256 331h-150c-8.284 0-15 6.716-15 15v91c0 8.284 6.716 15 15 15h150c8.284 0 15-6.716 15-15v-91c0-8.284-6.716-15-15-15zm-15 91h-120v-61h120z"/><path d="m407 331h-91c-8.284 0-15 6.716-15 15v91c0 8.284 6.716 15 15 15h91c8.284 0 15-6.716 15-15v-91c0-8.284-6.716-15-15-15zm-15 91h-61v-61h61z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Template</span>
          </a>
        </li>
        <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'salary' ? 'active':''}} || {{Request::segment ('4') == 'salary' ? 'active':''}} ">
          <a href="{{url('/accountant/payroll/salary')}}" class="flex items-center">
           <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512.066 512.066" height="512" viewBox="0 0 512.066 512.066" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m511.716 500.119c.488-2.285.323 11.703.323-308.092 0-4.041-1.675-8.102-4.8-10.999.281 0-3.638-2.785-76.2-55.494v-48.508c0-24.813-20.187-45-45-45h-20.922c-5.592-18.494-22.784-32-43.078-32h-196c-24.813 0-45 20.187-45 45v80.509c-80.717 58.659-75.702 54.727-77.477 56.841-1.47 1.752-2.574 3.881-3.125 6.251-.619 2.654-.397-15.777-.397 308.367-.022 7.398 5.442 13.899 13.058 14.896 1.618.212 485.068.137 483.944.137 7.015-.001 13.211-4.927 14.674-11.908zm-481.677-278.576 167.907 122.538-167.907 123.317zm226 117.095c8.999 6.609 186.407 136.904 195.236 143.389h-390.472c8.823-6.481 186.237-136.78 195.236-143.389zm226-117.095v245.855l-167.908-123.317zm-10.48-29.491-40.52 29.572v-59.011c11.129 8.085 24.362 17.697 40.52 29.439zm-70.52-115.026v166.491l-34 24.813v-206.304h19c8.271 0 15 6.729 15 15zm-275-47h196c8.271 0 15 6.729 15 15v245.198l-48.272 35.229-14.969-10.994c-10.621-7.803-24.896-7.803-35.518 0 .1-.1-1.2.881-14.97 10.994l-112.271-81.936v-198.491c0-8.271 6.728-15 15-15zm-45 132.589v59.008l-40.521-29.572c24.137-17.539 35.614-25.871 40.521-29.436z"/></g><g><path d="m240.692 157.655c-7.474-2.644-19.662-7.085-25.769-11.874-.37-.291-1.062-2.032-.576-4.619.234-1.242 1.308-5.388 5.332-6.601 6.214-1.883 12.112-.646 15.982 2.22 6.109 5.563 15.57 5.14 21.156-.956 5.579-6.089 5.182-15.535-.872-21.139 0 0-6.95-6.188-16.888-9.116v-1.234c0-8.284-6.716-15-15-15s-15 6.716-15 15v2.17c-26.962 9.806-33.302 46.688-12.646 62.884 9.41 7.378 22.857 12.507 34.272 16.547 7.436 2.63 8.191 7.962 7.517 11.973-.751 4.463-4.596 12.034-14.244 12.097-10.002.064-12.375-.303-19.675-5.081-6.933-4.536-16.228-2.597-20.766 4.336-4.537 6.932-2.596 16.229 4.336 20.766 7.974 5.219 14.29 7.805 21.205 9.016v1.443c0 8.284 6.716 15 15 15s15-6.716 15-15v-3.139c36.343-13.135 41.165-65.71 1.636-79.693z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Salary</span>
          </a>
        </li>
        <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'payslip' ? 'active':''}} || {{Request::segment ('4') == 'payslip' ? 'active':''}} ">
          <a href="{{url('/accountant/payroll/payslip')}}" class="flex items-center">
              <svg class="w-5 h-5 fill-current text-white" id="_x33_0" enable-background="new 0 0 64 64" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m26.998 9h-3.996c-2.758 0-5.002 2.244-5.002 5.002 0 .815.202 1.627.585 2.349l1.94 3.649h1.029c-.343-.59-.554-1.268-.554-2v-.764c0-.758.428-1.45 1.106-1.789l2.894-1.447 2.894 1.447c.678.339 1.106 1.032 1.106 1.789v.764c0 .732-.211 1.41-.555 2h1.029l1.941-3.65c.383-.721.585-1.533.585-2.348 0-2.758-2.244-5.002-5.002-5.002z" fill=""/></g><g><g><path d="m48 15h-14v-6h14z" fill=""/></g></g><g><path d="m34 17h14v5h-14z" fill=""/></g><g><path d="m16 36h18v4h-18z" fill=""/></g><g><path d="m44 27.101v-2.101h-2v2h-4v5c0 2.757 2.243 5 5 5 1.654 0 3 1.346 3 3v3h-3c-1.654 0-3-1.346-3-3v-3h-2v3c0 2.414 1.721 4.434 4 4.899v2.101h2v-2h4v-5c0-2.757-2.243-5-5-5-1.654 0-3-1.346-3-3v-3h3c1.654 0 3 1.346 3 3v3h2v-3c0-2.414-1.721-4.434-4-4.899z"/><path d="m36 53h-8c-1.103 0-2 .897-2 2v2c0 1.103.897 2 2 2h8c1.103 0 2-.897 2-2v-2c0-1.103-.897-2-2-2zm-8 4v-2h8l.002 2z"/><path d="m49 1h-34c-3.859 0-7 3.141-7 7v48c0 3.859 3.141 7 7 7h34c3.859 0 7-3.141 7-7v-48c0-3.859-3.141-7-7-7zm5 55c0 2.757-2.243 5-5 5h-34c-2.757 0-5-2.243-5-5v-48c0-2.757 2.243-5 5-5h34c2.757 0 5 2.243 5 5z"/><path d="m49 5h-34c-1.654 0-3 1.346-3 3v40c0 1.654 1.346 3 3 3h34c1.654 0 3-1.346 3-3v-40c0-1.654-1.346-3-3-3zm1 43c0 .552-.448 1-1 1h-34c-.552 0-1-.448-1-1v-40c0-.552.448-1 1-1h34c.552 0 1 .448 1 1z"/><path d="m28.377 21.663c.991-.914 1.623-2.212 1.623-3.663v-.764c0-1.144-.636-2.172-1.658-2.684l-2.342-1.17v-4.382h-2v4.382l-2.342 1.171c-1.022.511-1.658 1.54-1.658 2.683v.764c0 1.451.632 2.749 1.623 3.663-3.293 1.339-5.623 4.569-5.623 8.337v1h18v-1c0-3.768-2.33-6.998-5.623-8.337zm-6.377-3.663v-.764c0-.382.212-.725.553-.895l2.447-1.223 2.447 1.224c.341.17.553.512.553.894v.764c0 1.654-1.346 3-3 3s-3-1.346-3-3zm4.971 5.285c-.14.967-.966 1.715-1.971 1.715s-1.831-.748-1.971-1.715c.626-.184 1.286-.285 1.971-.285s1.345.101 1.971.285zm-8.9 5.715c.292-2.033 1.465-3.782 3.114-4.859.495 1.647 2.008 2.859 3.815 2.859s3.32-1.212 3.814-2.859c1.649 1.078 2.823 2.826 3.114 4.859z"/><path d="m38 9h2v6h-2z"/><path d="m42 9h2v6h-2z"/><path d="m34 17h6v2h-6z"/><path d="m42 17h6v2h-6z"/><path d="m34 21h14v2h-14z"/><path d="m16 45h2v2h-2z"/><path d="m20 45h2v2h-2z"/><path d="m24 45h2v2h-2z"/><path d="m28 45h2v2h-2z"/><path d="m16 39h18v2h-18z"/><path d="m16 35h18v2h-18z"/><path d="m32 45h2v2h-2z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Payroll</span>
          </a>
        </li>
         <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'transaction' ? 'active':''}} || {{Request::segment ('4') == 'transaction' ? 'active':''}} ">
          <a href="{{url('/accountant/payroll/transaction')}}" class="flex items-center">
              <!-- <svg class="w-5 h-5 fill-current text-white" id="_x33_0" enable-background="new 0 0 64 64" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m26.998 9h-3.996c-2.758 0-5.002 2.244-5.002 5.002 0 .815.202 1.627.585 2.349l1.94 3.649h1.029c-.343-.59-.554-1.268-.554-2v-.764c0-.758.428-1.45 1.106-1.789l2.894-1.447 2.894 1.447c.678.339 1.106 1.032 1.106 1.789v.764c0 .732-.211 1.41-.555 2h1.029l1.941-3.65c.383-.721.585-1.533.585-2.348 0-2.758-2.244-5.002-5.002-5.002z" fill=""/></g><g><g><path d="m48 15h-14v-6h14z" fill=""/></g></g><g><path d="m34 17h14v5h-14z" fill=""/></g><g><path d="m16 36h18v4h-18z" fill=""/></g><g><path d="m44 27.101v-2.101h-2v2h-4v5c0 2.757 2.243 5 5 5 1.654 0 3 1.346 3 3v3h-3c-1.654 0-3-1.346-3-3v-3h-2v3c0 2.414 1.721 4.434 4 4.899v2.101h2v-2h4v-5c0-2.757-2.243-5-5-5-1.654 0-3-1.346-3-3v-3h3c1.654 0 3 1.346 3 3v3h2v-3c0-2.414-1.721-4.434-4-4.899z"/><path d="m36 53h-8c-1.103 0-2 .897-2 2v2c0 1.103.897 2 2 2h8c1.103 0 2-.897 2-2v-2c0-1.103-.897-2-2-2zm-8 4v-2h8l.002 2z"/><path d="m49 1h-34c-3.859 0-7 3.141-7 7v48c0 3.859 3.141 7 7 7h34c3.859 0 7-3.141 7-7v-48c0-3.859-3.141-7-7-7zm5 55c0 2.757-2.243 5-5 5h-34c-2.757 0-5-2.243-5-5v-48c0-2.757 2.243-5 5-5h34c2.757 0 5 2.243 5 5z"/><path d="m49 5h-34c-1.654 0-3 1.346-3 3v40c0 1.654 1.346 3 3 3h34c1.654 0 3-1.346 3-3v-40c0-1.654-1.346-3-3-3zm1 43c0 .552-.448 1-1 1h-34c-.552 0-1-.448-1-1v-40c0-.552.448-1 1-1h34c.552 0 1 .448 1 1z"/><path d="m28.377 21.663c.991-.914 1.623-2.212 1.623-3.663v-.764c0-1.144-.636-2.172-1.658-2.684l-2.342-1.17v-4.382h-2v4.382l-2.342 1.171c-1.022.511-1.658 1.54-1.658 2.683v.764c0 1.451.632 2.749 1.623 3.663-3.293 1.339-5.623 4.569-5.623 8.337v1h18v-1c0-3.768-2.33-6.998-5.623-8.337zm-6.377-3.663v-.764c0-.382.212-.725.553-.895l2.447-1.223 2.447 1.224c.341.17.553.512.553.894v.764c0 1.654-1.346 3-3 3s-3-1.346-3-3zm4.971 5.285c-.14.967-.966 1.715-1.971 1.715s-1.831-.748-1.971-1.715c.626-.184 1.286-.285 1.971-.285s1.345.101 1.971.285zm-8.9 5.715c.292-2.033 1.465-3.782 3.114-4.859.495 1.647 2.008 2.859 3.815 2.859s3.32-1.212 3.814-2.859c1.649 1.078 2.823 2.826 3.114 4.859z"/><path d="m38 9h2v6h-2z"/><path d="m42 9h2v6h-2z"/><path d="m34 17h6v2h-6z"/><path d="m42 17h6v2h-6z"/><path d="m34 21h14v2h-14z"/><path d="m16 45h2v2h-2z"/><path d="m20 45h2v2h-2z"/><path d="m24 45h2v2h-2z"/><path d="m28 45h2v2h-2z"/><path d="m16 39h18v2h-18z"/><path d="m16 35h18v2h-18z"/><path d="m32 45h2v2h-2z"/></g></g></svg> -->
              <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 496 496" xml:space="preserve" class="w-5 h-5 fill-current text-gray-600"><g><g><path d="M392,144c-57.344,0-104,46.656-104,104s46.656,104,104,104s104-46.656,104-104S449.344,144,392,144z M392,336
      c-48.52,0-88-39.48-88-88c0-48.52,39.48-88,88-88c48.52,0,88,39.48,88,88S440.52,336,392,336z"></path></g></g> <g><g><path d="M392,240c-8.824,0-16-7.176-16-16c0-8.824,7.176-16,16-16c8.824,0,16,7.176,16,16h16c0-14.864-10.24-27.288-24-30.864V176
      h-16v17.136c-13.76,3.576-24,16-24,30.864c0,17.648,14.352,32,32,32c8.824,0,16,7.176,16,16c0,8.824-7.176,16-16,16
      c-8.824,0-16-7.176-16-16h-16c0,14.872,10.24,27.288,24,30.864V320h16v-17.136c13.76-3.576,24-15.992,24-30.864
      C424,254.352,409.648,240,392,240z"></path></g></g> <g><g><path d="M191.848,315.008L144,305.44v-11.552c8.008-5.6,14.456-13.24,18.648-22.16C179.04,270.36,192,256.744,192,240v-40
      c0-44.112-35.888-80-80-80s-80,35.888-80,80v40c0,16.744,12.96,30.36,29.352,31.728c4.192,8.92,10.64,16.56,18.648,22.16v11.552
      l-47.848,9.568C13.52,318.736,0,335.232,0,354.232V376h224v-21.768C224,335.232,210.48,318.728,191.848,315.008z M167.672,253.952
      c0.208-1.96,0.328-3.944,0.328-5.952v-21.776c4.76,2.776,8,7.88,8,13.776C176,246.032,172.608,251.224,167.672,253.952z M48,240
      c0-5.896,3.24-11,8-13.776V248c0,2.008,0.12,3.992,0.328,5.952C51.392,251.224,48,246.032,48,240z M57.24,208.752
      c-3.32,0.72-6.392,2.04-9.24,3.696V200c0-35.288,28.712-64,64-64s64,28.712,64,64v12.448c-2.848-1.664-5.92-2.984-9.24-3.704
      C163.664,199.072,154.688,192,144,192H80C69.312,192,60.336,199.072,57.24,208.752z M72,248v-32c0-4.408,3.592-8,8-8h64
      c4.408,0,8,3.592,8,8v32c0,22.056-17.944,40-40,40C89.944,288,72,270.056,72,248z M128,301.64v7.048l-16,16l-16-16v-7.048
      c5.072,1.52,10.44,2.36,16,2.36S122.928,303.16,128,301.64z M208,360H16v-5.768c0-11.408,8.112-21.304,19.296-23.536l50.08-10.016
      L112,347.312l26.632-26.632l50.08,10.016C199.888,332.928,208,342.832,208,354.232V360z"></path></g></g> <g><g><path d="M384,368v104c0,4.416-3.592,8-8,8H128c-4.408,0-8-3.584-8-8v-54.608l42.792,36.672l10.416-12.144L112,389.464
      l-61.208,52.472l10.416,12.144L104,417.392V472c0,13.232,10.768,24,24,24h248c13.232,0,24-10.768,24-24V368H384z"></path></g></g> <g><g><path d="M442.792,65.92L400,102.608V24c0-13.232-10.768-24-24-24H128c-13.232,0-24,10.768-24,24v80h16V24c0-4.408,3.592-8,8-8h248
      c4.408,0,8,3.592,8,8v78.608l-42.792-36.68L330.792,78.08L392,130.536l61.208-52.464L442.792,65.92z"></path></g></g> <g><g><rect x="440" y="240" width="16" height="16"></rect></g></g> <g><g><rect x="328" y="240" width="16" height="16"></rect></g></g> <g><g><rect x="272" y="32" width="16" height="16"></rect></g></g> <g><g><rect x="240" y="32" width="16" height="16"></rect></g></g> <g><g><rect x="208" y="32" width="16" height="16"></rect></g></g> <g><g><rect x="272" y="448" width="16" height="16"></rect></g></g> <g><g><rect x="240" y="448" width="16" height="16"></rect></g></g> <g><g><rect x="208" y="448" width="16" height="16"></rect></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Transaction</span>
          </a>
        </li>
      </ul>
    </li>--}}
  <!-- payroll end -->

    <!-- class wall start -->
    @php
        $class='';
        $array=array('pages','page','posts','post');
        if(in_array(\Request()->segment('3'),$array))
        {
            $class='active';
        }
    @endphp
    {{--<li class="relative py-3 px-3 hover:bg-red-900 {{$class}}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g id="XMLID_1153_"><g id="XMLID_452_"><path id="XMLID_957_" d="m469.885 359.996c23.343-.714 42.115-19.912 42.115-43.424v-253.084c0-23.963-19.495-43.458-43.458-43.458h-167.479c-5.522 0-10 4.477-10 10s4.478 10 10 10h167.479c12.935 0 23.458 10.523 23.458 23.458v253.084c0 12.487-9.808 22.723-22.124 23.417-2.993-24.73-24.097-43.959-49.622-43.959-25.539 0-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44s-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44-25.529 0-46.636 19.236-49.624 43.973-12.436-.568-22.378-10.859-22.378-23.431v-253.084c0-12.935 10.523-23.458 23.458-23.458h167.605c5.522 0 10-4.477 10-10s-4.478-10-10-10h-167.605c-23.963 0-43.458 19.495-43.458 43.458v253.084c0 23.598 18.909 42.849 42.369 43.43 1.437 12.009 7.141 22.72 15.557 30.572-33.909 13.57-57.926 46.759-57.926 85.456v6c0 5.523 4.478 10 10 10h492c5.522 0 10-4.477 10-10v-6c0-38.629-23.933-71.769-57.748-85.383 8.459-7.859 14.194-18.602 15.633-30.651zm-79.631-13.966c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-100.091 44.581c8.43-7.849 14.147-18.564 15.591-30.581h64.872c1.438 11.961 7.11 22.633 15.477 30.472-20.849 8.292-37.973 23.996-48.104 43.841-10.086-19.76-27.108-35.412-47.836-43.732zm-64.036-44.581c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-4.112 44.508c-20.808 8.301-37.899 23.988-48.015 43.805-10.101-19.789-27.158-35.458-47.926-43.769 8.409-7.846 14.111-18.547 15.553-30.545h64.873c1.44 11.981 7.127 22.667 15.515 30.509zm-160.015-36.508v-8c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-41.891 118c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm164 0c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm307.782 0h-143.782c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68z"/><path id="XMLID_1515_" d="m151.855 98.03c-5.522 0-10 4.477-10 10v16.127h-16.755c-5.522 0-10 4.477-10 10s4.478 10 10 10h16.756v16.756c0 5.523 4.478 10 10 10s10-4.477 10-10v-16.756h16.127c5.522 0 10-4.477 10-10s-4.478-10-10-10h-16.127v-16.127c-.001-5.523-4.478-10-10.001-10z"/><path id="XMLID_1623_" d="m81.1 191.609c5.522 0 10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.1c-5.522 0-10 4.477-10 10s4.478 10 10 10h7.1v70c0 5.523 4.477 10 10 10z"/><path id="XMLID_1852_" d="m194.884 101.609c0 5.523 4.478 10 10 10h7.099v70c0 5.523 4.478 10 10 10s10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.099c-5.523 0-10 4.477-10 10z"/><path id="XMLID_1853_" d="m288.333 184.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1921_" d="m288.333 116.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1922_" d="m64 252.03h384c5.522 0 10-4.477 10-10s-4.478-10-10-10h-384c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1923_" d="m256.06 39.97c2.63 0 5.21-1.07 7.07-2.93 1.87-1.86 2.93-4.44 2.93-7.07 0-2.64-1.06-5.21-2.93-7.07-1.86-1.87-4.43-2.93-7.07-2.93-2.63 0-5.21 1.06-7.069 2.93-1.86 1.86-2.931 4.43-2.931 7.07 0 2.63 1.07 5.21 2.931 7.07 1.859 1.86 4.439 2.93 7.069 2.93z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Class Wall <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>

        <ul class="list-reset sites-sidebar bottom-0" style="top: auto;">
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'pages' ? 'active':''}} || {{Request::segment ('3') == 'page' ? 'active':''}} ">
                <a href="{{ url('/admin/classwall/pages') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 480 480" style="enable-background:new 0 0 480 480;" xml:space="preserve"><g><g><path d="M160,344h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,344,160,344z"/></g></g><g><g><path d="M384,344H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,344,384,344z"/></g></g><g><g><path d="M160,296h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,296,160,296z"/></g></g><g><g><path d="M384,296H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,296,384,296z"/></g></g><g><g><path d="M160,248h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,248,160,248z"/></g></g><g><g><path d="M384,248H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,248,384,248z"/></g></g><g><g><path d="M160,200h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,200,160,200z"/></g></g><g><g><path d="M384,200H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,200,384,200z"/></g></g><g><g><path d="M160,152h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,152,160,152z"/></g></g><g><g><path d="M384,152H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,152,384,152z"/></g></g><g><g><path d="M439.896,119.496c-0.04-0.701-0.177-1.393-0.408-2.056c-0.088-0.256-0.152-0.504-0.264-0.752 c-0.389-0.87-0.931-1.664-1.6-2.344l-112-112c-0.68-0.669-1.474-1.211-2.344-1.6c-0.248-0.112-0.496-0.176-0.744-0.264 c-0.669-0.23-1.366-0.37-2.072-0.416C320.328,0.088,320.176,0,320,0H96c-4.418,0-8,3.582-8,8v24H48c-4.418,0-8,3.582-8,8v432 c0,4.418,3.582,8,8,8h336c4.418,0,8-3.582,8-8v-40h40c4.418,0,8-3.582,8-8V120C440,119.824,439.912,119.672,439.896,119.496z M328,27.312L412.688,112H328V27.312z M376,464H56V48h32v376c0,4.418,3.582,8,8,8h280V464z M424,416H104V16h208v104 c0,4.418,3.582,8,8,8h104V416z"/></g></g><g><g><path d="M192,72h-48c-4.418,0-8,3.582-8,8v48c0,4.418,3.582,8,8,8h48c4.418,0,8-3.582,8-8V80C200,75.582,196.418,72,192,72z M184,120h-32V88h32V120z"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Pages</span>
                </a>
            </li>

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'posts' ? 'active':''}} || {{Request::segment ('3') == 'post' ? 'active':''}} ">
                <a href="{{url('/admin/classwall/posts')}}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M0,30v452h512V30H0z M482,452H30V120h452V452z M482,90H30V60h452V90z"/></g></g><g><g><path d="M271,160v252h181V160H271z M422,382H301V190h121V382z"/></g></g><g><g><rect x="60" y="160" width="181" height="30"/></g></g><g><g><rect x="60" y="220" width="121" height="30"/></g></g><g><g><rect x="60" y="300" width="181" height="30"/></g></g><g><g><rect x="60" y="360" width="121" height="30"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Posts</span>
                </a>
            </li>

             <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'feeds' ? 'active':''}} || {{Request::segment ('2') == 'feed' ? 'active':''}} ">
                <a href="{{url('/admin/feeds')}}" class="flex items-center">
                   <svg height="460pt" viewBox="-11 0 460 460.11908" width="460pt" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 fill-current text-white"><path d="m204.636719 0h-3.378907c-13.730468 0-25.351562 11.054688-25.351562 24.785156v23.875l-72.027344-20.976562c-2.023437-.589844-4.199218-.347656-6.039062.675781-1.84375 1.027344-3.195313 2.746094-3.761719 4.777344l-93.714844 322.976562c-1.203125 4.253907 1.25 8.683594 5.496094 9.914063l322.988281 93.773437c4.226563 1.230469 8.65625-1.183593 9.917969-5.402343l10-34.398438h80.941406c4.476563-.03125 8.113281-3.625 8.199219-8.101562v-336.316407c0-4.417969-3.78125-7.582031-8.199219-7.582031h-188.175781l-11.625-3.898438v-39.316406c0-13.730468-11.539062-24.785156-25.269531-24.785156zm-12.730469 24.785156c0-4.90625 4.441406-8.785156 9.351562-8.785156h3.378907c4.910156 0 9.269531 3.878906 9.269531 8.785156v34.667969l-22-6.148437zm161.507812 379.214844 68.492188-235.332031v235.332031zm68.492188-320v35.890625l-125.265625-35.890625zm-6.78125 50.589844-89.402344 307.609375-307.660156-89.304688 89.46875-307.617187 106.375 30.835937v54.585938c0 4.972656-4.03125 9-9 9-4.972656 0-9-4.027344-9-9v-33.238281c0-4.417969-3.582031-8-8-8s-8 3.582031-8 8v33.238281c0 13.808593 11.191406 25 25 25 13.804688 0 25-11.191407 25-25v-49.9375zm0 0"></path></svg>
                    <span class="mx-3 whitespace-no-wrap">Feeds</span>
                </a>
            </li>

        </ul>
    </li>--}}
    <!-- class wall end -->

    <!--report module-->
    @php
        $class='';
        $array=array('reports','report');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
      
    <li class="py-3 px-3  {{$class}}">
        <a href="{{url('/admin/reports')}}" class="flex items-center">
            <!--<img src="{{asset('uploads/icons/sidebar/report.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-1 0 460 460" width="512px" class=""><g><path d="m7.515625 460h333.941406c4.417969 0 7.542969-4.078125 7.542969-8.5v-172.628906l106.921875-106.929688c3.148437-3.09375 3.195313-8.152344.105469-11.304687l-42.546875-42.601563c-3.199219-3.121094-8.304688-3.125-11.507813-.007812l-52.972656 52.652344v-81.230469c.085938-2.09375-.679688-4.132813-2.117188-5.660157l-80.835937-81.199218c-1.429687-1.570313-3.425781-2.5039065-5.546875-2.589844h-252.984375c-4.414063 0-7.515625 4.078125-7.515625 8.496094v443.007812c0 4.417969 3.101562 8.496094 7.515625 8.496094zm255.398437-173.386719 24.648438 24.648438-37.027344 12.378906zm39.441407 16.8125-31.609375-31.605469 101.515625-101.289062 31.382812 31.382812zm105.519531-168.425781 31.300781 31.300781-24.234375 24.289063-31.351562-31.359375zm-138.875-107.191406 53.144531 53.191406h-53.144531zm-253-11.808594h237v73.449219c-.09375 2.023437.660156 3.992187 2.089844 5.425781 1.425781 1.4375 3.386718 2.207031 5.410156 2.125h72.5v89.644531l-79.453125 79.5c-.839844.820313-1.464844 1.832031-1.820313 2.949219l-11.28125 33.90625h-172.746093c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h167.402343l-4.820312 14.601562c-.960938 2.84375-.210938 5.992188 1.929688 8.097657.5625.5625 1.199218 1.300781 1.875 1.300781h-166.386719c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h213.003906c4.421875 0 8-3.582031 8-8s-3.578125-8-8-8h-38.691406l62.886719-20.847656c1.105468-.363282 2.105468-1 2.902343-1.84375l25.199219-25.402344v149.09375h-317zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m280.703125 383h-213.003906c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h213.003906c4.421875 0 8-3.582031 8-8s-3.578125-8-8-8zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m67.699219 279h113.003906c4.421875 0 8-3.582031 8-8s-3.578125-8-8-8h-113.003906c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Reports</span>
        </a>
    </li>
    <!--report module-->

    <!--activity log-->
    <li class="py-3 px-3 {{Request::segment ('2') == 'activity' ? 'active':''}}">
        <a href="{{ url('/admin/activity') }}" class="flex  items-center">
            <!--<img src="{{asset('uploads/icons/sidebar/activity.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-1 0 512 512" width="512px"><g><path d="m360 242.839844v-207.839844c0-19.300781-15.699219-35-35-35h-290c-19.300781 0-35 15.699219-35 35v381c0 19.300781 15.699219 35 35 35h227.148438c24.152343 36.710938 65.714843 61 112.851562 61 74.4375 0 135-60.5625 135-135 0-79.980469-69.660156-143.085938-150-134.160156zm-325 178.160156c-2.757812 0-5-2.242188-5-5v-381c0-2.757812 2.242188-5 5-5h290c2.757812 0 5 2.242188 5 5v214.722656c-14.539062 5.15625-27.941406 12.734375-39.71875 22.253906-3.734375-1.410156 6.6875-.976562-155.28125-.976562-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h128.484375c-6.320313 9.242188-11.523437 19.308594-15.410156 30h-113.074219c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h105.953125c-2.425781 20.433594-.191406 40.886719 6.414063 60zm340 61c-57.898438 0-105-47.101562-105-105s47.101562-105 105-105 105 47.101562 105 105-47.101562 105-105 105zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m135 121h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m135 181h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m135 241h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 106c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 166c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 226c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 286c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 346c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m375 301c-8.285156 0-15 6.714844-15 15v45h-30c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h45c8.285156 0 15-6.714844 15-15v-60c0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Activity Log</span>
        </a>
    </li>
    <!--activity log-->

    <!--add on new-->
    <li class="py-3 px-3 {{Request::segment ('2') == 'addon' ? 'active':''}}">
        <a href="{{ url('/admin/addon') }}" class="flex  items-center">
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-1 0 512 512" width="512px"><g><path d="m360 242.839844v-207.839844c0-19.300781-15.699219-35-35-35h-290c-19.300781 0-35 15.699219-35 35v381c0 19.300781 15.699219 35 35 35h227.148438c24.152343 36.710938 65.714843 61 112.851562 61 74.4375 0 135-60.5625 135-135 0-79.980469-69.660156-143.085938-150-134.160156zm-325 178.160156c-2.757812 0-5-2.242188-5-5v-381c0-2.757812 2.242188-5 5-5h290c2.757812 0 5 2.242188 5 5v214.722656c-14.539062 5.15625-27.941406 12.734375-39.71875 22.253906-3.734375-1.410156 6.6875-.976562-155.28125-.976562-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h128.484375c-6.320313 9.242188-11.523437 19.308594-15.410156 30h-113.074219c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h105.953125c-2.425781 20.433594-.191406 40.886719 6.414063 60zm340 61c-57.898438 0-105-47.101562-105-105s47.101562-105 105-105 105 47.101562 105 105-47.101562 105-105 105zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m135 121h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m135 181h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m135 241h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 106c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 166c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 226c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 286c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m90 346c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m375 301c-8.285156 0-15 6.714844-15 15v45h-30c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h45c8.285156 0 15-6.714844 15-15v-60c0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Add On</span>
        </a>
    </li>
    <!--add-on-->


    <!-- question end -->
    @php
      $class='';
      $array=array('chapters','chapter','pattern','test');
      if(in_array(\Request()->segment('3'),$array))
      {
        $class='active';
      }
    @endphp
    {{-- <li class="relative py-3 px-3 hover:bg-red-900 {{$class}}">
      <a href="#" class="flex items-center">
        <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g id="XMLID_1153_"><g id="XMLID_452_"><path id="XMLID_957_" d="m469.885 359.996c23.343-.714 42.115-19.912 42.115-43.424v-253.084c0-23.963-19.495-43.458-43.458-43.458h-167.479c-5.522 0-10 4.477-10 10s4.478 10 10 10h167.479c12.935 0 23.458 10.523 23.458 23.458v253.084c0 12.487-9.808 22.723-22.124 23.417-2.993-24.73-24.097-43.959-49.622-43.959-25.539 0-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44s-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44-25.529 0-46.636 19.236-49.624 43.973-12.436-.568-22.378-10.859-22.378-23.431v-253.084c0-12.935 10.523-23.458 23.458-23.458h167.605c5.522 0 10-4.477 10-10s-4.478-10-10-10h-167.605c-23.963 0-43.458 19.495-43.458 43.458v253.084c0 23.598 18.909 42.849 42.369 43.43 1.437 12.009 7.141 22.72 15.557 30.572-33.909 13.57-57.926 46.759-57.926 85.456v6c0 5.523 4.478 10 10 10h492c5.522 0 10-4.477 10-10v-6c0-38.629-23.933-71.769-57.748-85.383 8.459-7.859 14.194-18.602 15.633-30.651zm-79.631-13.966c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-100.091 44.581c8.43-7.849 14.147-18.564 15.591-30.581h64.872c1.438 11.961 7.11 22.633 15.477 30.472-20.849 8.292-37.973 23.996-48.104 43.841-10.086-19.76-27.108-35.412-47.836-43.732zm-64.036-44.581c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-4.112 44.508c-20.808 8.301-37.899 23.988-48.015 43.805-10.101-19.789-27.158-35.458-47.926-43.769 8.409-7.846 14.111-18.547 15.553-30.545h64.873c1.44 11.981 7.127 22.667 15.515 30.509zm-160.015-36.508v-8c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-41.891 118c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm164 0c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm307.782 0h-143.782c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68z"/><path id="XMLID_1515_" d="m151.855 98.03c-5.522 0-10 4.477-10 10v16.127h-16.755c-5.522 0-10 4.477-10 10s4.478 10 10 10h16.756v16.756c0 5.523 4.478 10 10 10s10-4.477 10-10v-16.756h16.127c5.522 0 10-4.477 10-10s-4.478-10-10-10h-16.127v-16.127c-.001-5.523-4.478-10-10.001-10z"/><path id="XMLID_1623_" d="m81.1 191.609c5.522 0 10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.1c-5.522 0-10 4.477-10 10s4.478 10 10 10h7.1v70c0 5.523 4.477 10 10 10z"/><path id="XMLID_1852_" d="m194.884 101.609c0 5.523 4.478 10 10 10h7.099v70c0 5.523 4.478 10 10 10s10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.099c-5.523 0-10 4.477-10 10z"/><path id="XMLID_1853_" d="m288.333 184.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1921_" d="m288.333 116.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1922_" d="m64 252.03h384c5.522 0 10-4.477 10-10s-4.478-10-10-10h-384c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1923_" d="m256.06 39.97c2.63 0 5.21-1.07 7.07-2.93 1.87-1.86 2.93-4.44 2.93-7.07 0-2.64-1.06-5.21-2.93-7.07-1.86-1.87-4.43-2.93-7.07-2.93-2.63 0-5.21 1.06-7.069 2.93-1.86 1.86-2.931 4.43-2.931 7.07 0 2.63 1.07 5.21 2.931 7.07 1.859 1.86 4.439 2.93 7.069 2.93z"/></g></g></svg>
        <span class="mx-3 whitespace-no-wrap">Question generator</span>
      </a>
      <ul class="list-reset sites-sidebar bottom-0" style="top: auto;">
        <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'chapters' ? 'active':''}} || {{Request::segment ('3') == 'chapter' ? 'active':''}} ">
          <a href="{{url('/subject/chapters')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 480 480" style="enable-background:new 0 0 480 480;" xml:space="preserve"><g><g><path d="M160,344h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,344,160,344z"/></g></g><g><g><path d="M384,344H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,344,384,344z"/></g></g><g><g><path d="M160,296h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,296,160,296z"/></g></g><g><g><path d="M384,296H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,296,384,296z"/></g></g><g><g><path d="M160,248h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,248,160,248z"/></g></g><g><g><path d="M384,248H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,248,384,248z"/></g></g><g><g><path d="M160,200h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,200,160,200z"/></g></g><g><g><path d="M384,200H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,200,384,200z"/></g></g><g><g><path d="M160,152h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,152,160,152z"/></g></g><g><g><path d="M384,152H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,152,384,152z"/></g></g><g><g><path d="M439.896,119.496c-0.04-0.701-0.177-1.393-0.408-2.056c-0.088-0.256-0.152-0.504-0.264-0.752 c-0.389-0.87-0.931-1.664-1.6-2.344l-112-112c-0.68-0.669-1.474-1.211-2.344-1.6c-0.248-0.112-0.496-0.176-0.744-0.264 c-0.669-0.23-1.366-0.37-2.072-0.416C320.328,0.088,320.176,0,320,0H96c-4.418,0-8,3.582-8,8v24H48c-4.418,0-8,3.582-8,8v432 c0,4.418,3.582,8,8,8h336c4.418,0,8-3.582,8-8v-40h40c4.418,0,8-3.582,8-8V120C440,119.824,439.912,119.672,439.896,119.496z M328,27.312L412.688,112H328V27.312z M376,464H56V48h32v376c0,4.418,3.582,8,8,8h280V464z M424,416H104V16h208v104 c0,4.418,3.582,8,8,8h104V416z"/></g></g><g><g><path d="M192,72h-48c-4.418,0-8,3.582-8,8v48c0,4.418,3.582,8,8,8h48c4.418,0,8-3.582,8-8V80C200,75.582,196.418,72,192,72z M184,120h-32V88h32V120z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Questions</span>
          </a>
        </li>
        <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'patterns' ? 'active':''}} || {{Request::segment ('3') == 'pattern' ? 'active':''}} ">
          <a href="{{url('/test/pattern')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M0,30v452h512V30H0z M482,452H30V120h452V452z M482,90H30V60h452V90z"/></g></g><g><g><path d="M271,160v252h181V160H271z M422,382H301V190h121V382z"/></g></g><g><g><rect x="60" y="160" width="181" height="30"/></g></g><g><g><rect x="60" y="220" width="121" height="30"/></g></g><g><g><rect x="60" y="300" width="181" height="30"/></g></g><g><g><rect x="60" y="360" width="121" height="30"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Test</span>
          </a>
        </li>
      </ul>
    </li>--}}
  <!--end -->

    @php
        $class='';
        $array=array('schooldetails','academics','academic','promotion','leavetypes','leavetype','examrules','holidays','holiday','admissions','admission');
        if(in_array(\Request()->segment('2'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3  {{$class}}">
        <a href="#" class="flex items-center">
            <!--<img src="{{asset('uploads/icons/sidebar/settings.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 515.088 515.088" style="enable-background:new 0 0 515.088 515.088;" xml:space="preserve" width="512px" height="512px"><g><g><g><g><polygon points="109.088,427.416 86.128,404.456 106.56,347.304 86.848,299.736 32,273.784 32,241.304 86.848,215.352 106.56,167.784 86.128,110.632 109.088,87.672 166.272,108.104 213.776,88.44 239.776,33.544 272.224,33.544 298.224,88.44 345.728,108.104 402.912,87.672 425.872,110.632 407.52,161.96 437.664,172.744 462.816,102.328 411.232,50.728 346.576,73.832 321.856,63.592 292.48,1.544 219.52,1.544 190.144,63.592 165.424,73.832 100.768,50.728 49.184,102.328 72.272,166.936 62,191.704 0,221.064 0,294.024 62,323.384 72.272,348.152 49.184,412.76 100.768,464.36 171.2,439.208 160.432,409.08" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M484.8,343.944l30.288-41.36L481.6,244.552l-50.976,5.552l-16.688-9.6l-20.688-46.96h-66.944L305.6,240.472l-16.704,9.6 l-50.96-5.552l-33.456,58.016l30.272,41.408v19.2l-30.272,41.408l33.472,57.984l50.96-5.552l16.704,9.6l20.688,46.96h66.944     l20.688-46.928l16.688-9.6l50.976,5.552l33.472-57.984l-30.272-41.44V343.944z M476.944,406.664l-12.608,21.856l-40.64-4.432 L388.8,444.136l-16.416,37.408H347.2l-16.496-37.408l-34.816-20.096l-40.624,4.432l-12.608-21.856l24.128-32.96v-40.224 l-24.128-32.96l12.608-21.856l40.624,4.432l34.816-20.096l16.496-37.408h25.216l16.48,37.408l34.816,20.096l40.64-4.432 l12.608,21.856l-24.16,32.96v40.224L476.944,406.664z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M359.776,289.544c-35.346,0-64,28.654-64,64c0,35.346,28.654,64,64,64c35.346,0,64-28.654,64-64     C423.776,318.198,395.122,289.544,359.776,289.544z M359.776,385.544c-17.673,0-32-14.327-32-32c0-17.673,14.327-32,32-32     c17.673,0,32,14.327,32,32C391.776,371.217,377.449,385.544,359.776,385.544z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M160,257.544c-0.058-29.117,13.152-56.674,35.888-74.864l-20.064-24.928c-55.105,44.282-63.879,124.85-19.597,179.955c7.64,9.507,16.598,17.873,26.605,24.845l18.32-26.24C175.391,318.355,160.026,288.946,160,257.544z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M273.2,163.144c8.305,1.487,16.375,4.069,24,7.68l13.696-28.896c-10.167-4.823-20.927-8.282-32-10.288L273.2,163.144z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M219.376,168.76c8.453-3.493,17.366-5.746,26.464-6.688l-3.296-31.84c-12.154,1.271-24.063,4.283-35.36,8.944 L219.376,168.76z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Settings <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar bottom-0" style="top: auto;">
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'schooldetails' ? 'active':''}}">
                <a href="{{ url('/admin/schooldetails') }}" class="flex items-center whitespace-no-wrap">
                    <!-- <img src="{{asset('uploads/icons/sidebar/school.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 -20 512 512" width="512px"><g><path d="m485.484375 207.4375-19.484375-29.296875v-168.140625c0-5.523438-4.476562-10-10-10h-161.152344c-13.074218 0-25.359375 5.097656-34.589844 14.355469-1.539062 1.546875-2.953124 3.183593-4.257812 4.886719-1.304688-1.703126-2.714844-3.339844-4.257812-4.886719-9.230469-9.257813-21.515626-14.355469-34.589844-14.355469h-161.152344c-5.523438 0-10 4.476562-10 10v168.140625l-19.484375 29.296875c-17.347656 26.085938-26.515625 56.433594-26.515625 87.757812v166.804688c0 5.523438 4.476562 10 10 10s10-4.476562 10-10v-166.804688c0-27.371093 8.011719-53.890624 23.167969-76.679687l2.832031-4.257813v107.660157c0 12.429687 10.113281 22.542969 22.542969 22.542969 7.539062 0 14.542969-3.742188 18.734375-10.007813l21.035156-31.4375c2.074219-3.105469 6.003906-4.453125 9.550781-3.289063 4.152344 1.367188 6.523438 5.609376 5.511719 9.863282l-5.335938 22.464844c-7.917968 33.324218-20.59375 65.269531-37.671874 94.957031-.875 1.519531-1.335938 3.238281-1.335938 4.988281v30c0 5.519531 4.480469 10 10 10 5.523438 0 10-4.480469 10-10v-27.347656c7.945312-14.039063 14.949219-28.546875 21.003906-43.441406h271.929688c6.054687 14.894531 13.058594 29.40625 21.003906 43.441406v27.347656c0 5.523438 4.476562 10 10 10 5.519531 0 10-4.476562 10-10v-30c0-1.75-.460938-3.46875-1.335938-4.988281-17.078124-29.6875-29.753906-61.632813-37.671874-94.957031l-5.335938-22.464844c-1.011719-4.253906 1.359375-8.492188 5.511719-9.863282 3.550781-1.164062 7.476562.1875 9.550781 3.289063l21.035156 31.4375c4.191406 6.265625 11.195313 10.007813 18.734375 10.007813 12.429688 0 22.542969-10.113282 22.542969-22.542969v-107.660157l2.832031 4.257813c15.15625 22.792969 23.167969 49.308594 23.167969 76.679687v166.804688c0 5.523438 4.476562 10 10 10s10-4.476562 10-10v-166.804688c0-31.324218-9.167969-61.671874-26.515625-87.757812zm-371.355469-187.4375h41.820313v132.46875l-13.8125-13.925781c-1.875-1.894531-4.433594-2.957031-7.097657-2.957031-2.667968 0-5.222656 1.0625-7.101562 2.957031l-13.8125 13.925781v-132.46875zm-22.441406 271.894531-21.035156 31.433594c-.472656.707031-1.261719 1.132813-2.113282 1.132813-1.398437 0-2.539062-1.144532-2.539062-2.542969v-301.917969h28.125v156.753906c0 4.050782 2.445312 7.703125 6.191406 9.246094 3.75 1.542969 8.054688.671875 10.910156-2.203125l23.808594-24.011719 23.8125 24.011719c1.917969 1.929687 4.488282 2.957031 7.105469 2.957031 1.28125 0 2.574219-.246094 3.804687-.753906 3.746094-1.542969 6.191407-5.195312 6.191407-9.246094v-156.753906h41.203125c7.71875 0 14.976562 3.011719 20.425781 8.480469 5.453125 5.464843 8.445313 12.730469 8.421875 20.480469v284.914062c-8.316406-6.109375-18.328125-9.414062-28.847656-9.414062h-76.753906l2.433593-10.25c3.433594-14.445313-4.613281-28.839844-18.71875-33.480469-12.039062-3.964844-25.375.625-32.425781 11.164062zm43.859375 52.566407h81.605469c7.71875 0 14.976562 3.011718 20.425781 8.480468 4.9375 4.949219 7.847656 11.371094 8.339844 18.269532h-118.410157c3.007813-8.804688 5.691407-17.726563 8.039063-26.75zm130.535156 26.75c.492188-6.898438 3.402344-13.320313 8.339844-18.269532 5.449219-5.46875 12.707031-8.480468 20.425781-8.480468h81.605469c2.347656 9.023437 5.03125 17.945312 8.039063 26.75zm179.917969-49.292969c0 1.398437-1.140625 2.542969-2.542969 2.542969-.847656 0-1.640625-.425782-2.113281-1.128907l-21.03125-31.4375c-7.050781-10.539062-20.386719-15.128906-32.429688-11.164062-14.101562 4.640625-22.148437 19.035156-18.714843 33.480469l2.433593 10.25h-76.753906c-10.519531 0-20.527344 3.300781-28.847656 9.414062v-284.945312c-.023438-7.71875 2.96875-14.984376 8.421875-20.453126 5.449219-5.464843 12.703125-8.476562 20.425781-8.476562h151.152344zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m404.101562 138.375h-96.214843c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10h96.214843c5.523438 0 10-4.476562 10-10s-4.476562-10-10-10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m404.101562 189.039062h-96.214843c-5.523438 0-10 4.476563-10 10 0 5.523438 4.476562 10 10 10h96.214843c5.523438 0 10-4.476562 10-10 0-5.523437-4.476562-10-10-10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m404.101562 239.707031h-96.214843c-5.523438 0-10 4.476563-10 10 0 5.523438 4.476562 10 10 10h96.214843c5.523438 0 10-4.476562 10-10 0-5.523437-4.476562-10-10-10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m307.890625 107.710938c2.628906 0 5.199219-1.070313 7.070313-2.929688 1.859374-1.859375 2.929687-4.441406 2.929687-7.070312 0-2.640626-1.070313-5.210938-2.929687-7.070313-1.859376-1.871094-4.441407-2.929687-7.070313-2.929687-2.640625 0-5.210937 1.058593-7.070313 2.929687-1.859374 1.859375-2.929687 4.429687-2.929687 7.070313 0 2.628906 1.070313 5.210937 2.929687 7.070312 1.859376 1.859375 4.441407 2.929688 7.070313 2.929688zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m404.101562 87.707031h-56.214843c-5.523438 0-10 4.476563-10 10 0 5.523438 4.476562 10 10 10h56.214843c5.523438 0 10-4.476562 10-10 0-5.523437-4.476562-10-10-10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">School Details</span>
                </a>
            </li>

            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'academics' ? 'active':''}} || {{Request::segment ('2') == 'academic' ? 'active':''}}"> 
                <a href="{{ url('admin/academics') }}" class="flex items-center">
                    <!--<img src="{{asset('uploads/icons/sidebar/academic.svg')}}" class="w-5 h-5">   -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512.001 512.001" style="enable-background:new 0 0 512.001 512.001;" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M511.03,349.749c0-19.506-12.509-36.136-29.924-42.313V152.629l30.896-12.349L255.669,37.825L0,140.28l121.018,48.496 v71.201c0,21.949,15.388,41.731,43.329,55.702c24.645,12.323,57.079,19.109,91.329,19.109s66.685-6.786,91.329-19.109 c27.941-13.971,43.329-33.752,43.329-55.702V188.91l60.846-24.32v142.847c-17.415,6.176-29.924,22.807-29.924,42.313 c0,17.844,10.467,33.287,25.584,40.516l-24.816,74.448l28.389,9.463l15.73-47.189l15.73,47.189l28.389-9.463l-24.816-74.448 C500.561,383.035,511.03,367.593,511.03,349.749z M360.411,259.976c0,21.188-44.79,44.886-104.734,44.886    c-59.944,0-104.734-23.698-104.734-44.886v-59.209l104.727,41.968l104.742-41.866V259.976z M255.684,210.504L80.445,140.28 l175.239-70.224l175.691,70.224L255.684,210.504z M466.143,364.711c-8.25,0-14.962-6.712-14.962-14.962 c0-8.25,6.712-14.962,14.962-14.962c8.25,0,14.962,6.712,14.962,14.962C481.105,357.999,474.393,364.711,466.143,364.711z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Academic Years</span>
                </a> 
            </li>

            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'admissions' ? 'active':''}} || {{Request::segment ('2') == 'admission' ? 'active':''}}"> 
                <a href="{{ url('admin/admissions') }}" class="flex items-center">
                    <!--<img src="{{asset('uploads/icons/sidebar/academic.svg')}}" class="w-5 h-5">   -->
                    <svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="225.000000pt" height="225.000000pt" viewBox="0 0 225.000000 225.000000" preserveAspectRatio="xMidYMid meet" class="w-5 h-5" style="enable-background:new 0 0 512.001 512.001; filter: invert(1);"><g transform="translate(0.000000,225.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none"><path d="M311 1998 l-240 -253 -1 -862 c0 -843 0 -863 19 -873 13 -7 301 -10 865 -10 754 0 846 2 860 16 14 13 16 48 16 224 l0 208 -37 -9 c-21 -5 -41 -9 -45 -9 -5 0 -8 -76 -8 -170 l0 -170 -790 0 -790 0 0 795 0 795 209 0 c177 0 212 2 225 16 14 13 16 49 16 240 l0 224 565 0 565 0 0 -685 0 -686 38 7 c20 4 40 9 45 11 4 2 7 321 7 708 0 626 -2 705 -16 719 -14 14 -85 16 -639 16 l-623 0 -241 -252z m196 -215 c-3 -2 -63 -2 -135 -1 l-130 3 131 139 132 139 3 -138 c1 -76 1 -140 -1 -142z"/><path d="M1206 1774 c-9 -8 -16 -23 -16 -33 0 -37 19 -41 190 -41 116 0 170 4 178 12 18 18 14 56 -7 68 -11 6 -87 10 -175 10 -127 0 -157 -3 -170 -16z"/><path d="M743 1580 c-30 -12 -32 -64 -4 -80 13 -6 160 -10 410 -10 341 0 392 2 405 16 22 22 20 50 -6 68 -19 14 -74 16 -403 15 -209 0 -390 -4 -402 -9z"/><path d="M342 1368 c-15 -15 -15 -51 0 -66 17 -17 1199 -17 1216 0 15 15 15 51 0 66 -17 17 -1199 17 -1216 0z"/><path d="M348 1169 c-11 -6 -18 -22 -18 -40 0 -23 6 -32 26 -39 17 -7 239 -9 611 -8 506 3 585 5 593 18 14 22 12 47 -6 64 -14 14 -82 16 -602 16 -380 -1 -593 -4 -604 -11z"/><path d="M342 958 c-15 -15 -15 -51 0 -66 17 -17 719 -17 736 0 7 7 12 21 12 33 0 12 -5 26 -12 33 -17 17 -719 17 -736 0z"/><path d="M1791 760 c-46 -10 -133 -21 -195 -25 -133 -8 -241 -32 -356 -79 -78 -31 -106 -55 -82 -70 6 -3 42 8 82 24 135 56 200 71 338 81 109 7 328 42 340 53 1 2 0 11 -4 20 -7 19 -15 19 -123 -4z"/><path d="M342 758 c-15 -15 -15 -51 0 -66 8 -8 53 -12 135 -12 111 0 123 2 133 19 14 27 13 37 -6 55 -12 13 -39 16 -133 16 -78 0 -121 -4 -129 -12z"/><path d="M2022 717 c-41 -8 -51 -13 -48 -26 3 -9 10 -42 16 -73 8 -43 16 -58 28 -58 42 1 137 30 149 46 19 27 16 77 -7 102 -23 24 -50 26 -138 9z"/><path d="M1360 601 c-413 -89 -545 -121 -545 -132 0 -41 30 -171 40 -175 7 -3 257 47 557 110 299 64 546 116 549 116 3 0 -3 45 -15 100 -11 55 -25 100 -31 99 -5 -1 -255 -54 -555 -118z m539 55 c-13 -13 -1035 -224 -1043 -216 -5 6 -8 11 -5 14 2 2 236 53 519 113 443 94 553 113 529 89z"/><path d="M605 393 c-55 -35 -101 -69 -103 -77 -2 -9 30 -18 118 -31 66 -9 123 -15 126 -12 7 6 -25 169 -34 178 -4 4 -52 -22 -107 -58z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Admissions</span>
                </a> 
            </li>

            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'holidays' ? 'active':''}} || {{Request::segment ('2') == 'holiday' ? 'active':''}}"> 
                <a href="{{ url('admin/holidays') }}" class="flex items-center">
                    <!--<img src="{{asset('uploads/icons/sidebar/academic.svg')}}" class="w-5 h-5">-->
                    <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><path id="XMLID_86_" d="m480.912 40h-73.615c-1.048-22.233-19.461-40-41.949-40s-40.901 17.767-41.949 40h-123.776c-1.048-22.233-19.461-40-41.949-40s-40.901 17.767-41.949 40h-50.813c-17.142 0-31.089 13.946-31.089 31.088v332.891h-23.823c-5.523 0-10 4.477-10 10 0 22.644 14.016 42.064 33.823 50.075v37.946c0 5.523 4.477 10 10 10h458.177c5.523 0 10-4.477 10-10v-430.912c0-17.142-13.946-31.088-31.088-31.088zm-115.564-20c11.456 0 20.891 8.803 21.905 20h-43.81c1.014-11.197 10.448-20 21.905-20zm-207.674 0c11.456 0 20.891 8.803 21.905 20h-43.81c1.014-11.197 10.449-20 21.905-20zm-103.851 127h358.177c5.523 0 10-4.477 10-10s-4.477-10-10-10h-358.177v-55.912c0-6.114 4.974-11.088 11.089-11.088h50.813c1.048 22.233 19.461 40 41.949 40 5.523 0 10-4.477 10-10s-4.477-10-10-10c-11.456 0-20.891-8.803-21.905-20h187.63c1.048 22.233 19.461 40 41.949 40 5.523 0 10-4.477 10-10s-4.477-10-10-10c-11.456 0-20.891-8.803-21.905-20h137.469c6.114 0 11.088 4.974 11.088 11.088v346.891c0 16.521-13.424 29.964-29.938 29.998-18.719-.034-33.938-15.272-33.938-33.998 0-5.523-4.477-10-10-10h-364.301zm-32.323 276.979h387.553c1.688 8.975 5.604 17.176 11.148 24h-366.201c-15.269 0-28.22-10.117-32.5-24zm32.323 68.021v-24.025c.059 0 .117.004.177.004h406.379c.176 0 .352-.004.525-.014.352.008.706.011 1.06.012.012 0 .024.002.036.002.013 0 .025-.001.038-.001.029 0 .058.001.087.001.043 0 .084-.006.126-.006 11.15-.055 21.449-3.776 29.749-10.021v34.048z"/><path id="XMLID_893_" d="m457 147c2.63 0 5.21-1.07 7.07-2.93s2.93-4.44 2.93-7.07-1.07-5.21-2.93-7.07-4.44-2.93-7.07-2.93-5.21 1.07-7.07 2.93-2.93 4.44-2.93 7.07 1.07 5.21 2.93 7.07 4.44 2.93 7.07 2.93z"/><path id="XMLID_936_" d="m272.912 229.49c-25.364 0-46 20.636-46 46s20.636 46 46 46 46-20.636 46-46-20.636-46-46-46zm0 72c-14.336 0-26-11.664-26-26s11.664-26 26-26 26 11.664 26 26-11.664 26-26 26z"/><path id="XMLID_937_" d="m272.912 209.49c5.523 0 10-4.477 10-10v-22.49c0-5.523-4.477-10-10-10s-10 4.477-10 10v22.49c0 5.523 4.477 10 10 10z"/><path id="XMLID_938_" d="m272.912 341.49c-5.523 0-10 4.477-10 10v22.489c0 5.523 4.477 10 10 10s10-4.477 10-10v-22.489c0-5.523-4.477-10-10-10z"/><path id="XMLID_1001_" d="m371.401 265.49h-22.49c-5.523 0-10 4.477-10 10s4.477 10 10 10h22.49c5.523 0 10-4.477 10-10s-4.477-10-10-10z"/><path id="XMLID_1002_" d="m206.912 275.49c0-5.523-4.477-10-10-10h-22.49c-5.523 0-10 4.477-10 10s4.477 10 10 10h22.49c5.523 0 10-4.477 10-10z"/><path id="XMLID_1004_" d="m326.652 231.75c2.559 0 5.119-.976 7.071-2.929l15.902-15.902c3.905-3.905 3.905-10.237 0-14.143-3.905-3.905-10.237-3.905-14.143 0l-15.902 15.902c-3.905 3.905-3.905 10.237 0 14.143 1.953 1.952 4.513 2.929 7.072 2.929z"/><path id="XMLID_1005_" d="m212.1 322.159-15.902 15.903c-3.905 3.905-3.905 10.237 0 14.142 1.953 1.953 4.512 2.929 7.071 2.929s5.119-.977 7.071-2.929l15.902-15.903c3.905-3.905 3.905-10.237 0-14.142s-10.237-3.906-14.142 0z"/><path id="XMLID_1006_" d="m333.723 322.159c-3.905-3.905-10.237-3.905-14.142 0s-3.906 10.237 0 14.142l15.902 15.903c1.953 1.953 4.512 2.929 7.071 2.929s5.119-.977 7.071-2.929c3.905-3.905 3.906-10.237 0-14.142z"/><path id="XMLID_1018_" d="m212.1 228.821c1.953 1.953 4.512 2.929 7.071 2.929s5.119-.976 7.071-2.929c3.905-3.905 3.905-10.237 0-14.143l-15.902-15.902c-3.905-3.905-10.237-3.905-14.143 0-3.905 3.905-3.905 10.237 0 14.143z"/></svg>
                    <span class="mx-3 whitespace-no-wrap">Holidays List</span>
                </a> 
            </li>
     @if(config('gexam.enabled', false))
            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'examrules' ? 'active':''}}"> 
                <a href="{{ url('/admin/examrules') }}" class="flex items-center">
                    <!--  <img src="{{asset('uploads/icons/sidebar/rules.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-40 -20 640 640" width="512px"><g><path d="m428.667969 80h-300c-27.613281 0-50 22.386719-50 50v310c0 5.523438 4.476562 10 10 10 5.519531 0 10-4.476562 10-10v-310c0-16.566406 13.429687-30 30-30h300c16.566406 0 30 13.433594 30 30v420c0 16.566406-13.433594 30-30 30-16.570313 0-30-13.433594-30-30v-50c0-11.046875-8.957031-20-20-20h-360c-11.046875 0-20 8.953125-20 20v50c0 27.613281 22.386719 50 50 50h380c27.609375 0 50-22.386719 50-50v-420c0-27.613281-22.390625-50-50-50zm-380 500c-16.570313 0-30-13.433594-30-30v-50h360v50c0 10.820312 3.507812 21.34375 10 30zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m378.667969 200c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-160c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m158.667969 250c0 5.523438 4.476562 10 10 10h210c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-210c-5.523438 0-10 4.476562-10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m168.667969 320h210c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-210c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m168.667969 380h210c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-210c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m168.667969 440h170c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-170c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m508.667969 0h-300c-27.613281 0-50 22.386719-50 50 0 5.523438 4.476562 10 10 10 5.519531 0 10-4.476562 10-10 0-16.566406 13.429687-30 30-30h300c16.566406 0 30 13.433594 30 30v420c0 16.566406-13.433594 30-30 30-5.523438 0-10 4.476562-10 10s4.476562 10 10 10c27.609375 0 50-22.386719 50-50v-420c0-27.613281-22.390625-50-50-50zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">Exam Rules</span> 
                </a>
            </li>

             <li class="py-3 px-2 hover:font-semibold {{Request::segment ('3') == 'grade' ? 'active':''}}"> 
                <a href="{{ url('/admin/exam/grade') }}" class="flex items-center">
                    <!--  <img src="{{asset('uploads/icons/sidebar/rules.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-40 -20 640 640" width="512px"><g><path d="m428.667969 80h-300c-27.613281 0-50 22.386719-50 50v310c0 5.523438 4.476562 10 10 10 5.519531 0 10-4.476562 10-10v-310c0-16.566406 13.429687-30 30-30h300c16.566406 0 30 13.433594 30 30v420c0 16.566406-13.433594 30-30 30-16.570313 0-30-13.433594-30-30v-50c0-11.046875-8.957031-20-20-20h-360c-11.046875 0-20 8.953125-20 20v50c0 27.613281 22.386719 50 50 50h380c27.609375 0 50-22.386719 50-50v-420c0-27.613281-22.390625-50-50-50zm-380 500c-16.570313 0-30-13.433594-30-30v-50h360v50c0 10.820312 3.507812 21.34375 10 30zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m378.667969 200c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-160c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m158.667969 250c0 5.523438 4.476562 10 10 10h210c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-210c-5.523438 0-10 4.476562-10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m168.667969 320h210c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-210c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m168.667969 380h210c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-210c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m168.667969 440h170c5.519531 0 10-4.476562 10-10s-4.480469-10-10-10h-170c-5.523438 0-10 4.476562-10 10s4.476562 10 10 10zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m508.667969 0h-300c-27.613281 0-50 22.386719-50 50 0 5.523438 4.476562 10 10 10 5.519531 0 10-4.476562 10-10 0-16.566406 13.429687-30 30-30h300c16.566406 0 30 13.433594 30 30v420c0 16.566406-13.433594 30-30 30-5.523438 0-10 4.476562-10 10s4.476562 10 10 10c27.609375 0 50-22.386719 50-50v-420c0-27.613281-22.390625-50-50-50zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">Exam Grade</span> 
                </a>
            </li>
  @endif
            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'promotion' ? 'active':''}}">
                <a href="{{ url('/admin/promotion/create') }}" class="flex items-center">
                    <!--  <img src="{{asset('uploads/icons/sidebar/promotion.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px"><g><path d="m497 161h-60c-8.284 0-15 6.716-15 15s6.716 15 15 15h23.787l-73.093 73.093c-6.583-30.894-26.794-56.8-54.017-71.104 16.093-13.767 26.323-34.2 26.323-56.989 0-41.355-33.645-75-75-75s-75 33.645-75 75c0 22.789 10.23 43.222 26.323 56.988-25.113 13.196-44.261 36.262-52.247 64.012-1.878-2.151-3.844-4.24-5.91-6.252-7.355-7.167-15.59-13.13-24.454-17.789 16.073-13.767 26.288-34.187 26.288-56.959 0-41.355-33.645-75-75-75s-75 33.645-75 75c0 22.789 10.23 43.222 26.323 56.988-33.452 17.578-56.323 52.672-56.323 93.012v110c0 8.284 6.716 15 15 15h122c3.979 0 7.794-1.58 10.606-4.394l109.394-109.393 39.394 39.394c5.857 5.857 15.355 5.857 21.213 0l164.393-164.394v23.787c0 8.284 6.716 15 15 15s15-6.716 15-15v-60c0-8.284-6.716-15-15-15zm-257-25c0-24.813 20.187-45 45-45s45 20.187 45 45-20.187 45-45 45-45-20.187-45-45zm-180 40c0-24.813 20.187-45 45-45s45 20.187 45 45-20.187 45-45 45-45-20.187-45-45zm70.787 245h-100.787v-95c0-41.355 33.645-75 75-75 19.629 0 38.177 7.541 52.229 21.233 14.024 13.666 22.066 31.967 22.644 51.531.016.528.06 1.048.128 1.56v46.462zm176.213-76.213-39.394-39.394c-5.857-5.857-15.355-5.857-21.213 0l-36.393 36.394v-55.787c0-41.355 33.645-75 75-75s75 33.645 75 75v5.787z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">Promotions</span> 
                </a>
            </li>

            <li class="py-3 px-2 hover:font-semibold {{Request::segment ('2') == 'leavetypes' ? 'active':''}} || {{Request::segment ('2') == 'leavetype' ? 'active':''}}">
                <a href="{{ url('/admin/leavetypes') }}" class="flex items-center">
                    <!--<img src="{{asset('uploads/icons/sidebar/rooms.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 0 512 512.00025" width="512px"><g><path d="m396.425781 268.34375h59.996094v143.65625h-59.996094zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m282.808594 268.34375h60v143.65625h-60zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m169.191406 268.34375h60v143.65625h-60zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m55.578125 268.34375h59.996094v143.65625h-59.996094zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m476.425781 223.34375v-15h-440.847656v15c0 8.285156 6.714844 15 15 15h410.847656c8.28125 0 15-6.714844 15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m496.992188 442h-481.976563c-8.285156 0-15 6.714844-15 15v40c0 8.285156 6.714844 15 15 15h481.976563c8.285156 0 15-6.714844 15-15v-40c0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m15 178.34375h482c6.710938 0 12.605469-4.457031 14.433594-10.914062 1.824218-6.457032-.855469-13.34375-6.570313-16.859376l-241-148.34375c-4.820312-2.96875-10.902343-2.96875-15.726562 0l-241 148.34375c-5.714844 3.519532-8.394531 10.402344-6.566407 16.859376 1.828126 6.457031 7.722657 10.914062 14.429688 10.914062zm230.804688-90.117188h20.394531c8.285156 0 15 6.714844 15 15 0 8.285157-6.714844 15-15 15h-20.394531c-8.285157 0-15-6.714843-15-15 0-8.285156 6.714843-15 15-15zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
                    <span class="mx-3 whitespace-no-wrap">Leave Master</span> 
                </a>
            </li>
        </ul>
    </li>
    <!-- end -->

    <!-- <li class="py-3 px-3 {{Request::segment ('2') == 'standards' ? 'active':''}} && {{Request::segment ('2') == 'standard' ? 'active':''}}">
        <a href="{{url('/admin/standards')}}" class="flex items-center whitespace-no-wrap">
            <img src="{{asset('uploads/icons/sidebar/standard.svg')}}" class="w-5 h-5">
            <span class="mx-3 whitespace-no-wrap">Standards</span>
        </a>
    </li>
    <li class="py-3 px-3 {{Request::segment ('2') == 'sections' ? 'active':''}} && {{Request::segment ('2') == 'section' ? 'active':''}}">
        <a href="{{url('/admin/sections')}}" class="flex items-center whitespace-no-wrap">
            <img src="{{asset('uploads/icons/sidebar/section.svg')}}" class="w-5 h-5">
            <span class="mx-3 whitespace-no-wrap">Sections</span>
        </a>
      </li> -->

    <!-- <li class="py-3 px-3 {{Request::segment ('2') == 'subjects' ? 'active':''}} && {{Request::segment ('2') == 'subject' ? 'active':''}}">
        <a href="{{url('/admin/subjects')}}" class="flex items-center">
            <img src="{{asset('uploads/icons/sidebar/subject.svg')}}" class="w-5 h-5">
            <span class="mx-3 whitespace-no-wrap">Subjects</span>
        </a>
    </li> -->
     
    <!--<li class="py-3 px-3 {{Request::segment ('2') == 'files' ? 'active':''}} && {{Request::segment ('2') == 'videos' ? 'active':''}}">
        <a href="{{url('/admin/videos')}}" class="flex items-center">
            <img src="{{asset('uploads/icons/sidebar/upload.svg')}}" class="w-5 h-5">
            <span class="mx-3 whitespace-no-wrap">Media Upload</span>
        </a>
    </li> -->

      @php
        $class='';
        $array=array('transport');
        if(in_array(\Request()->segment('1'),$array))
        {
            $class='active';
        }
    @endphp
@if(config('gtransport.enabled', false))
    <!-- 'transport' -->
    <li class="relative py-3 px-3 hover:bg-red-900 {{$class}}">
        <a href="#" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/settings.svg')}}" class="w-5 h-5"> -->
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64" class="w-5 h-5 fill-current text-white" ><g id="school_bus-bus-school-college-flag" data-name="school bus-bus-school-college-flag"><path d="M48.97,36.757A1,1,0,0,0,48,36H44a1,1,0,0,0-1,1v8a1,1,0,0,0,1,1h6a1,1,0,0,0,.97-1.243ZM45,44V38h2.219l1.5,6Z"/><path d="M32,21a3,3,0,1,0-3-3A3,3,0,0,0,32,21Zm0-4a1,1,0,1,1-1,1A1,1,0,0,1,32,17Z"/><path d="M43,20.18v-4l2.73.78.54-1.92L33,11.25V8h5a2.006,2.006,0,0,0,2-2V4a2.006,2.006,0,0,0-2-2H32a1,1,0,0,0-1,1v8.25L17.73,15.04l.54,1.92L21,16.18v4L1.8,24.02l.4,1.96.8-.16V39a1,1,0,0,0,1,1H7V57a1,1,0,0,0,1,1h5.1a5,5,0,0,0,9.8,0H43.1a5,5,0,0,0,9.8,0H56a1,1,0,0,0,1-1V49a1.033,1.033,0,0,0-.29-.71l-1.79-1.78L53.62,40H60a1,1,0,0,0,1-1V25.82l.8.16.4-1.96ZM33,4h5V6H33ZM23,15.61l9-2.57,9,2.57V30H39V25a3,3,0,0,0-6,0v5H31V25a3,3,0,0,0-6,0v5H23ZM37,25v5H35V25a1,1,0,0,1,2,0Zm-8,0v5H27V25a1,1,0,0,1,2,0ZM7,35v3H5V25.42l16-3.2V30H18.9A5,5,0,0,0,9,31v.03A4.952,4.952,0,0,0,7,35Zm9.82-5H12a4.6,4.6,0,0,0-.84.09A2.981,2.981,0,0,1,16.82,30ZM18,60a3,3,0,1,1,3-3A3.009,3.009,0,0,1,18,60Zm17-4H33V38h2Zm4,0H37V38h2Zm9,4a3,3,0,1,1,3-3A3.009,3.009,0,0,1,48,60Zm7-24H52a.971.971,0,0,0-.77.37.99.99,0,0,0-.21.83l2,10a1.014,1.014,0,0,0,.27.51L55,49.41V51H53v2h2v3H52.9a5,5,0,0,0-9.8,0H41V37a1,1,0,0,0-1-1H32a1,1,0,0,0-1,1V56H22.9a5,5,0,0,0-9.8,0H9V52h2V50H9V35a3.009,3.009,0,0,1,3-3H52a3.009,3.009,0,0,1,3,3Zm-7.82-6a2.97,2.97,0,0,1,5.66.09A4.6,4.6,0,0,0,52,30ZM59,38H56a1,1,0,0,0,1-1V35a4.952,4.952,0,0,0-2-3.97V31a5,5,0,0,0-9.9-1H43V22.22l16,3.2Z"/><path d="M18,36H12a1,1,0,0,0-1,1V47a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V37A1,1,0,0,0,18,36ZM17,46H13V44h4Zm0-4H13V38h4Z"/><path d="M28,36H22a1,1,0,0,0-1,1V47a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V37A1,1,0,0,0,28,36ZM27,46H23V42h4Zm0-6H23V38h4Z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Transport <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"> </span>
        </a>
        <ul class="list-reset sites-sidebar bottom-0" style="top: auto;">
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('4') == 'stoppage' ? 'active':''}} || {{Request::segment ('3') == 'stoppage' ? 'active':''}}">
                <a href="{{ url('admin/transport/stoppage') }}" class="flex  items-center">
                    <!--  <img src="{{asset('uploads/icons/reminder_.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5 fill-current text-white" id="Layer_5" enable-background="new 0 0 64 64"  viewBox="0 0 64 64"  xmlns="http://www.w3.org/2000/svg"><g><path d="m11 53c1.654 0 3-1.346 3-3s-1.346-3-3-3-3 1.346-3 3 1.346 3 3 3zm0-4c.552 0 1 .449 1 1s-.448 1-1 1-1-.449-1-1 .448-1 1-1z"/><path d="m24 50c0 1.654 1.346 3 3 3s3-1.346 3-3-1.346-3-3-3-3 1.346-3 3zm4 0c0 .551-.448 1-1 1s-1-.449-1-1 .448-1 1-1 1 .449 1 1z"/><path d="m13 45h12c1.654 0 3-1.346 3-3v-8c0-1.654-1.346-3-3-3h-12c-1.654 0-3 1.346-3 3v8c0 1.654 1.346 3 3 3zm-1-11c0-.551.448-1 1-1h12c.552 0 1 .449 1 1v8c0 .551-.448 1-1 1h-7v-4h2v-2h-6v2h2v4h-3c-.552 0-1-.449-1-1z"/><path d="m63 18v-2.512c0-1.335-.859-2.49-2.138-2.874l-37.872-11.361c-.559-.168-1.139-.253-1.723-.253h-.267c-3.309 0-6 2.691-6 6v.747l38 11.227v28.026h-7v-6.13c2.871-.696 5-4.337 5-8.87 0-5.047-2.636-9-6-9s-6 3.953-6 9c0 4.533 2.129 8.174 5 8.87v6.13h-3c-2.206 0-4 1.794-4 4v2h2v8h-9.184c.112-.314.184-.648.184-1v-3.085c2.268-.4 4-2.374 4-4.755 0-.134-.006-.268-.018-.402l-.729-8.758h.747c1.654 0 3-1.346 3-3v-6c0-1.654-1.346-3-3-3h-1.79c-.132-.737-.415-1.419-.841-2h.631c1.103 0 2-.897 2-2v-2c0-1.103-.897-2-2-2h-26c-1.103 0-2 .897-2 2v2c0 1.103.897 2 2 2h.632c-.426.581-.71 1.263-.841 2h-1.791c-1.654 0-3 1.346-3 3v6c0 1.654 1.346 3 3 3h.747l-.73 8.758c-.011.134-.017.267-.017.402 0 2.381 1.732 4.355 4 4.755v3.085c0 .352.072.686.184 1h-7.184v2h10 2 12 2 36v-6h-2v-36.184c1.161-.414 2-1.514 2-2.816zm-22 14c0-3.794 1.832-7 4-7s4 3.206 4 7c0 3.192-1.298 5.959-3 6.76v-5.225l2.555-1.703-1.109-1.664-1.446.964v-1.367l-1.105-2.211-1.789.895.894 1.787v2.35l-1.293-1.293-1.414 1.414 2.707 2.707v3.346c-1.702-.801-3-3.568-3-6.76zm-20-29h.267c.39 0 .776.057 1.149.169l37.872 11.361c.426.128.712.513.712.958v2.512c0 .511-.385.933-.88.993l-43.054-12.721c.343-1.859 1.977-3.272 3.934-3.272zm20 46h12v2h-14c0-1.103.897-2 2-2zm0 4h2v8h-2zm-6-19v6c0 .551-.448 1-1 1h-.914l-.667-8h1.581c.552 0 1 .449 1 1zm-29-9h26l.001 2h-4.534-16.934-4.533zm-2 16c-.552 0-1-.449-1-1v-6c0-.551.448-1 1-1h1.581l-.667 8zm2 11.16c0-.079.004-.158.01-.236l1.693-20.32c.121-1.46 1.364-2.604 2.83-2.604h16.934c1.466 0 2.709 1.144 2.83 2.604l1.693 20.319c.006.079.01.158.01.237 0 1.566-1.274 2.84-2.84 2.84h-20.32c-1.566 0-2.84-1.274-2.84-2.84zm10 4.84h6v3c0 .352.072.686.184 1h-6.369c.113-.314.185-.648.185-1zm-5 4c-.552 0-1-.449-1-1v-3h4v3c0 .551-.448 1-1 1zm14 0c-.552 0-1-.449-1-1v-3h4v3c0 .551-.448 1-1 1zm26 0h-6v-8h8v4h-2zm10 0h-8v-2h8zm-6-4v-37.435l4 1.182v36.253z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Stoppage</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'route' ? 'active':''}} || {{Request::segment ('4') == 'route' ? 'active':''}}">
                <a href="{{ url('admin/transport/route') }}" class="flex  items-center">
                    <!--  <img src="{{asset('uploads/icons/reminder_.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5 fill-current text-white" viewBox="0 0 480 480" xmlns="http://www.w3.org/2000/svg"><path d="m88 448c2.425781 0 4.722656-1.105469 6.238281-3 3.363281-4.160156 81.761719-102.535156 81.761719-149 0-48.601562-39.398438-88-88-88s-88 39.398438-88 88c0 46.464844 78.398438 144.800781 81.761719 149 1.515625 1.894531 3.8125 3 6.238281 3zm0-224c39.746094.042969 71.957031 32.253906 72 72 0 31.039062-47.289062 98.910156-72 131.03125-24.710938-32.109375-72-99.976562-72-131.03125.042969-39.746094 32.253906-71.957031 72-72zm0 0"/><path d="m120 288c0-17.671875-14.328125-32-32-32s-32 14.328125-32 32 14.328125 32 32 32 32-14.328125 32-32zm-48 0c0-8.835938 7.164062-16 16-16s16 7.164062 16 16-7.164062 16-16 16-16-7.164062-16-16zm0 0"/><path d="m416 168c2.332031 0 4.542969-1.015625 6.0625-2.785156 5.9375-6.886719 57.9375-68.269532 57.9375-101.214844 0-35.347656-28.652344-64-64-64s-64 28.652344-64 64c0 32.945312 52 94.328125 57.9375 101.214844 1.519531 1.769531 3.730469 2.785156 6.0625 2.785156zm0-152c26.5.027344 47.972656 21.5 48 48 0 20.273438-30.542969 62.046875-48 83.511719-17.464844-21.464844-48-63.199219-48-83.511719.027344-26.5 21.5-47.972656 48-48zm0 0"/><path d="m440 56c0-13.253906-10.746094-24-24-24s-24 10.746094-24 24 10.746094 24 24 24 24-10.746094 24-24zm-32 0c0-4.417969 3.582031-8 8-8s8 3.582031 8 8-3.582031 8-8 8-8-3.582031-8-8zm0 0"/><path d="m408 200h8c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-8c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8zm0 0"/><path d="m304 248h16.175781c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-16.304687c-2.113282.003906-4.140625.851562-5.628906 2.351562-1.488282 1.5-2.320313 3.535157-2.304688 5.648438.027344 4.429688 3.632812 8.003906 8.0625 8zm0 0"/><path d="m393.6875 240c0 4.417969 3.582031 8 8 8h16.296875c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-16.296875c-4.417969 0-8 3.582031-8 8zm0 0"/><path d="m359.097656 200h16.300782c4.417968 0 8-3.582031 8-8s-3.582032-8-8-8h-16.300782c-4.421875 0-8 3.582031-8 8s3.578125 8 8 8zm0 0"/><path d="m145.71875 464h-16.304688c-4.417968 0-8 3.582031-8 8s3.582032 8 8 8h16.304688c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8zm0 0"/><path d="m280.503906 228.960938c.558594 0 1.113282-.058594 1.65625-.175782 4.320313-.910156 7.085938-5.144531 6.183594-9.464844-.226562-1.09375-.339844-2.203124-.34375-3.320312-.003906-2.53125.59375-5.023438 1.742188-7.28125 2.003906-3.9375.4375-8.753906-3.503907-10.757812-3.9375-2.003907-8.753906-.4375-10.757812 3.503906-3.316407 6.511718-4.300781 13.96875-2.792969 21.121094.769531 3.703124 4.03125 6.367187 7.816406 6.375zm0 0"/><path d="m352.800781 248h16.304688c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-16.304688c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8zm0 0"/><path d="m310.191406 200h16.304688c4.417968 0 8-3.582031 8-8s-3.582032-8-8-8h-16.304688c-4.417968 0-8 3.582031-8 8s3.582032 8 8 8zm0 0"/><path d="m231.136719 339.015625c.632812.164063 1.289062.242187 1.941406.242187 3.671875-.007812 6.867187-2.507812 7.753906-6.066406 1.035157-4.113281 2.984375-7.941406 5.703125-11.199218 1.921875-2.179688 2.507813-5.226563 1.539063-7.960938-.96875-2.738281-3.347657-4.734375-6.210938-5.21875-2.859375-.480469-5.761719.625-7.574219 2.890625-4.285156 5.113281-7.355468 11.128906-8.976562 17.601563-.519531 2.058593-.195312 4.242187.898438 6.0625 1.089843 1.824218 2.863281 3.136718 4.925781 3.648437zm0 0"/><path d="m389.183594 463.664062c-1.71875.226563-3.449219.339844-5.183594.335938h-10.070312c-4.421876 0-8 3.582031-8 8s3.578124 8 8 8h10.070312c2.40625 0 4.8125-.15625 7.199219-.464844 4.382812-.566406 7.476562-4.578125 6.914062-8.960937-.566406-4.382813-4.578125-7.476563-8.960937-6.910157zm0 0"/><path d="m400.328125 370.398438c-5.292969-1.601563-10.796875-2.410157-16.328125-2.398438h-2.097656c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h2.097656c3.953125 0 7.886719.582031 11.671875 1.726562.753906.234376 1.539063.351563 2.328125.351563 3.964844.003906 7.335938-2.898437 7.921875-6.820313.582031-3.925781-1.796875-7.683593-5.59375-8.832031zm0 0"/><path d="m383.265625 312c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-16.296875c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8zm0 0"/><path d="m431.070312 436.390625c-4.023437-1.8125-8.757812-.023437-10.574218 4-1.863282 4.136719-4.421875 7.925781-7.558594 11.203125-2.054688 2.050781-2.835938 5.050781-2.042969 7.839844.792969 2.792968 3.035157 4.9375 5.855469 5.601562 2.824219.667969 5.789062-.246094 7.746094-2.386718 4.398437-4.585938 7.984375-9.894532 10.59375-15.6875 1.804687-4.027344.007812-8.757813-4.019532-10.570313zm0 0"/><path d="m472.96875 273.40625c-2.035156-.601562-4.226562-.371094-6.09375.644531-1.863281 1.015625-3.25 2.730469-3.851562 4.765625-1.175782 3.921875-3.324219 7.484375-6.246094 10.351563-3.160156 3.09375-3.214844 8.160156-.121094 11.320312 3.09375 3.160157 8.160156 3.210938 11.320312.121094 4.875-4.777344 8.453126-10.714844 10.398438-17.257813.605469-2.035156.371094-4.226562-.640625-6.09375-1.015625-1.863281-2.730469-3.25-4.765625-3.851562zm0 0"/><path d="m463.839844 258.640625c3.160156.003906 6.023437-1.855469 7.3125-4.738281 1.285156-2.882813.757812-6.253906-1.351563-8.605469-4.566406-5.078125-10.347656-8.910156-16.800781-11.136719-4.179688-1.4375-8.730469.789063-10.167969 4.96875-1.4375 4.179688.789063 8.730469 4.96875 10.167969 3.875 1.332031 7.34375 3.632813 10.078125 6.6875 1.519532 1.691406 3.6875 2.65625 5.960938 2.65625zm0 0"/><path d="m349.304688 368h-16.296876c-4.417968 0-8 3.582031-8 8s3.582032 8 8 8h16.296876c4.417968 0 8-3.582031 8-8s-3.582032-8-8-8zm0 0"/><path d="m432.167969 296h-16.304688c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h16.304688c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8zm0 0"/><path d="m194.617188 464h-16.296876c-4.417968 0-8 3.582031-8 8s3.582032 8 8 8h16.296876c4.417968 0 8-3.582031 8-8s-3.582032-8-8-8zm0 0"/><path d="m430.34375 392.558594c-2.496094-3.652344-7.480469-4.589844-11.136719-2.09375-3.652343 2.496094-4.589843 7.480468-2.09375 11.136718 2.554688 3.742188 4.449219 7.894532 5.597657 12.277344.625 2.863282 2.765624 5.15625 5.582031 5.976563 2.8125.820312 5.847656.035156 7.914062-2.046875 2.0625-2.078125 2.824219-5.121094 1.984375-7.929688-1.601562-6.179687-4.253906-12.039062-7.847656-17.320312zm0 0"/><path d="m255.617188 365.128906c-3.800782-1.894531-7.125-4.613281-9.738282-7.960937-2.710937-3.492188-7.738281-4.121094-11.226562-1.410157-3.492188 2.707032-4.121094 7.734376-1.414063 11.226563 4.097657 5.257813 9.324219 9.527344 15.296875 12.488281 3.941406 1.839844 8.632813.191406 10.558594-3.710937 1.925781-3.898438.378906-8.625-3.476562-10.632813zm0 0"/><path d="m243.519531 464h-16.320312c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h16.320312c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8zm0 0"/><path d="m341.328125 464h-16.296875c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h16.296875c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8zm0 0"/><path d="m285.464844 312c4.417968 0 8-3.582031 8-8s-3.582032-8-8-8h-16.296875c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8zm0 0"/><path d="m334.398438 312c4.417968 0 8-3.582031 8-8s-3.582032-8-8-8h-16.335938c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8zm0 0"/><path d="m300.40625 368h-16.300781c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h16.300781c4.421875 0 8-3.582031 8-8s-3.578125-8-8-8zm0 0"/><path d="m292.433594 464h-16.304688c-4.417968 0-8 3.582031-8 8s3.582032 8 8 8h16.304688c4.417968 0 8-3.582031 8-8s-3.582032-8-8-8zm0 0"/><path d="m96 464h-8c-4.417969 0-8 3.582031-8 8s3.582031 8 8 8h8c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8zm0 0"/></svg>
                    <span class="mx-3 whitespace-no-wrap">Route</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'vehicle' ? 'active':''}} || {{Request::segment ('4') == 'vehicle' ? 'active':''}}">
                <a href="{{ url('admin/transport/vehicle') }}" class="flex  items-center">
                    <!--  <img src="{{asset('uploads/icons/reminder_.svg')}}" class="w-5 h-5"> -->
                    <svg version="1.1"  class="w-5 h-5 fill-current text-white" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                   viewBox="0 0 512.006 512.006" style="enable-background:new 0 0 512.006 512.006;" xml:space="preserve">
                <g>
                  <g>
                    <g>
                      <path d="M507.375,451.92l-42.667-21.973c-2.71-1.396-5.96-1.241-8.524,0.408c-2.564,1.649-4.054,4.541-3.908,7.586
                        s1.905,5.781,4.616,7.178l42.667,21.982c4.192,2.159,9.34,0.51,11.499-3.682C513.216,459.226,511.567,454.078,507.375,451.92z"/>
                      <path d="M290.133,196.27c2.263,0,4.433-0.9,6.033-2.5L394.3,95.636c3.234-3.348,3.188-8.671-0.104-11.962
                        c-3.292-3.292-8.614-3.338-11.962-0.104L284.1,181.703c-2.44,2.44-3.169,6.11-1.849,9.298
                        C283.572,194.19,286.683,196.269,290.133,196.27z"/>
                      <path d="M322.5,227.903c3.332,3.331,8.734,3.331,12.066,0l98.133-98.133c3.234-3.348,3.188-8.671-0.104-11.962
                        c-3.292-3.292-8.614-3.338-11.962-0.104L322.5,215.837C319.169,219.169,319.169,224.571,322.5,227.903z"/>
                      <path d="M503.467,494.936H300.681L17.067,353.129V318.45l76.843,21.487c0,0.469-0.043,0.93-0.043,1.399
                        c0,28.698,14.984,51.2,34.133,51.2c2.392-0.001,4.77-0.357,7.057-1.058l26.129-4.352c2.901-0.486,5.811-0.93,8.721-1.374
                        c4.267-0.649,8.482-1.297,12.698-2.065c7.859-1.533,14.81-6.073,19.371-12.655l24.747,7.347
                        c5.883,3.347,12.487,5.223,19.251,5.47c0.239,0.063,0.481,0.114,0.725,0.154c0.094,0,0.171-0.051,0.256-0.051
                        c0.085,0,0.333,0.051,0.512,0.051h90.795l84.48,43.52c4.19,2.159,9.336,0.512,11.494-3.678c2.158-4.19,0.512-9.336-3.678-11.494
                        l-55.023-28.348h93.798c23.552-0.028,42.638-19.114,42.667-42.667V42.67c-0.028-23.552-19.114-42.638-42.667-42.667H247.467
                        c-1.966,0.06-3.925,0.259-5.862,0.597c-1.638-0.622-3.43-0.708-5.12-0.247L6.084,68.62C2.47,69.702-0.004,73.03,0,76.803v281.6
                        c-0.018,3.25,1.812,6.227,4.719,7.68L294.852,511.15c0.102,0.051,0.222,0.068,0.333,0.119c0.111,0.051,0.316,0.111,0.478,0.171
                        c0.96,0.366,1.977,0.556,3.004,0.563h204.8c4.713,0,8.533-3.821,8.533-8.533S508.18,494.936,503.467,494.936z M130.27,374.975
                        l-2.56,0.427c-7.996-0.358-16.777-14.771-16.777-34.065c0-19.541,9.011-34.133,17.067-34.133s17.067,14.592,17.067,34.133
                        C145.067,359.052,137.66,372.585,130.27,374.975z M179.567,366.936c-4.062,0.734-8.149,1.357-12.237,1.98
                        c-2.987,0.452-5.973,0.913-8.951,1.408l-2.253,0.375c1.753-3.872,3.109-7.912,4.045-12.058l23.134,6.878
                        C182.145,366.194,180.882,366.673,179.567,366.936z M315.733,17.07h85.333v25.6h-85.333V17.07z M298.667,17.07v25.6
                        c0,9.426,7.641,17.067,17.067,17.067h85.333c9.426,0,17.067-7.641,17.067-17.067v-25.6h43.861
                        c-0.748,1.238-1.16,2.65-1.195,4.096v192.171c0,37.128-21.385,42.667-34.133,42.667H290.133
                        c-12.749,0-34.133-5.538-34.133-42.667V21.166c-0.035-1.446-0.447-2.858-1.195-4.096H298.667z M221.867,42.67
                        c0.052-11.016,7.146-20.764,17.613-24.201c-0.329,0.863-0.514,1.774-0.546,2.697v192.171c0,44.041,26.453,59.733,51.2,59.733
                        h136.533c24.747,0,51.2-15.693,51.2-59.733V21.166c-0.032-0.923-0.217-1.834-0.546-2.697
                        c10.466,3.437,17.56,13.184,17.613,24.201v298.667c0,14.138-11.461,25.6-25.6,25.6H247.467c-14.138,0-25.6-11.462-25.6-25.6
                        V42.67z M128,50.35l42.667-12.646v148.753L128,180.312V50.35z M17.067,83.177L76.8,65.479v103.748l-59.733-9.122V83.177z
                         M17.067,177.36l57.054,8.721c4.903,0.819,9.918-0.567,13.705-3.789c3.844-3.253,6.055-8.037,6.042-13.073v-108.8l17.067-5.06
                        v124.954c0.04,8.478,6.265,15.657,14.652,16.896l42.761,6.153c0.755,0.102,1.516,0.154,2.278,0.154
                        c9.426,0,17.067-7.641,17.067-17.067V32.609l20.258-5.973c-2.077,5.091-3.147,10.536-3.149,16.034v298.667
                        c0.057,4.58,0.861,9.119,2.381,13.44l-45.047-13.389v-0.051c0-28.706-14.993-51.2-34.133-51.2
                        c-14.763,0-27.025,13.406-31.881,32.7l-79.053-22.11V177.36z"/>
                      <path d="M285.867,349.87c16.495,0,29.867-13.372,29.867-29.867c0-16.495-13.372-29.867-29.867-29.867
                        c-16.495,0-29.867,13.372-29.867,29.867C256,336.498,269.372,349.87,285.867,349.87z M285.867,307.203
                        c7.069,0,12.8,5.731,12.8,12.8c0,7.069-5.731,12.8-12.8,12.8c-7.069,0-12.8-5.731-12.8-12.8
                        C273.067,312.934,278.798,307.203,285.867,307.203z"/>
                      <path d="M430.933,349.87c16.495,0,29.867-13.372,29.867-29.867c0-16.495-13.372-29.867-29.867-29.867
                        s-29.867,13.372-29.867,29.867C401.067,336.498,414.439,349.87,430.933,349.87z M430.933,307.203c7.069,0,12.8,5.731,12.8,12.8
                        c0,7.069-5.731,12.8-12.8,12.8c-7.069,0-12.8-5.731-12.8-12.8C418.133,312.934,423.864,307.203,430.933,307.203z"/>
                    </g>
                  </g>
                </g>
                </svg>
                    <span class="mx-3 whitespace-no-wrap">Vehicle</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'service' ? 'active':''}} || {{Request::segment ('4') == 'service' ? 'active':''}}">
                <a href="{{ url('admin/transport/service') }}" class="flex  items-center">
                    <!--  <img src="{{asset('uploads/icons/reminder_.svg')}}" class="w-5 h-5"> -->
                    <svg class="w-5 h-5 fill-current text-white" version="1.0" xmlns="http://www.w3.org/2000/svg"
 width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000"
 preserveAspectRatio="xMidYMid meet">

<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
fill="#fff" stroke="none">
<path d="M2370 5113 c-559 -53 -1006 -230 -1417 -562 -795 -640 -1130 -1684
-858 -2674 77 -284 211 -563 385 -808 l69 -96 -25 -50 c-78 -158 -45 -351 81
-478 231 -230 620 -122 701 195 81 319 -228 602 -541 496 -79 -27 -63 -36
-144 79 -204 292 -339 637 -398 1015 -25 159 -24 509 1 670 162 1042 953 1831
2001 1997 153 24 517 24 665 0 202 -34 185 -34 225 6 50 50 43 122 -15 152
-84 44 -521 79 -730 58z m-1354 -4189 c61 -37 104 -113 104 -184 0 -141 -141
-247 -280 -210 -61 16 -134 89 -150 150 -39 145 75 288 222 278 40 -3 70 -13
104 -34z"/>
<path d="M3431 4926 c-56 -31 -66 -99 -22 -148 24 -27 36 -33 71 -33 35 0 47
6 72 34 26 29 30 39 25 75 -10 72 -81 108 -146 72z"/>
<path d="M4110 4785 c-193 -55 -323 -237 -308 -432 22 -278 291 -458 553 -369
80 28 62 40 159 -104 200 -297 326 -624 383 -990 24 -161 24 -502 0 -660 -121
-782 -590 -1432 -1287 -1781 -446 -224 -953 -298 -1456 -213 -84 14 -95 14
-123 0 -38 -20 -51 -44 -51 -94 0 -32 6 -45 29 -65 16 -13 45 -27 63 -31 319
-59 647 -59 963 -1 595 110 1143 441 1527 920 712 891 744 2152 77 3087 l-69
97 20 33 c10 18 27 62 36 98 52 202 -62 417 -259 492 -69 27 -186 32 -257 13z
m175 -196 c79 -22 155 -124 155 -209 0 -122 -113 -228 -234 -218 -111 9 -195
93 -204 204 -4 44 1 64 22 108 49 100 151 145 261 115z"/>
<path d="M2193 4360 c-39 -23 -42 -36 -46 -168 l-2 -103 -93 -31 c-51 -17
-136 -52 -188 -77 l-94 -47 -72 73 c-78 79 -113 99 -155 88 -39 -9 -499 -468
-513 -511 -16 -47 5 -86 87 -167 l69 -68 -47 -97 c-26 -53 -61 -137 -78 -187
l-30 -90 -120 -5 c-180 -7 -165 27 -169 -392 -2 -239 1 -350 9 -370 19 -47 47
-57 169 -60 l112 -3 32 -96 c18 -53 53 -137 78 -187 l45 -90 -73 -73 c-80 -79
-100 -114 -89 -156 9 -39 468 -499 511 -513 47 -16 86 5 168 88 l69 70 81 -41
c45 -22 128 -57 186 -78 l105 -37 2 -103 c4 -133 7 -146 46 -169 30 -19 52
-20 367 -20 432 0 408 -11 413 189 l2 103 106 37 c58 21 142 56 186 78 l81 41
68 -70 c82 -83 121 -104 168 -88 43 14 502 474 511 513 11 42 -9 77 -89 156
l-73 73 45 90 c25 50 60 134 78 187 l32 96 112 3 c122 3 150 13 169 60 8 20
11 131 9 370 -4 419 11 385 -169 392 l-120 5 -30 90 c-17 50 -52 134 -78 187
l-47 97 69 68 c82 81 103 120 87 167 -14 43 -474 502 -513 511 -42 11 -77 -9
-155 -88 l-72 -73 -94 47 c-52 25 -137 60 -188 77 l-93 31 -2 103 c-4 132 -7
145 -46 168 -30 19 -52 20 -367 20 -315 0 -337 -1 -367 -20z m579 -285 c3 -97
5 -106 29 -130 17 -18 52 -33 103 -46 125 -32 305 -109 391 -168 17 -12 46
-21 69 -21 34 0 46 8 110 70 40 39 77 70 82 70 5 0 74 -65 153 -144 l145 -145
-72 -75 c-93 -98 -94 -117 -22 -243 56 -98 97 -197 135 -330 37 -128 49 -137
180 -141 l105 -4 0 -209 0 -209 -95 0 c-148 0 -149 -1 -205 -190 -30 -102 -72
-200 -126 -292 -64 -112 -62 -132 26 -222 39 -40 70 -77 70 -82 0 -5 -65 -74
-144 -153 l-145 -145 -74 71 c-88 83 -113 92 -177 59 -25 -13 -85 -44 -135
-70 -49 -26 -135 -60 -190 -77 -178 -55 -186 -58 -201 -95 -8 -20 -14 -69 -14
-124 l0 -90 -210 0 -210 0 0 90 c0 55 -6 104 -14 124 -15 37 -18 38 -204 96
-57 18 -142 53 -190 78 -48 24 -107 55 -132 68 -64 33 -89 24 -177 -59 l-74
-71 -145 145 c-79 79 -144 148 -144 153 0 5 31 42 70 82 88 90 90 110 26 222
-54 92 -96 190 -126 292 -56 189 -57 190 -205 190 l-95 0 0 209 0 209 105 4
c131 4 143 13 180 141 38 133 79 232 135 330 72 125 70 143 -22 242 l-71 76
144 145 c79 79 148 144 153 144 5 0 42 -31 82 -70 64 -62 76 -70 110 -70 23 0
52 9 69 21 86 58 290 143 431 179 22 5 51 21 65 36 22 23 24 36 27 130 l4 104
208 0 208 0 4 -105z"/>
<path d="M2451 3380 c-179 -25 -339 -106 -472 -239 -99 -99 -159 -194 -200
-316 -192 -572 275 -1153 873 -1085 450 51 779 462 728 909 -39 341 -285 627
-616 711 -87 23 -228 31 -313 20z m259 -212 c93 -21 211 -89 286 -163 127
-125 186 -267 186 -445 0 -175 -59 -319 -181 -441 -122 -122 -266 -181 -441
-181 -178 0 -320 59 -445 186 -77 78 -142 194 -166 296 -16 71 -16 209 0 280
24 102 89 218 166 296 159 161 374 223 595 172z"/>
<path d="M1602 365 c-38 -17 -66 -71 -56 -110 19 -75 110 -100 165 -46 52 53
33 135 -38 162 -30 11 -31 11 -71 -6z"/>
</g>
</svg>
                    <span class="mx-3 whitespace-no-wrap">Service</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'studentroute' ? 'active':''}} || {{Request::segment ('4') == 'studentroute' ? 'active':''}}">
                <a href="{{ url('admin/transport/studentroute/create') }}" class="flex  items-center">
                  <svg class="w-5 h-5 fill-current text-white" version="1.0" xmlns="http://www.w3.org/2000/svg"
 width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000"
 preserveAspectRatio="xMidYMid meet">

<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
fill="#fff" stroke="none">
<path d="M2451 4899 c-125 -16 -297 -84 -391 -153 -169 -127 -294 -322 -335
-525 -21 -101 -16 -293 9 -386 24 -91 108 -252 169 -326 294 -354 820 -410
1185 -124 134 104 244 270 292 435 31 107 38 289 15 401 -73 362 -366 632
-737 679 -92 11 -115 11 -207 -1z m214 -434 c313 -81 425 -466 204 -700 -87
-92 -185 -135 -309 -135 -260 0 -465 240 -420 491 45 250 284 406 525 344z"/>
<path d="M640 2241 l0 -1169 98 -6 c389 -24 705 -95 1022 -232 264 -114 578
-316 757 -487 l41 -39 74 64 c396 345 883 574 1399 658 100 16 349 39 432 40
16 0 17 62 17 1170 l0 1170 -93 0 c-192 0 -490 -48 -713 -115 -381 -115 -714
-298 -1026 -563 l-87 -74 -88 74 c-315 266 -647 448 -1027 563 -223 67 -521
115 -713 115 l-93 0 0 -1169z m565 679 c285 -65 602 -214 857 -402 94 -69 164
-130 358 -312 74 -69 137 -126 141 -126 3 0 82 71 176 158 256 238 362 320
553 430 200 114 462 216 668 260 l92 20 0 -742 0 -742 -79 -11 c-417 -61 -893
-245 -1263 -489 -79 -52 -148 -92 -153 -90 -6 2 -73 45 -150 95 -246 162 -577
315 -855 396 -115 33 -374 90 -445 97 l-30 3 -3 743 -2 742 22 -5 c13 -2 64
-14 113 -25z"/>
</g>
</svg>
                    <span class="mx-3 whitespace-no-wrap">Route Student</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'driverlist' ? 'active':''}} || {{Request::segment ('4') == 'driverlist' ? 'active':''}}">
                <a href="{{ url('admin/transport/driverlist') }}" class="flex  items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.0" xmlns="http://www.w3.org/2000/svg"
 width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000"
 preserveAspectRatio="xMidYMid meet">

<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
fill="#fff" stroke="none">
<path d="M2392 5106 c-213 -41 -383 -128 -528 -271 -269 -266 -360 -661 -268
-1165 43 -239 58 -302 86 -385 59 -174 145 -319 257 -438 l71 -75 -36 -86
c-30 -72 -40 -87 -63 -92 -71 -16 -216 -59 -301 -91 -355 -133 -623 -343 -736
-578 l-34 -69 0 -483 0 -483 27 -30 c37 -40 79 -51 129 -34 44 15 60 33 74 84
6 20 10 215 10 470 l0 435 36 55 c106 163 332 321 592 414 l73 26 366 -275
c358 -269 367 -275 413 -275 46 0 55 6 413 275 l366 275 73 -26 c265 -96 485
-249 592 -414 l36 -55 0 -436 c0 -240 3 -450 6 -466 8 -43 35 -72 79 -87 49
-17 91 -6 128 34 l27 30 0 483 0 483 -34 69 c-138 287 -502 530 -978 655 l-87
23 -36 85 -35 84 71 75 c154 162 260 381 308 636 65 343 75 431 68 606 -9 244
-68 436 -187 611 -127 187 -330 327 -559 387 -120 31 -310 39 -419 19z m358
-251 c85 -21 211 -83 282 -140 127 -100 240 -295 264 -451 l7 -47 -31 22 c-86
61 -241 114 -417 143 -124 20 -536 17 -653 -5 -126 -23 -241 -63 -315 -108
-34 -20 -63 -33 -65 -28 -7 17 30 137 64 208 107 228 290 370 537 417 86 16
233 11 327 -11z m144 -725 c118 -25 227 -73 284 -125 51 -45 103 -148 110
-214 2 -26 -3 -95 -13 -152 -69 -427 -246 -695 -531 -801 -86 -33 -282 -33
-368 0 -285 106 -462 374 -531 801 -20 123 -16 191 18 264 64 137 206 217 438
247 129 16 479 4 593 -20z m-582 -1522 c90 -32 99 -33 248 -33 148 0 160 2
250 32 52 18 95 31 96 30 1 -1 20 -47 43 -102 23 -55 53 -111 66 -125 l24 -26
-232 -174 c-127 -96 -239 -174 -247 -174 -8 0 -119 78 -247 174 l-232 174 27
30 c15 17 45 75 66 129 22 53 41 97 42 97 2 0 45 -15 96 -32z"/>
<path d="M2311 1519 c-382 -40 -748 -202 -916 -406 -94 -114 -134 -219 -135
-348 0 -355 388 -650 973 -742 155 -24 499 -24 652 0 589 92 975 387 975 742
-1 89 -13 144 -52 222 -135 275 -534 484 -1017 533 -120 12 -359 11 -480 -1z
m129 -327 l0 -97 -52 -13 c-186 -44 -319 -190 -306 -334 l5 -50 -61 -27 c-33
-15 -135 -59 -225 -96 l-164 -69 -39 44 c-65 73 -90 123 -96 195 -6 79 12 133
70 206 96 122 318 238 563 295 60 13 232 39 288 43 15 1 17 -10 17 -97z m375
83 c160 -19 352 -74 480 -137 158 -79 250 -160 302 -265 22 -47 25 -63 21
-123 -6 -76 -29 -124 -96 -200 l-39 -44 -224 95 -224 94 3 52 c10 149 -120
291 -305 335 l-53 13 0 98 0 98 43 -5 c23 -3 65 -8 92 -11z m-114 -435 c54
-20 99 -55 99 -76 0 -21 -59 -63 -112 -79 -65 -19 -190 -19 -252 -1 -52 16
-116 60 -116 80 0 21 44 56 96 76 69 27 215 27 285 0z m-401 -360 c73 -37 165
-52 290 -48 111 5 146 13 255 58 28 11 42 7 190 -55 88 -37 164 -71 168 -75
10 -9 -83 -41 -203 -70 -115 -28 -313 -50 -440 -50 -199 0 -469 44 -608 99
-40 16 -44 20 -27 27 11 4 85 36 165 71 80 34 151 63 158 63 7 0 31 -9 52 -20z"/>
</g>
</svg>
                    <span class="mx-3 whitespace-no-wrap">Driver List</span>
                </a>
            </li>

            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'studentsattendance' ? 'active':''}} || {{Request::segment ('4') == 'studentsattendance' ? 'active':''}}">
                <a href="{{ url('admin/transport/studentsattendance/list') }}" class="flex  items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.0" xmlns="http://www.w3.org/2000/svg"
 width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000"
 preserveAspectRatio="xMidYMid meet">

<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
fill="#fff" stroke="none">
<path d="M1766 4470 c-111 -18 -211 -50 -321 -105 -296 -147 -500 -413 -571
-741 -20 -95 -23 -301 -5 -394 55 -294 223 -547 468 -707 106 -69 190 -107
311 -141 88 -24 113 -27 272 -27 151 0 186 3 260 23 309 84 558 286 694 565
204 415 122 903 -206 1228 -134 133 -302 228 -486 275 -109 28 -313 40 -416
24z m304 -436 c175 -41 340 -172 419 -334 69 -141 86 -268 55 -418 -47 -233
-230 -425 -465 -488 -83 -22 -234 -23 -316 -1 -331 87 -538 419 -468 752 48
231 244 434 470 489 80 19 224 19 305 0z"/>
<path d="M4400 3184 c-22 -9 -174 -154 -402 -382 l-368 -367 -153 152 c-91 91
-167 158 -190 168 -135 56 -285 -32 -295 -174 -8 -105 -2 -113 257 -374 245
-247 296 -287 369 -287 95 0 88 -6 575 479 301 301 464 470 477 497 83 170
-97 362 -270 288z"/>
<path d="M1640 2115 c-676 -93 -1179 -503 -1207 -986 -4 -63 -2 -108 7 -132
52 -159 271 -192 370 -56 16 23 32 55 34 73 3 17 9 62 15 101 40 269 360 498
801 572 127 21 393 21 520 0 277 -47 508 -153 655 -302 88 -89 133 -173 146
-276 15 -107 26 -144 56 -179 89 -106 256 -97 338 18 29 43 30 47 30 155 0 89
-5 128 -24 187 -133 428 -591 746 -1189 825 -137 18 -419 18 -552 0z"/>
</g>
</svg>

                    <span class="mx-3 whitespace-no-wrap"> Attendance List</span>
                </a>
            </li>
        </ul>
    </li> 
    <!-- end -->
    @endif

</ul>