{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.admin.layout')

@section('content')
    <div class="">
        <div>
            <h1 class="admin-h1 my-3 flex items-center">
                <a href="{{ url('/admin/events') }}" class="rounded-full bg-gray-300 p-2" title="Back">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 492 492" xml:space="preserve" width="512px" height="512px" class="w-3 h-3 fill-current text-gray-700"><g><g><g><path d="M464.344,207.418l0.768,0.168H135.888l103.496-103.724c5.068-5.064,7.848-11.924,7.848-19.124    c0-7.2-2.78-14.012-7.848-19.088L223.28,49.538c-5.064-5.064-11.812-7.864-19.008-7.864c-7.2,0-13.952,2.78-19.016,7.844 L7.844,226.914C2.76,231.998-0.02,238.77,0,245.974c-0.02,7.244,2.76,14.02,7.844,19.096l177.412,177.412 c5.064,5.06,11.812,7.844,19.016,7.844c7.196,0,13.944-2.788,19.008-7.844l16.104-16.112c5.068-5.056,7.848-11.808,7.848-19.008 c0-7.196-2.78-13.592-7.848-18.652L134.72,284.406h329.992c14.828,0,27.288-12.78,27.288-27.6v-22.788    C492,219.198,479.172,207.418,464.344,207.418z" data-original="#000000" fill="" class="active-path"></path></g></g></g></svg>
                </a>
                <span class="mx-3">Event Details</span>
            </h1>
        </div>
        <div class="flex flex-col lg:flex-row md:flex-row">
            <div class="w-full lg:w-1/6 md:w-1/5 py-3">
                <div>
                    <img src="{{ $event->ImagePath }}" class="h-40">
                </div>
            </div>

            <input type="hidden" name="event_id" value="{{ $event->id }}" id="event_id">

            
            <div class="w-full lg:w-4/5 md:w-4/5 lg:mx-6 md:mx-6 relative">
                <div>
                    <h3 class="font-semibold text-3xl text-gray-700">{{ $event->title }}</h3>
                    <div class="">
                        <div class="flex items-start mt-5">
                            <div class="py-1">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 405.092 405.092" style="enable-background:new 0 0 405.092 405.092;" xml:space="preserve" width="512px" height="512px" class="w-4 h-4"><g><g><path d="M114.139,180.059h37.557c9.825,0,17.819,6.165,17.819,13.743s-7.994,13.743-17.819,13.743h-34.057 c-1.408,0-2.15,0.635-2.525,1.168c-0.802,1.139-0.527,2.613-0.156,3.648c13.218,36.858,48.417,61.623,87.587,61.623 c39.656,0,74.998-25.171,87.944-62.636l0.042-0.114c0.177-0.482,0.591-1.609-0.107-2.61c-0.753-1.08-2.157-1.08-2.618-1.08h-34.411 c-9.825,0-17.819-6.165-17.819-13.743s7.994-13.743,17.819-13.743h38.911l0.221-0.017c1.054-0.157,3.049-1.177,3.049-3.914v-17.25 c0-2.29-1.89-3.333-3.686-3.333h-0.001h-38.493c-9.825,0-17.819-6.165-17.819-13.743s7.994-13.743,17.819-13.743h37.285 c0.054,0.002,0.14,0.005,0.252,0.005c2.821,0,4.643-1.528,4.643-3.894v-16.875c0-2.443-2.121-3.656-4.163-3.75h-38.018 c-9.825,0-17.819-6.165-17.819-13.743s7.994-13.743,17.819-13.743h34.661c1.802,0,2.831-0.862,3.376-1.584 c1.785-2.365,0.806-6.237,0.591-6.99C280.702,27.751,243.907,0,202.546,0c-42.987,0-80.144,29.12-90.36,70.814 c-0.25,1.022-0.19,2.535,0.733,3.711c0.549,0.7,1.611,1.534,3.554,1.534h35.224c9.825,0,17.819,6.165,17.819,13.743 s-7.994,13.743-17.819,13.743l-38.3-0.001c-1.869,0-3.881,1.096-3.881,3.501v17.514c0,2.406,1.915,3.502,3.693,3.502l38.487-0.002 c9.825,0,17.819,6.165,17.819,13.743s-7.994,13.743-17.819,13.743l-37.428,0c-1.91,0.048-4.752,1.331-4.752,4.666v15.751 C109.516,178.954,112.277,180.051,114.139,180.059z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#718096"/><path d="M327.484,145.762c-6.903,0-12.5,5.597-12.5,12.5v26.159c0,61.999-50.439,112.438-112.438,112.438 S90.108,246.42,90.108,184.421v-26.159c0-6.903-5.597-12.5-12.5-12.5c-6.904,0-12.5,5.597-12.5,12.5v26.159 c0,71.57,54.991,130.527,124.938,136.864v58.807h-53.492c-6.904,0-12.5,5.597-12.5,12.5s5.596,12.5,12.5,12.5h132.124 c6.903,0,12.5-5.597,12.5-12.5s-5.597-12.5-12.5-12.5h-53.631v-58.807c69.947-6.337,124.938-65.294,124.938-136.864v-26.159 C339.984,151.359,334.388,145.762,327.484,145.762z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#718096"/></g></g></svg>
                            </div>
                            <div class="text-sm mx-2 flex items-center">
                                <div class="w-24">
                                    <p class="text-gray-700 font-semibold">Organised By:</p>
                                </div>
                                <div class="text-sm tracking-wider">
                                    <p class="text-gray-600">{{ $event->organised_by }}</p>
                                </div>
                            </div>
                        </div>

                        @if($event->select_type=='class')
                            <div class="flex items-start mt-5">
                                <div class="py-1">                                    
                                    <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 511.998 511.998" style="enable-background:new 0 0 511.998 511.998; filter: brightness(0);" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M386.872,397.626c-2.031-5.158-7.859-7.698-13.02-5.663l-70.492,27.755c-5.159,2.031-7.695,7.86-5.663,13.02 c1.556,3.951,5.339,6.364,9.344,6.364c1.223,0,2.468-0.226,3.675-0.701l70.492-27.755    C386.368,408.615,388.904,402.786,386.872,397.626z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M402.433,381.438c-12.919,0-12.94,20.078,0,20.078C415.352,401.516,415.374,381.438,402.433,381.438z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M478.201,247.628c-0.138-0.66-0.34-1.295-0.6-1.9c0,0-0.001-0.002-0.001-0.003c-0.006-0.013-0.013-0.025-0.019-0.039 c-0.125-0.289-0.263-0.57-0.415-0.844c-0.064-0.117-0.139-0.228-0.208-0.341c-0.097-0.162-0.192-0.324-0.298-0.48 c-0.109-0.161-0.23-0.312-0.347-0.465c-0.077-0.099-0.151-0.203-0.232-0.3c-0.138-0.165-0.284-0.319-0.431-0.474 c-0.075-0.079-0.147-0.161-0.225-0.238c-0.149-0.147-0.304-0.282-0.46-0.419c-0.089-0.078-0.177-0.159-0.269-0.234 c-0.146-0.117-0.296-0.226-0.448-0.334c-0.115-0.083-0.229-0.17-0.347-0.248c-0.133-0.088-0.272-0.168-0.409-0.249 c-0.146-0.086-0.29-0.175-0.44-0.254c-0.12-0.063-0.246-0.118-0.368-0.178c-0.171-0.081-0.341-0.164-0.518-0.236 c-0.12-0.049-0.244-0.089-0.365-0.134c-0.181-0.065-0.36-0.133-0.546-0.189c-0.147-0.044-0.296-0.077-0.445-0.114 c-0.162-0.04-0.321-0.084-0.486-0.117c-0.221-0.044-0.444-0.073-0.668-0.102c-0.095-0.012-0.19-0.031-0.286-0.04 c-1.046-0.105-2.117-0.043-3.177,0.195c-0.616,0.137-1.213,0.326-1.781,0.571l-54.72,23.5 c-23.478-40.073-61.031-68.797-104.573-81.214c29.199-16.986,48.872-48.62,48.872-84.765C353.991,43.955,310.031,0,255.999,0 c-54.028,0-97.982,43.954-97.982,97.982c0,36.145,19.672,67.778,48.868,84.765c-43.537,12.416-81.091,41.139-104.576,81.212 l-54.722-23.498c-0.618-0.266-1.268-0.475-1.943-0.612c-0.673-0.139-1.35-0.204-2.021-0.204c-0.002,0-0.004,0-0.005,0 c-0.329,0-0.656,0.017-0.981,0.049c-0.122,0.012-0.241,0.035-0.362,0.051c-0.199,0.027-0.397,0.052-0.592,0.09 c-0.182,0.035-0.357,0.083-0.535,0.128c-0.133,0.034-0.266,0.063-0.397,0.102c-0.197,0.058-0.388,0.13-0.579,0.2 c-0.111,0.041-0.224,0.077-0.334,0.122c-0.184,0.075-0.361,0.161-0.54,0.246c-0.116,0.055-0.234,0.107-0.348,0.168 c-0.156,0.082-0.305,0.173-0.455,0.262c-0.133,0.079-0.266,0.156-0.396,0.24c-0.122,0.08-0.238,0.168-0.356,0.254 c-0.149,0.107-0.297,0.214-0.441,0.329c-0.093,0.076-0.182,0.158-0.272,0.237c-0.156,0.135-0.31,0.27-0.458,0.416 c-0.078,0.077-0.151,0.16-0.226,0.24c-0.147,0.155-0.292,0.308-0.43,0.472c-0.081,0.097-0.155,0.2-0.232,0.3 c-0.118,0.154-0.238,0.304-0.348,0.465c-0.106,0.155-0.201,0.318-0.298,0.479c-0.069,0.115-0.143,0.224-0.208,0.342 c-0.152,0.274-0.288,0.555-0.415,0.844c-0.006,0.013-0.013,0.025-0.019,0.039c0,0.001-0.001,0.002-0.001,0.002 c-0.26,0.606-0.463,1.242-0.6,1.901c-0.144,0.685-0.213,1.373-0.213,2.057V410.75c0,4.014,2.39,7.641,6.078,9.224l212.378,91.206 c0.348,0.15,0.702,0.274,1.056,0.383c0.059,0.018,0.12,0.029,0.179,0.046c0.377,0.107,0.756,0.189,1.136,0.25 c0.09,0.014,0.181,0.029,0.271,0.041c0.439,0.058,0.877,0.098,1.315,0.098c0.039,0,0.077-0.008,0.117-0.009 c0.385-0.004,0.77-0.035,1.153-0.084c0.128-0.016,0.254-0.036,0.38-0.058c0.344-0.057,0.686-0.132,1.024-0.226 c0.078-0.022,0.158-0.037,0.236-0.061c0.356-0.107,0.709-0.232,1.055-0.38l212.378-91.206c3.687-1.583,6.078-5.21,6.078-9.224    V249.685C478.415,249.001,478.346,248.313,478.201,247.628z M178.093,97.983c0-42.956,34.947-77.904,77.904-77.904 c42.962,0,77.914,34.948,77.914,77.904c0,42.963-34.951,77.914-77.914,77.914C213.04,175.897,178.093,140.946,178.093,97.983z M245.957,486.722l-192.3-82.583V264.92h0.001l48.648,20.89c0.134,0.064,0.27,0.126,0.407,0.186l143.245,61.51V486.722z M255.996,329.964l-135.104-58.013c28.622-47.125,79.447-75.975,135.105-75.975c55.666,0,106.49,28.848,135.103,75.969 L255.996,329.964z M458.336,404.138l-192.3,82.583V347.504l192.3-82.583V404.138z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
                                </div>
                                <div class="text-sm mx-2 flex items-center">
                                    <div class="w-24">
                                        <p class="text-gray-700 font-semibold">Standard:</p>
                                    </div>
                                    <div class="text-sm tracking-wider">
                                        <p class="text-gray-600">{{ $event->standardlink->StandardSection }}</p>
                                    </div>
                                </div>
                            </div>
                        @elseif($event->select_type=='alumni')
                            <div class="flex items-start mt-5">
                                <div class="py-1">
                                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 511.998 511.998" style="enable-background:new 0 0 511.998 511.998; filter: brightness(0);" xml:space="preserve" width="512px" height="512px"><g><g><g><path d="M386.872,397.626c-2.031-5.158-7.859-7.698-13.02-5.663l-70.492,27.755c-5.159,2.031-7.695,7.86-5.663,13.02 c1.556,3.951,5.339,6.364,9.344,6.364c1.223,0,2.468-0.226,3.675-0.701l70.492-27.755    C386.368,408.615,388.904,402.786,386.872,397.626z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M402.433,381.438c-12.919,0-12.94,20.078,0,20.078C415.352,401.516,415.374,381.438,402.433,381.438z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g><g><g><path d="M478.201,247.628c-0.138-0.66-0.34-1.295-0.6-1.9c0,0-0.001-0.002-0.001-0.003c-0.006-0.013-0.013-0.025-0.019-0.039 c-0.125-0.289-0.263-0.57-0.415-0.844c-0.064-0.117-0.139-0.228-0.208-0.341c-0.097-0.162-0.192-0.324-0.298-0.48 c-0.109-0.161-0.23-0.312-0.347-0.465c-0.077-0.099-0.151-0.203-0.232-0.3c-0.138-0.165-0.284-0.319-0.431-0.474 c-0.075-0.079-0.147-0.161-0.225-0.238c-0.149-0.147-0.304-0.282-0.46-0.419c-0.089-0.078-0.177-0.159-0.269-0.234 c-0.146-0.117-0.296-0.226-0.448-0.334c-0.115-0.083-0.229-0.17-0.347-0.248c-0.133-0.088-0.272-0.168-0.409-0.249 c-0.146-0.086-0.29-0.175-0.44-0.254c-0.12-0.063-0.246-0.118-0.368-0.178c-0.171-0.081-0.341-0.164-0.518-0.236 c-0.12-0.049-0.244-0.089-0.365-0.134c-0.181-0.065-0.36-0.133-0.546-0.189c-0.147-0.044-0.296-0.077-0.445-0.114 c-0.162-0.04-0.321-0.084-0.486-0.117c-0.221-0.044-0.444-0.073-0.668-0.102c-0.095-0.012-0.19-0.031-0.286-0.04 c-1.046-0.105-2.117-0.043-3.177,0.195c-0.616,0.137-1.213,0.326-1.781,0.571l-54.72,23.5 c-23.478-40.073-61.031-68.797-104.573-81.214c29.199-16.986,48.872-48.62,48.872-84.765C353.991,43.955,310.031,0,255.999,0 c-54.028,0-97.982,43.954-97.982,97.982c0,36.145,19.672,67.778,48.868,84.765c-43.537,12.416-81.091,41.139-104.576,81.212 l-54.722-23.498c-0.618-0.266-1.268-0.475-1.943-0.612c-0.673-0.139-1.35-0.204-2.021-0.204c-0.002,0-0.004,0-0.005,0 c-0.329,0-0.656,0.017-0.981,0.049c-0.122,0.012-0.241,0.035-0.362,0.051c-0.199,0.027-0.397,0.052-0.592,0.09 c-0.182,0.035-0.357,0.083-0.535,0.128c-0.133,0.034-0.266,0.063-0.397,0.102c-0.197,0.058-0.388,0.13-0.579,0.2 c-0.111,0.041-0.224,0.077-0.334,0.122c-0.184,0.075-0.361,0.161-0.54,0.246c-0.116,0.055-0.234,0.107-0.348,0.168 c-0.156,0.082-0.305,0.173-0.455,0.262c-0.133,0.079-0.266,0.156-0.396,0.24c-0.122,0.08-0.238,0.168-0.356,0.254 c-0.149,0.107-0.297,0.214-0.441,0.329c-0.093,0.076-0.182,0.158-0.272,0.237c-0.156,0.135-0.31,0.27-0.458,0.416 c-0.078,0.077-0.151,0.16-0.226,0.24c-0.147,0.155-0.292,0.308-0.43,0.472c-0.081,0.097-0.155,0.2-0.232,0.3 c-0.118,0.154-0.238,0.304-0.348,0.465c-0.106,0.155-0.201,0.318-0.298,0.479c-0.069,0.115-0.143,0.224-0.208,0.342 c-0.152,0.274-0.288,0.555-0.415,0.844c-0.006,0.013-0.013,0.025-0.019,0.039c0,0.001-0.001,0.002-0.001,0.002 c-0.26,0.606-0.463,1.242-0.6,1.901c-0.144,0.685-0.213,1.373-0.213,2.057V410.75c0,4.014,2.39,7.641,6.078,9.224l212.378,91.206 c0.348,0.15,0.702,0.274,1.056,0.383c0.059,0.018,0.12,0.029,0.179,0.046c0.377,0.107,0.756,0.189,1.136,0.25 c0.09,0.014,0.181,0.029,0.271,0.041c0.439,0.058,0.877,0.098,1.315,0.098c0.039,0,0.077-0.008,0.117-0.009 c0.385-0.004,0.77-0.035,1.153-0.084c0.128-0.016,0.254-0.036,0.38-0.058c0.344-0.057,0.686-0.132,1.024-0.226 c0.078-0.022,0.158-0.037,0.236-0.061c0.356-0.107,0.709-0.232,1.055-0.38l212.378-91.206c3.687-1.583,6.078-5.21,6.078-9.224    V249.685C478.415,249.001,478.346,248.313,478.201,247.628z M178.093,97.983c0-42.956,34.947-77.904,77.904-77.904 c42.962,0,77.914,34.948,77.914,77.904c0,42.963-34.951,77.914-77.914,77.914C213.04,175.897,178.093,140.946,178.093,97.983z M245.957,486.722l-192.3-82.583V264.92h0.001l48.648,20.89c0.134,0.064,0.27,0.126,0.407,0.186l143.245,61.51V486.722z M255.996,329.964l-135.104-58.013c28.622-47.125,79.447-75.975,135.105-75.975c55.666,0,106.49,28.848,135.103,75.969 L255.996,329.964z M458.336,404.138l-192.3,82.583V347.504l192.3-82.583V404.138z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></svg>
                                </div>
                                <div class="text-sm mx-2 flex items-center">
                                    <div class="w-24">
                                        <p class="text-gray-700 font-semibold">Batch:</p>
                                    </div>
                                    <div class="text-sm tracking-wider">
                                        <p class="text-gray-600">{{ $event->batch }}</p>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="flex items-start mt-5">
                            <div class="py-1">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" width="512px" height="512px" viewBox="0 0 510 510" style="enable-background:new 0 0 510 510;" xml:space="preserve" class="w-4 h-4"><g><g><g id="access-time"><path d="M255,0C114.75,0,0,114.75,0,255s114.75,255,255,255s255-114.75,255-255S395.25,0,255,0z     M255,459c-112.2,0-204-91.8-204-204S142.8,51,255,51s204,91.8,204,204S367.2,459,255,459z" data-original="#000000" class="active-path" data-old_color="fill-opacity:0.9" fill="#4a5568"/><polygon points="267.75,127.5 229.5,127.5 229.5,280.5 362.1,362.1 382.5,328.95 267.75,260.1" data-original="#000000" class="active-path" data-old_color="fill-opacity:0.9" fill="#4a5568"/></g></g></g></svg>
                            </div>
                            <div class="text-sm mx-2 flex items-center">
                                <div class="w-20">
                                    <p class="text-gray-700 font-semibold">Start Date:</p>
                                    <p class="text-gray-700 font-semibold">End Date:</p>
                                </div>
                                <div class="text-sm tracking-wider">
                                    <p class="text-gray-600">{{ date('d-m-Y h:i A',strtotime($event->start_date))}}</p>
                                    <p class="text-gray-600">{{ date('d-m-Y h:i A',strtotime($event->end_date))}}</p>
                                </div>
                            </div>
                        </div>
                        <div class="flex items-start mt-5">
                            <div class="py-1">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px" class="w-4 h-4"><g><g><g><path d="M256,0C161.896,0,85.333,76.563,85.333,170.667c0,28.25,7.063,56.26,20.49,81.104L246.667,506.5 c1.875,3.396,5.448,5.5,9.333,5.5s7.458-2.104,9.333-5.5l140.896-254.813c13.375-24.76,20.438-52.771,20.438-81.021 C426.667,76.563,350.104,0,256,0z M256,256c-47.052,0-85.333-38.281-85.333-85.333c0-47.052,38.281-85.333,85.333-85.333    s85.333,38.281,85.333,85.333C341.333,217.719,303.052,256,256,256z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#718096"/></g></g></g></svg>
                            </div>
                            <div class="text-sm mx-2">
                                <p class="text-gray-600">{{ $event->location }}</p>
                            </div>
                        </div>
                    </div>
                </div>  
            </div>
        </div>

        @if($event->category!='exam')
            <div class="my-3 flex text-xs justify-end top-0 right-0">
                @if($event->end_date>$now)
                    <a href="#" onclick="editevent()" id="edit" title="Edit" class="text-white text-xs flex items-center blue-bg rounded px-2 py-1 ml-2 font-medium"><!-- <img src="{{url('uploads/icons/profile-edit.svg')}}" class="w-3 h-3"> --><span class="mx-1">Edit</span></a>
                @endif

                <a href="{{url('/admin/events/delete/'.$event->id)}}" title="Delete" class=" text-white text-xs flex items-center blue-bg rounded px-2 py-1 ml-2 font-medium"><!-- <img src="{{url('uploads/icons/p-delete.svg')}}" class="w-3 h-3"> --><span class="mx-1">Delete</span></a>
            </div>

            <div class="bg-white shadow my-5">
                <event-tab url="{{ url('/') }}" id="{{ $event->id }}" event_id="{{ $event->event_id }}" entity_id="{{ $event->id }}" entity_name="event" school_id="{{ $event->school_id }}"></event-tab>
                <portal-target name="events"></portal-target>
            </div>
        @endif
    </div>
    <edit-event url="{{ url('/') }}"></edit-event>
@endsection

@push('scripts')
    <script>
        function editevent()
        {
            $('#edit-event-modal').click();
        }
    </script>
@endpush