/*
 Highstock JS v8.2.2 (2020-10-22)

 All technical indicators for Highstock

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(w){b(w);b.Highcharts=w;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function w(b,g,l,k){b.hasOwnProperty(g)||(b[g]=k.apply(null,l))}b=b?b._modules:{};w(b,"Mixins/IndicatorRequired.js",[b["Core/Utilities.js"]],function(b){var g=b.error;return{isParentLoaded:function(b,
k,f,e,a){if(b)return e?e(b):!0;g(a||this.generateMessage(f,k));return!1},generateMessage:function(b,k){return'Error: "'+b+'" indicator type requires "'+k+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+b}}});w(b,"Stock/Indicators/SMAIndicator.js",[b["Core/Series/Series.js"],b["Core/Globals.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l,k){var f=b.seriesTypes,e=k.addEvent,a=k.error,d=k.extend,c=k.isArray,r=k.pick,p=k.splat,
q=g.Series,t=f.ohlc.prototype,n=l.generateMessage;e(g.Series,"init",function(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&d(this,{pointValKey:t.pointValKey,keys:t.keys,pointArrayMap:t.pointArrayMap,toYData:t.toYData})});e(q,"afterSetOptions",function(a){a=a.options;var c=a.dataGrouping;c&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")});b.seriesType("sma","line",{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:0,
period:14}},{processData:function(){var a=this.options.compareToMain,c=this.linkedParent;q.prototype.processData.apply(this,arguments);c&&c.compareValue&&a&&(this.compareValue=c.compareValue)},bindTo:{series:!0,eventName:"updatedData"},hasDerivedData:!0,useCommonDataGrouping:!0,nameComponents:["period"],nameSuffixes:[],calculateOn:"init",requiredIndicators:[],requireIndicators:function(){var a={allLoaded:!0};this.requiredIndicators.forEach(function(c){f[c]?f[c].prototype.requireIndicators():(a.allLoaded=
!1,a.needed=c)});return a},init:function(c,d){function u(){var a=f.points||[],c=(f.xData||[]).length,d=f.getValues(f.linkedParent,f.options.params)||{values:[],xData:[],yData:[]},e=[],u=!0;if(c&&!f.hasGroupedData&&f.visible&&f.points)if(f.cropped){if(f.xAxis){var r=f.xAxis.min;var m=f.xAxis.max}c=f.cropData(d.xData,d.yData,r,m);for(r=0;r<c.xData.length;r++)e.push([c.xData[r]].concat(p(c.yData[r])));c=d.xData.indexOf(f.xData[0]);r=d.xData.indexOf(f.xData[f.xData.length-1]);-1===c&&r===d.xData.length-
2&&e[0][0]===a[0].x&&e.shift();f.updateData(e)}else d.xData.length!==c-1&&d.xData.length!==c+1&&(u=!1,f.updateData(d.values));u&&(f.xData=d.xData,f.yData=d.yData,f.options.data=d.values);!1===f.bindTo.series&&(delete f.processedXData,f.isDirty=!0,f.redraw());f.isDirtyData=!1}var f=this,r=f.requireIndicators();if(!r.allLoaded)return a(n(f.type,r.needed));q.prototype.init.call(f,c,d);c.linkSeries();f.dataEventsToUnbind=[];if(!f.linkedParent)return a("Series "+f.options.linkedTo+" not found! Check `linkedTo`.",
!1,c);f.dataEventsToUnbind.push(e(f.bindTo.series?f.linkedParent:f.linkedParent.xAxis,f.bindTo.eventName,u));if("init"===f.calculateOn)u();else var m=e(f.chart,f.calculateOn,function(){u();m()});return f},getName:function(){var a=this.name,c=[];a||((this.nameComponents||[]).forEach(function(a,d){c.push(this.options.params[a]+r(this.nameSuffixes[d],""))},this),a=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+c.join(", ")+")":""));return a},getValues:function(a,d){var e=d.period,
f=a.xData;a=a.yData;var r=a.length,p=0,q=0,m=[],k=[],n=[],h=-1;if(!(f.length<e)){for(c(a[0])&&(h=d.index?d.index:0);p<e-1;)q+=0>h?a[p]:a[p][h],p++;for(d=p;d<r;d++){q+=0>h?a[d]:a[d][h];var t=[f[d],q/e];m.push(t);k.push(t[0]);n.push(t[1]);q-=0>h?a[d-p]:a[d-p][h]}return{values:m,xData:k,yData:n}}},destroy:function(){this.dataEventsToUnbind.forEach(function(a){a()});q.prototype.destroy.apply(this,arguments)}});""});w(b,"Stock/Indicators/ADIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],
function(b,g){var l=g.error;b.seriesType("ad","sma",{params:{volumeSeriesID:"volume"}},{nameComponents:!1,nameBase:"Accumulation/Distribution",getValues:function(k,f){var e=f.period,a=k.xData,d=k.yData,c=f.volumeSeriesID,r=k.chart.get(c);f=r&&r.yData;var p=d?d.length:0,q=[],t=[],n=[];if(!(a.length<=e&&p&&4!==d[0].length)){if(r){for(;e<p;e++){k=q.length;c=d[e][1];r=d[e][2];var h=d[e][3],m=f[e];c=[a[e],h===c&&h===r||c===r?0:(2*h-r-c)/(c-r)*m];0<k&&(c[1]+=q[k-1][1]);q.push(c);t.push(c[0]);n.push(c[1])}return{values:q,
xData:t,yData:n}}l("Series "+c+" not found! Check `volumeSeriesID`.",!0,k.chart)}}});""});w(b,"Stock/Indicators/AOIndicator.js",[b["Core/Series/Series.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.correctFloat,f=l.isArray;b.seriesType("ao","sma",{greaterBarColor:"#06B535",lowerBarColor:"#F21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}},{nameBase:"AO",nameComponents:!1,markerAttribs:g.noop,getColumnMetrics:g.seriesTypes.column.prototype.getColumnMetrics,
crispCol:g.seriesTypes.column.prototype.crispCol,translate:g.seriesTypes.column.prototype.translate,drawPoints:g.seriesTypes.column.prototype.drawPoints,drawGraph:function(){var e=this.options,a=this.points,d=e.greaterBarColor;e=e.lowerBarColor;var c=a[0];if(!this.userOptions.color&&c)for(c.color=d,c=1;c<a.length;c++)a[c].color=a[c].y>a[c-1].y?d:a[c].y<a[c-1].y?e:a[c-1].color},getValues:function(e){var a=e.xData||[];e=e.yData||[];var d=e.length,c=[],r=[],p=[],q=0,t=0,n;if(!(34>=a.length)&&f(e[0])&&
4===e[0].length){for(n=0;33>n;n++){var h=(e[n][1]+e[n][2])/2;29<=n&&(q=k(q+h));t=k(t+h)}for(n=33;n<d;n++){h=(e[n][1]+e[n][2])/2;q=k(q+h);t=k(t+h);h=q/5;var m=t/34;h=k(h-m);c.push([a[n],h]);r.push(a[n]);p.push(h);h=n+1-5;m=n+1-34;q=k(q-(e[h][1]+e[h][2])/2);t=k(t-(e[m][1]+e[m][2])/2)}return{values:c,xData:r,yData:p}}}});""});w(b,"Mixins/MultipleLines.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,g){var l=g.defined,k=g.error,f=g.merge,e=b.seriesTypes.sma;return{pointArrayMap:["top","bottom"],
pointValKey:"top",linesApiNames:["bottomLine"],getTranslatedLinesNames:function(a){var d=[];(this.pointArrayMap||[]).forEach(function(c){c!==a&&d.push("plot"+c.charAt(0).toUpperCase()+c.slice(1))});return d},toYData:function(a){var d=[];(this.pointArrayMap||[]).forEach(function(c){d.push(a[c])});return d},translate:function(){var a=this,d=a.pointArrayMap,c=[],f;c=a.getTranslatedLinesNames();e.prototype.translate.apply(a,arguments);a.points.forEach(function(e){d.forEach(function(d,r){f=e[d];null!==
f&&(e[c[r]]=a.yAxis.toPixels(f,!0))})})},drawGraph:function(){var a=this,d=a.linesApiNames,c=a.points,r=c.length,p=a.options,q=a.graph,t={options:{gapSize:p.gapSize}},n=[],h;a.getTranslatedLinesNames(a.pointValKey).forEach(function(a,d){for(n[d]=[];r--;)h=c[r],n[d].push({x:h.x,plotX:h.plotX,plotY:h[a],isNull:!l(h[a])});r=c.length});d.forEach(function(c,d){n[d]?(a.points=n[d],p[c]?a.options=f(p[c].styles,t):k('Error: "There is no '+c+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),
a.graph=a["graph"+c],e.prototype.drawGraph.call(a),a["graph"+c]=a.graph):k('Error: "'+c+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=c;a.options=p;a.graph=q;e.prototype.drawGraph.call(a)}}});w(b,"Stock/Indicators/AroonIndicator.js",[b["Core/Series/Series.js"],b["Mixins/MultipleLines.js"],b["Core/Utilities.js"]],function(b,g,l){function k(a,d){var c=a[0],e=0,f;for(f=1;f<a.length;f++)if("max"===d&&a[f]>=c||"min"===d&&a[f]<=c)c=
a[f],e=f;return e}var f=l.merge,e=l.pick;b.seriesType("aroon","sma",{params:{period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},f(g,{nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y",linesApiNames:["aroonDown"],getValues:function(a,d){d=d.period;var c=a.xData,
f=(a=a.yData)?a.length:0,p=[],q=[],t=[],n;for(n=d-1;n<f;n++){var h=a.slice(n-d+1,n+2);var m=k(h.map(function(a){return e(a[2],a)}),"min");h=k(h.map(function(a){return e(a[1],a)}),"max");h=h/d*100;m=m/d*100;c[n+1]&&(p.push([c[n+1],h,m]),q.push(c[n+1]),t.push([h,m]))}return{values:p,xData:q,yData:t}}}));""});w(b,"Stock/Indicators/AroonOscillatorIndicator.js",[b["Core/Series/Series.js"],b["Mixins/MultipleLines.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l,k){k=k.merge;
var f=b.seriesTypes.aroon;b.seriesType("aroonoscillator","aroon",{params:{period:25},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}},k(g,{nameBase:"Aroon Oscillator",pointArrayMap:["y"],pointValKey:"y",linesApiNames:[],init:function(){var e=arguments,a=this;l.isParentLoaded(f,"aroon",a.type,function(d){d.prototype.init.apply(a,e)})},getValues:function(e,a){var d=[],c=[],r=[];e=f.prototype.getValues.call(this,e,a);for(a=0;a<e.yData.length;a++){var p=
e.yData[a][0];var q=e.yData[a][1];p-=q;d.push([e.xData[a],p]);c.push(e.xData[a]);r.push(p)}return{values:d,xData:c,yData:r}}}));""});w(b,"Stock/Indicators/ATRIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){function l(f,e){return Math.max(f[1]-f[2],"undefined"===typeof e?0:Math.abs(f[1]-e[3]),"undefined"===typeof e?0:Math.abs(f[2]-e[3]))}var k=g.isArray;b.seriesType("atr","sma",{params:{period:14}},{getValues:function(f,e){e=e.period;var a=f.xData,d=(f=f.yData)?f.length:
0,c=1,r=0,p=0,q=[],t=[],n=[],h;var m=[[a[0],f[0]]];if(!(a.length<=e)&&k(f[0])&&4===f[0].length){for(h=1;h<=d;h++)if(m.push([a[h],f[h]]),e<c){var u=e;var v=a[h-1],b=l(f[h-1],f[h-2]);u=[v,(r*(u-1)+b)/u];r=u[1];q.push(u);t.push(u[0]);n.push(u[1])}else e===c?(r=p/(h-1),q.push([a[h-1],r]),t.push(a[h-1]),n.push(r)):p+=l(f[h-1],f[h-2]),c++;return{values:q,xData:t,yData:n}}}});""});w(b,"Stock/Indicators/BBIndicator.js",[b["Core/Series/Series.js"],b["Mixins/MultipleLines.js"],b["Core/Utilities.js"]],function(b,
g,l){var k=l.isArray,f=l.merge,e=b.seriesTypes.sma;b.seriesType("bb","sma",{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}},f(g,{pointArrayMap:["top","middle","bottom"],
pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],init:function(){e.prototype.init.apply(this,arguments);this.options=f({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(a,d){var c=d.period,f=d.standardDeviation,p=a.xData,q=(a=a.yData)?a.length:0,t=[],n=[],h=[],m;if(!(p.length<c)){var u=k(a[0]);for(m=c;m<=q;m++){var v=p.slice(m-c,m);var b=a.slice(m-c,m);var g=e.prototype.getValues.call(this,
{xData:v,yData:b},d);v=g.xData[0];g=g.yData[0];for(var l=0,y=b.length,z=0;z<y;z++){var x=(u?b[z][d.index]:b[z])-g;l+=x*x}x=Math.sqrt(l/(y-1));b=g+f*x;x=g-f*x;t.push([v,b,g,x]);n.push(v);h.push([b,g,x])}return{values:t,xData:n,yData:h}}}}));""});w(b,"Stock/Indicators/CCIIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){function l(f){return f.reduce(function(e,a){return e+a},0)}var k=g.isArray;b.seriesType("cci","sma",{params:{period:14}},{getValues:function(f,e){e=e.period;
var a=f.xData,d=(f=f.yData)?f.length:0,c=[],r=1,p=[],q=[],t=[];if(!(a.length<=e)&&k(f[0])&&4===f[0].length){for(;r<e;){var n=f[r-1];c.push((n[1]+n[2]+n[3])/3);r++}for(r=e;r<=d;r++){n=f[r-1];n=(n[1]+n[2]+n[3])/3;var h=c.push(n);var m=c.slice(h-e);h=l(m)/e;var u,v=m.length,b=0;for(u=0;u<v;u++)b+=Math.abs(h-m[u]);m=b/e;n=(n-h)/(.015*m);p.push([a[r-1],n]);q.push(a[r-1]);t.push(n)}return{values:p,xData:q,yData:t}}}});""});w(b,"Stock/Indicators/CMFIndicator.js",[b["Core/Series/Series.js"]],function(b){b.seriesType("cmf",
"sma",{params:{period:14,volumeSeriesID:"volume"}},{nameBase:"Chaikin Money Flow",isValid:function(){var b=this.chart,l=this.options,k=this.linkedParent;b=this.volumeSeries||(this.volumeSeries=b.get(l.params.volumeSeriesID));var f=k&&k.yData&&4===k.yData[0].length;return!!(k&&b&&k.xData&&k.xData.length>=l.params.period&&b.xData&&b.xData.length>=l.params.period&&f)},getValues:function(b,l){if(this.isValid())return this.getMoneyFlow(b.xData,b.yData,this.volumeSeries.yData,l.period)},getMoneyFlow:function(b,
l,k,f){function e(a,c){var d=a[1],e=a[2];a=a[3];return null!==c&&null!==d&&null!==e&&null!==a&&d!==e?(a-e-(d-a))/(d-e)*c:(h=n,null)}var a=l.length,d=[],c=0,r=0,p=[],q=[],t=[],n,h=-1;if(0<f&&f<=a){for(n=0;n<f;n++)d[n]=e(l[n],k[n]),c+=k[n],r+=d[n];p.push(b[n-1]);q.push(n-h>=f&&0!==c?r/c:null);for(t.push([p[0],q[0]]);n<a;n++){d[n]=e(l[n],k[n]);c-=k[n-f];c+=k[n];r-=d[n-f];r+=d[n];var m=[b[n],n-h>=f?r/c:null];p.push(m[0]);q.push(m[1]);t.push([m[0],m[1]])}}return{values:t,xData:p,yData:q}}});""});w(b,"Stock/Indicators/DPOIndicator.js",
[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){function l(e,a,d,c,r){a=f(a[d][c],a[d]);return r?k(e-a):k(e+a)}var k=g.correctFloat,f=g.pick;b.seriesType("dpo","sma",{params:{period:21}},{nameBase:"DPO",getValues:function(e,a){var d=a.period;a=a.index;var c=d+Math.floor(d/2+1),r=e.xData||[];e=e.yData||[];var p=e.length,q=[],k=[],b=[],h=0,m,u;if(!(r.length<=c)){for(m=0;m<d-1;m++)h=l(h,e,m,a);for(u=0;u<=p-c;u++){var v=u+d-1;m=u+c-1;h=l(h,e,v,a);v=f(e[m][a],e[m]);v-=h/d;h=l(h,e,u,a,
!0);q.push([r[m],v]);k.push(r[m]);b.push(v)}return{values:q,xData:k,yData:b}}}});""});w(b,"Stock/Indicators/EMAIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){var l=g.correctFloat,k=g.isArray;b.seriesType("ema","sma",{params:{index:3,period:9}},{accumulatePeriodPoints:function(f,e,a){for(var d=0,c=0,r;c<f;)r=0>e?a[c]:a[c][e],d+=r,c++;return d},calculateEma:function(f,e,a,d,c,r,p){f=f[a-1];e=0>r?e[a-1]:e[a-1][r];d="undefined"===typeof c?p:l(e*d+c*(1-d));return[f,d]},
getValues:function(f,e){var a=e.period,d=f.xData,c=(f=f.yData)?f.length:0,r=2/(a+1),p=[],q=[],b=[],n=-1;if(!(c<a)){k(f[0])&&(n=e.index?e.index:0);e=this.accumulatePeriodPoints(a,n,f);for(e/=a;a<c+1;a++){var h=this.calculateEma(d,f,a,r,h,n,e);p.push(h);q.push(h[0]);b.push(h[1]);h=h[1]}return{values:p,xData:q,yData:b}}}});""});w(b,"Stock/Indicators/ChaikinIndicator.js",[b["Core/Series/Series.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l){var k=b.seriesTypes,f=l.correctFloat,
e=l.error,a=k.ema,d=k.ad;b.seriesType("chaikin","ema",{params:{volumeSeriesID:"volume",periods:[3,10]}},{nameBase:"Chaikin Osc",nameComponents:["periods"],init:function(){var c=arguments,d=this;g.isParentLoaded(a,"ema",d.type,function(a){a.prototype.init.apply(d,c)})},getValues:function(c,r){var p=r.periods,q=r.period,b=[],k=[],h=[],m;if(2!==p.length||p[1]<=p[0])e('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');else if(r=d.prototype.getValues.call(this,
c,{volumeSeriesID:r.volumeSeriesID,period:q}))if(c=a.prototype.getValues.call(this,r,{period:p[0]}),r=a.prototype.getValues.call(this,r,{period:p[1]}),c&&r){p=p[1]-p[0];for(m=0;m<r.yData.length;m++)q=f(c.yData[m+p]-r.yData[m]),b.push([r.xData[m],q]),k.push(r.xData[m]),h.push(q);return{values:b,xData:k,yData:h}}}});""});w(b,"Stock/Indicators/DEMAIndicator.js",[b["Core/Series/Series.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.correctFloat,f=l.isArray,e=b.seriesTypes.ema;
b.seriesType("dema","ema",{},{init:function(){var a=arguments,d=this;g.isParentLoaded(e,"ema",d.type,function(c){c.prototype.init.apply(d,a)})},getEMA:function(a,d,c,f,p,q){return e.prototype.calculateEma(q||[],a,"undefined"===typeof p?1:p,this.chart.series[0].EMApercent,d,"undefined"===typeof f?-1:f,c)},getValues:function(a,d){var c=d.period,r=2*c,p=a.xData,q=a.yData,b=q?q.length:0,n=-1,h=[],m=[],u=[],v=0,A=[],l;a.EMApercent=2/(c+1);if(!(b<2*c-1)){f(q[0])&&(n=d.index?d.index:0);a=e.prototype.accumulatePeriodPoints(c,
n,q);d=a/c;a=0;for(l=c;l<b+2;l++){l<b+1&&(v=this.getEMA(q,g,d,n,l)[1],A.push(v));var g=v;if(l<r)a+=v;else{l===r&&(d=a/c);v=A[l-c-1];var y=this.getEMA([v],y,d)[1];var z=[p[l-2],k(2*v-y)];h.push(z);m.push(z[0]);u.push(z[1])}}return{values:h,xData:m,yData:u}}}});""});w(b,"Stock/Indicators/TEMAIndicator.js",[b["Core/Series/Series.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.correctFloat,f=l.isArray,e=b.seriesTypes.ema;b.seriesType("tema","ema",{},{init:function(){var a=
arguments,d=this;g.isParentLoaded(e,"ema",d.type,function(c){c.prototype.init.apply(d,a)})},getEMA:function(a,d,c,f,p,q){return e.prototype.calculateEma(q||[],a,"undefined"===typeof p?1:p,this.chart.series[0].EMApercent,d,"undefined"===typeof f?-1:f,c)},getTemaPoint:function(a,d,c,e){return[a[e-3],k(3*c.level1-3*c.level2+c.level3)]},getValues:function(a,d){var c=d.period,r=2*c,p=3*c,q=a.xData,b=a.yData,k=b?b.length:0,h=-1,m=[],u=[],v=[],A=[],l=[],g,y,z={};a.EMApercent=2/(c+1);if(!(k<3*c-2)){f(b[0])&&
(h=d.index?d.index:0);a=e.prototype.accumulatePeriodPoints(c,h,b);d=a/c;a=0;for(g=c;g<k+3;g++){g<k+1&&(z.level1=this.getEMA(b,x,d,h,g)[1],A.push(z.level1));var x=z.level1;if(g<r)a+=z.level1;else{g===r&&(d=a/c,a=0);z.level1=A[g-c-1];z.level2=this.getEMA([z.level1],D,d)[1];l.push(z.level2);var D=z.level2;if(g<p)a+=z.level2;else{g===p&&(d=a/c);g===k+1&&(z.level1=A[g-c-1],z.level2=this.getEMA([z.level1],D,d)[1],l.push(z.level2));z.level1=A[g-c-2];z.level2=l[g-2*c-1];z.level3=this.getEMA([z.level2],z.prevLevel3,
d)[1];if(y=this.getTemaPoint(q,p,z,g))m.push(y),u.push(y[0]),v.push(y[1]);z.prevLevel3=z.level3}}}return{values:m,xData:u,yData:v}}}});""});w(b,"Stock/Indicators/TRIXIndicator.js",[b["Core/Series/Series.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.correctFloat,f=b.seriesTypes.tema;b.seriesType("trix","tema",{},{init:function(){var e=arguments,a=this;g.isParentLoaded(f,"tema",a.type,function(d){d.prototype.init.apply(a,e)})},getTemaPoint:function(e,a,d,c){if(c>
a)var f=[e[c-3],0!==d.prevLevel3?k(d.level3-d.prevLevel3)/d.prevLevel3*100:null];return f}});""});w(b,"Stock/Indicators/APOIndicator.js",[b["Core/Series/Series.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.error,f=b.seriesTypes.ema;b.seriesType("apo","ema",{params:{periods:[10,20]}},{nameBase:"APO",nameComponents:["periods"],init:function(){var e=arguments,a=this;g.isParentLoaded(f,"ema",a.type,function(d){d.prototype.init.apply(a,e)})},getValues:function(e,
a){var d=a.periods,c=a.index;a=[];var b=[],p=[],q;if(2!==d.length||d[1]<=d[0])k('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var t=f.prototype.getValues.call(this,e,{index:c,period:d[0]});e=f.prototype.getValues.call(this,e,{index:c,period:d[1]});if(t&&e){d=d[1]-d[0];for(q=0;q<e.yData.length;q++)c=t.yData[q+d]-e.yData[q],a.push([e.xData[q],c]),b.push(e.xData[q]),p.push(c);return{values:a,xData:b,yData:p}}}}});""});w(b,"Stock/Indicators/IKHIndicator.js",
[b["Core/Series/Series.js"],b["Core/Color/Color.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,g,l,k){function f(a){return a.reduce(function(a,c){return Math.max(a,c[1])},-Infinity)}function e(a){return a.reduce(function(a,c){return Math.min(a,c[2])},Infinity)}function a(a){return{high:f(a),low:e(a)}}function d(a){var c,d,e,f,b;a.series.forEach(function(a){if(a.xData)for(f=a.xData,b=d=a.xIncrement?1:f.length-1;0<b;b--)if(e=f[b]-f[b-1],"undefined"===typeof c||e<c)c=e});return c}function c(a,
c,d,e){if(a&&c&&d&&e){var f=c.plotX-a.plotX;c=c.plotY-a.plotY;var b=e.plotX-d.plotX;e=e.plotY-d.plotY;var q=a.plotX-d.plotX,p=a.plotY-d.plotY;d=(-c*q+f*p)/(-b*c+f*e);b=(b*p-e*q)/(-b*c+f*e);if(0<=d&&1>=d&&0<=b&&1>=b)return{plotX:a.plotX+b*f,plotY:a.plotY+b*c}}return!1}function r(a){var c=a.indicator;c.points=a.points;c.nextPoints=a.nextPoints;c.color=a.color;c.options=n(a.options.senkouSpan.styles,a.gap);c.graph=a.graph;c.fillGraph=!0;m.prototype.drawGraph.call(c)}var p=g.parse,q=k.defined,t=k.isArray,
n=k.merge,h=k.objectEach,m=b.seriesTypes.sma;l.approximations["ichimoku-averages"]=function(){var a=[],c;[].forEach.call(arguments,function(d,e){a.push(l.approximations.average(d));c=!c&&"undefined"===typeof a[e]});return c?void 0:a};b.seriesType("ikh","sma",{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}},{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period",
"periodTenkan"],init:function(){m.prototype.init.apply(this,arguments);this.options=n({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:p(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:p(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:p(this.color).setOpacity(.2).get()}}},this.options)},toYData:function(a){return[a.tenkanSen,a.kijunSen,
a.chikouSpan,a.senkouSpanA,a.senkouSpanB]},translate:function(){var a=this;m.prototype.translate.apply(a);a.points.forEach(function(c){a.pointArrayMap.forEach(function(d){q(c[d])&&(c["plot"+d]=a.yAxis.toPixels(c[d],!0),c.plotY=c["plot"+d],c.tooltipPos=[c.plotX,c["plot"+d]],c.isNull=!1)})})},drawGraph:function(){var a=this,d=a.points,e=d.length,f=a.options,b=a.graph,p=a.color,k={options:{gapSize:f.gapSize}},t=a.pointArrayMap.length,g=[[],[],[],[],[],[]],l={tenkanLine:g[0],kijunLine:g[1],chikouLine:g[2],
senkouSpanA:g[3],senkouSpanB:g[4],senkouSpan:g[5]},x=[],B=a.options.senkouSpan,w=B.color||B.styles.fill,M=B.negativeColor,L=[[],[]],I=[[],[]],O=0,J,P,N;for(a.ikhMap=l;e--;){var E=d[e];for(J=0;J<t;J++)B=a.pointArrayMap[J],q(E[B])&&g[J].push({plotX:E.plotX,plotY:E["plot"+B],isNull:!1});M&&e!==d.length-1&&(B=l.senkouSpanB.length-1,E=c(l.senkouSpanA[B-1],l.senkouSpanA[B],l.senkouSpanB[B-1],l.senkouSpanB[B]),J={plotX:E.plotX,plotY:E.plotY,isNull:!1,intersectPoint:!0},E&&(l.senkouSpanA.splice(B,0,J),l.senkouSpanB.splice(B,
0,J),x.push(B)))}h(l,function(c,d){f[d]&&"senkouSpan"!==d&&(a.points=g[O],a.options=n(f[d].styles,k),a.graph=a["graph"+d],a.fillGraph=!1,a.color=p,m.prototype.drawGraph.call(a),a["graph"+d]=a.graph);O++});a.graphCollection&&a.graphCollection.forEach(function(c){a[c].destroy();delete a[c]});a.graphCollection=[];if(M&&l.senkouSpanA[0]&&l.senkouSpanB[0]){x.unshift(0);x.push(l.senkouSpanA.length-1);for(t=0;t<x.length-1;t++){B=x[t];E=x[t+1];e=l.senkouSpanB.slice(B,E+1);B=l.senkouSpanA.slice(B,E+1);if(1<=
Math.floor(e.length/2))if(E=Math.floor(e.length/2),e[E].plotY===B[E].plotY){for(N=J=E=0;N<e.length;N++)E+=e[N].plotY,J+=B[N].plotY;E=E>J?0:1}else E=e[E].plotY>B[E].plotY?0:1;else E=e[0].plotY>B[0].plotY?0:1;L[E]=L[E].concat(e);I[E]=I[E].concat(B)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,d){L[d].length&&I[d].length&&(P=0===d?w:M,r({indicator:a,points:L[d],nextPoints:I[d],color:P,options:f,gap:k,graph:a[c]}),a[c]=a.graph,a.graphCollection.push(c))})}else r({indicator:a,
points:l.senkouSpanB,nextPoints:l.senkouSpanA,color:w,options:f,gap:k,graph:a.graphsenkouSpan}),a.graphsenkouSpan=a.graph;delete a.nextPoints;delete a.fillGraph;a.points=d;a.options=f;a.graph=b},getGraphPath:function(a){var c=[],d;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((d=m.prototype.getGraphPath.call(this,this.nextPoints))&&d.length){d[0][0]="L";c=m.prototype.getGraphPath.call(this,a);d=d.slice(0,c.length);for(var e=d.length-1;0<=e;e--)c.push(d[e])}}else c=m.prototype.getGraphPath.apply(this,
arguments);return c},getValues:function(c,e){var f=e.period,b=e.periodTenkan;e=e.periodSenkouSpanB;var q=c.xData,p=c.yData,r=p&&p.length||0;c=d(c.xAxis);var k=[],m=[],h;if(!(q.length<=f)&&t(p[0])&&4===p[0].length){var n=q[0]-f*c;for(h=0;h<f;h++)m.push(n+h*c);for(h=0;h<r;h++){if(h>=b){var l=p.slice(h-b,h);l=a(l);l=(l.high+l.low)/2}if(h>=f){var u=p.slice(h-f,h);u=a(u);u=(u.high+u.low)/2;var g=(l+u)/2}if(h>=e){var v=p.slice(h-e,h);v=a(v);v=(v.high+v.low)/2}n=p[h][3];var x=q[h];"undefined"===typeof k[h]&&
(k[h]=[]);"undefined"===typeof k[h+f]&&(k[h+f]=[]);k[h+f][0]=l;k[h+f][1]=u;k[h+f][2]=void 0;k[h][2]=n;h<=f&&(k[h+f][3]=void 0,k[h+f][4]=void 0);"undefined"===typeof k[h+2*f]&&(k[h+2*f]=[]);k[h+2*f][3]=g;k[h+2*f][4]=v;m.push(x)}for(h=1;h<=f;h++)m.push(x+h*c);return{values:k,xData:m,yData:k}}}});""});w(b,"Stock/Indicators/KeltnerChannelsIndicator.js",[b["Core/Series/Series.js"],b["Mixins/MultipleLines.js"],b["Core/Utilities.js"]],function(b,g,l){var k=b.seriesTypes,f=l.correctFloat,e=l.merge,a=k.sma,
d=k.ema,c=k.atr;b.seriesType("keltnerchannels","sma",{params:{period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1},e(g,{pointArrayMap:["top",
"middle","bottom"],pointValKey:"middle",nameBase:"Keltner Channels",nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],requiredIndicators:["ema","atr"],init:function(){a.prototype.init.apply(this,arguments);this.options=e({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(a,e){var b=e.period,k=e.periodATR,p=e.multiplierATR,h=a.yData;h=h?h.length:0;var r=[];e=d.prototype.getValues(a,{period:b,
index:e.index});var l=c.prototype.getValues(a,{period:k}),g=[],A=[],x;if(!(h<b)){for(x=b;x<=h;x++){var C=e.values[x-b];var y=l.values[x-k];var z=C[0];a=f(C[1]+p*y[1]);y=f(C[1]-p*y[1]);C=C[1];r.push([z,a,C,y]);g.push(z);A.push([a,C,y])}return{values:r,xData:g,yData:A}}}}));""});w(b,"Stock/Indicators/MACDIndicator.js",[b["Core/Series/Series.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.correctFloat,f=l.defined,e=l.merge,a=g.seriesTypes.sma,d=g.seriesTypes.ema;b.seriesType("macd",
"sma",{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0},
{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:g.noop,getColumnMetrics:g.seriesTypes.column.prototype.getColumnMetrics,crispCol:g.seriesTypes.column.prototype.crispCol,init:function(){a.prototype.init.apply(this,arguments);this.options&&(this.options=e({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones=
{zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0)},toYData:function(a){return[a.y,a.signal,a.MACD]},translate:function(){var a=this,d=["plotSignal","plotMACD"];g.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(c){[c.signal,c.MACD].forEach(function(e,f){null!==e&&(c[d[f]]=a.yAxis.toPixels(e,!0))})})},destroy:function(){this.graph=null;
this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();a.prototype.destroy.apply(this,arguments)},drawPoints:g.seriesTypes.column.prototype.drawPoints,drawGraph:function(){for(var c=this,d=c.points,b=d.length,k=c.options,t=c.zones,n={options:{gapSize:k.gapSize}},h=[[],[]],m;b--;)m=d[b],f(m.plotMACD)&&h[0].push({plotX:m.plotX,plotY:m.plotMACD,isNull:!f(m.plotMACD)}),f(m.plotSignal)&&h[1].push({plotX:m.plotX,plotY:m.plotSignal,isNull:!f(m.plotMACD)});
["macd","signal"].forEach(function(d,f){c.points=h[f];c.options=e(k[d+"Line"].styles,n);c.graph=c["graph"+d];c.currentLineZone=d+"Zones";c.zones=c[c.currentLineZone].zones;a.prototype.drawGraph.call(c);c["graph"+d]=c.graph});c.points=d;c.options=k;c.zones=t;c.currentLineZone=null},getZonesGraphs:function(c){var d=a.prototype.getZonesGraphs.call(this,c),e=d;this.currentLineZone&&(e=d.splice(this[this.currentLineZone].startIndex+1),e.length?e.splice(0,0,c[0]):e=[c[0]]);return e},applyZones:function(){var c=
this.zones;this.zones=this.signalZones.zones;a.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide();this.zones=c},getValues:function(a,e){var c=0,b=[],r=[],n=[];if(!(a.xData.length<e.longPeriod+e.signalPeriod)){var h=d.prototype.getValues(a,{period:e.shortPeriod});var m=d.prototype.getValues(a,{period:e.longPeriod});h=h.values;m=m.values;for(a=1;a<=h.length;a++)f(m[a-1])&&f(m[a-1][1])&&f(h[a+e.shortPeriod+1])&&f(h[a+e.shortPeriod+1][0])&&b.push([h[a+
e.shortPeriod+1][0],0,null,h[a+e.shortPeriod+1][1]-m[a-1][1]]);for(a=0;a<b.length;a++)r.push(b[a][0]),n.push([0,null,b[a][3]]);e=d.prototype.getValues({xData:r,yData:n},{period:e.signalPeriod,index:2});e=e.values;for(a=0;a<b.length;a++)b[a][0]>=e[0][0]&&(b[a][2]=e[c][1],n[a]=[0,e[c][1],b[a][3]],null===b[a][3]?(b[a][1]=0,n[a][0]=0):(b[a][1]=k(b[a][3]-e[c][1]),n[a][0]=k(b[a][3]-e[c][1])),c++);return{values:b,xData:r,yData:n}}}});""});w(b,"Stock/Indicators/MFIIndicator.js",[b["Core/Series/Series.js"],
b["Core/Utilities.js"]],function(b,g){function l(a){return a.reduce(function(a,c){return a+c})}function k(a){return(a[1]+a[2]+a[3])/3}var f=g.error,e=g.isArray;b.seriesType("mfi","sma",{params:{period:14,volumeSeriesID:"volume",decimals:4}},{nameBase:"Money Flow Index",getValues:function(a,d){var c=d.period,b=a.xData,p=a.yData,q=p?p.length:0,t=d.decimals,n=1,h=a.chart.get(d.volumeSeriesID),m=h&&h.yData,g=[],v=[],A=[],x=[],C=[];if(!h)f("Series "+d.volumeSeriesID+" not found! Check `volumeSeriesID`.",
!0,a.chart);else if(!(b.length<=c)&&e(p[0])&&4===p[0].length&&m){for(a=k(p[n]);n<c+1;)d=a,a=k(p[n]),d=a>=d,h=a*m[n],x.push(d?h:0),C.push(d?0:h),n++;for(c=n-1;c<q;c++)c>n-1&&(x.shift(),C.shift(),d=a,a=k(p[c]),d=a>d,h=a*m[c],x.push(d?h:0),C.push(d?0:h)),d=l(C),h=l(x),d=h/d,d=parseFloat((100-100/(1+d)).toFixed(t)),g.push([b[c],d]),v.push(b[c]),A.push(d);return{values:g,xData:v,yData:A}}}});""});w(b,"Stock/Indicators/MomentumIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,
g){function l(f,e,a,d,c){a=a[d-1][3]-a[d-c-1][3];e=e[d-1];f.shift();return[e,a]}var k=g.isArray;b.seriesType("momentum","sma",{params:{period:14}},{nameBase:"Momentum",getValues:function(f,e){e=e.period;var a=f.xData,d=(f=f.yData)?f.length:0,c=a[0],b=[],p=[],q=[];if(!(a.length<=e)&&k(f[0])){var t=f[0][3];t=[[c,t]];for(c=e+1;c<d;c++){var n=l(t,a,f,c,e,void 0);b.push(n);p.push(n[0]);q.push(n[1])}n=l(t,a,f,c,e,void 0);b.push(n);p.push(n[0]);q.push(n[1]);return{values:b,xData:p,yData:q}}}});""});w(b,
"Stock/Indicators/NATRIndicator.js",[b["Core/Series/Series.js"]],function(b){var g=b.seriesTypes.atr;b.seriesType("natr","sma",{tooltip:{valueSuffix:"%"}},{requiredIndicators:["atr"],getValues:function(b,k){var f=g.prototype.getValues.apply(this,arguments),e=f.values.length,a=k.period-1,d=b.yData,c=0;if(f){for(;c<e;c++)f.yData[c]=f.values[c][1]/d[a][3]*100,f.values[c][1]=f.yData[c],a++;return f}}});""});w(b,"Stock/Indicators/PivotPointsIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],
function(b,g){function l(a,d){var c=a.series.pointArrayMap,f=c.length;for(e.prototype.pointClass.prototype[d].call(a);f--;)d="dataLabel"+c[f],a[d]&&a[d].element&&a[d].destroy(),a[d]=null}var k=g.defined,f=g.isArray,e=b.seriesTypes.sma;b.seriesType("pivotpoints","sma",{params:{period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}},{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),
pointValKey:"P",toYData:function(a){return[a.P]},translate:function(){var a=this;e.prototype.translate.apply(a);a.points.forEach(function(d){a.pointArrayMap.forEach(function(c){k(d[c])&&(d["plot"+c]=a.yAxis.toPixels(d[c],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,!0)},getGraphPath:function(a){for(var d=this,c=a.length,f=[[],[],[],[],[],[],[],[],[]],b=[],q=d.plotEndPoint,t=d.pointArrayMap.length,n,h,m;c--;){h=a[c];for(m=0;m<t;m++)n=d.pointArrayMap[m],k(h[n])&&f[m].push({plotX:h.plotX,plotY:h["plot"+
n],isNull:!1},{plotX:q,plotY:h["plot"+n],isNull:!1},{plotX:q,plotY:null,isNull:!0});q=h.plotX}f.forEach(function(a){b=b.concat(e.prototype.getGraphPath.call(d,a))});return b},drawDataLabels:function(){var a=this,d=a.pointArrayMap,c,f,b;if(a.options.dataLabels.enabled){var k=a.points.length;d.concat([!1]).forEach(function(p,q){for(b=k;b--;)f=a.points[b],p?(f.y=f[p],f.pivotLine=p,f.plotY=f["plot"+p],c=f["dataLabel"+p],q&&(f["dataLabel"+d[q-1]]=f.dataLabel),f.dataLabels||(f.dataLabels=[]),f.dataLabels[0]=
f.dataLabel=c=c&&c.element?c:null):f["dataLabel"+d[q-1]]=f.dataLabel;e.prototype.drawDataLabels.apply(a,arguments)})}},getValues:function(a,d){var c=d.period,e=a.xData,b=(a=a.yData)?a.length:0;d=this[d.algorithm+"Placement"];var k=[],l=[],n=[],h;if(!(e.length<c)&&f(a[0])&&4===a[0].length){for(h=c+1;h<=b+c;h+=c){var m=e.slice(h-c-1,h);var g=a.slice(h-c-1,h);var v=m.length;var A=m[v-1];g=this.getPivotAndHLC(g);g=d(g);g=k.push([A].concat(g));l.push(A);n.push(k[g-1].slice(1))}this.endPoint=m[0]+(A-m[0])/
v*c;return{values:k,xData:l,yData:n}}},getPivotAndHLC:function(a){var d=-Infinity,c=Infinity,e=a[a.length-1][3];a.forEach(function(a){d=Math.max(d,a[1]);c=Math.min(c,a[2])});return[(d+c+e)/3,d,c,e]},standardPlacement:function(a){var d=a[1]-a[2];return[null,null,a[0]+d,2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-d,null,null]},camarillaPlacement:function(a){var d=a[1]-a[2];return[a[3]+1.5*d,a[3]+1.25*d,a[3]+1.1666*d,a[3]+1.0833*d,a[0],a[3]-1.0833*d,a[3]-1.1666*d,a[3]-1.25*d,a[3]-1.5*d]},fibonacciPlacement:function(a){var d=
a[1]-a[2];return[null,a[0]+d,a[0]+.618*d,a[0]+.382*d,a[0],a[0]-.382*d,a[0]-.618*d,a[0]-d,null]}},{destroyElements:function(){l(this,"destroyElements")},destroy:function(){l(this,"destroyElements")}});""});w(b,"Stock/Indicators/PPOIndicator.js",[b["Core/Globals.js"],b["Mixins/IndicatorRequired.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.correctFloat,f=l.error,e=b.seriesTypes.ema;b.seriesType("ppo","ema",{params:{periods:[12,26]}},{nameBase:"PPO",nameComponents:["periods"],init:function(){var a=
arguments,d=this;g.isParentLoaded(e,"ema",d.type,function(c){c.prototype.init.apply(d,a)})},getValues:function(a,d){var c=d.periods,b=d.index;d=[];var p=[],q=[],g;if(2!==c.length||c[1]<=c[0])f('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');else{var n=e.prototype.getValues.call(this,a,{index:b,period:c[0]});a=e.prototype.getValues.call(this,a,{index:b,period:c[1]});if(n&&a){c=c[1]-c[0];for(g=0;g<a.yData.length;g++)b=k((n.yData[g+c]-a.yData[g])/a.yData[g]*
100),d.push([a.xData[g],b]),p.push(a.xData[g]),q.push(b);return{values:d,xData:p,yData:q}}}}});""});w(b,"Mixins/ReduceArray.js",[],function(){return{minInArray:function(b,g){return b.reduce(function(b,k){return Math.min(b,k[g])},Number.MAX_VALUE)},maxInArray:function(b,g){return b.reduce(function(b,k){return Math.max(b,k[g])},-Number.MAX_VALUE)},getArrayExtremes:function(b,g,l){return b.reduce(function(b,f){return[Math.min(b[0],f[g]),Math.max(b[1],f[l])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});
w(b,"Stock/Indicators/PCIndicator.js",[b["Core/Series/Series.js"],b["Mixins/MultipleLines.js"],b["Mixins/ReduceArray.js"],b["Core/Utilities.js"]],function(b,g,l,k){k=k.merge;var f=l.getArrayExtremes;b.seriesType("pc","sma",{params:{period:20},lineWidth:1,topLine:{styles:{lineColor:"#90ed7d",lineWidth:1}},bottomLine:{styles:{lineColor:"#f45b5b",lineWidth:1}},dataGrouping:{approximation:"averages"}},k(g,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",nameComponents:["period"],
linesApiNames:["topLine","bottomLine"],getValues:function(e,a){a=a.period;var d=e.xData,c=(e=e.yData)?e.length:0,b=[],k=[],q=[],g;if(!(c<a)){for(g=a;g<=c;g++){var n=d[g-1];var h=e.slice(g-a,g);var m=f(h,2,1);h=m[1];var l=m[0];m=(h+l)/2;b.push([n,h,m,l]);k.push(n);q.push([h,m,l])}return{values:b,xData:k,yData:q}}}}));""});w(b,"Stock/Indicators/PriceEnvelopesIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){var l=g.isArray,k=g.merge,f=b.seriesTypes.sma;b.seriesType("priceenvelopes",
"sma",{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x",
"y","top","bottom"],pointValKey:"middle",init:function(){f.prototype.init.apply(this,arguments);this.options=k({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},toYData:function(e){return[e.top,e.middle,e.bottom]},translate:function(){var e=this,a=["plotTop","plotMiddle","plotBottom"];f.prototype.translate.apply(e);e.points.forEach(function(d){[d.top,d.middle,d.bottom].forEach(function(c,f){null!==c&&(d[a[f]]=e.yAxis.toPixels(c,!0))})})},drawGraph:function(){for(var e=
this,a=e.points,d=a.length,c=e.options,b=e.graph,p={options:{gapSize:c.gapSize}},q=[[],[]],g;d--;)g=a[d],q[0].push({plotX:g.plotX,plotY:g.plotTop,isNull:g.isNull}),q[1].push({plotX:g.plotX,plotY:g.plotBottom,isNull:g.isNull});["topLine","bottomLine"].forEach(function(a,d){e.points=q[d];e.options=k(c[a].styles,p);e.graph=e["graph"+a];f.prototype.drawGraph.call(e);e["graph"+a]=e.graph});e.points=a;e.options=c;e.graph=b;f.prototype.drawGraph.call(e)},getValues:function(e,a){var d=a.period,c=a.topBand,
b=a.bottomBand,k=e.xData,q=(e=e.yData)?e.length:0,g=[],n=[],h=[],m;if(!(k.length<d)&&l(e[0])&&4===e[0].length){for(m=d;m<=q;m++){var u=k.slice(m-d,m);var v=e.slice(m-d,m);v=f.prototype.getValues.call(this,{xData:u,yData:v},a);u=v.xData[0];v=v.yData[0];var A=v*(1+c);var x=v*(1-b);g.push([u,A,v,x]);n.push(u);h.push([A,v,x])}return{values:g,xData:n,yData:h}}}});""});w(b,"Stock/Indicators/PSARIndicator.js",[b["Core/Series/Series.js"]],function(b){b.seriesType("psar","sma",{lineWidth:0,marker:{enabled:!0},
states:{hover:{lineWidthPlus:0}},params:{initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}},{nameComponents:!1,getValues:function(b,l){var k=b.xData;b=b.yData;var f=b[0][1],e=l.maxAccelerationFactor,a=l.increment,d=l.initialAccelerationFactor,c=b[0][2],g=l.decimals,p=l.index,q=[],t=[],n=[],h=1,m;if(!(p>=b.length)){for(m=0;m<p;m++)f=Math.max(b[m][1],f),c=Math.min(b[m][2],parseFloat(c.toFixed(g)));var u=b[m][1]>c?1:-1;l=l.initialAccelerationFactor;var v=l*(f-c);
q.push([k[p],c]);t.push(k[p]);n.push(parseFloat(c.toFixed(g)));for(m=p+1;m<b.length;m++){p=b[m-1][2];var A=b[m-2][2];var x=b[m-1][1];var C=b[m-2][1];var y=b[m][1];var z=b[m][2];null!==A&&null!==C&&null!==p&&null!==x&&null!==y&&null!==z&&(c=u===h?1===u?c+v<Math.min(A,p)?c+v:Math.min(A,p):c+v>Math.max(C,x)?c+v:Math.max(C,x):f,p=1===u?y>f?y:f:z<f?z:f,y=1===h&&z>c||-1===h&&y>c?1:-1,h=y,v=p,z=a,A=e,x=d,l=h===u?1===h&&v>f?l===A?A:parseFloat((l+z).toFixed(2)):-1===h&&v<f?l===A?A:parseFloat((l+z).toFixed(2)):
l:x,f=p-c,v=l*f,q.push([k[m],parseFloat(c.toFixed(g))]),t.push(k[m]),n.push(parseFloat(c.toFixed(g))),h=u,u=y,f=p)}return{values:q,xData:t,yData:n}}}});""});w(b,"Stock/Indicators/ROCIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){var l=g.isArray;b.seriesType("roc","sma",{params:{index:3,period:9}},{nameBase:"Rate of Change",getValues:function(b,f){var e=f.period,a=b.xData,d=(b=b.yData)?b.length:0,c=[],k=[],p=[],q=-1;if(!(a.length<=e)){l(b[0])&&(q=f.index);for(f=e;f<
d;f++){var g=0>q?(g=b[f-e])?(b[f]-g)/g*100:null:(g=b[f-e][q])?(b[f][q]-g)/g*100:null;g=[a[f],g];c.push(g);k.push(g[0]);p.push(g[1])}return{values:c,xData:k,yData:p}}}});""});w(b,"Stock/Indicators/RSIIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){var l=g.isArray;b.seriesType("rsi","sma",{params:{period:14,decimals:4}},{getValues:function(b,f){var e=f.period,a=b.xData,d=(b=b.yData)?b.length:0;f=f.decimals;var c=1,k=[],p=[],q=[],g=0,n=0,h;if(!(a.length<e)&&l(b[0])&&4===
b[0].length){for(;c<e;){var m=parseFloat((b[c][3]-b[c-1][3]).toFixed(f));0<m?g+=m:n+=Math.abs(m);c++}var u=parseFloat((g/(e-1)).toFixed(f));for(h=parseFloat((n/(e-1)).toFixed(f));c<d;c++)m=parseFloat((b[c][3]-b[c-1][3]).toFixed(f)),0<m?(g=m,n=0):(g=0,n=Math.abs(m)),u=parseFloat(((u*(e-1)+g)/e).toFixed(f)),h=parseFloat(((h*(e-1)+n)/e).toFixed(f)),g=0===h?100:0===u?0:parseFloat((100-100/(1+u/h)).toFixed(f)),k.push([a[c],g]),p.push(a[c]),q.push(g);return{values:k,xData:p,yData:q}}}});""});w(b,"Stock/Indicators/StochasticIndicator.js",
[b["Core/Series/Series.js"],b["Mixins/MultipleLines.js"],b["Mixins/ReduceArray.js"],b["Core/Utilities.js"]],function(b,g,l,k){var f=k.isArray,e=k.merge,a=b.seriesTypes.sma,d=l.getArrayExtremes;b.seriesType("stochastic","sma",{params:{periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},
e(g,{nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],init:function(){a.prototype.init.apply(this,arguments);this.options=e({smoothedLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(c,b){var e=b.periods[0];b=b.periods[1];var k=c.xData,g=(c=c.yData)?c.length:0,n=[],h=[],m=[],l=null,r;if(!(g<e)&&f(c[0])&&4===c[0].length){for(r=e-1;r<g;r++){var A=c.slice(r-e+1,r+1);
var x=d(A,2,1);var C=x[0];A=c[r][3]-C;C=x[1]-C;A=A/C*100;h.push(k[r]);m.push([A,null]);r>=e-1+(b-1)&&(l=a.prototype.getValues.call(this,{xData:h.slice(-b),yData:m.slice(-b)},{period:b}),l=l.yData[0]);n.push([k[r],A,l]);m[m.length-1][1]=l}return{values:n,xData:h,yData:m}}}}));""});w(b,"Stock/Indicators/SlowStochasticIndicator.js",[b["Core/Series/Series.js"],b["Mixins/IndicatorRequired.js"]],function(b,g){var l=b.seriesTypes;b.seriesType("slowstochastic","stochastic",{params:{periods:[14,3,3]}},{nameBase:"Slow Stochastic",
init:function(){var b=arguments,f=this;g.isParentLoaded(l.stochastic,"stochastic",f.type,function(e){e.prototype.init.apply(f,b)})},getValues:function(b,f){var e=f.periods,a=l.stochastic.prototype.getValues.call(this,b,f);b={values:[],xData:[],yData:[]};f=0;if(a){b.xData=a.xData.slice(e[1]-1);a=a.yData.slice(e[1]-1);var d=l.sma.prototype.getValues.call(this,{xData:b.xData,yData:a},{index:1,period:e[2]});if(d){for(var c=b.xData.length;f<c;f++)b.yData[f]=[a[f][1],d.yData[f-e[2]+1]||null],b.values[f]=
[b.xData[f],a[f][1],d.yData[f-e[2]+1]||null];return b}}}});""});w(b,"Stock/Indicators/SupertrendIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){function l(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var k=b.seriesTypes,f=g.correctFloat,e=g.isArray,a=g.merge,d=g.objectEach,c=k.atr,r=k.sma;b.seriesType("supertrend","sma",{params:{multiplier:3,period:10},risingTrendColor:"#06B535",fallingTrendColor:"#F21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",
dashStyle:"LongDash"}}},{nameBase:"Supertrend",nameComponents:["multiplier","period"],requiredIndicators:["atr"],init:function(){r.prototype.init.apply(this,arguments);var a=this.options;a.cropThreshold=this.linkedParent.options.cropThreshold-(a.params.period-1)},drawGraph:function(){var b=this,c=b.options,e=b.linkedParent,f=e?e.points:[],h=b.points,k=b.graph,g=h.length,v=f.length-g;v=0<v?v:0;for(var A={options:{gapSize:c.gapSize}},x={top:[],bottom:[],intersect:[]},C={top:{styles:{lineWidth:c.lineWidth,
lineColor:c.fallingTrendColor||c.color,dashStyle:c.dashStyle}},bottom:{styles:{lineWidth:c.lineWidth,lineColor:c.risingTrendColor||c.color,dashStyle:c.dashStyle}},intersect:c.changeTrendLine},y,z,F,D,w,H,B,G;g--;)y=h[g],z=h[g-1],F=f[g-1+v],D=f[g-2+v],w=f[g+v],H=f[g+v+1],B=y.options.color,G={x:y.x,plotX:y.plotX,plotY:y.plotY,isNull:!1},!D&&F&&e.yData[F.index-1]&&(D=l(e,F.index-1,3)),!H&&w&&e.yData[w.index+1]&&(H=l(e,w.index+1,3)),!F&&D&&e.yData[D.index+1]?F=l(e,D.index+1,3):!F&&w&&e.yData[w.index-
1]&&(F=l(e,w.index-1,3)),y&&F&&w&&D&&y.x!==F.x&&(y.x===w.x?(D=F,F=w):y.x===D.x?(F=D,D={close:e.yData[F.index-1][3],x:e.xData[F.index-1]}):H&&y.x===H.x&&(F=H,D=w)),z&&D&&F?(w={x:z.x,plotX:z.plotX,plotY:z.plotY,isNull:!1},y.y>=F.close&&z.y>=D.close?(y.color=B||c.fallingTrendColor||c.color,x.top.push(G)):y.y<F.close&&z.y<D.close?(y.color=B||c.risingTrendColor||c.color,x.bottom.push(G)):(x.intersect.push(G),x.intersect.push(w),x.intersect.push(a(w,{isNull:!0})),y.y>=F.close&&z.y<D.close?(y.color=B||c.fallingTrendColor||
c.color,z.color=B||c.risingTrendColor||c.color,x.top.push(G),x.top.push(a(w,{isNull:!0}))):y.y<F.close&&z.y>=D.close&&(y.color=B||c.risingTrendColor||c.color,z.color=B||c.fallingTrendColor||c.color,x.bottom.push(G),x.bottom.push(a(w,{isNull:!0}))))):F&&(y.y>=F.close?(y.color=B||c.fallingTrendColor||c.color,x.top.push(G)):(y.color=B||c.risingTrendColor||c.color,x.bottom.push(G)));d(x,function(c,e){b.points=c;b.options=a(C[e].styles,A);b.graph=b["graph"+e+"Line"];r.prototype.drawGraph.call(b);b["graph"+
e+"Line"]=b.graph});b.points=h;b.options=c;b.graph=k},getValues:function(a,b){var d=b.period;b=b.multiplier;var k=a.xData,h=a.yData,g=[],l=[],p=[],q=0===d?0:d-1,r=[],x=[],y;if(!(k.length<=d||!e(h[0])||4!==h[0].length||0>d)){a=c.prototype.getValues.call(this,a,{period:d}).yData;for(y=0;y<a.length;y++){var z=h[q+y];var w=h[q+y-1]||[];var D=r[y-1];var K=x[y-1];var H=p[y-1];0===y&&(D=K=H=0);d=f((z[1]+z[2])/2+b*a[y]);var B=f((z[1]+z[2])/2-b*a[y]);r[y]=d<D||w[3]>D?d:D;x[y]=B>K||w[3]<K?B:K;if(H===D&&z[3]<
r[y]||H===K&&z[3]<x[y])var G=r[y];else if(H===D&&z[3]>r[y]||H===K&&z[3]>x[y])G=x[y];g.push([k[q+y],G]);l.push(k[q+y]);p.push(G)}return{values:g,xData:l,yData:p}}}});""});w(b,"Stock/Indicators/VBPIndicator.js",[b["Core/Animation/AnimationUtilities.js"],b["Core/Series/Series.js"],b["Core/Globals.js"],b["Core/Series/Point.js"],b["Core/Utilities.js"]],function(b,g,l,k,f){var e=b.animObject;b=l.noop;var a=f.addEvent,d=f.arrayMax,c=f.arrayMin,r=f.correctFloat,p=f.error,q=f.extend,t=f.isArray,n=Math.abs,
h=g.seriesTypes.column.prototype;g.seriesType("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",
padding:0,style:{fontSize:"7px"},verticalAlign:"top"}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:b,drawGraph:b,getColumnMetrics:h.getColumnMetrics,crispCol:h.crispCol,init:function(a){l.seriesTypes.sma.prototype.init.apply(this,arguments);var c=this.options.params;var b=this.linkedParent;c=a.get(c.volumeSeriesID);this.addCustomEvents(b,c);return this},addCustomEvents:function(c,b){function e(){d.chart.redraw();d.setData([]);d.zoneStarts=
[];d.zoneLinesSVG&&(d.zoneLinesSVG.destroy(),delete d.zoneLinesSVG)}var d=this;d.dataEventsToUnbind.push(a(c,"remove",function(){e()}));b&&d.dataEventsToUnbind.push(a(b,"remove",function(){e()}));return d},animate:function(a){var c=this,b=c.chart.inverted,d=c.group,f={};!a&&d&&(a=b?"translateY":"translateX",b=b?c.yAxis.top:c.xAxis.left,d["forceAnimate:"+a]=!0,f[a]=b,d.animate(f,q(e(c.options.animation),{step:function(a,b){c.group.attr({scaleX:Math.max(.001,b.pos)})}})))},drawPoints:function(){this.options.volumeDivision.enabled&&
(this.posNegVolume(!0,!0),h.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));h.drawPoints.apply(this,arguments)},posNegVolume:function(a,c){var b=c?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,e=this.points.length,f=[],k=[],h=0,g;a?(this.posWidths=f,this.negWidths=k):(f=this.posWidths,k=this.negWidths);for(;h<e;h++){var m=this.points[h];m[b[0]+"Graphic"]=m.graphic;m.graphic=m[b[1]+"Graphic"];if(a){var l=m.shapeArgs.width;var p=this.priceZones[h];(g=p.wholeVolumeData)?
(f.push(l/g*p.positiveVolumeData),k.push(l/g*p.negativeVolumeData)):(f.push(0),k.push(0))}m.color=c?d.styles.positiveColor:d.styles.negativeColor;m.shapeArgs.width=c?this.posWidths[h]:this.negWidths[h];m.shapeArgs.x=c?m.shapeArgs.x:this.posWidths[h]}},translate:function(){var a=this,c=a.options,b=a.chart,e=a.yAxis,f=e.min,k=a.options.zoneLines,g=a.priceZones,l=0,p,q,t;h.translate.apply(a);var x=a.points;if(x.length){var w=.5>c.pointPadding?c.pointPadding:.1;c=a.volumeDataArray;var G=d(c);var M=b.plotWidth/
2;var L=b.plotTop;var I=n(e.toPixels(f)-e.toPixels(f+a.rangeStep));var O=n(e.toPixels(f)-e.toPixels(f+a.rangeStep));w&&(f=n(I*(1-2*w)),l=n((I-f)/2),I=n(f));x.forEach(function(c,b){q=c.barX=c.plotX=0;t=c.plotY=e.toPixels(g[b].start)-L-(e.reversed?I-O:I)-l;p=r(M*g[b].wholeVolumeData/G);c.pointWidth=p;c.shapeArgs=a.crispCol.apply(a,[q,t,p,I]);c.volumeNeg=g[b].negativeVolumeData;c.volumePos=g[b].positiveVolumeData;c.volumeAll=g[b].wholeVolumeData});k.enabled&&a.drawZones(b,e,a.zoneStarts,k.styles)}},
getValues:function(a,c){var b=a.processedXData,e=a.processedYData,d=this.chart,f=c.ranges,k=[],h=[],g=[],m;if(a.chart)if(m=d.get(c.volumeSeriesID))if((c=t(e[0]))&&4!==e[0].length)p("Type of "+a.name+" series is different than line, OHLC or candlestick.",!0,d);else return(this.priceZones=this.specifyZones(c,b,e,f,m)).forEach(function(a,c){k.push([a.x,a.end]);h.push(k[c][0]);g.push(k[c][1])}),{values:k,xData:h,yData:g};else p("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,d);else p("Base series not found! In case it has been removed, add a new one.",
!0,d)},specifyZones:function(a,b,e,f,k){if(a){var h=e.length;for(var g=e[0][3],m=g,p=1,l;p<h;p++)l=e[p][3],l<g&&(g=l),l>m&&(m=l);h={min:g,max:m}}else h=!1;h=(g=h)?g.min:c(e);l=g?g.max:d(e);g=this.zoneStarts=[];m=[];var q=0;p=1;if(!h||!l)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var n=this.rangeStep=r(l-h)/f;for(g.push(h);q<f-1;q++)g.push(r(g[q]+n));g.push(l);for(f=g.length;p<f;p++)m.push({index:p-1,x:b[0],start:g[p-1],end:g[p]});return this.volumePerZone(a,
m,k,b,e)},volumePerZone:function(a,c,b,e,d){var f=this,h=b.processedXData,g=b.processedYData,k=c.length-1,p=d.length;b=g.length;var l,m,q,r,t;n(p-b)&&(e[0]!==h[0]&&g.unshift(0),e[p-1]!==h[b-1]&&g.push(0));f.volumeDataArray=[];c.forEach(function(c){c.wholeVolumeData=0;c.positiveVolumeData=0;for(t=c.negativeVolumeData=0;t<p;t++)q=m=!1,r=a?d[t][3]:d[t],l=t?a?d[t-1][3]:d[t-1]:r,r<=c.start&&0===c.index&&(m=!0),r>=c.end&&c.index===k&&(q=!0),(r>c.start||m)&&(r<c.end||q)&&(c.wholeVolumeData+=g[t],l>r?c.negativeVolumeData+=
g[t]:c.positiveVolumeData+=g[t]);f.volumeDataArray.push(c.wholeVolumeData)});return c},drawZones:function(a,c,b,e){var d=a.renderer,f=this.zoneLinesSVG,g=[],h=a.plotWidth,k=a.plotTop,p;b.forEach(function(b){p=c.toPixels(b)-k;g=g.concat(a.renderer.crispLine([["M",0,p],["L",h,p]],e.lineWidth))});f?f.animate({d:g}):f=this.zoneLinesSVG=d.path(g).attr({"stroke-width":e.lineWidth,stroke:e.color,dashstyle:e.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&
(this.negativeGraphic=this.negativeGraphic.destroy());return k.prototype.destroy.apply(this,arguments)}});""});w(b,"Stock/Indicators/VWAPIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){var l=g.error,k=g.isArray;b.seriesType("vwap","sma",{params:{period:30,volumeSeriesID:"volume"}},{getValues:function(b,e){var a=b.chart,d=b.xData;b=b.yData;var c=e.period,f=!0,g;if(g=a.get(e.volumeSeriesID))return k(b[0])||(f=!1),this.calculateVWAPValues(f,d,b,g,c);l("Series "+e.volumeSeriesID+
" not found! Check `volumeSeriesID`.",!0,a)},calculateVWAPValues:function(b,e,a,d,c){var f=d.yData,g=d.xData.length,k=e.length;d=[];var l=[],n=[],h=[],m=[],u;g=k<=g?k:g;for(u=k=0;k<g;k++){var v=b?(a[k][1]+a[k][2]+a[k][3])/3:a[k];v*=f[k];v=u?d[k-1]+v:v;var x=u?l[k-1]+f[k]:f[k];d.push(v);l.push(x);m.push([e[k],v/x]);n.push(m[k][0]);h.push(m[k][1]);u++;u===c&&(u=0)}return{values:m,xData:n,yData:h}}});""});w(b,"Stock/Indicators/WilliamsRIndicator.js",[b["Core/Series/Series.js"],b["Mixins/ReduceArray.js"],
b["Core/Utilities.js"]],function(b,g,l){var k=g.getArrayExtremes,f=l.isArray;b.seriesType("williamsr","sma",{params:{period:14}},{nameBase:"Williams %R",getValues:function(b,a){a=a.period;var d=b.xData,c=(b=b.yData)?b.length:0,e=[],g=[],l=[],t;if(!(d.length<a)&&f(b[0])&&4===b[0].length){for(t=a-1;t<c;t++){var n=b.slice(t-a+1,t+1);var h=k(n,2,1);n=h[0];h=h[1];var m=b[t][3];n=(h-m)/(h-n)*-100;d[t]&&(e.push([d[t],n]),g.push(d[t]),l.push(n))}return{values:e,xData:g,yData:l}}}});""});w(b,"Stock/Indicators/WMAIndicator.js",
[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){function l(b,a){a*=(a+1)/2;return b.reduce(function(a,b,e){return[null,a[1]+b[1]*(e+1)]})[1]/a}function k(b,a,d,c){d=l(b,b.length);a=a[c-1];b.shift();return[a,d]}var f=g.isArray;b.seriesType("wma","sma",{params:{index:3,period:9}},{getValues:function(b,a){var d=a.period,c=b.xData,e=(b=b.yData)?b.length:0,g=1,l=c[0],t=b[0],n=[],h=[],m=[],u=-1;if(!(c.length<d)){f(b[0])&&(u=a.index,t=b[0][u]);for(a=[[l,t]];g!==d;)a.push([c[g],0>u?b[g]:
b[g][u]]),g++;for(d=g;d<e;d++)g=k(a,c,b,d),n.push(g),h.push(g[0]),m.push(g[1]),a.push([c[d],0>u?b[d]:b[d][u]]);g=k(a,c,b,d);n.push(g);h.push(g[0]);m.push(g[1]);return{values:n,xData:h,yData:m}}}});""});w(b,"Stock/Indicators/ZigzagIndicator.js",[b["Core/Series/Series.js"]],function(b){b.seriesType("zigzag","sma",{params:{lowIndex:2,highIndex:1,deviation:1}},{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag",getValues:function(b,l){var g=l.lowIndex,f=l.highIndex,e=l.deviation/100;l=
1+e;var a=1-e;e=b.xData;var d=b.yData;b=d?d.length:0;var c=[],r=[],p=[],q,t,n=!1,h=!1;if(!(!e||1>=e.length||b&&("undefined"===typeof d[0][g]||"undefined"===typeof d[0][f]))){var m=d[0][g];var u=d[0][f];for(q=1;q<b;q++){if(d[q][g]<=u*a){c.push([e[0],u]);var v=[e[q],d[q][g]];n=t=!0}else d[q][f]>=m*l&&(c.push([e[0],m]),v=[e[q],d[q][f]],t=!1,n=!0);if(n){r.push(c[0][0]);p.push(c[0][1]);var x=q++;q=b}}for(q=x;q<b;q++)t?(d[q][g]<=v[1]&&(v=[e[q],d[q][g]]),d[q][f]>=v[1]*l&&(h=f)):(d[q][f]>=v[1]&&(v=[e[q],
d[q][f]]),d[q][g]<=v[1]*a&&(h=g)),!1!==h&&(c.push(v),r.push(v[0]),p.push(v[1]),v=[e[q],d[q][h]],t=!t,h=!1);g=c.length;0!==g&&c[g-1][0]<e[b-1]&&(c.push(v),r.push(v[0]),p.push(v[1]));return{values:c,xData:r,yData:p}}}});""});w(b,"Stock/Indicators/RegressionIndicators.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){var l=g.isArray;b.seriesType("linearRegression","sma",{params:{xAxisUnit:void 0},tooltip:{valueDecimals:4}},{nameBase:"Linear Regression Indicator",getRegressionLineParameters:function(b,
f){var e=this.options.params.index,a=function(a,b){return l(a)?a[b]:a},d=b.reduce(function(a,b){return b+a},0),c=f.reduce(function(b,c){return a(c,e)+b},0);d/=b.length;c/=f.length;var g=0,k=0,q;for(q=0;q<b.length;q++){var t=b[q]-d;var n=a(f[q],e)-c;g+=t*n;k+=Math.pow(t,2)}b=k?g/k:0;return{slope:b,intercept:c-b*d}},getEndPointY:function(b,f){return b.slope*f+b.intercept},transformXData:function(b,f){var e=b[0];return b.map(function(a){return(a-e)/f})},findClosestDistance:function(b){var f,e;for(e=
1;e<b.length-1;e++){var a=b[e]-b[e-1];0<a&&("undefined"===typeof f||a<f)&&(f=a)}return f},getValues:function(b,f){var e=b.xData;b=b.yData;f=f.period;var a,d={xData:[],yData:[],values:[]},c=this.options.params.xAxisUnit||this.findClosestDistance(e);for(a=f-1;a<=e.length-1;a++){var g=a-f+1;var k=a+1;var l=e[a];var t=e.slice(g,k);g=b.slice(g,k);k=this.transformXData(t,c);t=this.getRegressionLineParameters(k,g);g=this.getEndPointY(t,k[k.length-1]);d.values.push({regressionLineParameters:t,x:l,y:g});d.xData.push(l);
d.yData.push(g)}return d}});b.seriesType("linearRegressionSlope","linearRegression",{},{nameBase:"Linear Regression Slope Indicator",getEndPointY:function(b){return b.slope}});b.seriesType("linearRegressionIntercept","linearRegression",{},{nameBase:"Linear Regression Intercept Indicator",getEndPointY:function(b){return b.intercept}});b.seriesType("linearRegressionAngle","linearRegression",{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}},
{nameBase:"Linear Regression Angle Indicator",slopeToAngle:function(b){return 180/Math.PI*Math.atan(b)},getEndPointY:function(b){return this.slopeToAngle(b.slope)}});""});w(b,"Stock/Indicators/ABIndicator.js",[b["Core/Series/Series.js"],b["Mixins/MultipleLines.js"],b["Core/Utilities.js"]],function(b,g,l){var k=l.correctFloat;l=l.merge;var f=b.seriesTypes.sma;b.seriesType("abands","sma",{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},
dataGrouping:{approximation:"averages"}},l(g,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Acceleration Bands",nameComponents:["period","factor"],linesApiNames:["topLine","bottomLine"],getValues:function(b,a){var d=a.period,c=a.factor;a=a.index;var e=b.xData,g=(b=b.yData)?b.length:0,l=[],t=[],n=[],h=[],m=[],u;if(!(g<d)){for(u=0;u<=g;u++){if(u<g){var v=b[u][2];var w=b[u][1];var x=c;v=k(w-v)/(k(w+v)/2)*1E3*x;l.push(b[u][1]*k(1+2*v));t.push(b[u][2]*k(1-2*v))}if(u>=d){v=e.slice(u-
d,u);var C=b.slice(u-d,u);x=f.prototype.getValues.call(this,{xData:v,yData:l.slice(u-d,u)},{period:d});w=f.prototype.getValues.call(this,{xData:v,yData:t.slice(u-d,u)},{period:d});C=f.prototype.getValues.call(this,{xData:v,yData:C},{period:d,index:a});v=C.xData[0];x=x.yData[0];w=w.yData[0];C=C.yData[0];n.push([v,x,C,w]);h.push(v);m.push([x,C,w])}}return{values:n,xData:h,yData:m}}}}));""});w(b,"Stock/Indicators/TrendLineIndicator.js",[b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,g){var l=
g.isArray;b.seriesType("trendline","sma",{params:{index:3}},{nameBase:"Trendline",nameComponents:!1,getValues:function(b,f){var e=b.xData,a=b.yData;b=[];var d=[],c=[],g=0,k=0,q=0,t=0,n=e.length,h=f.index;for(f=0;f<n;f++){var m=e[f];var u=l(a[f])?a[f][h]:a[f];g+=m;k+=u;q+=m*u;t+=m*m}a=(n*q-g*k)/(n*t-g*g);isNaN(a)&&(a=0);g=(k-a*g)/n;for(f=0;f<n;f++)m=e[f],u=a*m+g,b[f]=[m,u],d[f]=m,c[f]=u;return{xData:d,yData:c,values:b}}});""});w(b,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map