<?php

namespace App\Nova\Actions;

use Illuminate\Bus\Queueable;
use Laravel\Nova\Actions\Action;
use Illuminate\Support\Collection;
use Laravel\Nova\Fields\ActionFields;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Traits\ResetPasswordProcess;

class ResetPasswordToUser extends Action
{
  use InteractsWithQueue, Queueable, SerializesModels;
  use ResetPasswordProcess;
  
   /**
    * Perform the action on the given models.
    *
    * @param  \Laravel\Nova\Fields\ActionFields  $fields
    * @param  \Illuminate\Support\Collection  $models
    * @return mixed
    */
   public function handle(ActionFields $fields, Collection $models)
   {
      foreach ($models as $model)
      {
        $this->resetPasswordToUser($model);
      }
       Action::message('ResetPassword Created');
   }
   /**
    * Get the fields available on the action.
    *
    * @return array
    */
   public function fields()
   {
       return [];
   }
}