<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class Notice extends JsonResource
{

   /**
    * Transform the resource into an array.
    *
    * @param  \Illuminate\Http\Request  $request
    * @return array
    */
   public function toArray($request)
   {
      if($this->standardLink_id != null)
      {
        $class_name = $this->standardLink->StandardSection;
      }
      else
      {
        $class_name = '--';
      }

      if($this->attachment_file != null)
      {
        $attachment_file = $this->AttachmentPath;
      }
      else
      {
        $attachment_file = '';
      }
      return 
      [
        'id'               => $this->id,
        'type'             => ucfirst($this->type),
        'class_name'       => $class_name,
        'title'            => $this->title,
        'publish_date'     => date('d-m-Y H:i:s', strtotime($this->publish_date)),
        'expire_date'      => date('d-m-Y H:i:s', strtotime($this->expire_date)),
        'description'      => $this->description,
        'attachment_file'  => $attachment_file,
       ];
   }
}